/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.cardmatch;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtpm.model.cardmatch.MultiCardEntryExt;
import kd.sdk.wtc.wtpm.model.cardmatch.MultiCardExt;
import kd.wtc.wtbs.business.bill.VaBillService;
import kd.wtc.wtbs.business.caltask.common.WTCCalSubTaskEntity;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskDetailEntity;
import kd.wtc.wtbs.business.helper.WTCTaskServiceHelper;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.task.common.WTCSubTaskEntity;
import kd.wtc.wtbs.business.task.common.WTCSubTaskStatus;
import kd.wtc.wtbs.business.task.common.WTCTaskDetailStatus;
import kd.wtc.wtbs.business.web.evaluation.EvaluationServiceHelper;
import kd.wtc.wtbs.business.web.file.AttFileQueryHelper;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.file.schedule.AttFileScheduleServiceImpl;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.enums.AttModeEnum;
import kd.wtc.wtbs.common.enums.signcard.PointTagEnum;
import kd.wtc.wtbs.common.enums.signcard.TaskCardModeEnum;
import kd.wtc.wtbs.common.model.Page;
import kd.wtc.wtbs.common.model.attfile.AttFileF7QueryParam;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.attfile.AttFileScheduleQueryParam;
import kd.wtc.wtbs.common.model.bill.va.VaBillParseParam;
import kd.wtc.wtbs.common.model.bill.va.rpc.AttFilesVaBillReq;
import kd.wtc.wtbs.common.model.evaluation.DutyShift;
import kd.wtc.wtbs.common.model.evaluation.DutyShiftResponse;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.model.evaluation.ShiftDetail;
import kd.wtc.wtbs.common.model.shift.RefDateType;
import kd.wtc.wtbs.common.model.sign.CheckCard;
import kd.wtc.wtbs.common.model.sign.CheckCardEntry;
import kd.wtc.wtbs.common.model.sign.MultiCard;
import kd.wtc.wtbs.common.model.sign.MultiCardEntry;
import kd.wtc.wtbs.common.model.sign.OnceCard;
import kd.wtc.wtbs.common.model.sign.PointTagLog;
import kd.wtc.wtbs.common.model.sign.SignCard;
import kd.wtc.wtbs.common.model.sign.TimeSeq;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.BeanUtils;
import kd.wtc.wtbs.wtom.common.rpc.OtDutyDateStartEndTime;
import kd.wtc.wtpm.common.vo.cardmatch.ExLogVo;
import kd.wtc.wtpm.common.vo.cardmatch.MatchDetailVo;
import kd.wtc.wtpm.common.vo.cardmatch.MatchTaskVo;
import kd.wtc.wtpm.common.vo.cardmatch.MatchVo;
import kd.wtc.wtpm.common.vo.cardmatch.MustSignInfoVo;
import kd.wtc.wtpm.common.vo.cardmatch.OffRangeVo;
import kd.wtc.wtpm.common.vo.cardmatch.ShiftVo;
import kd.wtc.wtpm.common.vo.cardmatch.TaskSummaryVo;
import kd.wtc.wtpm.constants.sign.CardMatchConstants;
import kd.wtc.wtpm.constants.sign.CardMatchKDString;
import kd.wtc.wtpm.enums.MatchStatusEnum;

public class CardMatchHelper
implements CardMatchConstants {
    private static final Log LOG = LogFactory.getLog(CardMatchHelper.class);

    public static MustSignInfoVo getMustSignInfo(LocalDate localDate, LocalDateTime absoluteDateTime, Boolean isSignOn, TimeSeq timeSeq) {
        MustSignInfoVo mustSignInfoVo = new MustSignInfoVo();
        mustSignInfoVo.setLocalDate(localDate);
        mustSignInfoVo.setAbsoluteSign(absoluteDateTime);
        mustSignInfoVo.setTimeSeq(timeSeq.getTimeSeq());
        if (Boolean.TRUE.equals(isSignOn)) {
            mustSignInfoVo.setSignOn(Boolean.TRUE);
            mustSignInfoVo.setsTakeCardRule(timeSeq.getStartTakeCardRule());
            mustSignInfoVo.setsBeforeScope(timeSeq.getStartBeforeScope());
            mustSignInfoVo.setsAfterScope(timeSeq.getStartAfterScope());
            mustSignInfoVo.setsTakeCardSameLen(timeSeq.getStartTakeCardSameLen());
        } else {
            mustSignInfoVo.setSignOn(Boolean.FALSE);
            mustSignInfoVo.seteTakeCardRule(timeSeq.getEndTakeCardRule());
            mustSignInfoVo.seteBeforeScope(timeSeq.getEndBeforeScope());
            mustSignInfoVo.seteAfterScope(timeSeq.getEndAfterScope());
            mustSignInfoVo.seteTakeCardSameLen(timeSeq.getEndTakeCardSameLen());
        }
        return mustSignInfoVo;
    }

    public static LocalDateTime getAbsoluteDateTime(LocalDate matchDate, String refDay, int startTime) {
        LocalDateTime result = matchDate.atStartOfDay();
        if (RefDateType.NEXTDAY.code.equals(refDay)) {
            result = result.plusDays(1L);
        } else if (RefDateType.LASTDAY.code.equals(refDay)) {
            result = result.minusDays(1L);
        }
        result = result.plusSeconds(startTime);
        return result;
    }

    private CardMatchHelper() {
    }

    public static void getOverTime(MatchVo matchVo, ShiftVo shiftVo, MatchTaskVo taskVo) {
        if (taskVo.getOtApplyMap() == null) {
            return;
        }
        Map map = (Map)taskVo.getOtApplyMap().get(matchVo.getAttPersonId());
        if (CollectionUtils.isEmpty((Map)map)) {
            return;
        }
        OtDutyDateStartEndTime otApply = (OtDutyDateStartEndTime)map.get(matchVo.getMatchDate());
        if (null != otApply) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("\u53d6\u5361\u5339\u914d\u4efb\u52a1,\u8003\u52e4\u4eba[{}]\u8003\u52e4\u65e5\u671f[{}]\u6700\u65e9\u52a0\u73ed[{}]\u6700\u665a\u52a0\u73ed[{}]", new Object[]{matchVo.getAttPersonId(), matchVo.getLocalDate(), otApply.getStartTime(), otApply.getEndTime()});
            }
            if (otApply.getStartTime() != null) {
                LocalDateTime start = WTCDateUtils.toLocalDateTime((Date)otApply.getStartTime());
                shiftVo.setOtStartFirst(start.minusHours(matchVo.getTimeDiff()));
            }
            if (otApply.getEndTime() != null) {
                LocalDateTime end = WTCDateUtils.toLocalDateTime((Date)otApply.getEndTime());
                shiftVo.setOtEndLast(end.minusHours(matchVo.getTimeDiff()));
            }
        }
    }

    public static void saveMatchExLogs(MatchTaskVo taskVo, boolean stop, List<ExLogVo> exLogList) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtpm_matchexdetail");
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"wtpm_matchexdetail");
        if (stop) {
            int num = 0;
            DynamicObject[] result = new DynamicObject[taskVo.getDetailList().size()];
            for (MatchDetailVo detailVo : taskVo.getDetailList()) {
                DynamicObject data = new DynamicObject((DynamicObjectType)mainEntityType);
                data.set("attfileid", (Object)detailVo.getAttFileBoId());
                data.set("evadate", (Object)taskVo.getStartDate());
                data.set("exinfo", (Object)CardMatchKDString.stopNotRun());
                data.set("taskid", (Object)taskVo.getTaskId());
                result[num] = data;
                ++num;
            }
            helper.save(result);
        } else if (!CollectionUtils.isEmpty(exLogList)) {
            DynamicObjectCollection collection = new DynamicObjectCollection();
            Map<Long, List<MatchDetailVo>> detailMap = taskVo.getDetailList().stream().collect(Collectors.groupingBy(MatchDetailVo::getAttFileBoId));
            for (ExLogVo ex : exLogList) {
                MatchDetailVo detailVo;
                List<MatchDetailVo> list;
                boolean recordEx = true;
                long attFileBoId = ex.getAttFileId();
                if (ex.getType() == 1 && !HRMapUtils.isEmpty(detailMap) && HRCollUtil.isNotEmpty(list = detailMap.get(attFileBoId)) && (detailVo = list.get(0)).getMatchStatusEnum() != MatchStatusEnum.SUCCESS) {
                    recordEx = false;
                }
                if (!recordEx) continue;
                DynamicObject data = new DynamicObject((DynamicObjectType)mainEntityType);
                data.set("attfileid", (Object)ex.getAttFileId());
                data.set("evadate", (Object)ex.getMatchDate());
                data.set("exinfo", (Object)ex.getDesc());
                data.set("taskid", (Object)ex.getMatchTaskId());
                collection.add((Object)data);
            }
            helper.save(collection);
        }
    }

    public static void callBackDispatchTask(MatchTaskVo taskVo, TaskSummaryVo summary, boolean success, boolean stop) {
        ArrayList<WTCCalTaskDetailEntity> detail = new ArrayList<WTCCalTaskDetailEntity>(taskVo.getDetailList().size());
        for (MatchDetailVo vo : taskVo.getDetailList()) {
            WTCCalTaskDetailEntity entity = new WTCCalTaskDetailEntity();
            entity.setTaskId(vo.getTaskId().longValue());
            entity.setSubTaskId(vo.getSubTaskId().longValue());
            entity.setAttPersonId(vo.getAttPersonId().longValue());
            entity.setAttFileId(vo.getAttFileId().longValue());
            entity.setAttFileBoId(vo.getAttFileBoId().longValue());
            entity.setRealCalStartDate(vo.getStartDate());
            entity.setRealCalEndDate(vo.getEndDate());
            entity.setTaskDetailState(stop ? WTCTaskDetailStatus.NOT_ACCOUNT : WTCTaskDetailStatus.from((String)vo.getMatchStatusEnum().getCode()));
            detail.add(entity);
        }
        WTCTaskServiceHelper.batchUpdateTaskDetailInfoBySubTaskIdAndAttFileBoId(detail, (String)"wtpm_match");
        WTCCalSubTaskEntity subTask = new WTCCalSubTaskEntity();
        subTask.setId(taskVo.getSubTaskId().longValue());
        subTask.setTaskId(taskVo.getTaskId().longValue());
        subTask.setStartDate(taskVo.getStartTime());
        subTask.setEndDate(new Date());
        subTask.setRefreshTime(new Date());
        subTask.setSubTaskStatus(!success ? WTCSubTaskStatus.ERROR : (stop ? WTCSubTaskStatus.TERMINATED : WTCSubTaskStatus.FINISHED));
        List notRunList = taskVo.getDetailList().stream().filter(detailVo -> detailVo.getMatchStatusEnum() == MatchStatusEnum.NOT_ACCOUNT).collect(Collectors.toList());
        subTask.setNotRunAttFile(stop ? summary.getAttFileBoIds().size() : notRunList.size());
        List failList = taskVo.getDetailList().stream().filter(detailVo -> detailVo.getMatchStatusEnum() == MatchStatusEnum.FAIL).collect(Collectors.toList());
        subTask.setFailedAttFile(stop ? 0 : failList.size());
        List successList = taskVo.getDetailList().stream().filter(detailVo -> detailVo.getMatchStatusEnum() == MatchStatusEnum.SUCCESS).collect(Collectors.toList());
        subTask.setSucceedAttFile(stop ? 0 : successList.size());
        subTask.setRunAttFile(stop ? 0 : successList.size() + failList.size());
        subTask.setTotalAttFile(notRunList.size() + successList.size() + failList.size());
        subTask.setTotalAttPerson(summary.getAttPersonIds().size());
        Set notRunPersons = notRunList.stream().map(MatchDetailVo::getAttPersonId).collect(Collectors.toSet());
        subTask.setNotRunAttPerson(stop ? summary.getAttPersonIds().size() : notRunPersons.size());
        Set failPersons = failList.stream().map(MatchDetailVo::getAttPersonId).collect(Collectors.toSet());
        failPersons.removeAll(notRunPersons);
        subTask.setFailedAttPerson(stop ? 0 : failPersons.size());
        Set successPersons = successList.stream().map(MatchDetailVo::getAttPersonId).collect(Collectors.toSet());
        successPersons.removeAll(failPersons);
        successPersons.removeAll(notRunPersons);
        subTask.setSucceedAttPerson(stop ? 0 : successPersons.size());
        subTask.setRunAttPerson(stop ? 0 : failPersons.size() + successPersons.size());
        subTask.setTotalAttPerson(notRunPersons.size() + failPersons.size() + successPersons.size());
        WTCTaskServiceHelper.updateTaskSub((String)"wtpm_match", (WTCSubTaskEntity)subTask);
    }

    public static void saveOnceCard(MatchTaskVo taskVo, boolean offShift, SignCard signCard, MatchVo matchVo) {
        OnceCard onceCard = new OnceCard();
        onceCard.setAttPersonId(matchVo.getAttPersonId());
        onceCard.setAdminOrgId(matchVo.getAdminOrgId());
        onceCard.setOrgId(matchVo.getOrgId());
        onceCard.setAttCard(matchVo.getAttCardNo());
        onceCard.setShiftDate(matchVo.getLocalDate());
        onceCard.setShiftId(matchVo.getShift().getId());
        onceCard.setAttFileId(matchVo.getAttFileId());
        onceCard.setAttFileBoId(matchVo.getAttFileBoId());
        onceCard.setAttFileTimeZoneId(matchVo.getTimeZoneId());
        onceCard.setOnceRange(offShift ? "" : matchVo.getShift().getOneCardType());
        onceCard.setPositionId(matchVo.getPositionId());
        onceCard.setJobId(matchVo.getJobId());
        onceCard.setManagingScopeId(matchVo.getManagingScopeId());
        onceCard.setCompanyId(matchVo.getCompanyId());
        onceCard.setAffiliateAdminOrgId(matchVo.getAffiliateAdminOrgId());
        onceCard.setEmpGroupId(matchVo.getEmpGroupId());
        onceCard.setDependencyId(matchVo.getDependencyId());
        onceCard.setDependencyTypeId(matchVo.getDependencyTypeId());
        onceCard.setWorkplaceId(matchVo.getWorkplaceId());
        onceCard.setAgreedLocationId(matchVo.getAgreedLocationId());
        onceCard.setWeek(matchVo.getWeek());
        onceCard.setDateTypeId(matchVo.getDateTypeId());
        onceCard.setOffShift(matchVo.getShift().isOff());
        onceCard.setNotPlan(matchVo.getShift().getOffNonPlan());
        if (!HRObjectUtils.isEmpty((Object)signCard) && null != signCard.getSignPointUtc() && null != signCard.getSignPoint()) {
            HashMap<LocalDate, LocalDateTime> workStartMap = (HashMap<LocalDate, LocalDateTime>)taskVo.getWorkStartMap().get(matchVo.getAttPersonId());
            if (null == workStartMap) {
                workStartMap = new HashMap<LocalDate, LocalDateTime>(16);
            }
            workStartMap.put(matchVo.getLocalDate(), signCard.getSignPointUtc());
            taskVo.getWorkStartMap().put(matchVo.getAttPersonId(), workStartMap);
            HashMap<LocalDate, LocalDateTime> workEndMap = (HashMap<LocalDate, LocalDateTime>)taskVo.getWorkEndMap().get(matchVo.getAttPersonId());
            if (null == workEndMap) {
                workEndMap = new HashMap<LocalDate, LocalDateTime>(16);
            }
            workEndMap.put(matchVo.getLocalDate(), signCard.getSignPointUtc());
            taskVo.getWorkEndMap().put(matchVo.getAttPersonId(), workEndMap);
            onceCard.setTimeZoneId(signCard.getTimeZoneId());
            onceCard.setSourceId(signCard.getSource());
            onceCard.setDeviceId(signCard.getDeviceId());
            onceCard.setOncePointUtc(signCard.getSignPointUtc());
            onceCard.setOncePoint(signCard.getSignPoint());
            onceCard.setAccessTag(signCard.getAccessTag());
            String pointTag = CardMatchHelper.getPointTag(signCard.getSignPointUtc(), matchVo.getLocalDate(), matchVo.getTimeDiff());
            onceCard.setPointTag(pointTag);
            onceCard.setSignCardId(signCard.getId().longValue());
            onceCard.setApplyReasonId(signCard.getApplyReasonId());
            onceCard.setPresetBiz1(signCard.getPresetBiz1());
            onceCard.setPresetBiz2(signCard.getPresetBiz2());
        }
        taskVo.getOnceCardSet().add(onceCard);
    }

    public static String getPointTag(LocalDateTime signPoint, LocalDate matchDate) {
        LocalDate sign = signPoint.toLocalDate();
        int time = sign.compareTo(matchDate);
        switch (time) {
            case -1: {
                return PointTagEnum.AUTO_NEXT.getCode();
            }
            case 1: {
                return PointTagEnum.AUTO_PREVIOUS.getCode();
            }
        }
        return PointTagEnum.AUTO_CURRENT.getCode();
    }

    public static String getPointTag(LocalDateTime signPointUtc, LocalDate matchDate, int timeDiff) {
        LocalDateTime localDateTime = signPointUtc.plusHours(timeDiff);
        LocalDate sign = localDateTime.toLocalDate();
        int time = sign.compareTo(matchDate);
        switch (time) {
            case -1: {
                return PointTagEnum.AUTO_NEXT.getCode();
            }
            case 1: {
                return PointTagEnum.AUTO_PREVIOUS.getCode();
            }
        }
        return PointTagEnum.AUTO_CURRENT.getCode();
    }

    public static String getManualPointTag(LocalDateTime signPoint, LocalDate matchDate) {
        LocalDate sign = signPoint.toLocalDate();
        int time = sign.compareTo(matchDate);
        switch (time) {
            case 0: {
                return PointTagEnum.MANUAL_CURRENT.getCode();
            }
            case -1: {
                return PointTagEnum.MANUAL_NEXT.getCode();
            }
            case 1: {
                return PointTagEnum.MANUAL_PREVIOUS.getCode();
            }
        }
        return PointTagEnum.MANUAL_CURRENT.getCode();
    }

    @Deprecated
    public static boolean saveEffectiveCardForOffShift(MatchTaskVo taskVo, MatchVo matchVo, List<SignCard> signCardList) {
        if (AttModeEnum.MANY_CARD.getCode().equals(matchVo.getAttMode())) {
            MultiCard multiCard = new MultiCard();
            multiCard.setAttPersonId(matchVo.getAttPersonId());
            multiCard.setAdminOrgId(matchVo.getAdminOrgId());
            multiCard.setOrgId(matchVo.getOrgId());
            multiCard.setAttCard(matchVo.getAttCardNo());
            multiCard.setShiftDate(matchVo.getLocalDate());
            multiCard.setShiftId(matchVo.getShift().getId());
            multiCard.setAttFileId(matchVo.getAttFileId());
            multiCard.setAttFileBoId(matchVo.getAttFileBoId());
            multiCard.setAttFileTimeZoneId(matchVo.getTimeZoneId());
            multiCard.setPositionId(matchVo.getPositionId());
            multiCard.setJobId(matchVo.getJobId());
            multiCard.setManagingScopeId(matchVo.getManagingScopeId());
            multiCard.setCompanyId(matchVo.getCompanyId());
            multiCard.setAffiliateAdminOrgId(matchVo.getAffiliateAdminOrgId());
            multiCard.setEmpGroupId(matchVo.getEmpGroupId());
            multiCard.setDependencyId(matchVo.getDependencyId());
            multiCard.setDependencyTypeId(matchVo.getDependencyTypeId());
            multiCard.setWorkplaceId(matchVo.getWorkplaceId());
            multiCard.setAgreedLocationId(matchVo.getAgreedLocationId());
            multiCard.setWeek(matchVo.getWeek());
            multiCard.setDateTypeId(matchVo.getDateTypeId());
            multiCard.setOffShift(matchVo.getShift().isOff());
            multiCard.setNotPlan(matchVo.getShift().getOffNonPlan());
            List<MultiCardEntry> entryList = CardMatchHelper.setMultiCardEntryForOffShift(taskVo, matchVo, signCardList);
            multiCard.setEntryList(entryList);
            taskVo.getMultiCardSet().add(multiCard);
        } else if (AttModeEnum.ONES_CARD.getCode().equals(matchVo.getAttMode())) {
            CardMatchHelper.saveOnceCard(taskVo, true, null != signCardList && signCardList.size() > 0 ? signCardList.get(0) : new SignCard(), matchVo);
        }
        return true;
    }

    public static MultiCard initOffMultiCard(MatchVo matchVo) {
        MultiCard multiCard = new MultiCard();
        multiCard.setAttPersonId(matchVo.getAttPersonId());
        multiCard.setAdminOrgId(matchVo.getAdminOrgId());
        multiCard.setOrgId(matchVo.getOrgId());
        multiCard.setAttCard(matchVo.getAttCardNo());
        multiCard.setShiftDate(matchVo.getLocalDate());
        multiCard.setShiftId(matchVo.getShift().getId());
        multiCard.setAttFileId(matchVo.getAttFileId());
        multiCard.setAttFileBoId(matchVo.getAttFileBoId());
        multiCard.setAttFileTimeZoneId(matchVo.getTimeZoneId());
        multiCard.setAffiliateAdminOrgId(matchVo.getAffiliateAdminOrgId());
        multiCard.setWeek(matchVo.getWeek());
        multiCard.setDateTypeId(matchVo.getDateTypeId());
        multiCard.setOffShift(matchVo.getShift().isOff());
        multiCard.setNotPlan(matchVo.getShift().getOffNonPlan());
        return multiCard;
    }

    @Deprecated
    public static boolean saveEffectiveCardForOffShift(MatchTaskVo taskVo, MatchVo matchVo, List<SignCard> signCardList, ShiftVo shiftVo, LocalDateTime startUtc, LocalDateTime endUtc) {
        if (AttModeEnum.MANY_CARD.getCode().equals(matchVo.getAttMode())) {
            MultiCard multiCard = new MultiCard();
            multiCard.setAttPersonId(matchVo.getAttPersonId());
            multiCard.setAdminOrgId(matchVo.getAdminOrgId());
            multiCard.setOrgId(matchVo.getOrgId());
            multiCard.setAttCard(matchVo.getAttCardNo());
            multiCard.setShiftDate(matchVo.getLocalDate());
            multiCard.setShiftId(matchVo.getShift().getId());
            multiCard.setAttFileId(matchVo.getAttFileId());
            multiCard.setAttFileBoId(matchVo.getAttFileBoId());
            multiCard.setAttFileTimeZoneId(matchVo.getTimeZoneId());
            multiCard.setPositionId(matchVo.getPositionId());
            multiCard.setJobId(matchVo.getJobId());
            multiCard.setManagingScopeId(matchVo.getManagingScopeId());
            multiCard.setCompanyId(matchVo.getCompanyId());
            multiCard.setAffiliateAdminOrgId(matchVo.getAffiliateAdminOrgId());
            multiCard.setEmpGroupId(matchVo.getEmpGroupId());
            multiCard.setDependencyId(matchVo.getDependencyId());
            multiCard.setDependencyTypeId(matchVo.getDependencyTypeId());
            multiCard.setWorkplaceId(matchVo.getWorkplaceId());
            multiCard.setAgreedLocationId(matchVo.getAgreedLocationId());
            multiCard.setWeek(matchVo.getWeek());
            multiCard.setDateTypeId(matchVo.getDateTypeId());
            multiCard.setOffShift(matchVo.getShift().isOff());
            multiCard.setNotPlan(matchVo.getShift().getOffNonPlan());
            List<MultiCardEntry> entryList = CardMatchHelper.setMultiCardEntryForOffShift(taskVo, matchVo, signCardList);
            multiCard.setEntryList(entryList);
            taskVo.getMultiCardSet().add(multiCard);
        } else if (AttModeEnum.ONES_CARD.getCode().equals(matchVo.getAttMode())) {
            SignCard signCard = CardMatchHelper.getOffShiftOnceSignCard(matchVo, startUtc, endUtc, shiftVo, signCardList);
            CardMatchHelper.saveOnceCard(taskVo, true, signCard, matchVo);
        }
        return true;
    }

    public static SignCard getOffShiftOnceSignCard(MatchVo matchVo, LocalDateTime startUtc, LocalDateTime endUtc, ShiftVo shiftVo, List<SignCard> signCardList) {
        List<Object> list;
        LocalDateTime start = startUtc;
        LocalDateTime end = endUtc;
        if (null != shiftVo.getPreMustSignLast() && shiftVo.getPreMustSignLast().isAfter(startUtc)) {
            start = shiftVo.getPreMustSignLast();
        }
        if (null != shiftVo.getPreActualSignLast() && shiftVo.getPreActualSignLast().isAfter(start)) {
            start = shiftVo.getPreActualSignLast();
        }
        if (null != shiftVo.getNextMustSignFirst() && shiftVo.getNextMustSignFirst().isBefore(endUtc)) {
            end = shiftVo.getNextMustSignFirst();
        }
        if (null != shiftVo.getNextActualSignFirst() && shiftVo.getNextActualSignFirst().isBefore(end)) {
            end = shiftVo.getNextActualSignFirst();
        }
        if (!CollectionUtils.isEmpty(signCardList)) {
            LocalDateTime finalStart = start;
            LocalDateTime finalEnd = end;
            list = start.isAfter(startUtc) ? signCardList.stream().filter(sign -> sign.getSignPointUtc().isAfter(finalStart) && sign.getSignPointUtc().isBefore(finalEnd)).collect(Collectors.toList()) : (start.isEqual(startUtc) && (null == shiftVo.getPreMustSignLast() || shiftVo.getPreMustSignLast().isBefore(startUtc)) ? signCardList.stream().filter(sign -> (sign.getSignPointUtc().isEqual(finalStart) || sign.getSignPointUtc().isAfter(finalStart)) && sign.getSignPointUtc().isBefore(finalEnd)).collect(Collectors.toList()) : signCardList.stream().filter(sign -> sign.getSignPointUtc().isAfter(finalStart) && sign.getSignPointUtc().isBefore(finalEnd)).collect(Collectors.toList()));
        } else {
            list = new ArrayList(1);
        }
        return CollectionUtils.isEmpty(list) ? new SignCard() : (SignCard)list.get(0);
    }

    private static List<MultiCardEntry> setMultiCardEntryForOffShift(MatchTaskVo taskVo, MatchVo matchVo, List<SignCard> signCardList) {
        ArrayList<MultiCardEntry> entryList = new ArrayList<MultiCardEntry>(2);
        LocalDateTime firstDateTime = null;
        for (int index = 0; index <= 1; ++index) {
            boolean first = index == 0;
            SignCard signCard = CardMatchHelper.getOffShiftSignCard(matchVo, first, signCardList, firstDateTime);
            if (first && null != signCard) {
                firstDateTime = signCard.getSignPointUtc();
            }
            MultiCardEntry entry = new MultiCardEntry();
            entry.setAttPersonId(matchVo.getAttPersonId());
            entry.setMatchDate(matchVo.getLocalDate());
            if (null != signCard) {
                entry.setEffectivePoint(signCard.getSignPoint());
                entry.setMultiPointUtc(signCard.getSignPointUtc());
                entry.setTimeZoneId(signCard.getTimeZoneId());
                entry.setSourceId(signCard.getSource());
                entry.setDeviceId(signCard.getDeviceId());
                entry.setAccessTag(signCard.getAccessTag());
                String pointTag = CardMatchHelper.getPointTag(signCard.getSignPointUtc(), matchVo.getLocalDate(), matchVo.getTimeDiff());
                entry.setPointTag(pointTag);
                if (signCard.getId() != null) {
                    entry.setSignCardId(signCard.getId().longValue());
                }
                entry.setApplyReasonId(signCard.getApplyReasonId());
                if (first) {
                    HashMap<LocalDate, LocalDateTime> workStartMap = (HashMap<LocalDate, LocalDateTime>)taskVo.getWorkStartMap().get(matchVo.getAttPersonId());
                    if (null == workStartMap) {
                        workStartMap = new HashMap<LocalDate, LocalDateTime>(16);
                    }
                    workStartMap.put(matchVo.getLocalDate(), signCard.getSignPointUtc());
                    taskVo.getWorkStartMap().put(matchVo.getAttPersonId(), workStartMap);
                } else {
                    HashMap<LocalDate, LocalDateTime> workEndMap = (HashMap<LocalDate, LocalDateTime>)taskVo.getWorkEndMap().get(matchVo.getAttPersonId());
                    if (null == workEndMap) {
                        workEndMap = new HashMap<LocalDate, LocalDateTime>(16);
                    }
                    workEndMap.put(matchVo.getLocalDate(), signCard.getSignPointUtc());
                    taskVo.getWorkEndMap().put(matchVo.getAttPersonId(), workEndMap);
                }
            }
            entryList.add(entry);
        }
        return entryList;
    }

    private static void fillMultiCardManualStart(MultiCardEntry firstEntry, ShiftVo shiftVo, PointTagLog start, boolean shiftShare) {
        if (null == shiftVo.getPreMustSignLast()) {
            CardMatchHelper.fillManualPointTagData(firstEntry, start);
        } else {
            LocalDateTime last;
            LocalDateTime localDateTime = last = null != shiftVo.getPreActualSignLast() && shiftVo.getPreActualSignLast().isAfter(shiftVo.getPreMustSignLast()) ? shiftVo.getPreActualSignLast() : shiftVo.getPreMustSignLast();
            if (null != start.getMultiPointUtc() && !start.getMultiPointUtc().isBefore(shiftVo.getPreMustSignLast()) && (!shiftShare && start.getMultiPointUtc().compareTo(last) > 0 || shiftShare && start.getMultiPointUtc().compareTo(last) >= 0)) {
                CardMatchHelper.fillManualPointTagData(firstEntry, start);
            }
        }
    }

    private static void fillMultiCardManualEnd(MultiCardEntry lastEntry, ShiftVo shiftVo, PointTagLog end, boolean shiftShare) {
        if (null == shiftVo.getNextMustSignFirst()) {
            CardMatchHelper.fillManualPointTagData(lastEntry, end);
        } else {
            LocalDateTime first;
            LocalDateTime localDateTime = first = null != shiftVo.getNextActualSignFirst() && shiftVo.getNextActualSignFirst().isBefore(shiftVo.getNextMustSignFirst()) ? shiftVo.getNextActualSignFirst() : shiftVo.getNextMustSignFirst();
            if (null != end.getMultiPointUtc() && !end.getMultiPointUtc().isAfter(shiftVo.getNextMustSignFirst()) && (!shiftShare && end.getMultiPointUtc().compareTo(first) < 0 || shiftShare && end.getMultiPointUtc().compareTo(first) <= 0)) {
                CardMatchHelper.fillManualPointTagData(lastEntry, end);
            }
        }
    }

    private static void fillManualPointTagData(MultiCardEntry entry, PointTagLog pointTagLog) {
        entry.setPointTag(pointTagLog.getPointTag());
        entry.setEffectivePoint(pointTagLog.getMultiPoint());
        entry.setMultiPointUtc(pointTagLog.getMultiPointUtc());
        entry.setTimeZoneId(pointTagLog.getTimeZoneId());
        entry.setSourceId(pointTagLog.getSource());
        entry.setDeviceId(pointTagLog.getDeviceId());
        entry.setAccessTag(pointTagLog.getAccessTag());
    }

    public static LocalDateTime getPreShiftLastSignPoint(ShiftVo shiftVo) {
        LocalDateTime lastSignPoint = null;
        if (null != shiftVo.getPreMustSignLast() && null == shiftVo.getPreActualSignLast()) {
            lastSignPoint = shiftVo.getPreMustSignLast();
        } else if (null != shiftVo.getPreActualSignLast() && null == shiftVo.getPreMustSignLast()) {
            lastSignPoint = shiftVo.getPreActualSignLast();
        } else if (null != shiftVo.getPreMustSignLast() && null != shiftVo.getPreActualSignLast()) {
            lastSignPoint = shiftVo.getPreActualSignLast().isAfter(shiftVo.getPreMustSignLast()) ? shiftVo.getPreActualSignLast() : shiftVo.getPreMustSignLast();
        }
        return lastSignPoint;
    }

    private static SignCard getOffShiftSignCard(MatchVo matchVo, boolean first, List<SignCard> signCardList, LocalDateTime firstDateTime) {
        SignCard signCard = null;
        if (CollectionUtils.isEmpty(signCardList)) {
            return null;
        }
        if (first) {
            List list = signCardList.stream().filter(sign -> !StringUtils.equals((CharSequence)"off", (CharSequence)sign.getAccessTag())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(list)) {
                signCard = (SignCard)list.get(0);
            }
        } else {
            List list = signCardList.stream().filter(sign -> !StringUtils.equals((CharSequence)"on", (CharSequence)sign.getAccessTag())).collect(Collectors.toList());
            if (null == firstDateTime && !CollectionUtils.isEmpty(list)) {
                signCard = (SignCard)list.get(list.size() - 1);
            }
            if (null != firstDateTime && !CollectionUtils.isEmpty(list) && !CollectionUtils.isEmpty(list = list.stream().filter(sign -> sign.getSignPointUtc().isAfter(firstDateTime)).collect(Collectors.toList()))) {
                signCard = (SignCard)list.get(list.size() - 1);
            }
        }
        return signCard;
    }

    public static SignCard getOffShiftFirstSignCard(OffRangeVo offRangeVo, ShiftVo shiftVo, MatchVo matchVo, List<SignCard> signCardList) {
        boolean isPerMustLast;
        LocalDateTime startUtc = offRangeVo.getRangeStart();
        SignCard signCard = null;
        List list = signCardList.stream().filter(sign -> !StringUtils.equals((CharSequence)"off", (CharSequence)sign.getAccessTag())).collect(Collectors.toList());
        boolean isPerActualAfterMust = null != shiftVo.getPreActualSignLast() && (null == shiftVo.getPreMustSignLast() || shiftVo.getPreActualSignLast().isAfter(shiftVo.getPreMustSignLast()));
        boolean bl = isPerMustLast = null != shiftVo.getPreMustSignLast() && (null == shiftVo.getPreActualSignLast() || !shiftVo.getPreActualSignLast().isAfter(shiftVo.getPreMustSignLast()));
        if (matchVo.getTakeCardRule().isCardShare()) {
            if (isPerActualAfterMust && !shiftVo.getPreActualSignLast().isBefore(startUtc)) {
                if (CollectionUtils.isEmpty(list = list.stream().filter(sign -> sign.getSignPointUtc().isEqual(shiftVo.getPreActualSignLast())).collect(Collectors.toList()))) {
                    list = signCardList.stream().filter(sign -> sign.getSignPointUtc().isAfter(shiftVo.getPreActualSignLast())).collect(Collectors.toList());
                }
            } else if (isPerMustLast) {
                list = signCardList.stream().filter(sign -> sign.getSignPointUtc().isAfter(shiftVo.getPreMustSignLast())).collect(Collectors.toList());
            }
        } else if (isPerActualAfterMust) {
            list = signCardList.stream().filter(sign -> sign.getSignPointUtc().isAfter(shiftVo.getPreActualSignLast())).collect(Collectors.toList());
        } else if (isPerMustLast) {
            list = signCardList.stream().filter(sign -> sign.getSignPointUtc().isAfter(shiftVo.getPreMustSignLast())).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(list)) {
            signCard = (SignCard)list.get(0);
        }
        return signCard;
    }

    public static SignCard getOffShiftLastSignCard(OffRangeVo offRangeVo, ShiftVo shiftVo, MatchVo matchVo, List<SignCard> signCardList, LocalDateTime firstDateTime) {
        boolean isNextMustFirst;
        LocalDateTime endUtc = offRangeVo.getRangeEnd();
        SignCard signCard = null;
        List list = signCardList.stream().filter(sign -> !StringUtils.equals((CharSequence)"on", (CharSequence)sign.getAccessTag())).collect(Collectors.toList());
        boolean isNextActualBeforeMust = null != shiftVo.getNextActualSignFirst() && (null == shiftVo.getNextMustSignFirst() || shiftVo.getNextActualSignFirst().isBefore(shiftVo.getNextMustSignFirst()));
        boolean bl = isNextMustFirst = null != shiftVo.getNextMustSignFirst() && (null == shiftVo.getNextActualSignFirst() || !shiftVo.getNextActualSignFirst().isBefore(shiftVo.getNextMustSignFirst()));
        if (matchVo.getTakeCardRule().isCardShare()) {
            if (isNextActualBeforeMust && !shiftVo.getNextActualSignFirst().isAfter(endUtc)) {
                if (CollectionUtils.isEmpty(list = list.stream().filter(sign -> sign.getSignPointUtc().isEqual(shiftVo.getNextActualSignFirst())).collect(Collectors.toList()))) {
                    list = signCardList.stream().filter(sign -> sign.getSignPointUtc().isBefore(shiftVo.getNextActualSignFirst())).collect(Collectors.toList());
                }
            } else if (isNextMustFirst) {
                list = signCardList.stream().filter(sign -> sign.getSignPointUtc().isBefore(shiftVo.getNextMustSignFirst())).collect(Collectors.toList());
            }
        } else if (isNextActualBeforeMust) {
            list = signCardList.stream().filter(sign -> sign.getSignPointUtc().isBefore(shiftVo.getNextActualSignFirst())).collect(Collectors.toList());
        } else if (isNextMustFirst) {
            list = signCardList.stream().filter(sign -> sign.getSignPointUtc().isBefore(shiftVo.getNextMustSignFirst())).collect(Collectors.toList());
        }
        if (null == firstDateTime && !CollectionUtils.isEmpty(list)) {
            return (SignCard)list.get(list.size() - 1);
        }
        if (null != firstDateTime && !CollectionUtils.isEmpty(list) && !CollectionUtils.isEmpty(list = list.stream().filter(sign -> sign.getSignPointUtc().isAfter(firstDateTime)).collect(Collectors.toList()))) {
            return (SignCard)list.get(list.size() - 1);
        }
        if (!CollectionUtils.isEmpty(list)) {
            signCard = (SignCard)list.get(list.size() - 1);
        }
        return signCard;
    }

    private static void batchSaveMultiCards(MatchTaskVo taskVo) {
        HRBaseServiceHelper multiCardHelper = new HRBaseServiceHelper("wtpm_multicard");
        CardMatchHelper.removeCurrentEffectiveCards(multiCardHelper, taskVo);
        Set multiCards = taskVo.getMultiCardSet();
        if (null != multiCards && multiCards.size() > 0) {
            DynamicObjectCollection collection = new DynamicObjectCollection();
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"wtpm_multicard");
            for (MultiCard multiCard : multiCards) {
                DynamicObject multiResult = new DynamicObject((DynamicObjectType)mainEntityType);
                multiResult.set("attperson", (Object)multiCard.getAttPersonId());
                multiResult.set("org", (Object)multiCard.getOrgId());
                multiResult.set("attcard", (Object)multiCard.getAttCard());
                multiResult.set("shiftdate", (Object)Date.from(multiCard.getShiftDate().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()));
                multiResult.set("shift", (Object)multiCard.getShiftId());
                multiResult.set("attfile", (Object)multiCard.getAttFileId());
                multiResult.set("attfilebo", (Object)multiCard.getAttFileBoId());
                multiResult.set("week", (Object)multiCard.getWeek());
                multiResult.set("datetype", (Object)multiCard.getDateTypeId());
                DynamicObjectCollection multiEntryCollection = new DynamicObjectCollection();
                DynamicObjectType multiEntity = multiResult.getDynamicObjectCollection("entryentity").getDynamicObjectType();
                int seq = 0;
                Map multiExtMap = (Map)taskVo.getExtMap().get("multiCardExtMap");
                if (!HRMapUtils.isEmpty((Map)multiExtMap) && null != multiExtMap.get(multiCard.getAttFileBoId()) && null != ((Map)multiExtMap.get(multiCard.getAttFileBoId())).get(multiCard.getShiftDate())) {
                    List entryExtList = ((MultiCardExt)((Map)multiExtMap.get(multiCard.getAttFileBoId())).get(multiCard.getShiftDate())).getEntryList();
                    for (MultiCardEntryExt entryExt : entryExtList) {
                        DynamicObject row = new DynamicObject(multiEntity);
                        row.set("seq", (Object)seq++);
                        row.set("attpersonid", (Object)entryExt.getAttPersonId());
                        row.set("matchdate", (Object)WTCDateUtils.toDate((LocalDate)multiCard.getShiftDate()));
                        row.set("mustpoint", null != entryExt.getMustPoint() ? WTCDateUtils.toDate((LocalDateTime)entryExt.getMustPoint()) : null);
                        row.set("pointdesc", (Object)entryExt.getPointDescId());
                        row.set("pointtag", (Object)entryExt.getPointTag());
                        row.set("effectivepoint", null != entryExt.getEffectivePoint() ? WTCDateUtils.toDate((LocalDateTime)entryExt.getEffectivePoint()) : null);
                        row.set("multipointutc", null != entryExt.getMultiPointUtc() ? WTCDateUtils.toDate((LocalDateTime)entryExt.getMultiPointUtc()) : null);
                        row.set("timezone", (Object)entryExt.getTimeZoneId());
                        row.set("source", (Object)entryExt.getSourceId());
                        row.set("device", (Object)entryExt.getDeviceId());
                        row.set("accesstag", (Object)entryExt.getAccessTag());
                        row.set("presetbiz1", (Object)entryExt.getPresetBiz1());
                        row.set("presetbiz2", (Object)entryExt.getPresetBiz2());
                        if (!HRMapUtils.isEmpty((Map)entryExt.getExtFieldMap())) {
                            for (Map.Entry element : entryExt.getExtFieldMap().entrySet()) {
                                row.set((String)element.getKey(), element.getValue());
                            }
                        }
                        multiEntryCollection.add((Object)row);
                    }
                } else {
                    for (MultiCardEntry entry : multiCard.getEntryList()) {
                        DynamicObject row = new DynamicObject(multiEntity);
                        row.set("seq", (Object)seq++);
                        row.set("attpersonid", (Object)entry.getAttPersonId());
                        row.set("matchdate", (Object)Date.from(multiCard.getShiftDate().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()));
                        row.set("mustpoint", null != entry.getMustPoint() ? Date.from(entry.getMustPoint().atZone(ZoneId.systemDefault()).toInstant()) : null);
                        row.set("pointdesc", (Object)entry.getPointDescId());
                        row.set("pointtag", (Object)entry.getPointTag());
                        row.set("effectivepoint", null != entry.getEffectivePoint() ? Date.from(entry.getEffectivePoint().atZone(ZoneId.systemDefault()).toInstant()) : null);
                        row.set("multipointutc", null != entry.getMultiPointUtc() ? Date.from(entry.getMultiPointUtc().atZone(ZoneId.systemDefault()).toInstant()) : null);
                        row.set("timezone", (Object)entry.getTimeZoneId());
                        row.set("source", (Object)entry.getSourceId());
                        row.set("device", (Object)entry.getDeviceId());
                        row.set("accesstag", (Object)entry.getAccessTag());
                        row.set("applyreason", (Object)entry.getApplyReasonId());
                        row.set("presetbiz1", (Object)entry.getPresetBiz1());
                        row.set("presetbiz2", (Object)entry.getPresetBiz2());
                        multiEntryCollection.add((Object)row);
                    }
                }
                multiResult.set("entryentity", (Object)multiEntryCollection);
                collection.add((Object)multiResult);
            }
            multiCardHelper.save(collection);
        }
    }

    private static void batchUpdateMultiCards(MatchTaskVo taskVo) {
        HRBaseServiceHelper multiCardHelper = new HRBaseServiceHelper("wtpm_multicard");
        Map offSignMap = taskVo.getOffSignMap();
        DynamicObjectCollection collection = new DynamicObjectCollection();
        LocalDate start = taskVo.getStart().minusDays(1L);
        if (!HRMapUtils.isEmpty((Map)offSignMap)) {
            for (Map.Entry entry : offSignMap.entrySet()) {
                Map multiMap = (Map)taskVo.getMultiMap().get(entry.getKey());
                if (HRMapUtils.isEmpty((Map)multiMap) || null == multiMap.get(start)) continue;
                for (Map.Entry signCardEntry : ((Map)entry.getValue()).entrySet()) {
                    DynamicObject multiDy;
                    if (!((LocalDate)signCardEntry.getKey()).isEqual(start) || null == (multiDy = (DynamicObject)multiMap.get(signCardEntry.getKey()))) continue;
                    SignCard signCard = (SignCard)signCardEntry.getValue();
                    DynamicObjectCollection entryEntity = multiDy.getDynamicObjectCollection("entryentity");
                    DynamicObject lastRow = (DynamicObject)entryEntity.get(entryEntity.size() - 1);
                    String pointTag = CardMatchHelper.getPointTag(signCard.getSignPointUtc(), (LocalDate)signCardEntry.getKey(), signCard.getTimeDiff());
                    lastRow.set("pointtag", (Object)pointTag);
                    lastRow.set("effectivepoint", (Object)WTCDateUtils.toDate((LocalDateTime)signCard.getSignPoint()));
                    lastRow.set("multipointutc", (Object)WTCDateUtils.toDate((LocalDateTime)signCard.getSignPointUtc()));
                    lastRow.set("timezone", (Object)signCard.getTimeZoneId());
                    lastRow.set("source", (Object)signCard.getSource());
                    lastRow.set("device", (Object)signCard.getDeviceId());
                    lastRow.set("accesstag", (Object)signCard.getAccessTag());
                    collection.add((Object)multiDy);
                }
            }
        }
        CardMatchHelper.updateMultiCardNextDay(taskVo, collection);
        multiCardHelper.save(collection);
    }

    private static void updateMultiCardNextDay(MatchTaskVo taskVo, DynamicObjectCollection collection) {
        LocalDate end = taskVo.getEnd().plusDays(1L);
        Map onSignMap = taskVo.getOnSignMap();
        if (!HRMapUtils.isEmpty((Map)onSignMap)) {
            for (Map.Entry entry : onSignMap.entrySet()) {
                Map multiMap = (Map)taskVo.getMultiMap().get(entry.getKey());
                if (HRMapUtils.isEmpty((Map)multiMap) || null == multiMap.get(end)) continue;
                for (Map.Entry signCardEntry : ((Map)entry.getValue()).entrySet()) {
                    DynamicObject multiDy;
                    if (!((LocalDate)signCardEntry.getKey()).isEqual(end) || null == (multiDy = (DynamicObject)multiMap.get(signCardEntry.getKey()))) continue;
                    SignCard signCard = (SignCard)signCardEntry.getValue();
                    DynamicObjectCollection entryEntity = multiDy.getDynamicObjectCollection("entryentity");
                    DynamicObject lastRow = (DynamicObject)entryEntity.get(0);
                    String pointTag = CardMatchHelper.getPointTag(signCard.getSignPointUtc(), (LocalDate)signCardEntry.getKey(), signCard.getTimeDiff());
                    lastRow.set("pointtag", (Object)pointTag);
                    lastRow.set("effectivepoint", (Object)WTCDateUtils.toDate((LocalDateTime)signCard.getSignPoint()));
                    lastRow.set("multipointutc", (Object)WTCDateUtils.toDate((LocalDateTime)signCard.getSignPointUtc()));
                    lastRow.set("timezone", (Object)signCard.getTimeZoneId());
                    lastRow.set("source", (Object)signCard.getSource());
                    lastRow.set("device", (Object)signCard.getDeviceId());
                    lastRow.set("accesstag", (Object)signCard.getAccessTag());
                    collection.add((Object)multiDy);
                }
            }
        }
    }

    private static void removeCurrentEffectiveCards(HRBaseServiceHelper cardHelper, MatchTaskVo taskVo) {
        QFilter filterDefault = new QFilter("shiftdate", ">=", (Object)taskVo.getStartDate()).and(new QFilter("shiftdate", "<=", (Object)taskVo.getEndDate())).and(new QFilter("attfile.boid", "in", (Object)taskVo.getAttFileBoIds()));
        if (HRMapUtils.isEmpty((Map)taskVo.getRetainMap())) {
            cardHelper.deleteByFilter(new QFilter[]{filterDefault});
            return;
        }
        String selectStr = "id,shiftdate,attfilebo.id";
        if (LOG.isInfoEnabled()) {
            LOG.info("cardmatch,delete[{}],query data", (Object)cardHelper.getEntityName());
        }
        DynamicObject[] dynamicObjects = cardHelper.query(selectStr, new QFilter[]{filterDefault});
        Map<Long, List<DynamicObject>> map = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(dy -> dy.getLong("attfilebo.id")));
        Set<Long> removeIds = Arrays.stream(dynamicObjects).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        if (LOG.isInfoEnabled()) {
            LOG.info("cardmatch,delete[{}],need retain data group size[{}]", (Object)cardHelper.getEntityName(), (Object)taskVo.getRetainMap().size());
        }
        for (Map.Entry<Long, List<DynamicObject>> entry : map.entrySet()) {
            String dateRangeStr = (String)taskVo.getRetainMap().get(entry.getKey());
            if (HRStringUtils.isEmpty((String)dateRangeStr)) continue;
            String[] dateStr = dateRangeStr.split("_");
            long start = Long.parseLong(dateStr[0]);
            long end = Long.parseLong(dateStr[1]);
            CardMatchHelper.notRemoveRetainIds(entry.getValue(), removeIds, start, end);
        }
        cardHelper.deleteByFilter(new QFilter[]{new QFilter("id", "in", removeIds)});
    }

    private static void notRemoveRetainIds(List<DynamicObject> dys, Set<Long> removeIds, long start, long end) {
        if (HRCollUtil.isEmpty(dys)) {
            return;
        }
        for (DynamicObject dy : dys) {
            Date shiftDate = dy.getDate("shiftdate");
            Long id = dy.getLong("id");
            if (shiftDate.before(HRDateTimeUtils.convertDate((Long)start)) || shiftDate.after(HRDateTimeUtils.convertDate((Long)end))) continue;
            removeIds.remove(id);
        }
    }

    public static Long getShiftId(List<DutyShift> dutyShiftList, Date date, boolean isCurrentDate, MatchVo matchVo) {
        if (CollectionUtils.isEmpty(dutyShiftList)) {
            return null;
        }
        List factDutyShiftList = dutyShiftList.stream().filter(element -> element.getRosterDate().getTime() == date.getTime() && element.getShiftId() != 0L && StringUtils.equals((CharSequence)element.getRosterType(), (CharSequence)"1")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(factDutyShiftList)) {
            List planDutyShiftList = dutyShiftList.stream().filter(element -> element.getRosterDate().getTime() == date.getTime() && element.getShiftId() != 0L && StringUtils.equals((CharSequence)element.getRosterType(), (CharSequence)"0")).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(planDutyShiftList)) {
                if (isCurrentDate) {
                    matchVo.setDateTypeId(((DutyShift)planDutyShiftList.get(0)).getDateTypeModel().getId());
                }
                return ((DutyShift)planDutyShiftList.get(0)).getShiftId();
            }
            return null;
        }
        if (isCurrentDate) {
            matchVo.setDateTypeId(((DutyShift)factDutyShiftList.get(0)).getDateTypeModel().getId());
        }
        return ((DutyShift)factDutyShiftList.get(0)).getShiftId();
    }

    public static List<MustSignInfoVo> getShiftMustSignList(List<ShiftDetail> details, List<TimeSeq> timeSeqList, LocalDate matchDate) {
        boolean bl;
        List<ShiftDetail> mustDetails = CardMatchHelper.getMustSignShiftDetails(details);
        ArrayList<MustSignInfoVo> mustSignInfoList = new ArrayList<MustSignInfoVo>();
        if (CollectionUtils.isEmpty(timeSeqList)) {
            return mustSignInfoList;
        }
        ArrayList<TimeSeq> timeSeqs = new ArrayList<TimeSeq>(timeSeqList.size());
        for (TimeSeq timeSeq : timeSeqList) {
            if (HRStringUtils.isNotEmpty((String)timeSeq.getStartTakeCardRule())) {
                timeSeqs.add(timeSeq);
            }
            if (!HRStringUtils.isNotEmpty((String)timeSeq.getEndTakeCardRule())) continue;
            timeSeqs.add(timeSeq);
        }
        ArrayList<ShiftDetail> shiftSeq = new ArrayList<ShiftDetail>(timeSeqList.size());
        try {
            for (ShiftDetail detail : mustDetails) {
                if (detail.isWorkTimeStart()) {
                    ShiftDetail start = new ShiftDetail();
                    BeanUtils.copyProperties((Object)start, (Object)detail);
                    start.setWorkTimeEnd(false);
                    start.setWorkTime(detail.getWorkTime());
                    start.setStartPunchCardPointEntryId(detail.getStartPunchCardPointEntryId());
                    shiftSeq.add(start);
                }
                if (!detail.isWorkTimeEnd()) continue;
                ShiftDetail end = new ShiftDetail();
                BeanUtils.copyProperties((Object)end, (Object)detail);
                end.setWorkTimeStart(false);
                end.setWorkTime(detail.getWorkTime());
                end.setEndPunchCardPointEntryId(detail.getEndPunchCardPointEntryId());
                shiftSeq.add(end);
            }
        }
        catch (Exception exception) {
            LOG.warn("\u53d6\u5361\u5339\u914d,\u5e94\u6253\u5361\u70b9\u5904\u7406\u5f02\u5e38", (Throwable)exception);
            return mustSignInfoList;
        }
        boolean bl2 = bl = !CardMatchHelper.matchTakeShape(shiftSeq, timeSeqs);
        if (bl) {
            return mustSignInfoList;
        }
        for (int index = 0; index < shiftSeq.size(); ++index) {
            MustSignInfoVo mustSignInfo;
            LocalDateTime localDateTime;
            ShiftDetail detail = (ShiftDetail)shiftSeq.get(index);
            TimeSeq timeSeq = (TimeSeq)timeSeqs.get(index);
            if (detail.isWorkTimeStart()) {
                localDateTime = CardMatchHelper.getAbsoluteDateTime(matchDate, detail.getRefStartDay(), detail.getShiftStartDate());
                mustSignInfo = CardMatchHelper.getMustSignInfo(matchDate, localDateTime, Boolean.TRUE, timeSeq);
                mustSignInfo.setShiftParPointId(detail.getStartPunchCardPointEntryId());
                mustSignInfoList.add(mustSignInfo);
            }
            if (!detail.isWorkTimeEnd()) continue;
            localDateTime = CardMatchHelper.getAbsoluteDateTime(matchDate, detail.getRefEndDay(), detail.getShiftEndDate());
            mustSignInfo = CardMatchHelper.getMustSignInfo(matchDate, localDateTime, Boolean.FALSE, timeSeq);
            mustSignInfo.setShiftParPointId(detail.getEndPunchCardPointEntryId());
            mustSignInfoList.add(mustSignInfo);
        }
        return mustSignInfoList;
    }

    private static List<ShiftDetail> getMustSignShiftDetails(List<ShiftDetail> details) {
        ArrayList<ShiftDetail> mustDetails = new ArrayList<ShiftDetail>(details.size());
        for (ShiftDetail detail : details) {
            boolean isRestOrNotSign;
            String outWorkType = detail.getOutWorkType();
            boolean bl = isRestOrNotSign = StringUtils.equals((CharSequence)outWorkType, (CharSequence)"B") || !detail.isWorkTimeStart() && !detail.isWorkTimeEnd();
            if (isRestOrNotSign) continue;
            mustDetails.add(detail);
        }
        return mustDetails;
    }

    private static boolean matchTakeShape(List<ShiftDetail> shiftSeq, List<TimeSeq> timeSeqList) {
        if (shiftSeq.size() != timeSeqList.size()) {
            return false;
        }
        int num = 0;
        for (ShiftDetail detail : shiftSeq) {
            boolean eTakeCardRule;
            boolean sTakeCardRule;
            TimeSeq timeSeq = timeSeqList.get(num);
            boolean bl = sTakeCardRule = !StringUtils.isEmpty((CharSequence)timeSeq.getStartTakeCardRule());
            if (detail.isWorkTimeStart() && !sTakeCardRule) {
                return false;
            }
            if (sTakeCardRule && detail.isWorkTimeStart()) {
                ++num;
                continue;
            }
            boolean bl2 = eTakeCardRule = !StringUtils.isEmpty((CharSequence)timeSeq.getEndTakeCardRule());
            if (detail.isWorkTimeEnd() && !eTakeCardRule) {
                return false;
            }
            ++num;
        }
        return true;
    }

    public static SignCard getFirstSignCard(MatchVo matchVo, List<SignCard> signCards, List<ShiftDetail> details, LocalDate matchDate) {
        SignCard signCard = null;
        for (ShiftDetail shiftDetail : details) {
            LocalDateTime start = CardMatchHelper.getAbsoluteDateTime(matchDate, shiftDetail.getRefStartDay(), shiftDetail.getShiftStartDate());
            LocalDateTime startFinal = start.minusHours(matchVo.getTimeDiff());
            LocalDateTime end = CardMatchHelper.getAbsoluteDateTime(matchDate, shiftDetail.getRefEndDay(), shiftDetail.getShiftEndDate());
            LocalDateTime endFinal = end.minusHours(matchVo.getTimeDiff());
            List legalSignCards = signCards.stream().filter(sign -> startFinal.isBefore(sign.getSignPointUtc()) && endFinal.isAfter(sign.getSignPointUtc()) || startFinal.equals(sign.getSignPointUtc()) || endFinal.equals(sign.getSignPointUtc())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(legalSignCards)) continue;
            signCard = (SignCard)legalSignCards.get(0);
            break;
        }
        return signCard;
    }

    public static void setAttMode(MatchTaskVo taskVo, Date date, MatchVo matchVo) {
        List modeEntry = (List)taskVo.getAttModeMap().get(matchVo.getAttFileBoId());
        if (null == modeEntry) {
            return;
        }
        for (DynamicObject attMode : modeEntry) {
            if (attMode.getDate("bsed") == null || attMode.getDate("bsed").compareTo(date) > 0 || attMode.getDate("bsled") == null || attMode.getDate("bsled").compareTo(date) < 0) continue;
            matchVo.setAttMode(attMode.getString(AttFileScheduleEnum.MODE.getKey()));
            break;
        }
    }

    public static void setTimeZone(MatchTaskVo taskVo, LocalDate date, MatchVo matchVo) {
        List entry = (List)taskVo.getTimeZoneMap().get(matchVo.getAttFileBoId());
        if (CollectionUtils.isEmpty((Collection)entry)) {
            LOG.info("\u53d6\u5361\u5339\u914d\u4efb\u52a1,\u8003\u52e4\u4eba[{}]\u5728\u8003\u52e4\u65e5\u671f[{}]\u4e0d\u5b58\u5728\u8003\u52e4\u6863\u6848\u7684\u65f6\u533a\u4fe1\u606f", (Object)matchVo.getAttPersonId(), (Object)date);
            return;
        }
        LocalDate preDate = date.minusDays(1L);
        LocalDate nextDate = date.plusDays(1L);
        for (DynamicObject timeZone : entry) {
            LocalDate start = timeZone.getDate("bsed").toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            LocalDate end = timeZone.getDate("bsled").toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            int timeDiff = timeZone.getInt("tz.timedif");
            if (start != null && start.compareTo(date) <= 0 && end != null && end.compareTo(date) >= 0) {
                matchVo.setTimeDiff(timeDiff);
                matchVo.setTimeZoneId(Long.valueOf(timeZone.getLong("tz.id")));
                matchVo.setTimeZoneNo(timeZone.getString("tz.number"));
            }
            if (start != null && start.compareTo(preDate) <= 0 && end != null && end.compareTo(preDate) >= 0) {
                matchVo.setPreTimeDiff(timeDiff);
            }
            if (start == null || start.compareTo(nextDate) > 0 || end == null || end.compareTo(nextDate) < 0) continue;
            matchVo.setNextTimeDiff(timeDiff);
        }
    }

    public static void setAttCard(MatchTaskVo taskVo, Date date, MatchVo matchVo) {
        List cardEntry = (List)taskVo.getAttCardMap().get(matchVo.getAttFileBoId());
        if (null == cardEntry) {
            return;
        }
        for (DynamicObject attCard : cardEntry) {
            if (attCard.getDate("bsed") == null || attCard.getDate("bsed").compareTo(date) > 0 || attCard.getDate("bsled") == null || attCard.getDate("bsled").compareTo(date) < 0) continue;
            matchVo.setAttCardNo(attCard.getString(AttFileScheduleEnum.CARD.getKey()));
            break;
        }
    }

    public static String isLegalAttFile(Date date, Long attPersonId, Long attFileBoId) {
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        String dateString = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)date);
        String frozenMsg = CardMatchHelper.isFrozenAttFile(date, attPersonId);
        if (HRStringUtils.isNotEmpty((String)frozenMsg)) {
            return frozenMsg;
        }
        HashSet<Long> attFileBoIds = new HashSet<Long>(2);
        attFileBoIds.add(attFileBoId);
        AttFileScheduleQueryParam attParam = new AttFileScheduleQueryParam();
        attParam.setFileBoIdSet(attFileBoIds);
        Map attModeMap = AttFileScheduleServiceImpl.getInstance().queryAttFileSchedule(AttFileScheduleEnum.MODE, attParam);
        if (attModeMap == null) {
            String msg = ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u8003\u52e4\u65b9\u5f0f\u3002", (String)"CardMatchHelper_1", (String)"wtc-wtpm-business", (Object[])new Object[0]);
            return dateString + msg;
        }
        List modeEntry = (List)attModeMap.get(attFileBoId);
        String attMode = CardMatchHelper.getAttMode(modeEntry, localDate);
        if (StringUtils.isEmpty((CharSequence)attMode) || AttModeEnum.NO_CARD.getCode().equals(attMode)) {
            String msg = ResManager.loadKDString((String)"\u8003\u52e4\u65b9\u5f0f\u4e3a\u4e0d\u6253\u5361\u3002", (String)"CardMatchHelper_2", (String)"wtc-wtpm-business", (Object[])new Object[0]);
            return dateString + msg;
        }
        if (!StringUtils.isEmpty((CharSequence)attMode) && AttModeEnum.ONES_CARD.getCode().equals(attMode)) {
            String msg = ResManager.loadKDString((String)"\u8003\u52e4\u65b9\u5f0f\u4e3a\u4e00\u6b21\u5361\u3002", (String)"CardMatchHelper_3", (String)"wtc-wtpm-business", (Object[])new Object[0]);
            return dateString + msg;
        }
        return null;
    }

    public static String isFrozenAttFile(Date date, Long attPersonId) {
        String dateString = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)date);
        AttFileQueryParam param = new AttFileQueryParam(date, date, attPersonId.longValue());
        String queryFields = "id,wtteinfo.frozenstartdate,wtteinfo.frozenenddate";
        param.setProperties(queryFields);
        param.setAuthCheck(Boolean.FALSE);
        List attFileList = AttFileQueryServiceImpl.getInstance().queryAttFiles(param);
        if (CollectionUtils.isEmpty((Collection)attFileList)) {
            String msg = ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u8003\u52e4\u6863\u6848\u3002", (String)"CardMatchHelper_0", (String)"wtc-wtpm-business", (Object[])new Object[0]);
            return dateString + msg;
        }
        Date frozenStart = ((DynamicObject)attFileList.get(0)).getDate("wtteinfo.frozenstartdate");
        Date frozenEnd = ((DynamicObject)attFileList.get(0)).getDate("wtteinfo.frozenenddate");
        if (null != frozenStart && !date.before(frozenStart) && null != frozenEnd && !date.after(frozenEnd)) {
            String msg = ResManager.loadKDString((String)"\u4eba\u5458\u8003\u52e4\u671f\u95f4\u5df2\u51bb\u7ed3\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"CardMatchHelper_10", (String)"wtc-wtpm-business", (Object[])new Object[0]);
            return dateString + msg;
        }
        return null;
    }

    public static String getAttMode(List<DynamicObject> modeEntry, LocalDate date) {
        String attMode = "";
        if (null == modeEntry) {
            return attMode;
        }
        for (DynamicObject element : modeEntry) {
            LocalDate start = element.getDate("bsed").toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            LocalDate end = element.getDate("bsled").toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            if (start == null || start.compareTo(date) > 0 || end == null || end.compareTo(date) <= 0) continue;
            attMode = element.getString(AttFileScheduleEnum.MODE.getKey());
            break;
        }
        return attMode;
    }

    public static String isLegalShift(Date date, @Deprecated Long attPersonId, Long attFileBoId) {
        String dateString = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)date);
        ArrayList<Long> attFileBoIds = new ArrayList<Long>(1);
        attFileBoIds.add(attFileBoId);
        DutyShiftResponse dutyShifts = EvaluationServiceHelper.getDutyShiftsByAttFileBoId(attFileBoIds, (Date)date, (Date)date);
        if (HRObjectUtils.isEmpty((Object)dutyShifts)) {
            String msg = ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u6392\u73ed", (String)"CardMatchHelper_4", (String)"wtc-wtpm-business", (Object[])new Object[0]);
            return dateString + msg;
        }
        Optional shifts = dutyShifts.getShiftByAttFileBoId(attFileBoId, date);
        if (!shifts.isPresent()) {
            String msg = ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u6392\u73ed", (String)"CardMatchHelper_4", (String)"wtc-wtpm-business", (Object[])new Object[0]);
            return dateString + msg;
        }
        return null;
    }

    public static String isLegalTag(boolean isFirst, String oldPointTag, String pointTag, Date signPoint) {
        String dateString = WTCInteDateUtil.formatBySysTzAndUserFmt((Date)signPoint);
        if (isFirst && PointTagEnum.AUTO_CURRENT.getCode().equals(oldPointTag) && !PointTagEnum.MANUAL_PREVIOUS.getCode().equals(pointTag)) {
            String msg = ResManager.loadKDString((String)"\u53ea\u53ef\u6539\u4e3a\u524d\u4e00\u4e2a\u73ed\u6b21\u4e0b\u73ed\u5361\u3002", (String)"CardMatchHelper_6", (String)"wtc-wtpm-business", (Object[])new Object[0]);
            return dateString + msg;
        }
        if (isFirst && PointTagEnum.MANUAL_CURRENT.getCode().equals(oldPointTag) && !PointTagEnum.MANUAL_PREVIOUS.getCode().equals(pointTag)) {
            String msg = ResManager.loadKDString((String)"\u53ea\u53ef\u6539\u4e3a\u524d\u4e00\u4e2a\u73ed\u6b21\u4e0b\u73ed\u5361\u3002", (String)"CardMatchHelper_6", (String)"wtc-wtpm-business", (Object[])new Object[0]);
            return dateString + msg;
        }
        if (isFirst && PointTagEnum.AUTO_NEXT.getCode().equals(oldPointTag) && !PointTagEnum.MANUAL_CURRENT.getCode().equals(pointTag)) {
            String msg = ResManager.loadKDString((String)"\u53ea\u53ef\u6539\u4e3a\u5f53\u5929\u73ed\u6b21\u4e0b\u73ed\u5361\u3002", (String)"CardMatchHelper_7", (String)"wtc-wtpm-business", (Object[])new Object[0]);
            return dateString + msg;
        }
        if (isFirst && PointTagEnum.MANUAL_NEXT.getCode().equals(oldPointTag) && !PointTagEnum.MANUAL_CURRENT.getCode().equals(pointTag)) {
            String msg = ResManager.loadKDString((String)"\u53ea\u53ef\u6539\u4e3a\u5f53\u5929\u73ed\u6b21\u4e0b\u73ed\u5361\u3002", (String)"CardMatchHelper_7", (String)"wtc-wtpm-business", (Object[])new Object[0]);
            return dateString + msg;
        }
        if (!isFirst && PointTagEnum.AUTO_CURRENT.getCode().equals(oldPointTag) && !PointTagEnum.MANUAL_NEXT.getCode().equals(pointTag)) {
            String msg = ResManager.loadKDString((String)"\u53ea\u53ef\u6539\u4e3a\u540e\u4e00\u4e2a\u73ed\u6b21\u4e0a\u73ed\u5361\u3002", (String)"CardMatchHelper_8", (String)"wtc-wtpm-business", (Object[])new Object[0]);
            return dateString + msg;
        }
        if (!isFirst && PointTagEnum.MANUAL_CURRENT.getCode().equals(oldPointTag) && !PointTagEnum.MANUAL_NEXT.getCode().equals(pointTag)) {
            String msg = ResManager.loadKDString((String)"\u53ea\u53ef\u6539\u4e3a\u540e\u4e00\u4e2a\u73ed\u6b21\u4e0a\u73ed\u5361\u3002", (String)"CardMatchHelper_8", (String)"wtc-wtpm-business", (Object[])new Object[0]);
            return dateString + msg;
        }
        if (!isFirst && PointTagEnum.AUTO_PREVIOUS.getCode().equals(oldPointTag) && !PointTagEnum.MANUAL_CURRENT.getCode().equals(pointTag)) {
            String msg = ResManager.loadKDString((String)"\u53ea\u53ef\u6539\u4e3a\u5f53\u5929\u73ed\u6b21\u4e0a\u73ed\u5361\u3002", (String)"CardMatchHelper_9", (String)"wtc-wtpm-business", (Object[])new Object[0]);
            return dateString + msg;
        }
        if (!isFirst && PointTagEnum.MANUAL_PREVIOUS.getCode().equals(oldPointTag) && !PointTagEnum.MANUAL_CURRENT.getCode().equals(pointTag)) {
            String msg = ResManager.loadKDString((String)"\u53ea\u53ef\u6539\u4e3a\u5f53\u5929\u73ed\u6b21\u4e0a\u73ed\u5361\u3002", (String)"CardMatchHelper_9", (String)"wtc-wtpm-business", (Object[])new Object[0]);
            return dateString + msg;
        }
        return null;
    }

    public static List<SignCard> getSignCardsInRange(LocalDateTime startDateTimeUtc, LocalDateTime endDateTimeUtc, List<SignCard> legalSignCards) {
        return legalSignCards.stream().filter(sign -> startDateTimeUtc.isBefore(sign.getSignPointUtc()) && endDateTimeUtc.isAfter(sign.getSignPointUtc()) || startDateTimeUtc.equals(sign.getSignPointUtc()) || endDateTimeUtc.equals(sign.getSignPointUtc())).collect(Collectors.toList());
    }

    public static LocalDateTime getOffStart(MatchTaskVo taskVo, Shift preShift, MatchVo matchVo, LocalDate preDate, LocalDateTime startDateTime) {
        LocalDateTime lastDateTime = null;
        if (!HRObjectUtils.isEmpty((Object)preShift)) {
            LocalDateTime preActualSignLast = null;
            Map workEndMap = (Map)taskVo.getWorkEndMap().get(matchVo.getAttPersonId());
            if (null != workEndMap) {
                preActualSignLast = (LocalDateTime)workEndMap.get(preDate);
            }
            if (null != preActualSignLast) {
                lastDateTime = preActualSignLast.plusSeconds(1L);
            } else if (null != preShift.getShiftDetailList() && preShift.getShiftDetailList().size() > 0) {
                ShiftDetail detail = (ShiftDetail)preShift.getShiftDetailList().get(preShift.getShiftDetailList().size() - 1);
                lastDateTime = CardMatchHelper.getAbsoluteDateTime(preDate, detail.getRefEndDay(), detail.getShiftEndDate());
                LocalDateTime lastUtc = lastDateTime.minusHours(matchVo.getTimeDiff());
                lastDateTime = lastUtc.minusSeconds(1L);
            }
            if (null != lastDateTime) {
                startDateTime = startDateTime.isAfter(lastDateTime) ? startDateTime : lastDateTime;
            }
        }
        return startDateTime;
    }

    public static LocalDateTime getOffEnd(MatchTaskVo taskVo, Shift nextShift, MatchVo matchVo, LocalDate nextDate, LocalDateTime endDateTime) {
        LocalDateTime firstDateTime = null;
        if (!HRObjectUtils.isEmpty((Object)nextShift)) {
            LocalDateTime nextActualSignLast = null;
            Map workStartMap = (Map)taskVo.getWorkStartMap().get(matchVo.getAttPersonId());
            if (null != workStartMap) {
                nextActualSignLast = (LocalDateTime)workStartMap.get(nextDate);
            }
            if (null != nextActualSignLast) {
                firstDateTime = nextActualSignLast.plusSeconds(1L);
            } else if (null != nextShift.getShiftDetailList() && nextShift.getShiftDetailList().size() > 0) {
                ShiftDetail detail = (ShiftDetail)nextShift.getShiftDetailList().get(0);
                firstDateTime = CardMatchHelper.getAbsoluteDateTime(nextDate, detail.getRefStartDay(), detail.getShiftStartDate());
                LocalDateTime firstUtc = firstDateTime.minusHours(matchVo.getTimeDiff());
                firstDateTime = firstUtc.minusSeconds(1L);
            }
            if (null != firstDateTime) {
                endDateTime = endDateTime.isBefore(firstDateTime) ? endDateTime : firstDateTime;
            }
        }
        return endDateTime;
    }

    public static List<SignCard> getSignCardsByAttPersons(Set<Long> personIds, LocalDateTime start, LocalDateTime end) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtpd_signcard");
        Date startDate = Date.from(start.atZone(ZoneId.systemDefault()).toInstant());
        Date endDate = Date.from(end.atZone(ZoneId.systemDefault()).toInstant());
        QFilter[] qFilters = new QFilter[]{new QFilter("signpoint", ">=", (Object)startDate), new QFilter("signpoint", "<=", (Object)endDate), new QFilter("attperson", "in", personIds)};
        String selects = "id,signpoint,signpointutc, timezone.timedif, timezone.id,source.id, device.id, accesstag, pointTag, attperson.id,applyreason.id,status,presetbiz1,presetbiz2";
        DynamicObject[] dynamicObjects = hrBaseServiceHelper.query(selects, qFilters);
        List signCardList = Arrays.stream(dynamicObjects).filter(dy -> dy.getBoolean("status")).collect(Collectors.toList());
        ArrayList<SignCard> result = new ArrayList<SignCard>(signCardList.size());
        for (DynamicObject data : signCardList) {
            SignCard signCard = new SignCard();
            signCard.setId(Long.valueOf(data.getLong("id")));
            signCard.setAttPersonId(Long.valueOf(data.getLong("attperson.id")));
            signCard.setTimeZoneId(Long.valueOf(data.getLong("timezone.id")));
            signCard.setTimeDiff(data.getInt("timezone.timedif"));
            LocalDateTime signPoint = data.getDate("signpoint").toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            signCard.setSignPoint(signPoint);
            LocalDateTime signPointUtc = data.getDate("signpointutc").toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            signCard.setSignPointUtc(signPointUtc);
            signCard.setSource(Long.valueOf(data.getLong("source.id")));
            signCard.setDeviceId(Long.valueOf(data.getLong("device.id")));
            signCard.setAccessTag(data.getString("accesstag"));
            signCard.setPointTag(data.getString("pointtag"));
            signCard.setApplyReasonId(Long.valueOf(data.getLong("applyreason.id")));
            signCard.setPresetBiz1(data.getString("presetbiz1"));
            signCard.setPresetBiz2(data.getString("presetbiz2"));
            result.add(signCard);
        }
        return result;
    }

    public static List<LocalDate> getLocalDates(MatchTaskVo taskVo, Date start, Date end, long attFileId) {
        ArrayList<LocalDate> result = new ArrayList<LocalDate>(16);
        Date startDate = WTCDateUtils.getZeroDate((Date)start);
        Date endDate = WTCDateUtils.getZeroDate((Date)end);
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(startDate);
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(endDate);
        while (startCal.before(endCal)) {
            LocalDate localDate = startCal.getTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            result.add(localDate);
            startCal.add(6, 1);
        }
        LocalDate lastDate = startCal.getTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        result.add(lastDate);
        return result;
    }

    public static Map<Long, List<DynamicObject>> getAllTakeRuleConfigs(Date startDate, Date endDate) {
        HRBaseServiceHelper takeCardConfigHelper = new HRBaseServiceHelper("wtbd_takecardconfig");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter dateFilter = AttFileQueryHelper.getDateQFilter((Date)startDate, (Date)endDate, (boolean)true);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList("1", "2", "0"));
        DynamicObject[] data = takeCardConfigHelper.loadDynamicObjectArray(new QFilter[]{statusFilter, versionFilter, dateFilter, dataStatusFilter});
        return Arrays.stream(data).collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
    }

    public static Map<Long, List<DynamicObject>> getAllTakeRules(Date startDate, Date endDate) {
        HRBaseServiceHelper takeCardConfigHelper = new HRBaseServiceHelper("wtbd_takecardrule");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter dateFilter = AttFileQueryHelper.getDateQFilter((Date)startDate, (Date)endDate, (boolean)true);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList("1", "2", "0"));
        DynamicObject[] data = takeCardConfigHelper.loadDynamicObjectArray(new QFilter[]{statusFilter, versionFilter, dateFilter, dataStatusFilter});
        return Arrays.stream(data).collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
    }

    public static Map<Long, List<DynamicObject>> getAllShifts(Date startDate, Date endDate) {
        HRBaseServiceHelper takeCardConfigHelper = new HRBaseServiceHelper("wtbd_shift");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter dateFilter = AttFileQueryHelper.getDateQFilter((Date)startDate, (Date)endDate, (boolean)true);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList("1", "2", "0"));
        DynamicObject[] data = takeCardConfigHelper.loadDynamicObjectArray(new QFilter[]{statusFilter, versionFilter, dateFilter, dataStatusFilter});
        return Arrays.stream(data).collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
    }

    @Deprecated
    public static Map<Long, Map<LocalDate, Map<String, PointTagLog>>> getAllManualPointTag(Set<Long> attPersonIds, LocalDate start, LocalDate end) {
        QFilter attPersonFilter;
        QFilter endFilter;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtpm_pointtaglog");
        QFilter startFilter = new QFilter("vestingdate", ">=", (Object)Date.from(start.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()));
        DynamicObject[] data = serviceHelper.loadDynamicObjectArray(new QFilter[]{startFilter, endFilter = new QFilter("vestingdate", "<=", (Object)Date.from(end.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant())), attPersonFilter = new QFilter("attperson", "in", attPersonIds)});
        if (null == data || data.length == 0) {
            return new HashMap<Long, Map<LocalDate, Map<String, PointTagLog>>>(2);
        }
        ArrayList list = new ArrayList(data.length);
        Arrays.stream(data).forEach(item -> {
            PointTagLog pointTagLog = new PointTagLog();
            LocalDate vestingDate = item.getDate("vestingdate").toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            pointTagLog.setVestingDate(vestingDate);
            LocalDateTime multiPoint = item.getDate("multipoint").toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            pointTagLog.setMultiPoint(multiPoint);
            LocalDateTime multiPointUtc = item.getDate("multipointutc").toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            pointTagLog.setMultiPointUtc(multiPointUtc);
            pointTagLog.setTimeZoneId(Long.valueOf(item.getLong("timezone.id")));
            pointTagLog.setWorkTag(item.getString("worktag"));
            pointTagLog.setAttPersonId(Long.valueOf(item.getLong("attperson.id")));
            pointTagLog.setSource(Long.valueOf(item.getLong("source.id")));
            pointTagLog.setDeviceId(Long.valueOf(item.getLong("device.id")));
            pointTagLog.setAccessTag(item.getString("accesstag"));
            pointTagLog.setPointTag(item.getString("pointtag"));
            list.add(pointTagLog);
        });
        Map<Long, List<PointTagLog>> map = list.stream().collect(Collectors.groupingBy(PointTagLog::getAttPersonId));
        HashMap<Long, Map<LocalDate, Map<String, PointTagLog>>> result = new HashMap<Long, Map<LocalDate, Map<String, PointTagLog>>>(map.size());
        for (Map.Entry<Long, List<PointTagLog>> entry : map.entrySet()) {
            Long attPersonId = entry.getKey();
            List<PointTagLog> pointTagLogs = entry.getValue();
            HashMap<LocalDate, HashMap<String, PointTagLog>> localDateMap = new HashMap<LocalDate, HashMap<String, PointTagLog>>(pointTagLogs.size());
            for (PointTagLog pointTagLog : pointTagLogs) {
                boolean workStart = HRStringUtils.endsWithIgnoreCase((String)"0", (String)pointTagLog.getWorkTag());
                HashMap<String, PointTagLog> pointTagLogMap = (HashMap<String, PointTagLog>)localDateMap.get(pointTagLog.getVestingDate());
                if (CollectionUtils.isEmpty((Map)pointTagLogMap)) {
                    pointTagLogMap = new HashMap<String, PointTagLog>(2);
                }
                pointTagLogMap.put(workStart ? "start" : "end", pointTagLog);
                localDateMap.put(pointTagLog.getVestingDate(), pointTagLogMap);
            }
            result.put(attPersonId, localDateMap);
        }
        return result;
    }

    public static Map<Long, Map<LocalDate, Map<String, PointTagLog>>> getAllManualPointTag(MatchTaskVo taskVo, LocalDate start, LocalDate end) {
        QFilter attPersonFilter;
        QFilter endFilter;
        Set attPersonIds = taskVo.getAttPersonIds();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtpm_pointtaglog");
        QFilter startFilter = new QFilter("vestingdate", ">=", (Object)WTCDateUtils.toDate((LocalDate)start));
        DynamicObject[] logDys = serviceHelper.loadDynamicObjectArray(new QFilter[]{startFilter, endFilter = new QFilter("vestingdate", "<=", (Object)WTCDateUtils.toDate((LocalDate)end)), attPersonFilter = new QFilter("attperson", "in", (Object)attPersonIds)});
        if (null == logDys || logDys.length == 0) {
            return new HashMap<Long, Map<LocalDate, Map<String, PointTagLog>>>(2);
        }
        ArrayList<PointTagLog> list = new ArrayList<PointTagLog>(logDys.length);
        for (DynamicObject log : logDys) {
            LocalDateTime multiPointUtc;
            long attPersonId = log.getLong("attperson.id");
            List signCards = (List)taskVo.getSignCardMap().get(attPersonId);
            if (HRCollUtil.isEmpty((Collection)signCards) || null == (multiPointUtc = WTCDateUtils.toLocalDateTime((Date)log.getDate("multipointutc")))) continue;
            long sourceId = log.getLong("source.id");
            boolean effectiveLog = false;
            for (SignCard signCard : signCards) {
                if (!signCard.getSignPointUtc().isEqual(multiPointUtc) || sourceId != signCard.getSource()) continue;
                effectiveLog = true;
                break;
            }
            if (!effectiveLog) continue;
            PointTagLog pointTagLog = new PointTagLog();
            LocalDate vestingDate = log.getDate("vestingdate").toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            pointTagLog.setVestingDate(vestingDate);
            LocalDateTime multiPoint = log.getDate("multipoint").toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            pointTagLog.setMultiPoint(multiPoint);
            pointTagLog.setMultiPointUtc(multiPointUtc);
            pointTagLog.setTimeZoneId(Long.valueOf(log.getLong("timezone.id")));
            pointTagLog.setWorkTag(log.getString("worktag"));
            pointTagLog.setAttPersonId(Long.valueOf(attPersonId));
            pointTagLog.setSource(Long.valueOf(sourceId));
            pointTagLog.setDeviceId(Long.valueOf(log.getLong("device.id")));
            pointTagLog.setAccessTag(log.getString("accesstag"));
            pointTagLog.setPointTag(log.getString("pointtag"));
            list.add(pointTagLog);
        }
        Map<Long, List<PointTagLog>> map = list.stream().collect(Collectors.groupingBy(PointTagLog::getAttPersonId));
        HashMap<Long, Map<LocalDate, Map<String, PointTagLog>>> result = new HashMap<Long, Map<LocalDate, Map<String, PointTagLog>>>(map.size());
        for (Map.Entry<Long, List<PointTagLog>> entry : map.entrySet()) {
            Long attPersonId = entry.getKey();
            List<PointTagLog> pointTagLogs = entry.getValue();
            HashMap<LocalDate, HashMap<String, PointTagLog>> localDateMap = new HashMap<LocalDate, HashMap<String, PointTagLog>>(pointTagLogs.size());
            for (PointTagLog pointTagLog : pointTagLogs) {
                boolean workStart = HRStringUtils.endsWithIgnoreCase((String)"0", (String)pointTagLog.getWorkTag());
                HashMap<String, PointTagLog> pointTagLogMap = (HashMap<String, PointTagLog>)localDateMap.get(pointTagLog.getVestingDate());
                if (CollectionUtils.isEmpty((Map)pointTagLogMap)) {
                    pointTagLogMap = new HashMap<String, PointTagLog>(2);
                }
                pointTagLogMap.put(workStart ? "start" : "end", pointTagLog);
                localDateMap.put(pointTagLog.getVestingDate(), pointTagLogMap);
            }
            result.put(attPersonId, localDateMap);
        }
        return result;
    }

    public static List<SignCard> getAllSignCardsByAttPersons(Set<Long> personIds, LocalDate start, LocalDate end) {
        LocalDateTime actualEnd;
        LocalDateTime actualStart = start.atStartOfDay().minusDays(2L);
        List<SignCard> signCards = CardMatchHelper.getSignCardsByAttPersons(personIds, actualStart, actualEnd = end.atStartOfDay().plusDays(2L));
        if (CollectionUtils.isEmpty(signCards)) {
            return new ArrayList<SignCard>(1);
        }
        return signCards;
    }

    @Deprecated
    public static Map<Long, Map<LocalDate, LocalDateTime>> getWorkEffectivePoints(boolean isWorkStart, LocalDate localDate, Set<Long> attPersonIds) {
        QFilter pointFilter;
        DynamicObject[] multiData;
        QFilter dateFilter;
        HashMap<Long, Map<LocalDate, LocalDateTime>> result = new HashMap<Long, Map<LocalDate, LocalDateTime>>(attPersonIds.size());
        HRBaseServiceHelper multiServiceHelper = new HRBaseServiceHelper("wtpm_multicard");
        HRBaseServiceHelper onceServiceHelper = new HRBaseServiceHelper("wtpm_oncecard");
        Date date = WTCDateUtils.toDate((LocalDate)localDate);
        if (!isWorkStart) {
            Date nextDate = WTCDateUtils.toDate((LocalDate)localDate.plusDays(1L));
            dateFilter = new QFilter("shiftdate", ">=", (Object)date).and(new QFilter("shiftdate", "<=", (Object)nextDate));
        } else {
            Date preDate = WTCDateUtils.toDate((LocalDate)localDate.minusDays(1L));
            dateFilter = new QFilter("shiftdate", ">=", (Object)preDate).and(new QFilter("shiftdate", "<=", (Object)date));
        }
        QFilter attPersonFilter = new QFilter("attperson", "in", attPersonIds);
        QFilter onceFilter = new QFilter("oncepointutc", "is not null", null);
        DynamicObject[] onceData = onceServiceHelper.query("attperson.id,oncepointutc,shiftdate", new QFilter[]{dateFilter, attPersonFilter, onceFilter});
        if (null != onceData && onceData.length > 0) {
            for (DynamicObject once : onceData) {
                Long attPersonId = once.getLong("attperson.id");
                Date oncePointUtc = once.getDate("oncepointutc");
                Date shiftDate = once.getDate("shiftdate");
                if (null == oncePointUtc) continue;
                LocalDateTime localDateTime = oncePointUtc.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
                HashMap<LocalDate, LocalDateTime> map = new HashMap<LocalDate, LocalDateTime>(2);
                map.put(WTCDateUtils.toLocalDate((Date)shiftDate), localDateTime);
                result.put(attPersonId, map);
            }
        }
        if (null != (multiData = multiServiceHelper.query("attperson.id,entryentity.multipointutc,shiftdate", new QFilter[]{dateFilter, attPersonFilter, pointFilter = new QFilter("entryentity.multipointutc", "is not null", null)})) && multiData.length > 0) {
            for (DynamicObject multi : multiData) {
                Long attPersonId = multi.getLong("attperson.id");
                Date shiftDate = multi.getDate("shiftdate");
                DynamicObjectCollection entity = multi.getDynamicObjectCollection("entryentity");
                List effectiveList = entity.stream().filter(item -> !HRObjectUtils.isEmpty((Object)item.get("multipointutc"))).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(effectiveList)) continue;
                LocalDateTime localDateTime = Boolean.FALSE.equals(isWorkStart) ? WTCDateUtils.toLocalDateTime((Date)((DynamicObject)effectiveList.get(effectiveList.size() - 1)).getDate("multipointutc")) : WTCDateUtils.toLocalDateTime((Date)((DynamicObject)effectiveList.get(0)).getDate("multipointutc"));
                HashMap<LocalDate, LocalDateTime> map = new HashMap<LocalDate, LocalDateTime>(2);
                map.put(WTCDateUtils.toLocalDate((Date)shiftDate), localDateTime);
                result.put(attPersonId, map);
            }
        }
        return result;
    }

    public static void getWorkEffectivePoints(boolean isWorkStart, LocalDate localDate, Set<Long> attPersonIds, MatchTaskVo taskVo) {
        String properties;
        DynamicObject[] multiData;
        QFilter dateFilter;
        HRBaseServiceHelper multiServiceHelper = new HRBaseServiceHelper("wtpm_multicard");
        HRBaseServiceHelper onceServiceHelper = new HRBaseServiceHelper("wtpm_oncecard");
        Date date = WTCDateUtils.toDate((LocalDate)localDate);
        if (!isWorkStart) {
            Date nextDate = WTCDateUtils.toDate((LocalDate)localDate.plusDays(1L));
            dateFilter = new QFilter("shiftdate", ">=", (Object)date).and(new QFilter("shiftdate", "<=", (Object)nextDate));
        } else {
            Date preDate = WTCDateUtils.toDate((LocalDate)localDate.minusDays(1L));
            dateFilter = new QFilter("shiftdate", ">=", (Object)preDate).and(new QFilter("shiftdate", "<=", (Object)date));
        }
        QFilter attPersonFilter = new QFilter("attperson", "in", attPersonIds);
        QFilter onceFilter = new QFilter("oncepointutc", "is not null", null);
        DynamicObject[] onceData = onceServiceHelper.query("attperson.id,oncepointutc,shiftdate", new QFilter[]{dateFilter, attPersonFilter, onceFilter});
        if (null != onceData && onceData.length > 0) {
            for (DynamicObject once : onceData) {
                Long attPersonId = once.getLong("attperson.id");
                Date oncePointUtc = once.getDate("oncepointutc");
                Date shiftDate = once.getDate("shiftdate");
                LocalDate shiftLocal = WTCDateUtils.toLocalDate((Date)shiftDate);
                if (null == oncePointUtc) continue;
                LocalDateTime localDateTime = oncePointUtc.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
                HashMap<LocalDate, LocalDateTime> workEndMap = (HashMap<LocalDate, LocalDateTime>)taskVo.getWorkEndMap().get(attPersonId);
                if (null == workEndMap) {
                    workEndMap = new HashMap<LocalDate, LocalDateTime>(16);
                }
                workEndMap.put(shiftLocal, localDateTime);
                taskVo.getWorkEndMap().put(attPersonId, workEndMap);
                HashMap<LocalDate, LocalDateTime> workStartMap = (HashMap<LocalDate, LocalDateTime>)taskVo.getWorkStartMap().get(attPersonId);
                if (null == workStartMap) {
                    workStartMap = new HashMap<LocalDate, LocalDateTime>(16);
                }
                workStartMap.put(shiftLocal, localDateTime);
                taskVo.getWorkStartMap().put(attPersonId, workStartMap);
            }
        }
        if (null != (multiData = multiServiceHelper.query(properties = "id,attperson.id,entryentity.multipointutc,shiftdate,entryentity.pointtag,entryentity.effectivepoint,entryentity.timezone,entryentity.source,entryentity.device,entryentity.accesstag", new QFilter[]{dateFilter, attPersonFilter})) && multiData.length > 0) {
            for (DynamicObject multi : multiData) {
                Long attPersonId = multi.getLong("attperson.id");
                Date shiftDate = multi.getDate("shiftdate");
                LocalDate shiftLocal = WTCDateUtils.toLocalDate((Date)shiftDate);
                HashMap<LocalDate, DynamicObject> dyMap = (HashMap<LocalDate, DynamicObject>)taskVo.getMultiMap().get(attPersonId);
                if (HRMapUtils.isEmpty((Map)dyMap)) {
                    dyMap = new HashMap<LocalDate, DynamicObject>(2);
                }
                dyMap.put(WTCDateUtils.toLocalDate((Date)shiftDate), multi);
                taskVo.getMultiMap().put(attPersonId, dyMap);
                DynamicObjectCollection entity = multi.getDynamicObjectCollection("entryentity");
                List effectiveList = entity.stream().filter(item -> !HRObjectUtils.isEmpty((Object)item.get("multipointutc"))).collect(Collectors.toList());
                if (HRCollUtil.isEmpty(effectiveList)) continue;
                HashMap<LocalDate, LocalDateTime> workEndMap = (HashMap<LocalDate, LocalDateTime>)taskVo.getWorkEndMap().get(attPersonId);
                if (null == workEndMap) {
                    workEndMap = new HashMap<LocalDate, LocalDateTime>(16);
                }
                workEndMap.put(shiftLocal, WTCDateUtils.toLocalDateTime((Date)((DynamicObject)effectiveList.get(effectiveList.size() - 1)).getDate("multipointutc")));
                taskVo.getWorkEndMap().put(attPersonId, workEndMap);
                HashMap<LocalDate, LocalDateTime> workStartMap = (HashMap<LocalDate, LocalDateTime>)taskVo.getWorkStartMap().get(attPersonId);
                if (null == workStartMap) {
                    workStartMap = new HashMap<LocalDate, LocalDateTime>(16);
                }
                workStartMap.put(WTCDateUtils.toLocalDate((Date)shiftDate), WTCDateUtils.toLocalDateTime((Date)((DynamicObject)effectiveList.get(0)).getDate("multipointutc")));
                taskVo.getWorkStartMap().put(attPersonId, workStartMap);
            }
        }
    }

    public static void batchSaveEffectiveCards(MatchTaskVo taskVo) {
        CardMatchHelper.batchSaveMultiCards(taskVo);
        CardMatchHelper.batchSaveCheckCards(taskVo);
        if (!taskVo.isManualPointTag()) {
            CardMatchHelper.batchSaveOnceCards(taskVo);
        }
        CardMatchHelper.batchSaveLackCards(taskVo);
        CardMatchHelper.batchUpdateMultiCards(taskVo);
    }

    private static void batchSaveLackCards(MatchTaskVo taskVo) {
        HRBaseServiceHelper lackCardHelper = new HRBaseServiceHelper("wtpm_lackcard");
        CardMatchHelper.removeCurrentEffectiveCards(lackCardHelper, taskVo);
        Set multiCards = taskVo.getMultiCardSet();
        DynamicObjectCollection collection = new DynamicObjectCollection();
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"wtpm_lackcard");
        for (MultiCard multiCard : multiCards) {
            if (multiCard.isOffShift() && multiCard.isNotPlan()) continue;
            Map multiExtMap = (Map)taskVo.getExtMap().get("multiCardExtMap");
            if (!HRMapUtils.isEmpty((Map)multiExtMap) && null != multiExtMap.get(multiCard.getAttFileBoId()) && null != ((Map)multiExtMap.get(multiCard.getAttFileBoId())).get(multiCard.getShiftDate())) {
                List entryExtList = ((MultiCardExt)((Map)multiExtMap.get(multiCard.getAttFileBoId())).get(multiCard.getShiftDate())).getEntryList();
                Iterator iterator = entryExtList.iterator();
                while (iterator.hasNext()) {
                    MultiCardEntryExt entryExt = (MultiCardEntryExt)iterator.next();
                    if (null != entryExt.getEffectivePoint()) continue;
                    DynamicObject lackResult = new DynamicObject((DynamicObjectType)mainEntityType);
                    lackResult.set("attperson", (Object)multiCard.getAttPersonId());
                    lackResult.set("org", (Object)multiCard.getOrgId());
                    lackResult.set("attmode", (Object)AttModeEnum.MANY_CARD.getCode());
                    lackResult.set("attcard", (Object)multiCard.getAttCard());
                    lackResult.set("shiftdate", (Object)WTCDateUtils.toDate((LocalDate)multiCard.getShiftDate()));
                    lackResult.set("shift", (Object)multiCard.getShiftId());
                    lackResult.set("week", (Object)multiCard.getWeek());
                    lackResult.set("datetype", (Object)multiCard.getDateTypeId());
                    lackResult.set("attfile", (Object)multiCard.getAttFileId());
                    lackResult.set("attfilebo", (Object)multiCard.getAttFileBoId());
                    lackResult.set("lackpoint", null != entryExt.getMustPoint() ? WTCDateUtils.toDate((LocalDateTime)entryExt.getMustPoint()) : null);
                    lackResult.set("lackpointutc", null != entryExt.getMustPointUtc() ? WTCDateUtils.toDate((LocalDateTime)entryExt.getMustPointUtc()) : null);
                    lackResult.set("timezone", (Object)multiCard.getAttFileTimeZoneId());
                    lackResult.set("pointdesc", (Object)entryExt.getPointDescId());
                    collection.add((Object)lackResult);
                }
                continue;
            }
            for (MultiCardEntry entry : multiCard.getEntryList()) {
                if (null != entry.getEffectivePoint()) continue;
                DynamicObject lackResult = new DynamicObject((DynamicObjectType)mainEntityType);
                lackResult.set("attperson", (Object)multiCard.getAttPersonId());
                lackResult.set("org", (Object)multiCard.getOrgId());
                lackResult.set("attmode", (Object)AttModeEnum.MANY_CARD.getCode());
                lackResult.set("attcard", (Object)multiCard.getAttCard());
                lackResult.set("shiftdate", (Object)WTCDateUtils.toDate((LocalDate)multiCard.getShiftDate()));
                lackResult.set("shift", (Object)multiCard.getShiftId());
                lackResult.set("week", (Object)multiCard.getWeek());
                lackResult.set("datetype", (Object)multiCard.getDateTypeId());
                lackResult.set("attfile", (Object)multiCard.getAttFileId());
                lackResult.set("attfilebo", (Object)multiCard.getAttFileBoId());
                lackResult.set("lackpoint", null != entry.getMustPoint() ? WTCDateUtils.toDate((LocalDateTime)entry.getMustPoint()) : null);
                lackResult.set("lackpointutc", null != entry.getMustPointUtc() ? WTCDateUtils.toDate((LocalDateTime)entry.getMustPointUtc()) : null);
                lackResult.set("timezone", (Object)multiCard.getAttFileTimeZoneId());
                lackResult.set("pointdesc", (Object)entry.getPointDescId());
                collection.add((Object)lackResult);
            }
        }
        Set onceCards = taskVo.getOnceCardSet();
        for (OnceCard onceCard : onceCards) {
            if (onceCard.isOffShift() || onceCard.isNotPlan() || null != onceCard.getOncePoint()) continue;
            DynamicObject lackResult = new DynamicObject((DynamicObjectType)mainEntityType);
            lackResult.set("attperson", (Object)onceCard.getAttPersonId());
            lackResult.set("org", (Object)onceCard.getOrgId());
            lackResult.set("attmode", (Object)AttModeEnum.ONES_CARD.getCode());
            lackResult.set("attcard", (Object)onceCard.getAttCard());
            lackResult.set("shiftdate", (Object)Date.from(onceCard.getShiftDate().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()));
            lackResult.set("shift", (Object)onceCard.getShiftId());
            lackResult.set("week", (Object)onceCard.getWeek());
            lackResult.set("datetype", (Object)onceCard.getDateTypeId());
            lackResult.set("attfile", (Object)onceCard.getAttFileId());
            lackResult.set("attfilebo", (Object)onceCard.getAttFileBoId());
            lackResult.set("timezone", (Object)onceCard.getAttFileTimeZoneId());
            collection.add((Object)lackResult);
        }
        lackCardHelper.save(collection);
    }

    private static void batchSaveCheckCards(MatchTaskVo taskVo) {
        Set checkCards = taskVo.getCheckCardSet();
        HRBaseServiceHelper checkCardHelper = new HRBaseServiceHelper("wtpm_checkcard");
        CardMatchHelper.removeCurrentEffectiveCards(checkCardHelper, taskVo);
        if (null != checkCards && checkCards.size() > 0) {
            DynamicObjectCollection collection = new DynamicObjectCollection();
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"wtpm_checkcard");
            for (CheckCard checkCard : checkCards) {
                DynamicObject checkResult = new DynamicObject((DynamicObjectType)mainEntityType);
                checkResult.set("attperson", (Object)checkCard.getAttPersonId());
                checkResult.set("org", (Object)checkCard.getOrgId());
                checkResult.set("attcard", (Object)checkCard.getAttCard());
                checkResult.set("shiftdate", (Object)Date.from(checkCard.getShiftDate().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()));
                checkResult.set("shift", (Object)checkCard.getShiftId());
                checkResult.set("attfile", (Object)checkCard.getAttFileId());
                checkResult.set("attfilebo", (Object)checkCard.getAttFileBoId());
                checkResult.set("week", (Object)checkCard.getWeek());
                checkResult.set("datetype", (Object)checkCard.getDateTypeId());
                DynamicObjectCollection checkEntryCollection = new DynamicObjectCollection();
                DynamicObjectType checkEntity = checkResult.getDynamicObjectCollection("entryentity").getDynamicObjectType();
                int seq = 0;
                for (CheckCardEntry check : checkCard.getEntryList()) {
                    DynamicObject row = new DynamicObject(checkEntity);
                    row.set("seq", (Object)seq++);
                    row.set("checkpointutc", null != check.getCheckPointUtc() ? Date.from(check.getCheckPointUtc().atZone(ZoneId.systemDefault()).toInstant()) : null);
                    row.set("checkpoint", null != check.getCheckPoint() ? Date.from(check.getCheckPoint().atZone(ZoneId.systemDefault()).toInstant()) : null);
                    row.set("timezone", (Object)check.getTimeZoneId());
                    row.set("source", (Object)check.getSource());
                    row.set("device", (Object)check.getDeviceId());
                    row.set("pointdesc", (Object)check.getPointDesc());
                    row.set("accesstag", (Object)check.getAccessTag());
                    row.set("pointtag", (Object)check.getPointTag());
                    row.set("matchdate", (Object)Date.from(checkCard.getShiftDate().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()));
                    row.set("attpersonid", (Object)checkCard.getAttPersonId());
                    row.set("presetbiz1", (Object)check.getPresetBiz1());
                    row.set("presetbiz2", (Object)check.getPresetBiz2());
                    checkEntryCollection.add((Object)row);
                }
                checkResult.set("entryentity", (Object)checkEntryCollection);
                collection.add((Object)checkResult);
            }
            checkCardHelper.save(collection);
        }
    }

    private static void batchSaveOnceCards(MatchTaskVo taskVo) {
        HRBaseServiceHelper onceCardHelper = new HRBaseServiceHelper("wtpm_oncecard");
        CardMatchHelper.removeCurrentEffectiveCards(onceCardHelper, taskVo);
        Set onceCards = taskVo.getOnceCardSet();
        if (null != onceCards && onceCards.size() > 0) {
            DynamicObjectCollection collection = new DynamicObjectCollection();
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"wtpm_oncecard");
            for (OnceCard onceCard : onceCards) {
                DynamicObject onceResult = new DynamicObject((DynamicObjectType)mainEntityType);
                onceResult.set("attperson", (Object)onceCard.getAttPersonId());
                onceResult.set("org", (Object)onceCard.getOrgId());
                onceResult.set("attcard", (Object)onceCard.getAttCard());
                onceResult.set("shiftdate", (Object)Date.from(onceCard.getShiftDate().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()));
                onceResult.set("shift", (Object)onceCard.getShiftId());
                onceResult.set("attfile", (Object)onceCard.getAttFileId());
                onceResult.set("attfilebo", (Object)onceCard.getAttFileBoId());
                onceResult.set("week", (Object)onceCard.getWeek());
                onceResult.set("datetype", (Object)onceCard.getDateTypeId());
                onceResult.set("oncerange", (Object)onceCard.getOnceRange());
                onceResult.set("timezone", (Object)onceCard.getTimeZoneId());
                onceResult.set("source", (Object)onceCard.getSourceId());
                onceResult.set("device", (Object)onceCard.getDeviceId());
                onceResult.set("oncepointutc", null != onceCard.getOncePointUtc() ? Date.from(onceCard.getOncePointUtc().atZone(ZoneId.systemDefault()).toInstant()) : null);
                onceResult.set("oncepoint", null != onceCard.getOncePoint() ? Date.from(onceCard.getOncePoint().atZone(ZoneId.systemDefault()).toInstant()) : null);
                onceResult.set("accesstag", (Object)onceCard.getAccessTag());
                onceResult.set("pointtag", (Object)onceCard.getPointTag());
                onceResult.set("applyreason", (Object)onceCard.getApplyReasonId());
                onceResult.set("presetbiz1", (Object)onceCard.getPresetBiz1());
                onceResult.set("presetbiz2", (Object)onceCard.getPresetBiz2());
                collection.add((Object)onceResult);
            }
            onceCardHelper.save(collection);
        }
    }

    public static void getAllVaApplyBills(MatchTaskVo taskVo) {
        AttFilesVaBillReq vaParam = new AttFilesVaBillReq();
        vaParam.setAttFileBoIds(new ArrayList(taskVo.getAttFileBoIds()));
        vaParam.setStartDate(taskVo.getStartDate());
        vaParam.setEndDate(taskVo.getEndDate());
        vaParam.setBillStateEnum(AttFilesVaBillReq.BILL_STATE.VALIDATED);
        Map vaBillMap = (Map)WTCServiceHelper.invokeWtcWtabmBizService((String)"IVaApplyBillService", (String)"getVaBillInfoByAttFileBoids", (Object[])new Object[]{vaParam});
        if (HRMapUtils.isEmpty((Map)vaBillMap)) {
            return;
        }
        VaBillService vaBillService = VaBillService.getInstance();
        for (Map.Entry entry : vaBillMap.entrySet()) {
            VaBillParseParam param = new VaBillParseParam();
            param.setAttFileBoid(((Long)entry.getKey()).longValue());
            param.setStartDate(taskVo.getStartDate());
            param.setEndDate(taskVo.getEndDate());
            param.setDutyShiftResponse(taskVo.getDutyShift());
            param.setVaBillVos((List)entry.getValue());
            List list = vaBillService.parseVaBillByShifts(param);
            taskVo.getVaBillMap().put(entry.getKey(), list);
        }
    }

    public static void batchSaveSignCards(List<SignCard> signCards) {
        HRBaseServiceHelper onceCardHelper = new HRBaseServiceHelper("wtpd_signcard");
        if (null != signCards && signCards.size() > 0) {
            DynamicObjectCollection collection = new DynamicObjectCollection();
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"wtpd_signcard");
            for (SignCard signCard : signCards) {
                DynamicObject data = new DynamicObject((DynamicObjectType)mainEntityType);
                data.set("attperson", (Object)signCard.getAttPersonId());
                data.set("attfilebo", (Object)signCard.getAttFileBoId());
                data.set("attfile", (Object)signCard.getAttFileId());
                data.set("org", (Object)signCard.getOrgId());
                data.set("attcard", (Object)signCard.getAttCard());
                data.set("signpoint", (Object)Date.from(signCard.getSignPoint().atZone(ZoneId.systemDefault()).toInstant()));
                data.set("source", (Object)signCard.getSource());
                data.set("status", (Object)"1");
                data.set("accesstag", (Object)signCard.getAccessTag());
                data.set("timezone", (Object)signCard.getTimeZoneId());
                data.set("signpointutc", (Object)Date.from(signCard.getSignPointUtc().atZone(ZoneId.systemDefault()).toInstant()));
                collection.add((Object)data);
            }
            onceCardHelper.save(collection);
        }
    }

    public static Set<Long> getReRunFileBoIds(Object taskId, Set<Long> attFileBoIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtpm_matchtaskdetail");
        Set<Long> fileBoIdSet = attFileBoIds;
        if (CollectionUtils.isEmpty(attFileBoIds)) {
            DynamicObject[] taskDetailDys = helper.queryOriginalArray("attFileBoId", new QFilter[]{new QFilter("taskid", "=", taskId)});
            fileBoIdSet = Arrays.stream(taskDetailDys).map(taskDetailDy -> taskDetailDy.getLong("attFileBoId")).collect(Collectors.toSet());
        }
        AttFileF7QueryParam queryParam = new AttFileF7QueryParam();
        queryParam.setSetBoIds(fileBoIdSet);
        queryParam.setProperties("boid");
        queryParam.setPermField("attfile");
        queryParam.setFormId("wtpm_matchtaskdetail");
        queryParam.setAppId("wtpm");
        queryParam.setUsableStatus((Set)Sets.newHashSet((Object[])new String[]{"0", "-1"}));
        Page attFileDys = AttFileQueryServiceImpl.getInstance().queryAttFileF7WithPerm(queryParam, 0, 1000000);
        return attFileDys.getListRecords().stream().map(fileDy -> fileDy.getLong("boid")).collect(Collectors.toSet());
    }

    public static Map<String, Object> getTaskCustomParams(long orgId, Date startDate, Date endDate, String version, String desc, Set<Long> attFileBoIds, Map<String, Object> otherParams) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("org", orgId);
        result.put("startdate", startDate);
        result.put("enddate", endDate);
        String newVersion = CodeRuleServiceHelper.getNumber((String)"wtpm_matchresult", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"wtpm_matchresult"), null);
        String newDesc = desc;
        if (!HRStringUtils.isEmpty((String)version)) {
            newDesc = CardMatchKDString.reRun() + version;
        }
        result.put("version", newVersion);
        result.put("desc", newDesc);
        result.put("attFileBoIds", attFileBoIds);
        if (!HRMapUtils.isEmpty(otherParams)) {
            result.putAll(otherParams);
        }
        return result;
    }

    public static void retainFrozenDate(MatchVo matchVo, MatchTaskVo taskVo) {
        String dateRangeStr = (String)taskVo.getRetainMap().get(matchVo.getAttFileBoId());
        if (HRStringUtils.isNotEmpty((String)dateRangeStr)) {
            return;
        }
        long start = Math.max(matchVo.getFrozenStartDate().getTime(), taskVo.getStartDate().getTime());
        long end = Math.min(matchVo.getFrozenEndDate().getTime(), taskVo.getEndDate().getTime());
        StringBuilder sb = new StringBuilder();
        dateRangeStr = sb.append(start).append("_").append(end).toString();
        taskVo.getRetainMap().put(matchVo.getAttFileBoId(), dateRangeStr);
    }

    public static LocalDateTime getNextShiftMustFirst(MatchVo matchVo) {
        if (null == matchVo.getNextShift() || matchVo.getNextShift().getOffNonPlan() && matchVo.getNextShift().isOff()) {
            return null;
        }
        if (null == matchVo.getNextShift().getShiftDetailList() || null == matchVo.getNextTakeCardRule() || null == matchVo.getNextTakeCardRule().getTimeSeqList()) {
            return null;
        }
        List<MustSignInfoVo> nextMustList = CardMatchHelper.getShiftMustSignList(matchVo.getNextShift().getShiftDetailList(), matchVo.getNextTakeCardRule().getTimeSeqList(), matchVo.getLocalDate().plusDays(1L));
        if (HRCollUtil.isEmpty(nextMustList)) {
            return null;
        }
        MustSignInfoVo nextInfo = nextMustList.get(0);
        if (!TaskCardModeEnum.EARLIEST.getCode().equals(nextInfo.getsTakeCardRule())) {
            return null;
        }
        return nextInfo.getAbsoluteSign().minusHours(matchVo.getNextTimeDiff());
    }
}

