/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.cardmatch;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtpm.business.cardmatch.AfterCardMatchEvent;
import kd.sdk.wtc.wtpm.business.cardmatch.AfterCardMatchExtPlugin;
import kd.sdk.wtc.wtpm.business.cardmatch.BeforeCardMatchIntersectionEvent;
import kd.sdk.wtc.wtpm.business.cardmatch.CardMatchIntersectionExtPlugin;
import kd.sdk.wtc.wtpm.business.cardmatch.CardMatchOffShiftExtPlugin;
import kd.sdk.wtc.wtpm.business.cardmatch.OffShiftTakeCardRangeEvent;
import kd.sdk.wtc.wtpm.model.cardmatch.CardMatchTaskVoExt;
import kd.sdk.wtc.wtpm.model.cardmatch.CardMatchVoExt;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.task.common.WTCSource;
import kd.wtc.wtbs.business.task.executor.WTCShardingAbleTask;
import kd.wtc.wtbs.business.task.executor.WTCTaskParam;
import kd.wtc.wtbs.business.task.sharding.std.WTCTaskCalShardingDetail;
import kd.wtc.wtbs.business.web.evaluation.EvaluationServiceHelper;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.file.schedule.AttFileScheduleServiceImpl;
import kd.wtc.wtbs.common.constants.takecard.CardRuleConstants;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.enums.AttModeEnum;
import kd.wtc.wtbs.common.enums.file.AttStatusEnum;
import kd.wtc.wtbs.common.enums.signcard.OnceCardModeEnum;
import kd.wtc.wtbs.common.enums.signcard.TaskCardModeEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.attfile.AttFileScheduleQueryParam;
import kd.wtc.wtbs.common.model.bill.va.VaBillEntryEntityValidVo;
import kd.wtc.wtbs.common.model.bill.va.VaBillWithTimeVo;
import kd.wtc.wtbs.common.model.bill.va.VaEntryValidTimeVo;
import kd.wtc.wtbs.common.model.evaluation.DutyShiftResponse;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.model.evaluation.ShiftDetail;
import kd.wtc.wtbs.common.model.sign.CheckCard;
import kd.wtc.wtbs.common.model.sign.CheckCardEntry;
import kd.wtc.wtbs.common.model.sign.MultiCard;
import kd.wtc.wtbs.common.model.sign.MultiCardEntry;
import kd.wtc.wtbs.common.model.sign.MultiCardEntryDTO;
import kd.wtc.wtbs.common.model.sign.PointTagLog;
import kd.wtc.wtbs.common.model.sign.SignCard;
import kd.wtc.wtbs.common.model.sign.SignCardDTO;
import kd.wtc.wtbs.common.model.sign.TakeCardRule;
import kd.wtc.wtbs.common.model.sign.TimeSeq;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.wtbd.common.enums.TakeCardRuleRefDayEnum;
import kd.wtc.wtbs.wtom.common.rpc.OtDutyDateStartEndTime;
import kd.wtc.wtpm.business.cardmatch.CardMatchHelper;
import kd.wtc.wtpm.business.cardmatch.MatchService;
import kd.wtc.wtpm.business.ext.model.cardmatch.CardMatchTaskVoExtImpl;
import kd.wtc.wtpm.business.ext.model.cardmatch.MatchVoExtImpl;
import kd.wtc.wtpm.business.ext.model.cardmatch.SignCardExtImpl;
import kd.wtc.wtpm.business.signcard.SignCardCommonService;
import kd.wtc.wtpm.business.supquotapool.SupQuotaPoolTaskService;
import kd.wtc.wtpm.common.vo.cardmatch.ExLogVo;
import kd.wtc.wtpm.common.vo.cardmatch.MatchDetailVo;
import kd.wtc.wtpm.common.vo.cardmatch.MatchTaskVo;
import kd.wtc.wtpm.common.vo.cardmatch.MatchVo;
import kd.wtc.wtpm.common.vo.cardmatch.MustSignInfoVo;
import kd.wtc.wtpm.common.vo.cardmatch.OffRangeVo;
import kd.wtc.wtpm.common.vo.cardmatch.ShiftVo;
import kd.wtc.wtpm.common.vo.cardmatch.TakeCardRangeVo;
import kd.wtc.wtpm.common.vo.cardmatch.TaskSummaryVo;
import kd.wtc.wtpm.common.vo.cardmatch.TaskVo;
import kd.wtc.wtpm.common.vo.cardmatch.TimeZoneVo;
import kd.wtc.wtpm.constants.sign.CardMatchConstants;
import kd.wtc.wtpm.constants.sign.CardMatchKDString;
import kd.wtc.wtpm.enums.MatchStatusEnum;

public class CardMatchServiceImpl
extends MatchService
implements CardMatchConstants {
    private static final Log LOG = LogFactory.getLog(CardMatchServiceImpl.class);

    @Override
    public void batchCardMatch(WTCTaskParam taskParams) {
        LOG.info("cardmatch,start....");
        long batchMatch = new Date().getTime();
        MatchTaskVo taskVo = (MatchTaskVo)this.beforeBatchCardMatch(taskParams);
        this.doBatchCardMatch(taskVo);
        this.costLog("batchMatch", batchMatch);
        LOG.info("cardmatch,end....");
    }

    @Override
    protected TaskVo beforeBatchCardMatch(WTCTaskParam taskParams) {
        MatchTaskVo taskVo = new MatchTaskVo();
        taskVo.setStartTime(new Date());
        String type = taskParams.getTaskSource();
        if (WTCSource.MANUAL.code.equals(type) || WTCSource.SCHEDULE.code.equals(type) || WTCSource.BATCH_AD.getCode().equals(type)) {
            taskVo.setDistributed(true);
            taskVo.setTaskId(Long.valueOf(taskParams.getMainTaskId()));
            taskVo.setSubTaskId(Long.valueOf(taskParams.getTaskId()));
        }
        Date startDate = WTCDateUtils.str2Date((String)String.valueOf(taskParams.getParam("startDate")), (String)"yyyy-MM-dd HH:mm:ss");
        Date endDate = WTCDateUtils.str2Date((String)String.valueOf(taskParams.getParam("endDate")), (String)"yyyy-MM-dd HH:mm:ss");
        taskVo.setStartDate(startDate);
        taskVo.setEndDate(endDate);
        taskVo.setStart(WTCDateUtils.toLocalDate((Date)startDate));
        taskVo.setEnd(WTCDateUtils.toLocalDate((Date)endDate));
        List details = taskParams.getTaskShardingDetails();
        taskVo.setAttFileIds(new HashSet(details.size()));
        taskVo.setAttPersonIds(new HashSet(details.size()));
        taskVo.setAttFileBoIds(new HashSet(details.size()));
        for (Object detail : details) {
            WTCTaskCalShardingDetail shardingDetail = (WTCTaskCalShardingDetail)detail;
            taskVo.getAttPersonIds().add(shardingDetail.getAttPersonId());
            taskVo.getAttFileIds().add(shardingDetail.getAttFileId());
            taskVo.getAttFileBoIds().add(shardingDetail.getAttFileBoId());
        }
        return this.fillTaskVo(taskVo);
    }

    private TaskVo fillTaskVo(MatchTaskVo taskVo) {
        TaskSummaryVo summary = new TaskSummaryVo();
        Set attPersonIds = taskVo.getAttPersonIds();
        HashMap<Long, List> personAttFileMap = new HashMap<Long, List>(attPersonIds.size());
        String queryFields = "boid,attperson.id,bsed,bsled,enddate,id,org.id,atttag.attendstatus,affiliateadminorg.id,wtteinfo.frozenstartdate,wtteinfo.frozenenddate,usablestatus,empposorgrel.datastatus";
        AttFileQueryParam queryParam = new AttFileQueryParam(taskVo.getStartDate(), taskVo.getEndDate());
        queryParam.setqFilter(new QFilter("bsed", "<=", (Object)taskVo.getEndDate()).and("bsled", ">=", (Object)taskVo.getStartDate()));
        queryParam.setAuthCheck(Boolean.FALSE);
        queryParam.setProperties(queryFields);
        queryParam.setSetBoIds(taskVo.getAttFileBoIds());
        queryParam.setAttStatus(null);
        queryParam.setUsableStatus((Set)Sets.newHashSet((Object[])new String[]{"0", "-1"}));
        long attFileQuery = new Date().getTime();
        List attFileList = AttFileQueryServiceImpl.getInstance().queryAttFiles(queryParam);
        this.costLog("attFileQuery", attFileQuery);
        if (CollectionUtils.isEmpty((Collection)attFileList)) {
            LOG.warn("cardmatch,taskId = {},\u672a\u627e\u5230\u8003\u52e4\u6863\u6848", (Object)taskVo.getTaskId());
            return null;
        }
        HashSet<Long> attFileBoIds = new HashSet<Long>(attFileList.size());
        for (DynamicObject attFile : attFileList) {
            attFileBoIds.add(attFile.getLong("boid"));
            List affFiles = (List)personAttFileMap.get(attFile.getLong("attperson.id"));
            if (CollectionUtils.isEmpty((Collection)affFiles)) {
                ArrayList<DynamicObject> fileList = new ArrayList<DynamicObject>(1);
                fileList.add(attFile);
                personAttFileMap.put(attFile.getLong("attperson.id"), fileList);
                continue;
            }
            affFiles.add(attFile);
            personAttFileMap.put(attFile.getLong("attperson.id"), affFiles);
        }
        summary.setAttFileBoIds(attFileBoIds);
        summary.setAttPersonIds(taskVo.getAttPersonIds());
        taskVo.setSummary(summary);
        taskVo.setPersonAttFileMap(personAttFileMap);
        AttFileScheduleQueryParam param = new AttFileScheduleQueryParam();
        param.setFileBoIdSet(attFileBoIds);
        long attModeQuery = new Date().getTime();
        Map attModeMap = AttFileScheduleServiceImpl.getInstance().queryAttFileSchedule(AttFileScheduleEnum.MODE, param);
        this.costLog("attModeQuery", attModeQuery);
        taskVo.setAttModeMap(attModeMap);
        long attCardQuery = new Date().getTime();
        Map attCardMap = AttFileScheduleServiceImpl.getInstance().queryAttFileSchedule(AttFileScheduleEnum.CARD, param);
        this.costLog("attCardQuery", attCardQuery);
        taskVo.setAttCardMap(attCardMap);
        param.setLoad(Boolean.TRUE);
        long timeZoneQuery = new Date().getTime();
        Map timeZoneMap = AttFileScheduleServiceImpl.getInstance().queryAttFileSchedule(AttFileScheduleEnum.TZ, param);
        this.costLog("timeZoneQuery", timeZoneQuery);
        taskVo.setTimeZoneMap(timeZoneMap);
        long signCardQuery = new Date().getTime();
        List<SignCard> allSignCards = CardMatchHelper.getAllSignCardsByAttPersons(taskVo.getAttPersonIds(), taskVo.getStart(), taskVo.getEnd());
        this.costLog("signCardQuery", signCardQuery);
        long signCardSort = new Date().getTime();
        Map<Long, List<SignCard>> signCardMap = allSignCards.stream().collect(Collectors.groupingBy(SignCard::getAttPersonId));
        for (Map.Entry<Long, List<SignCard>> entry : signCardMap.entrySet()) {
            entry.getValue().sort((o1, o2) -> {
                LocalDateTime localDateTime1 = o1.getSignPointUtc();
                LocalDateTime localDateTime2 = o2.getSignPointUtc();
                if (null == localDateTime1 || null == localDateTime2) {
                    return 0;
                }
                if (localDateTime1.compareTo(localDateTime2) < 0) {
                    return -1;
                }
                if (localDateTime1.compareTo(localDateTime2) == 0) {
                    long source1 = o1.getSource();
                    long source2 = o2.getSource();
                    return Long.compare(source1, source2);
                }
                return 1;
            });
        }
        this.costLog("signCardSort", signCardSort);
        taskVo.setSignCardMap(signCardMap);
        long otApplyBillQuery = new Date().getTime();
        Map otApplyBills = (Map)WTCServiceHelper.invokeWtcWtomBizService((String)"IOverTimeApplyBillService", (String)"queryDutyDateMaxAndMinTime", (Object[])new Object[]{taskVo.getAttPersonIds(), taskVo.getStartDate(), taskVo.getEndDate()});
        this.costLog("otApplyBillQuery", otApplyBillQuery);
        taskVo.setOtApplyMap(otApplyBills);
        return taskVo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBatchCardMatch(MatchTaskVo taskVo) {
        Date shiftStart = WTCDateUtils.getCustomDate((Date)taskVo.getStartDate(), (Integer)-2);
        Date shiftEnd = WTCDateUtils.getCustomDate((Date)taskVo.getEndDate(), (Integer)2);
        LocalDate shiftStartLocal = WTCDateUtils.toLocalDate((Date)shiftStart);
        LocalDate shiftEndLocal = WTCDateUtils.toLocalDate((Date)shiftEnd);
        long effectiveCardQuery = new Date().getTime();
        CardMatchHelper.getWorkEffectivePoints(false, shiftStartLocal, taskVo.getAttPersonIds(), taskVo);
        CardMatchHelper.getWorkEffectivePoints(true, shiftEndLocal, taskVo.getAttPersonIds(), taskVo);
        this.costLog("effectiveCardQuery", effectiveCardQuery);
        long dutyShiftQuery = new Date().getTime();
        DutyShiftResponse dutyShifts = EvaluationServiceHelper.getDutyShiftsByAttFileBoId(new ArrayList(taskVo.getAttFileBoIds()), (Date)shiftStart, (Date)shiftEnd);
        this.costLog("dutyShiftQuery", dutyShiftQuery);
        taskVo.setDutyShift(dutyShifts);
        long ruleConfigQuery = new Date().getTime();
        Map<Long, List<DynamicObject>> ruleConfigMap = CardMatchHelper.getAllTakeRuleConfigs(shiftStart, shiftEnd);
        this.costLog("ruleConfigQuery", ruleConfigQuery);
        taskVo.setRuleConfigMap(ruleConfigMap);
        long takeRuleQuery = new Date().getTime();
        Map<Long, List<DynamicObject>> ruleMap = CardMatchHelper.getAllTakeRules(shiftStart, shiftEnd);
        this.costLog("takeRuleQuery", takeRuleQuery);
        taskVo.setRuleMap(ruleMap);
        long shiftQuery = new Date().getTime();
        Map<Long, List<DynamicObject>> shiftMap = CardMatchHelper.getAllShifts(shiftStart, shiftEnd);
        this.costLog("shiftQuery", shiftQuery);
        taskVo.setShiftMap(shiftMap);
        long pointTagQuery = new Date().getTime();
        Map<Long, Map<LocalDate, Map<String, PointTagLog>>> pointTagMap = CardMatchHelper.getAllManualPointTag(taskVo, shiftStartLocal, shiftEndLocal);
        this.costLog("pointTagQuery", pointTagQuery);
        taskVo.setPointTagMap(pointTagMap);
        long vaApplyQuery = new Date().getTime();
        CardMatchHelper.getAllVaApplyBills(taskVo);
        this.costLog("vaApplyQuery", vaApplyQuery);
        WTCPluginProxy offShiftExtInstance = WTCPluginProxyFactory.create(null, CardMatchOffShiftExtPlugin.class, (String)"kd.sdk.wtc.wtpm.business.cardmatch.CardMatchOffShiftExtPlugin", null);
        taskVo.setOffShiftExtWTCPluginProxy(offShiftExtInstance);
        WTCPluginProxy intersectionExtInstance = WTCPluginProxyFactory.create(null, CardMatchIntersectionExtPlugin.class, (String)"kd.sdk.wtc.wtpm.business.cardmatch.CardMatchIntersectionExtPlugin", null);
        taskVo.setIntersectionExtPluginProxy(intersectionExtInstance);
        int size = 0;
        int attPersonSize = taskVo.getAttPersonIds().size();
        long calculateQuery = new Date().getTime();
        try {
            for (Long attPersonId : taskVo.getAttPersonIds()) {
                this.singleAttMatch(attPersonId, taskVo);
                if (++size != attPersonSize && size % 100 != 0) continue;
                Float sizeDouble = Float.valueOf((float)size * 1.0f);
                Float attPersonDouble = Float.valueOf((float)attPersonSize * 1.0f);
                float progress = sizeDouble.floatValue() / attPersonDouble.floatValue() * 100.0f;
                WTCShardingAbleTask.WTCShardingTaskHelper.reportProgress((long)taskVo.getSubTaskId(), (int)((int)progress));
            }
        }
        catch (Exception exception) {
            try {
                LOG.warn("cardmatch,\u6267\u884c\u5f02\u5e38", (Throwable)exception);
                taskVo.getSummary().setMessage(exception.getMessage());
                taskVo.getSummary().setStatus("ERROR");
            }
            catch (Throwable throwable) {
                boolean stop = taskVo.isDistributed() && WTCShardingAbleTask.WTCShardingTaskHelper.isStop((long)taskVo.getSubTaskId());
                this.costLog("matchCalculate", calculateQuery);
                long saveTaskDetail = new Date().getTime();
                CardMatchServiceImpl.saveTaskDetail(taskVo, stop);
                this.costLog("saveTaskDetail", saveTaskDetail);
                if (!stop) {
                    long saveEffectiveCard = new Date().getTime();
                    WTCPluginProxy afterExtPluginProxy = WTCPluginProxyFactory.create(null, AfterCardMatchExtPlugin.class, (String)"kd.sdk.wtc.wtpm.business.cardmatch.AfterCardMatchExtPlugin", null);
                    if (null != afterExtPluginProxy && afterExtPluginProxy.hasPlugin()) {
                        CardMatchTaskVoExtImpl taskVoExtImpl = new CardMatchTaskVoExtImpl(taskVo);
                        AfterCardMatchEvent param = new AfterCardMatchEvent((CardMatchTaskVoExt)taskVoExtImpl);
                        afterExtPluginProxy.invokeReplace(extPlugin -> {
                            if (LOG.isInfoEnabled()) {
                                LOG.info("cardmatch,\u3010\u4e8c\u5f00\u57cb\u70b9\u3011\u53d6\u5361\u5339\u914d\u903b\u8f91\u8ba1\u7b97\u5b8c\u6210\u6269\u5c55\u65b9\u6cd5:[afterCardMatching]\u8c03\u7528\u5f00\u59cb,\u8c03\u7528\u6269\u5c55\u7c7b\uff1a{}", (Object)extPlugin.getClass().getName());
                            }
                            extPlugin.adjustMultiCard(param);
                            if (!HRMapUtils.isEmpty((Map)param.getMulTiCardExtMap())) {
                                taskVo.getExtMap().put("multiCardExtMap", param.getMulTiCardExtMap());
                            }
                        });
                    }
                    CardMatchHelper.batchSaveEffectiveCards(taskVo);
                    this.costLog("saveEffectiveCard", saveEffectiveCard);
                    long updateAdQuotaPool = new Date().getTime();
                    SupQuotaPoolTaskService.updateAdQuotaPool(shiftStart, shiftEnd, taskVo.getAttPersonIds(), false);
                    this.costLog("updateAdQuotaPool", updateAdQuotaPool);
                }
                throw throwable;
            }
            boolean stop = taskVo.isDistributed() && WTCShardingAbleTask.WTCShardingTaskHelper.isStop((long)taskVo.getSubTaskId());
            this.costLog("matchCalculate", calculateQuery);
            long saveTaskDetail = new Date().getTime();
            CardMatchServiceImpl.saveTaskDetail(taskVo, stop);
            this.costLog("saveTaskDetail", saveTaskDetail);
            if (!stop) {
                long saveEffectiveCard = new Date().getTime();
                WTCPluginProxy afterExtPluginProxy = WTCPluginProxyFactory.create(null, AfterCardMatchExtPlugin.class, (String)"kd.sdk.wtc.wtpm.business.cardmatch.AfterCardMatchExtPlugin", null);
                if (null != afterExtPluginProxy && afterExtPluginProxy.hasPlugin()) {
                    CardMatchTaskVoExtImpl taskVoExtImpl = new CardMatchTaskVoExtImpl(taskVo);
                    AfterCardMatchEvent param = new AfterCardMatchEvent((CardMatchTaskVoExt)taskVoExtImpl);
                    afterExtPluginProxy.invokeReplace(extPlugin -> {
                        if (LOG.isInfoEnabled()) {
                            LOG.info("cardmatch,\u3010\u4e8c\u5f00\u57cb\u70b9\u3011\u53d6\u5361\u5339\u914d\u903b\u8f91\u8ba1\u7b97\u5b8c\u6210\u6269\u5c55\u65b9\u6cd5:[afterCardMatching]\u8c03\u7528\u5f00\u59cb,\u8c03\u7528\u6269\u5c55\u7c7b\uff1a{}", (Object)extPlugin.getClass().getName());
                        }
                        extPlugin.adjustMultiCard(param);
                        if (!HRMapUtils.isEmpty((Map)param.getMulTiCardExtMap())) {
                            taskVo.getExtMap().put("multiCardExtMap", param.getMulTiCardExtMap());
                        }
                    });
                }
                CardMatchHelper.batchSaveEffectiveCards(taskVo);
                this.costLog("saveEffectiveCard", saveEffectiveCard);
                long updateAdQuotaPool = new Date().getTime();
                SupQuotaPoolTaskService.updateAdQuotaPool(shiftStart, shiftEnd, taskVo.getAttPersonIds(), false);
                this.costLog("updateAdQuotaPool", updateAdQuotaPool);
            }
        }
        boolean stop = taskVo.isDistributed() && WTCShardingAbleTask.WTCShardingTaskHelper.isStop((long)taskVo.getSubTaskId());
        this.costLog("matchCalculate", calculateQuery);
        long saveTaskDetail = new Date().getTime();
        CardMatchServiceImpl.saveTaskDetail(taskVo, stop);
        this.costLog("saveTaskDetail", saveTaskDetail);
        if (!stop) {
            long saveEffectiveCard = new Date().getTime();
            WTCPluginProxy afterExtPluginProxy = WTCPluginProxyFactory.create(null, AfterCardMatchExtPlugin.class, (String)"kd.sdk.wtc.wtpm.business.cardmatch.AfterCardMatchExtPlugin", null);
            if (null != afterExtPluginProxy && afterExtPluginProxy.hasPlugin()) {
                CardMatchTaskVoExtImpl taskVoExtImpl = new CardMatchTaskVoExtImpl(taskVo);
                AfterCardMatchEvent param = new AfterCardMatchEvent((CardMatchTaskVoExt)taskVoExtImpl);
                afterExtPluginProxy.invokeReplace(extPlugin -> {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("cardmatch,\u3010\u4e8c\u5f00\u57cb\u70b9\u3011\u53d6\u5361\u5339\u914d\u903b\u8f91\u8ba1\u7b97\u5b8c\u6210\u6269\u5c55\u65b9\u6cd5:[afterCardMatching]\u8c03\u7528\u5f00\u59cb,\u8c03\u7528\u6269\u5c55\u7c7b\uff1a{}", (Object)extPlugin.getClass().getName());
                    }
                    extPlugin.adjustMultiCard(param);
                    if (!HRMapUtils.isEmpty((Map)param.getMulTiCardExtMap())) {
                        taskVo.getExtMap().put("multiCardExtMap", param.getMulTiCardExtMap());
                    }
                });
            }
            CardMatchHelper.batchSaveEffectiveCards(taskVo);
            this.costLog("saveEffectiveCard", saveEffectiveCard);
            long updateAdQuotaPool = new Date().getTime();
            SupQuotaPoolTaskService.updateAdQuotaPool(shiftStart, shiftEnd, taskVo.getAttPersonIds(), false);
            this.costLog("updateAdQuotaPool", updateAdQuotaPool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void singleAttMatch(Long personId, MatchTaskVo taskVo) {
        LOG.debug("cardmatch,\u5355\u4eba[{}]\u5f00\u59cb", (Object)personId);
        try {
            List attFiles = (List)taskVo.getPersonAttFileMap().get(personId);
            if (CollectionUtils.isEmpty((Collection)attFiles)) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("cardmatch,\u8003\u52e4\u4eba[{}]\u4e0d\u5b58\u5728\u8003\u52e4\u6863\u6848", (Object)personId);
                }
                return;
            }
            Map<Long, List<DynamicObject>> map = attFiles.stream().collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
            for (Map.Entry<Long, List<DynamicObject>> entry : map.entrySet()) {
                List<DynamicObject> list = entry.getValue();
                list.sort((o1, o2) -> {
                    Date o1Date = o1.getDate("bsed");
                    Date o2Date = o2.getDate("bsed");
                    return Long.compare(o1Date.getTime(), o2Date.getTime());
                });
                this.processSingleAttFileBoMatch(personId, taskVo, list);
            }
        }
        catch (Exception exception) {
            if (LOG.isInfoEnabled()) {
                LOG.info("cardmatch,\u6267\u884c\u5f02\u5e38(\u5355\u4eba)", (Object)exception);
            }
        }
        finally {
            if (taskVo.isManualPointTag() || taskVo.isFromAdTrigger()) {
                WTCPluginProxy afterExtPluginProxy = WTCPluginProxyFactory.create(null, AfterCardMatchExtPlugin.class, (String)"kd.sdk.wtc.wtpm.business.cardmatch.AfterCardMatchExtPlugin", null);
                if (null != afterExtPluginProxy && afterExtPluginProxy.hasPlugin()) {
                    CardMatchTaskVoExtImpl taskVoExtImpl = new CardMatchTaskVoExtImpl(taskVo);
                    AfterCardMatchEvent param = new AfterCardMatchEvent((CardMatchTaskVoExt)taskVoExtImpl);
                    afterExtPluginProxy.invokeReplace(extPlugin -> {
                        if (LOG.isInfoEnabled()) {
                            LOG.info("cardmatch,\u3010\u4e8c\u5f00\u57cb\u70b9\u3011\u53d6\u5361\u5339\u914d\u903b\u8f91\u8ba1\u7b97\u5b8c\u6210\u6269\u5c55\u65b9\u6cd5:[afterCardMatching]\u8c03\u7528\u5f00\u59cb,\u8c03\u7528\u6269\u5c55\u7c7b\uff1a{}", (Object)extPlugin.getClass().getName());
                        }
                        extPlugin.adjustMultiCard(param);
                        if (!HRMapUtils.isEmpty((Map)param.getMulTiCardExtMap())) {
                            taskVo.getExtMap().put("multiCardExtMap", param.getMulTiCardExtMap());
                        }
                    });
                }
                CardMatchHelper.batchSaveEffectiveCards(taskVo);
            }
        }
    }

    private void processSingleAttFileBoMatch(Long personId, MatchTaskVo taskVo, List<DynamicObject> attFiles) {
        boolean stop;
        MatchDetailVo detail = this.initMatchDetailVo(personId, taskVo, attFiles);
        taskVo.getDetailList().add(detail);
        boolean bl = stop = taskVo.isDistributed() && WTCShardingAbleTask.WTCShardingTaskHelper.isStop((long)taskVo.getSubTaskId());
        if (stop) {
            detail.setMatchStatusEnum(MatchStatusEnum.NOT_ACCOUNT);
            return;
        }
        Date attFileStart = attFiles.get(0).getDate("bsed");
        Date attFileEnd = attFiles.get(attFiles.size() - 1).getDate("bsled");
        if (taskVo.getStartDate().after(attFileEnd) || taskVo.getEndDate().before(attFileStart)) {
            detail.setMatchStatusEnum(MatchStatusEnum.NOT_ACCOUNT);
            ExLogVo exLog = this.initExLogVo(taskVo, attFiles.get(0), taskVo.getStart());
            String msg = CardMatchKDString.notInAttFileEffectiveDate();
            exLog.setDesc(taskVo.getStart().toString() + "~" + taskVo.getEnd().toString() + msg);
            taskVo.getExLogList().add(exLog);
            return;
        }
        DynamicObject firstAttFile = attFiles.get(0);
        Date firstBsed = firstAttFile.getDate("bsed");
        Date actualStart = firstBsed.compareTo(taskVo.getStartDate()) >= 0 ? firstBsed : taskVo.getStartDate();
        detail.setStartDate(actualStart);
        DynamicObject latestAttFile = attFiles.get(attFiles.size() - 1);
        Date lastBsled = latestAttFile.getDate("bsled");
        Date endDate = lastBsled.compareTo(taskVo.getEndDate()) < 0 ? lastBsled : taskVo.getEndDate();
        Date actualEnd = endDate.compareTo(latestAttFile.getDate("enddate")) < 0 ? endDate : latestAttFile.getDate("enddate");
        detail.setEndDate(actualEnd);
        if (actualEnd.before(actualStart)) {
            detail.setEndDate(actualStart);
        }
        block0: for (DynamicObject attFile : attFiles) {
            Date end;
            Date start = attFile.getDate("bsed").compareTo(taskVo.getStartDate()) >= 0 ? attFile.getDate("bsed") : taskVo.getStartDate();
            Date endTemp = attFile.getDate("bsled").compareTo(taskVo.getEndDate()) < 0 ? attFile.getDate("bsled") : taskVo.getEndDate();
            Date date = end = endTemp.compareTo(attFile.getDate("enddate")) < 0 ? endTemp : attFile.getDate("enddate");
            if (start.compareTo(end) > 0 && attFiles.size() == 1) {
                detail.setMatchStatusEnum(MatchStatusEnum.FAIL);
                ExLogVo exLog = this.initExLogVo(taskVo, attFiles.get(0), WTCDateUtils.toLocalDate((Date)start));
                String msg = CardMatchKDString.notInAttFileEffectiveDate();
                exLog.setDesc(WTCDateUtils.toLocalDate((Date)start).toString() + "~" + taskVo.getEnd().toString() + msg);
                taskVo.getExLogList().add(exLog);
                continue;
            }
            List<LocalDate> actualDateList = CardMatchHelper.getLocalDates(taskVo, start, end, attFile.getLong("id"));
            String depEmpJobStatus = attFile.getString("empposorgrel.datastatus");
            if (HRStringUtils.equals((String)"-1", (String)depEmpJobStatus)) {
                ExLogVo exLog = this.initExLogVo(taskVo, attFile, actualDateList.get(0));
                exLog.setType(1);
                String msg = CardMatchKDString.depEmpJobTips((String)WTCDateUtils.toLocalDate((Date)start).toString(), (String)WTCDateUtils.toLocalDate((Date)end).toString());
                exLog.setDesc(msg);
                taskVo.getExLogList().add(exLog);
            }
            for (LocalDate localDate : actualDateList) {
                Date date2 = Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
                MatchVo matchVo = CardMatchServiceImpl.initMatchVo(personId, localDate, attFile);
                ExLogVo exLog = this.initExLogVo(taskVo, attFile, localDate);
                CardMatchHelper.setAttMode(taskVo, date2, matchVo);
                CardMatchHelper.setAttCard(taskVo, date2, matchVo);
                CardMatchHelper.setTimeZone(taskVo, matchVo.getLocalDate(), matchVo);
                matchVo.setAllSignCards((List)taskVo.getSignCardMap().get(personId));
                boolean isLegalMatch = CardMatchServiceImpl.isLegalMatch(attFile, matchVo, exLog, attFiles, detail, taskVo, actualDateList);
                if (!isLegalMatch) continue block0;
                boolean isLegalSingleMatch = CardMatchServiceImpl.isLegalSingleMatch(matchVo, exLog, detail, taskVo, taskVo.getSummary());
                if (!isLegalSingleMatch) continue;
                CardMatchServiceImpl.processSingleMatch(taskVo, matchVo, exLog, detail, taskVo.getSummary());
            }
        }
    }

    private MatchDetailVo initMatchDetailVo(Long personId, MatchTaskVo taskVo, List<DynamicObject> attFiles) {
        MatchDetailVo detail = new MatchDetailVo();
        DynamicObject latestAttFile = attFiles.get(attFiles.size() - 1);
        detail.setOrgId(Long.valueOf(latestAttFile.getLong("org.id")));
        detail.setAttFileId(Long.valueOf(latestAttFile.getLong("id")));
        detail.setAttFileBoId(Long.valueOf(latestAttFile.getLong("boid")));
        detail.setAttPersonId(personId);
        detail.setTaskId(taskVo.getTaskId());
        detail.setSubTaskId(taskVo.getSubTaskId());
        detail.setMatchStatusEnum(MatchStatusEnum.SUCCESS);
        return detail;
    }

    private ExLogVo initExLogVo(MatchTaskVo taskVo, DynamicObject attFile, LocalDate localDate) {
        ExLogVo exLog = new ExLogVo();
        exLog.setMatchTaskId(taskVo.getTaskId());
        exLog.setAttFileId(Long.valueOf(attFile.getLong("boid")));
        exLog.setMatchDate(Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()));
        exLog.setOrgId(Long.valueOf(attFile.getLong("org.id")));
        return exLog;
    }

    private static void saveTaskDetail(MatchTaskVo taskVo, boolean stop) {
        LOG.info("cardmatch,\u4e2a\u4eba\u8be6\u60c5:size={},\u5f02\u5e38\u65e5\u5fd7\u660e\u7ec6:exLogSize={}", (Object)taskVo.getDetailList().size(), (Object)taskVo.getExLogList().size());
        CardMatchHelper.saveMatchExLogs(taskVo, stop, taskVo.getExLogList());
        boolean success = !HRStringUtils.equalsIgnoreCase((String)"ERROR", (String)taskVo.getSummary().getStatus());
        CardMatchHelper.callBackDispatchTask(taskVo, taskVo.getSummary(), success, stop);
    }

    private static MatchVo initMatchVo(Long personId, LocalDate localDate, DynamicObject attFile) {
        String attStatus = attFile.getString("atttag.attendstatus");
        MatchVo matchVo = new MatchVo();
        matchVo.setAttPersonId(personId);
        matchVo.setMatchDate(Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()));
        matchVo.setLocalDate(localDate);
        matchVo.setWeek(String.valueOf(localDate.getDayOfWeek().getValue()));
        matchVo.setAttFileBoId(Long.valueOf(attFile.getLong("boid")));
        matchVo.setAttFileId(Long.valueOf(attFile.getLong("id")));
        matchVo.setAttStatus(attStatus);
        matchVo.setOrgId(Long.valueOf(attFile.getLong("org.id")));
        matchVo.setFrozenStartDate(attFile.getDate("wtteinfo.frozenstartdate"));
        matchVo.setFrozenEndDate(attFile.getDate("wtteinfo.frozenenddate"));
        return matchVo;
    }

    private static boolean isLegalSingleMatch(MatchVo matchVo, ExLogVo exLog, MatchDetailVo detailVo, MatchTaskVo taskVo, TaskSummaryVo summary) {
        if (!StringUtils.isEmpty((CharSequence)matchVo.getAttMode()) && AttModeEnum.NO_CARD.getCode().equals(matchVo.getAttMode())) {
            String msg = ResManager.loadKDString((String)"\u4eba\u5458\u8003\u52e4\u65b9\u5f0f\u4e3a\u514d\u6253\u5361\u3002", (String)"CardMatchServiceImpl_0", (String)"wtc-wtpm-business", (Object[])new Object[0]);
            exLog.setDesc(matchVo.getLocalDate().toString() + msg);
            taskVo.getExLogList().add(exLog);
            detailVo.setMatchStatusEnum(MatchStatusEnum.NOT_ACCOUNT);
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)matchVo.getAttMode())) {
            String msg = ResManager.loadKDString((String)"\u4eba\u5458\u8003\u52e4\u65b9\u5f0f\u672a\u8bbe\u7f6e\u3002", (String)"CardMatchServiceImpl_4", (String)"wtc-wtpm-business", (Object[])new Object[0]);
            exLog.setDesc(matchVo.getLocalDate().toString() + msg);
            taskVo.getExLogList().add(exLog);
            detailVo.setMatchStatusEnum(MatchStatusEnum.FAIL);
            return false;
        }
        if (null == matchVo.getTimeZoneId()) {
            String msg = ResManager.loadKDString((String)"\u8003\u52e4\u6863\u6848\u672a\u8bbe\u7f6e\u65f6\u533a\u3002", (String)"CardMatchServiceImpl_1", (String)"wtc-wtpm-business", (Object[])new Object[0]);
            exLog.setDesc(matchVo.getLocalDate().toString() + msg);
            taskVo.getExLogList().add(exLog);
            detailVo.setMatchStatusEnum(MatchStatusEnum.FAIL);
            return false;
        }
        if (CardMatchServiceImpl.isFrozenDate(matchVo)) {
            String msg = ResManager.loadKDString((String)"\u4eba\u5458\u8003\u52e4\u5468\u671f\u5df2\u51bb\u7ed3\u3002", (String)"CardMatchServiceImpl_2", (String)"wtc-wtpm-business", (Object[])new Object[0]);
            exLog.setDesc(matchVo.getLocalDate().toString() + msg);
            taskVo.getExLogList().add(exLog);
            detailVo.setMatchStatusEnum(MatchStatusEnum.FAIL);
            CardMatchHelper.retainFrozenDate(matchVo, taskVo);
            return false;
        }
        Optional shiftOptional = taskVo.getDutyShift().getCurrShiftHis(matchVo.getAttFileBoId(), matchVo.getMatchDate());
        if (!shiftOptional.isPresent()) {
            String msg = ResManager.loadKDString((String)"\u4eba\u5458\u672a\u6392\u73ed", (String)"CardMatchServiceImpl_3", (String)"wtc-wtpm-business", (Object[])new Object[0]);
            exLog.setDesc(matchVo.getLocalDate().toString() + msg);
            taskVo.getExLogList().add(exLog);
            detailVo.setMatchStatusEnum(MatchStatusEnum.FAIL);
            return false;
        }
        Shift shift = (Shift)shiftOptional.get();
        matchVo.setShift(shift);
        Optional dutyShift = taskVo.getDutyShift().getDutyShift(matchVo.getAttFileBoId(), matchVo.getMatchDate());
        dutyShift.ifPresent(value -> matchVo.setDateTypeId(value.getDateTypeModel().getId()));
        long ruleBoId = shift.getTakeCardRule().getId();
        List ruleList = (List)taskVo.getRuleMap().get(ruleBoId);
        DynamicObject takeCardRuleDy = SignCardCommonService.getDyDate(ruleList, matchVo.getMatchDate(), true);
        if (null == takeCardRuleDy) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("cardmatch,\u5355\u4eba[{}]\u5355\u5929[{}]\u4e0d\u5b58\u5728\u53d6\u5361\u89c4\u5219", (Object)matchVo.getAttPersonId(), (Object)matchVo.getLocalDate());
            }
            String msg = ResManager.loadKDString((String)"\u4eba\u5458\u73ed\u6b21\u4e0e\u53d6\u5361\u89c4\u5219\u4e0d\u4e00\u81f4\u3002", (String)"CardMatchServiceImpl_7", (String)"wtc-wtpm-business", (Object[])new Object[0]);
            exLog.setDesc(matchVo.getLocalDate().toString() + msg);
            taskVo.getExLogList().add(exLog);
            detailVo.setMatchStatusEnum(MatchStatusEnum.FAIL);
            return false;
        }
        CardMatchServiceImpl.setMatchVoProperties(takeCardRuleDy, matchVo, taskVo);
        return true;
    }

    private static void setMatchVoProperties(DynamicObject takeCardRuleDy, MatchVo matchVo, MatchTaskVo taskVo) {
        TakeCardRule rule = CardMatchServiceImpl.setTakeCardRuleProperties(takeCardRuleDy, matchVo);
        matchVo.setTakeCardRule(rule);
        Date preDate = WTCDateUtils.getBeforeDate((Date)matchVo.getMatchDate());
        Optional preShiftOptional = taskVo.getDutyShift().getCurrShiftHis(matchVo.getAttFileBoId(), preDate);
        if (preShiftOptional.isPresent()) {
            Shift preShift = (Shift)preShiftOptional.get();
            matchVo.setPreShift(preShift);
            long ruleBoId = preShift.getTakeCardRule().getId();
            List ruleList = (List)taskVo.getRuleMap().get(ruleBoId);
            DynamicObject preTakeCardRuleDy = SignCardCommonService.getDyDate(ruleList, preDate, true);
            if (null != preTakeCardRuleDy) {
                TakeCardRule preRule = CardMatchServiceImpl.setTakeCardRuleProperties(preTakeCardRuleDy, matchVo);
                matchVo.setPreTakeCardRule(preRule);
            }
        }
        Date nextDate = WTCDateUtils.getNextDate((Date)matchVo.getMatchDate());
        Optional nextShiftOptional = taskVo.getDutyShift().getCurrShiftHis(matchVo.getAttFileBoId(), nextDate);
        if (nextShiftOptional.isPresent()) {
            Shift nextShift = (Shift)nextShiftOptional.get();
            matchVo.setNextShift(nextShift);
            long ruleBoId = nextShift.getTakeCardRule().getId();
            List ruleList = (List)taskVo.getRuleMap().get(ruleBoId);
            DynamicObject nextTakeCardRuleDy = SignCardCommonService.getDyDate(ruleList, nextDate, true);
            if (null != nextTakeCardRuleDy) {
                TakeCardRule nextRule = CardMatchServiceImpl.setTakeCardRuleProperties(nextTakeCardRuleDy, matchVo);
                matchVo.setNextTakeCardRule(nextRule);
            }
        }
    }

    private static TakeCardRule setTakeCardRuleProperties(DynamicObject takeCardRuleDy, MatchVo matchVo) {
        TakeCardRule takeCardRuleVo = new TakeCardRule();
        takeCardRuleVo.setId(takeCardRuleDy.getLong("boid"));
        takeCardRuleVo.setConfigId(null != takeCardRuleDy.get("takecardconfig") ? takeCardRuleDy.getLong("takecardconfig.id") : 0L);
        takeCardRuleVo.setOffShift(takeCardRuleDy.getBoolean("isoff"));
        takeCardRuleVo.setOffShiftTaskCardMode(takeCardRuleDy.getString("offmode"));
        takeCardRuleVo.setContinueCard(takeCardRuleDy.getBoolean("iscontinuecard"));
        takeCardRuleVo.setOvertimeTakeCardMode(takeCardRuleDy.getBoolean("isotapplytakecard"));
        takeCardRuleVo.setCardShare(takeCardRuleDy.getBoolean("iscardshare"));
        takeCardRuleVo.setOffRefDayStart(takeCardRuleDy.getString("offrefdaystart"));
        takeCardRuleVo.setOffShiftStart(takeCardRuleDy.getInt("takecardstarttime"));
        takeCardRuleVo.setOffRefDayEnd(takeCardRuleDy.getString("offrefdayend"));
        takeCardRuleVo.setOffShiftEnd(takeCardRuleDy.getInt("takecardendtime"));
        takeCardRuleVo.setVaApplyTakeCard(takeCardRuleDy.getBoolean("isvaapplytakecard"));
        takeCardRuleVo.setIntersectionRule(takeCardRuleDy.getBoolean("intersectionrule"));
        DynamicObjectCollection ruleEntry = takeCardRuleDy.getDynamicObjectCollection("wtbd_tcardruleentry");
        ArrayList<TimeSeq> timeSeqList = new ArrayList<TimeSeq>(ruleEntry.size());
        for (DynamicObject entry : ruleEntry) {
            TimeSeq timeSeq = new TimeSeq();
            timeSeq.setTimeSeq(Integer.valueOf(entry.getInt("timeseq")));
            timeSeq.setStartBeforeScope(Integer.valueOf(entry.getInt("sbeforescope")));
            timeSeq.setStartAfterScope(Integer.valueOf(entry.getInt("safterscope")));
            timeSeq.setStartTakeCardRule(entry.getString("stakecardrule"));
            timeSeq.setStartTakeCardSameLen(entry.getString("stakecardsamelen"));
            timeSeq.setEndBeforeScope(Integer.valueOf(entry.getInt("ebeforescope")));
            timeSeq.setEndAfterScope(Integer.valueOf(entry.getInt("eafterscope")));
            timeSeq.setEndTakeCardRule(entry.getString("etakecardrule"));
            timeSeq.setEndTakeCardSameLen(entry.getString("etakecardsamelen"));
            timeSeqList.add(timeSeq);
        }
        takeCardRuleVo.setTimeSeqList(timeSeqList);
        return takeCardRuleVo;
    }

    private static boolean isLegalMatch(DynamicObject attFileDy, MatchVo matchVo, ExLogVo exLog, List<DynamicObject> attFiles, MatchDetailVo detailVo, MatchTaskVo taskVo, List<LocalDate> actualDateList) {
        String start = actualDateList.get(0).toString();
        String end = actualDateList.get(actualDateList.size() - 1).toString();
        if (null == taskVo.getAttModeMap().get(matchVo.getAttFileBoId())) {
            String msg = ResManager.loadKDString((String)"\u4eba\u5458\u8003\u52e4\u65b9\u5f0f\u672a\u8bbe\u7f6e\u3002", (String)"CardMatchServiceImpl_4", (String)"wtc-wtpm-business", (Object[])new Object[0]);
            exLog.setDesc(start + "~" + end + msg);
            taskVo.getExLogList().add(exLog);
            detailVo.setMatchStatusEnum(MatchStatusEnum.FAIL);
            return false;
        }
        if (!AttStatusEnum.ATT_NORMAL.getCode().equals(matchVo.getAttStatus()) && attFiles.size() == 1) {
            String msg = ResManager.loadKDString((String)"\u4eba\u5458\u505c\u6b62\u8003\u52e4", (String)"CardMatchServiceImpl_5", (String)"wtc-wtpm-business", (Object[])new Object[0]);
            exLog.setDesc(start + "~" + end + msg);
            taskVo.getExLogList().add(exLog);
            detailVo.setMatchStatusEnum(MatchStatusEnum.NOT_ACCOUNT);
            return false;
        }
        String usableStatus = attFileDy.getString("usablestatus");
        if (HRStringUtils.equalsIgnoreCase((String)"-1", (String)usableStatus) && attFiles.size() == 1) {
            exLog.setDesc(CardMatchKDString.attFileUseDiscardTips());
            taskVo.getExLogList().add(exLog);
            detailVo.setMatchStatusEnum(MatchStatusEnum.NOT_ACCOUNT);
            return false;
        }
        return true;
    }

    private static void processSingleMatch(MatchTaskVo taskVo, MatchVo matchVo, ExLogVo exLog, MatchDetailVo detailVo, TaskSummaryVo summary) {
        try {
            boolean isOff = matchVo.getShift().isOff();
            boolean success = isOff && matchVo.getShift().getOffNonPlan() ? CardMatchServiceImpl.processOffShift(taskVo, matchVo) : CardMatchServiceImpl.processNotOffShift(taskVo, matchVo, exLog, detailVo, summary);
            if (!success) {
                summary.getFailAttFileBoIds().add(matchVo.getAttFileBoId());
                summary.getFailAttPersonIds().add(matchVo.getAttPersonId());
            }
        }
        catch (Exception exception) {
            exLog.setDesc(ResManager.loadKDString((String)"\u7cfb\u7edf\u539f\u56e0\u4e2d\u65ad\uff0c\u7f51\u7edc\u5f02\u5e38\u3002", (String)"CardMatchServiceImpl_6", (String)"wtc-wtpm-business", (Object[])new Object[0]));
            taskVo.getExLogList().add(exLog);
            detailVo.setMatchStatusEnum(MatchStatusEnum.FAIL);
            taskVo.getDetailList().add(detailVo);
            throw new KDBizException((Throwable)exception, new ErrorCode("", exception.getMessage()), new Object[0]);
        }
    }

    private static boolean processOffShift(MatchTaskVo taskVo, MatchVo matchVo) {
        List<SignCard> signCardList;
        ShiftVo shiftVo;
        OffRangeVo offRangeVo = CardMatchServiceImpl.genOffRangeVo(TakeCardRuleRefDayEnum.CURRENT_DAY.refDay, matchVo, taskVo);
        Date nextDate = WTCDateUtils.getCustomDate((Date)matchVo.getMatchDate(), (Integer)1);
        Optional nextShiftOptional = taskVo.getDutyShift().getCurrShiftHis(matchVo.getAttFileBoId(), nextDate);
        if (nextShiftOptional.isPresent() && !((Shift)nextShiftOptional.get()).getOffNonPlan()) {
            Shift nextShift = (Shift)nextShiftOptional.get();
            long ruleBoId = nextShift.getTakeCardRule().getId();
            List ruleList = (List)taskVo.getRuleMap().get(ruleBoId);
            DynamicObject nextTakeCardRuleDy = SignCardCommonService.getDyDate(ruleList, nextDate, true);
            if (null != nextTakeCardRuleDy) {
                TakeCardRule nextRule = CardMatchServiceImpl.setTakeCardRuleProperties(nextTakeCardRuleDy, matchVo);
                List<MustSignInfoVo> shiftMustSignList = CardMatchHelper.getShiftMustSignList(nextShift.getShiftDetailList(), nextRule.getTimeSeqList(), WTCDateUtils.toLocalDate((Date)nextDate));
                if (HRCollUtil.isNotEmpty(shiftMustSignList)) {
                    MustSignInfoVo infoVo = shiftMustSignList.get(0);
                    TimeZoneVo timeZoneVo = CardMatchServiceImpl.getTimeDiff(taskVo, WTCDateUtils.toLocalDate((Date)nextDate), matchVo);
                    if (null != infoVo && null != timeZoneVo) {
                        infoVo.setAbsoluteSignUtc(infoVo.getAbsoluteSign().minusHours(timeZoneVo.getTimeDiff()));
                        if (infoVo.getAbsoluteSignUtc().isBefore(offRangeVo.getRangeEnd())) {
                            offRangeVo.setRangeEnd(infoVo.getAbsoluteSignUtc());
                        }
                    }
                }
            }
        }
        if (null != (shiftVo = CardMatchServiceImpl.generateOffShiftVo(taskVo, matchVo, offRangeVo)).getPreMustSignLast() && shiftVo.getPreMustSignLast().isAfter(offRangeVo.getRangeStart())) {
            offRangeVo.setRangeStart(shiftVo.getPreMustSignLast());
            shiftVo.setMustSignFirst(shiftVo.getPreMustSignLast());
        }
        if (null != shiftVo.getNextMustSignFirst() && shiftVo.getNextMustSignFirst().isBefore(offRangeVo.getRangeEnd())) {
            offRangeVo.setRangeEnd(shiftVo.getNextMustSignFirst());
            shiftVo.setMustSignLast(shiftVo.getNextMustSignFirst());
        }
        List<SignCard> list = signCardList = null != matchVo.getAllSignCards() ? matchVo.getAllSignCards().stream().filter(signCard -> null != signCard.getSignPointUtc() && signCard.getSignPointUtc().compareTo(offRangeVo.getRangeStart()) >= 0 && signCard.getSignPointUtc().compareTo(offRangeVo.getRangeEnd()) <= 0).collect(Collectors.toList()) : null;
        if (AttModeEnum.ONES_CARD.getCode().equals(matchVo.getAttMode())) {
            SignCard signCard2 = CardMatchHelper.getOffShiftOnceSignCard(matchVo, offRangeVo.getRangeStart(), offRangeVo.getRangeEnd(), shiftVo, signCardList);
            CardMatchHelper.saveOnceCard(taskVo, true, signCard2, matchVo);
            return true;
        }
        if (AttModeEnum.MANY_CARD.getCode().equals(matchVo.getAttMode())) {
            MultiCard multiCard = CardMatchHelper.initOffMultiCard(matchVo);
            List<MultiCardEntry> entryList = CardMatchServiceImpl.setMultiCardEntryForOffShift(taskVo, matchVo, signCardList, shiftVo, offRangeVo);
            multiCard.setEntryList(entryList);
            taskVo.getMultiCardSet().add(multiCard);
            return true;
        }
        return true;
    }

    private static List<MultiCardEntry> setMultiCardEntryForOffShift(MatchTaskVo taskVo, MatchVo matchVo, List<SignCard> signCardList, ShiftVo shiftVo, OffRangeVo offRangeVo) {
        ArrayList<MultiCardEntry> entryList = new ArrayList<MultiCardEntry>(2);
        LocalDateTime firstDateTime = null;
        for (int index = 0; index <= 1; ++index) {
            MultiCardEntry multiEntry = new MultiCardEntry();
            multiEntry.setAttPersonId(matchVo.getAttPersonId());
            multiEntry.setMatchDate(matchVo.getLocalDate());
            boolean first = index == 0;
            CardMatchServiceImpl.fillMultiEntryForPointTag(taskVo, matchVo, multiEntry, first, shiftVo);
            CardMatchServiceImpl.fillMultiEntryForIntersectionOffShift(taskVo, matchVo, multiEntry, first, shiftVo);
            if (null != multiEntry.getMultiPointUtc()) {
                firstDateTime = multiEntry.getMultiPointUtc();
            } else {
                SignCard signCard = CardMatchServiceImpl.getOffShiftSignCard(matchVo, first, signCardList, firstDateTime, shiftVo, offRangeVo, taskVo);
                if (first && null != signCard) {
                    firstDateTime = signCard.getSignPointUtc();
                }
                if (first && null == signCard) {
                    firstDateTime = CardMatchHelper.getPreShiftLastSignPoint(shiftVo);
                }
                if (null != signCard) {
                    CardMatchServiceImpl.fillMultiEntryForSignCard(signCard, multiEntry, matchVo, taskVo, first);
                }
            }
            entryList.add(multiEntry);
        }
        HashMap<LocalDate, LocalDateTime> workStartMap = (HashMap<LocalDate, LocalDateTime>)taskVo.getWorkStartMap().get(matchVo.getAttPersonId());
        if (null == workStartMap) {
            workStartMap = new HashMap<LocalDate, LocalDateTime>(16);
        }
        workStartMap.put(matchVo.getLocalDate(), ((MultiCardEntry)entryList.get(0)).getMultiPointUtc());
        taskVo.getWorkStartMap().put(matchVo.getAttPersonId(), workStartMap);
        HashMap<LocalDate, LocalDateTime> workEndMap = (HashMap<LocalDate, LocalDateTime>)taskVo.getWorkEndMap().get(matchVo.getAttPersonId());
        if (null == workEndMap) {
            workEndMap = new HashMap<LocalDate, LocalDateTime>(16);
        }
        workEndMap.put(matchVo.getLocalDate(), ((MultiCardEntry)entryList.get(entryList.size() - 1)).getMultiPointUtc());
        taskVo.getWorkEndMap().put(matchVo.getAttPersonId(), workEndMap);
        return entryList;
    }

    private static void fillMultiEntryForIntersectionOffShift(MatchTaskVo taskVo, MatchVo matchVo, MultiCardEntry multiEntry, boolean first, ShiftVo shiftVo) {
        if (null != multiEntry.getEffectivePoint()) {
            return;
        }
        if (first) {
            Map onSignCard = (Map)taskVo.getOnSignMap().get(matchVo.getAttPersonId());
            if (null == onSignCard || null == onSignCard.get(matchVo.getLocalDate())) {
                return;
            }
            SignCard signCard = (SignCard)onSignCard.get(matchVo.getLocalDate());
            if (null == shiftVo.getPreMustSignLast() || !signCard.getSignPointUtc().isBefore(shiftVo.getPreMustSignLast())) {
                CardMatchServiceImpl.fillMultiCard(signCard, multiEntry, matchVo);
            }
        }
    }

    private static void fillMultiEntryForSignCard(SignCard signCard, MultiCardEntry entry, MatchVo matchVo, MatchTaskVo taskVo, boolean first) {
        entry.setEffectivePoint(signCard.getSignPoint());
        entry.setMultiPointUtc(signCard.getSignPointUtc());
        entry.setTimeZoneId(signCard.getTimeZoneId());
        entry.setSourceId(signCard.getSource());
        entry.setDeviceId(signCard.getDeviceId());
        entry.setAccessTag(signCard.getAccessTag());
        entry.setPresetBiz1(signCard.getPresetBiz1());
        entry.setPresetBiz2(signCard.getPresetBiz2());
        String pointTag = CardMatchHelper.getPointTag(signCard.getSignPointUtc(), matchVo.getLocalDate(), matchVo.getTimeDiff());
        entry.setPointTag(pointTag);
        if (signCard.getId() != null) {
            entry.setSignCardId(signCard.getId().longValue());
        }
        entry.setApplyReasonId(signCard.getApplyReasonId());
        if (first) {
            HashMap<LocalDate, LocalDateTime> workStartMap = (HashMap<LocalDate, LocalDateTime>)taskVo.getWorkStartMap().get(matchVo.getAttPersonId());
            if (null == workStartMap) {
                workStartMap = new HashMap<LocalDate, LocalDateTime>(16);
            }
            workStartMap.put(matchVo.getLocalDate(), signCard.getSignPointUtc());
            taskVo.getWorkStartMap().put(matchVo.getAttPersonId(), workStartMap);
        } else {
            HashMap<LocalDate, LocalDateTime> workEndMap = (HashMap<LocalDate, LocalDateTime>)taskVo.getWorkEndMap().get(matchVo.getAttPersonId());
            if (null == workEndMap) {
                workEndMap = new HashMap<LocalDate, LocalDateTime>(16);
            }
            workEndMap.put(matchVo.getLocalDate(), signCard.getSignPointUtc());
            taskVo.getWorkEndMap().put(matchVo.getAttPersonId(), workEndMap);
        }
    }

    private static void fillMultiEntryForPointTag(MatchTaskVo taskVo, MatchVo matchVo, MultiCardEntry multiEntry, boolean first, ShiftVo shiftVo) {
        Map map;
        Map tagMap = (Map)taskVo.getPointTagMap().get(matchVo.getAttPersonId());
        if (null != tagMap && null != (map = (Map)tagMap.get(matchVo.getLocalDate()))) {
            PointTagLog end;
            boolean shiftShare = null != matchVo.getTakeCardRule() && matchVo.getTakeCardRule().isCardShare();
            PointTagLog start = (PointTagLog)map.get("start");
            if (null != start && first) {
                CardMatchServiceImpl.fillMultiCardManualStart(multiEntry, shiftVo, start, shiftShare);
            }
            if (null != (end = (PointTagLog)map.get("end")) && !first) {
                CardMatchServiceImpl.fillMultiCardManualEnd(multiEntry, shiftVo, end, shiftShare);
            }
        }
    }

    private static SignCard getOffShiftSignCard(MatchVo matchVo, boolean first, List<SignCard> signCardList, LocalDateTime firstDateTime, ShiftVo shiftVo, OffRangeVo offRangeVo, MatchTaskVo taskVo) {
        SignCard signCard;
        if (CollectionUtils.isEmpty(signCardList)) {
            return null;
        }
        if (first) {
            signCard = CardMatchServiceImpl.getOffSignCardByIntersection(signCardList, matchVo, taskVo, 0, firstDateTime, shiftVo);
            if (null == signCard) {
                signCard = CardMatchHelper.getOffShiftFirstSignCard(offRangeVo, shiftVo, matchVo, signCardList);
            }
        } else {
            signCard = CardMatchServiceImpl.getOffSignCardByIntersection(signCardList, matchVo, taskVo, 1, firstDateTime, shiftVo);
            if (null == signCard) {
                signCard = CardMatchHelper.getOffShiftLastSignCard(offRangeVo, shiftVo, matchVo, signCardList, firstDateTime);
            }
        }
        return signCard;
    }

    private static OffRangeVo genOffRangeVo(String refDay, MatchVo matchVo, MatchTaskVo taskVo) {
        TakeCardRule takeCardRule = matchVo.getTakeCardRule();
        LocalDate localDate = matchVo.getLocalDate();
        Shift shift = matchVo.getShift();
        int timeDiff = matchVo.getTimeDiff();
        if (HRStringUtils.equals((String)TakeCardRuleRefDayEnum.PREVIOUS_DAY.refDay, (String)refDay)) {
            takeCardRule = matchVo.getPreTakeCardRule();
            localDate = matchVo.getLocalDate().minusDays(1L);
            shift = matchVo.getPreShift();
            timeDiff = matchVo.getPreTimeDiff();
        } else if (HRStringUtils.equals((String)TakeCardRuleRefDayEnum.NEXT_DAY.refDay, (String)refDay)) {
            takeCardRule = matchVo.getNextTakeCardRule();
            localDate = matchVo.getLocalDate().plusDays(1L);
            shift = matchVo.getNextShift();
            timeDiff = matchVo.getNextTimeDiff();
        }
        int start = takeCardRule.getOffShiftStart();
        int end = takeCardRule.getOffShiftEnd();
        if (HRStringUtils.equals((String)TakeCardRuleRefDayEnum.PREVIOUS_DAY.refDay, (String)takeCardRule.getOffRefDayStart())) {
            start = -(CardRuleConstants.TAKE_CARD_END_TIME_DEFAULT - start);
        }
        if (HRStringUtils.equals((String)TakeCardRuleRefDayEnum.NEXT_DAY.refDay, (String)takeCardRule.getOffRefDayEnd())) {
            end = CardRuleConstants.TAKE_CARD_END_TIME_DEFAULT + end;
        }
        OffShiftTakeCardRangeEvent param = new OffShiftTakeCardRangeEvent(matchVo.getAttPersonId().longValue(), localDate, matchVo.getAttFileBoId().longValue(), shift.getId().longValue(), start, end);
        if (null != taskVo.getOffShiftExtWTCPluginProxy()) {
            taskVo.getOffShiftExtWTCPluginProxy().invokeReplace(hrPlugin -> {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("cardmatch,\u3010\u4e8c\u5f00\u57cb\u70b9\u3011off\u73ed\u53d6\u5361\u8303\u56f4\u6269\u5c55\u65b9\u6cd5\u8c03\u7528\u5f00\u59cb,\u8c03\u7528\u6269\u5c55\u7c7b\uff1a{}", (Object)hrPlugin.getClass().getName());
                }
                hrPlugin.afterOffShiftTakeCardRange(param);
            });
        }
        start = param.getRangeStartSecords();
        end = param.getRangeEndSecords();
        if (LOG.isDebugEnabled()) {
            LOG.debug("cardmatch,off shift rangeStart\uff1a{},rangeEnd\uff1a{}", (Object)start, (Object)end);
        }
        LocalDateTime startDateTime = localDate.atStartOfDay().plusSeconds(start);
        LocalDateTime startUtc = startDateTime.minusHours(timeDiff);
        LocalDateTime endDateTime = localDate.atStartOfDay().plusSeconds(end);
        LocalDateTime endUtc = endDateTime.minusHours(timeDiff);
        OffRangeVo offRangeVo = new OffRangeVo();
        offRangeVo.setRangeStart(startUtc);
        offRangeVo.setRangeEnd(endUtc);
        return offRangeVo;
    }

    private static boolean processNotOffShift(MatchTaskVo taskVo, MatchVo matchVo, ExLogVo exLog, MatchDetailVo detailVo, TaskSummaryVo summary) {
        List<SignCard> signCardList;
        String msg = ResManager.loadKDString((String)"\u4eba\u5458\u73ed\u6b21\u4e0e\u53d6\u5361\u89c4\u5219\u4e0d\u4e00\u81f4\u3002", (String)"CardMatchServiceImpl_7", (String)"wtc-wtpm-business", (Object[])new Object[0]);
        if (null == matchVo.getShift().getTakeCardRule()) {
            LOG.debug("cardmatch,\u5355\u4eba[{}]\u5355\u5929[{}]\u4e0d\u5b58\u5728\u53d6\u5361\u89c4\u5219", (Object)matchVo.getAttPersonId(), (Object)matchVo.getLocalDate());
            exLog.setDesc(matchVo.getLocalDate().toString() + msg);
            taskVo.getExLogList().add(exLog);
            summary.getFailAttFileBoIds().add(matchVo.getAttFileBoId());
            summary.getFailAttPersonIds().add(matchVo.getAttPersonId());
            detailVo.setMatchStatusEnum(MatchStatusEnum.FAIL);
            return false;
        }
        List timeSeqList = matchVo.getTakeCardRule().getTimeSeqList();
        List<MustSignInfoVo> shiftMustSignList = CardMatchHelper.getShiftMustSignList(matchVo.getShift().getShiftDetailList(), timeSeqList, matchVo.getLocalDate());
        if (CollectionUtils.isEmpty(shiftMustSignList)) {
            exLog.setDesc(matchVo.getLocalDate().toString() + msg);
            taskVo.getExLogList().add(exLog);
            summary.getFailAttFileBoIds().add(matchVo.getAttFileBoId());
            summary.getFailAttPersonIds().add(matchVo.getAttPersonId());
            detailVo.setMatchStatusEnum(MatchStatusEnum.FAIL);
            return false;
        }
        for (MustSignInfoVo info : shiftMustSignList) {
            info.setAbsoluteSignUtc(info.getAbsoluteSign().minusHours(matchVo.getTimeDiff()));
            info.setTimeDiff(matchVo.getTimeDiff());
            info.setTimeZoneId(matchVo.getTimeZoneId());
        }
        CardMatchServiceImpl.processTakeRangeForVaBill(shiftMustSignList, matchVo, taskVo);
        matchVo.setShiftMustSignList(shiftMustSignList);
        ShiftVo shiftVo = CardMatchServiceImpl.generateShiftVo(taskVo, shiftMustSignList, matchVo);
        LocalDateTime beginTime = CardMatchServiceImpl.getSearchCardBeginPoint(matchVo, timeSeqList, shiftVo, matchVo.getShift());
        LocalDateTime endTime = CardMatchServiceImpl.getSearchCardEndPoint(matchVo, timeSeqList, shiftVo, matchVo.getShift());
        List<SignCard> list = signCardList = null != matchVo.getAllSignCards() ? matchVo.getAllSignCards().stream().filter(signCard -> null != signCard.getSignPointUtc() && signCard.getSignPointUtc().compareTo(beginTime) >= 0 && signCard.getSignPointUtc().compareTo(endTime) <= 0).collect(Collectors.toList()) : null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("cardmatch,beginTime[{}],endTime[{}],signcardsize={}", new Object[]{beginTime, endTime, null != signCardList ? signCardList.size() : 0});
        }
        if (AttModeEnum.MANY_CARD.getCode().equals(matchVo.getAttMode())) {
            CardMatchServiceImpl.processMultiCard(taskVo, matchVo, signCardList, shiftVo);
        } else if (AttModeEnum.ONES_CARD.getCode().equals(matchVo.getAttMode())) {
            CardMatchServiceImpl.processOnceCard(taskVo, matchVo, signCardList, shiftVo);
        }
        return true;
    }

    private static void processTakeRangeForVaBill(List<MustSignInfoVo> shiftMustSignList, MatchVo matchVo, MatchTaskVo taskVo) {
        if (!matchVo.getTakeCardRule().isVaApplyTakeCard()) {
            return;
        }
        for (MustSignInfoVo mustSign : shiftMustSignList) {
            int index = shiftMustSignList.indexOf(mustSign);
            if (mustSign.getSignOn().booleanValue()) {
                MustSignInfoVo nextSignOff = shiftMustSignList.get(index + 1);
                LocalDateTime signOffPoint = nextSignOff.getAbsoluteSign();
                CardMatchServiceImpl.genVaBillSignOnAfterRange(matchVo, mustSign, signOffPoint, taskVo);
                continue;
            }
            MustSignInfoVo preSignOn = shiftMustSignList.get(index - 1);
            LocalDateTime signOnPoint = preSignOn.getAbsoluteSign();
            CardMatchServiceImpl.genVaBillSignOffBeforeRange(matchVo, mustSign, signOnPoint, taskVo);
        }
    }

    private static void genVaBillSignOnAfterRange(MatchVo matchVo, MustSignInfoVo mustSign, LocalDateTime signOffPoint, MatchTaskVo taskVo) {
        List vaBills = (List)taskVo.getVaBillMap().get(matchVo.getAttFileBoId());
        if (HRCollUtil.isEmpty((Collection)vaBills)) {
            return;
        }
        ArrayList<Date> endTimeList = new ArrayList<Date>(vaBills.size());
        Date mustSignOnTime = WTCDateUtils.toDate((LocalDateTime)mustSign.getAbsoluteSign());
        Date mustSignOffTime = WTCDateUtils.toDate((LocalDateTime)signOffPoint);
        for (VaBillWithTimeVo vo : vaBills) {
            List entryList = vo.getEntryEntities();
            if (HRCollUtil.isEmpty((Collection)entryList)) continue;
            CardMatchServiceImpl.getSignOnVaTime(entryList, mustSignOffTime, endTimeList, mustSignOnTime);
        }
        if (HRCollUtil.isEmpty(endTimeList)) {
            return;
        }
        Comparator comparator = Date::compareTo;
        endTimeList.sort(comparator);
        Date lastVaBillTime = (Date)endTimeList.get(endTimeList.size() - 1);
        long diffLong = lastVaBillTime.getTime() - mustSignOnTime.getTime();
        int diffInt = (int)(diffLong / 60000L);
        mustSign.setsAfterScope(Integer.valueOf(mustSign.getsAfterScope() + diffInt));
    }

    private static void genVaBillSignOffBeforeRange(MatchVo matchVo, MustSignInfoVo mustSign, LocalDateTime signOnPoint, MatchTaskVo taskVo) {
        List vaBills = (List)taskVo.getVaBillMap().get(matchVo.getAttFileBoId());
        if (HRCollUtil.isEmpty((Collection)vaBills)) {
            return;
        }
        ArrayList<Date> startTimeList = new ArrayList<Date>(vaBills.size());
        Date mustSignOffTime = WTCDateUtils.toDate((LocalDateTime)mustSign.getAbsoluteSign());
        Date mustSignOnTime = WTCDateUtils.toDate((LocalDateTime)signOnPoint);
        for (VaBillWithTimeVo vo : vaBills) {
            List entryList = vo.getEntryEntities();
            if (HRCollUtil.isEmpty((Collection)entryList)) continue;
            CardMatchServiceImpl.getSignOffVaTime(entryList, mustSignOffTime, startTimeList, mustSignOnTime);
        }
        if (HRCollUtil.isEmpty(startTimeList)) {
            return;
        }
        Comparator comparator = Date::compareTo;
        startTimeList.sort(comparator);
        Date firstVaBillTime = (Date)startTimeList.get(0);
        long diffLong = mustSignOffTime.getTime() - firstVaBillTime.getTime();
        int diffInt = (int)(diffLong / 60000L);
        mustSign.seteBeforeScope(Integer.valueOf(mustSign.geteBeforeScope() + diffInt));
    }

    private static void getSignOnVaTime(List<VaBillEntryEntityValidVo> entryList, Date mustSignOffTime, List<Date> endTimeList, Date mustSignOnTime) {
        for (VaBillEntryEntityValidVo subVo : entryList) {
            List subList = subVo.getVaEntryValidTimeVoList();
            if (HRCollUtil.isEmpty((Collection)subList)) continue;
            for (VaEntryValidTimeVo validTimeVo : subList) {
                if (validTimeVo.getOffNonPlan() || null == validTimeVo.getStartDateTime() || null == validTimeVo.getEndDateTime()) continue;
                Date vaStart = WTCDateUtils.cutDateSecondAndMillisecond((Date)validTimeVo.getStartDateTime());
                Date vaEnd = WTCDateUtils.cutDateSecondAndMillisecond((Date)validTimeVo.getEndDateTime());
                if (vaStart.after(mustSignOnTime) || vaEnd.before(mustSignOnTime) || !vaEnd.before(mustSignOffTime)) continue;
                endTimeList.add(vaEnd);
            }
        }
    }

    private static void getSignOffVaTime(List<VaBillEntryEntityValidVo> entryList, Date mustSignOffTime, List<Date> startTimeList, Date mustSignOnTime) {
        for (VaBillEntryEntityValidVo subVo : entryList) {
            List subList = subVo.getVaEntryValidTimeVoList();
            if (HRCollUtil.isEmpty((Collection)subList)) continue;
            for (VaEntryValidTimeVo validTimeVo : subList) {
                if (validTimeVo.getOffNonPlan() || null == validTimeVo.getStartDateTime() || null == validTimeVo.getEndDateTime()) continue;
                Date vaStart = WTCDateUtils.cutDateSecondAndMillisecond((Date)validTimeVo.getStartDateTime());
                Date vaEnd = WTCDateUtils.cutDateSecondAndMillisecond((Date)validTimeVo.getEndDateTime());
                if (vaStart.after(mustSignOffTime) || !vaStart.after(mustSignOnTime) || vaEnd.before(mustSignOffTime)) continue;
                startTimeList.add(vaStart);
            }
        }
    }

    private static void processMultiCard(MatchTaskVo taskVo, MatchVo matchVo, List<SignCard> signCardList, ShiftVo shiftVo) {
        MultiCard multiCard = CardMatchServiceImpl.initMultiCard(matchVo);
        CardMatchServiceImpl.calculateMultiCard(taskVo, multiCard, matchVo, signCardList, shiftVo);
        taskVo.getMultiCardSet().add(multiCard);
        CardMatchServiceImpl.processCheckCard(multiCard, taskVo, matchVo, signCardList);
    }

    private static void calculateMultiCard(MatchTaskVo taskVo, MultiCard multiCard, MatchVo matchVo, List<SignCard> signCardList, ShiftVo shiftVo) {
        List entryList = multiCard.getEntryList();
        LocalDateTime nextEffectiveSignPoint = CardMatchServiceImpl.getNextEffectiveSignPoint(taskVo, matchVo, shiftVo);
        CardMatchServiceImpl.processManualPointTag(entryList, taskVo, matchVo, shiftVo);
        for (MultiCardEntry entry : entryList) {
            if (null != entry.getEffectivePoint()) continue;
            int index = entryList.indexOf(entry);
            List mustSignInfoList = matchVo.getShiftMustSignList();
            MustSignInfoVo info = (MustSignInfoVo)mustSignInfoList.get(index);
            SignCard signCard = CardMatchServiceImpl.getSignCardByIntersection(info, signCardList, matchVo, taskVo, entryList, entry, shiftVo);
            if (null != signCard) {
                CardMatchServiceImpl.fillMultiCard(signCard, entry, matchVo);
                continue;
            }
            LocalDateTime startDateTime = CardMatchServiceImpl.getSignRangeStart(index, mustSignInfoList, shiftVo);
            LocalDateTime endDateTime = CardMatchServiceImpl.getSignRangeEnd(index, mustSignInfoList, shiftVo);
            List<SignCard> legalSignCards = CardMatchServiceImpl.getLegalSignCards(taskVo, shiftVo, entry, entryList, signCardList, matchVo, nextEffectiveSignPoint);
            if (CollectionUtils.isEmpty(legalSignCards)) continue;
            List<SignCard> signCards = legalSignCards.stream().filter(sign -> startDateTime.isBefore(sign.getSignPointUtc()) && endDateTime.isAfter(sign.getSignPointUtc()) || startDateTime.equals(sign.getSignPointUtc()) || endDateTime.equals(sign.getSignPointUtc())).collect(Collectors.toList());
            LOG.debug("cardmatch,startDateTime[{}],endDateTime[{}],signCards[{}]", new Object[]{startDateTime, endDateTime, signCards.size()});
            if (CollectionUtils.isEmpty(signCards)) continue;
            boolean isSignOn = info.getSignOn();
            if (CollectionUtils.isEmpty(signCards = signCards.stream().filter(sign -> isSignOn ? !StringUtils.equals((CharSequence)"off", (CharSequence)sign.getAccessTag()) : !StringUtils.equals((CharSequence)"on", (CharSequence)sign.getAccessTag())).collect(Collectors.toList()))) continue;
            CardMatchServiceImpl.fillMultiCardByTakeCardRule(info, signCards, entry, matchVo);
        }
        HashMap<LocalDate, LocalDateTime> workStartMap = (HashMap<LocalDate, LocalDateTime>)taskVo.getWorkStartMap().get(matchVo.getAttPersonId());
        if (null == workStartMap) {
            workStartMap = new HashMap<LocalDate, LocalDateTime>(16);
        }
        workStartMap.put(matchVo.getLocalDate(), ((MultiCardEntry)entryList.get(0)).getMultiPointUtc());
        taskVo.getWorkStartMap().put(matchVo.getAttPersonId(), workStartMap);
        HashMap<LocalDate, LocalDateTime> workEndMap = (HashMap<LocalDate, LocalDateTime>)taskVo.getWorkEndMap().get(matchVo.getAttPersonId());
        if (null == workEndMap) {
            workEndMap = new HashMap<LocalDate, LocalDateTime>(16);
        }
        workEndMap.put(matchVo.getLocalDate(), ((MultiCardEntry)entryList.get(entryList.size() - 1)).getMultiPointUtc());
        taskVo.getWorkEndMap().put(matchVo.getAttPersonId(), workEndMap);
    }

    private static void processMultiIntersection(List<MultiCardEntry> entryList, MatchTaskVo taskVo, MatchVo matchVo, ShiftVo shiftVo) {
        MultiCardEntry firstEntry = entryList.get(0);
        Map onSignCard = (Map)taskVo.getOnSignMap().get(matchVo.getAttPersonId());
        if (null != onSignCard && null != onSignCard.get(matchVo.getLocalDate())) {
            SignCard signCard = (SignCard)onSignCard.get(matchVo.getLocalDate());
            if (null == shiftVo.getPreMustSignLast() || !signCard.getSignPointUtc().isBefore(shiftVo.getPreMustSignLast())) {
                CardMatchServiceImpl.fillMultiCard(signCard, firstEntry, matchVo);
            }
        }
    }

    private static void processManualPointTag(List<MultiCardEntry> entryList, MatchTaskVo taskVo, MatchVo matchVo, ShiftVo shiftVo) {
        Map map;
        Map tagMap = (Map)taskVo.getPointTagMap().get(matchVo.getAttPersonId());
        if (null != tagMap && null != (map = (Map)tagMap.get(matchVo.getLocalDate()))) {
            PointTagLog end;
            boolean shiftShare = null != matchVo.getTakeCardRule() && matchVo.getTakeCardRule().isCardShare();
            PointTagLog start = (PointTagLog)map.get("start");
            if (null != start) {
                MultiCardEntry firstEntry = entryList.get(0);
                CardMatchServiceImpl.fillMultiCardManualStart(firstEntry, shiftVo, start, shiftShare);
            }
            if (null != (end = (PointTagLog)map.get("end"))) {
                MultiCardEntry lastEntry = entryList.get(entryList.size() - 1);
                CardMatchServiceImpl.fillMultiCardManualEnd(lastEntry, shiftVo, end, shiftShare);
            }
        }
    }

    private static void fillMultiCardManualStart(MultiCardEntry firstEntry, ShiftVo shiftVo, PointTagLog start, boolean shiftShare) {
        if (null == shiftVo.getPreMustSignLast()) {
            CardMatchServiceImpl.fillManualPointTagData(firstEntry, start);
        } else {
            LocalDateTime last;
            LocalDateTime localDateTime = last = null != shiftVo.getPreActualSignLast() && shiftVo.getPreActualSignLast().isAfter(shiftVo.getPreMustSignLast()) ? shiftVo.getPreActualSignLast() : shiftVo.getPreMustSignLast();
            if (null != start.getMultiPointUtc() && !start.getMultiPointUtc().isBefore(shiftVo.getPreMustSignLast()) && (!shiftShare && (start.getMultiPointUtc().compareTo(last) > 0 || start.getMultiPointUtc().compareTo(shiftVo.getPreMustSignLast()) == 0) || shiftShare && start.getMultiPointUtc().compareTo(last) >= 0)) {
                CardMatchServiceImpl.fillManualPointTagData(firstEntry, start);
            }
        }
    }

    private static void fillMultiCardManualEnd(MultiCardEntry lastEntry, ShiftVo shiftVo, PointTagLog end, boolean shiftShare) {
        if (null == shiftVo.getNextMustSignFirst()) {
            CardMatchServiceImpl.fillManualPointTagData(lastEntry, end);
        } else {
            LocalDateTime first;
            LocalDateTime localDateTime = first = null != shiftVo.getNextActualSignFirst() && shiftVo.getNextActualSignFirst().isBefore(shiftVo.getNextMustSignFirst()) ? shiftVo.getNextActualSignFirst() : shiftVo.getNextMustSignFirst();
            if (null != end.getMultiPointUtc() && !end.getMultiPointUtc().isAfter(shiftVo.getNextMustSignFirst()) && (!shiftShare && end.getMultiPointUtc().compareTo(first) < 0 || end.getMultiPointUtc().compareTo(shiftVo.getNextMustSignFirst()) == 0 || shiftShare && end.getMultiPointUtc().compareTo(first) <= 0)) {
                CardMatchServiceImpl.fillManualPointTagData(lastEntry, end);
            }
        }
    }

    private static void fillManualPointTagData(MultiCardEntry entry, PointTagLog pointTagLog) {
        entry.setPointTag(pointTagLog.getPointTag());
        entry.setEffectivePoint(pointTagLog.getMultiPoint());
        entry.setMultiPointUtc(pointTagLog.getMultiPointUtc());
        entry.setTimeZoneId(pointTagLog.getTimeZoneId());
        entry.setSourceId(pointTagLog.getSource());
        entry.setDeviceId(pointTagLog.getDeviceId());
        entry.setAccessTag(pointTagLog.getAccessTag());
    }

    private static List<SignCard> getLegalSignCards(MatchTaskVo taskVo, ShiftVo shiftVo, MultiCardEntry entry, List<MultiCardEntry> entryList, List<SignCard> signCardList, MatchVo matchVo, LocalDateTime nextEffectiveSignPoint) {
        boolean isContinueNext;
        int index = entryList.indexOf(entry);
        if (Boolean.TRUE.equals(shiftVo.getContinuePre()) && index == 0) {
            entry.setEffectivePoint(entry.getMustPoint());
            entry.setMultiPointUtc(entry.getMustPointUtc());
            entry.setPointTag(CardMatchHelper.getPointTag(entry.getMustPointUtc(), matchVo.getLocalDate(), matchVo.getTimeDiff()));
            entry.setTimeZoneId(matchVo.getTimeZoneId());
            return new ArrayList<SignCard>(1);
        }
        boolean bl = isContinueNext = Boolean.TRUE.equals(shiftVo.getContinueNext()) && index == entryList.size() - 1 && (nextEffectiveSignPoint == null || entry.getMustPointUtc().compareTo(nextEffectiveSignPoint) <= 0);
        if (isContinueNext) {
            entry.setEffectivePoint(entry.getMustPoint());
            entry.setMultiPointUtc(entry.getMustPointUtc());
            entry.setTimeZoneId(matchVo.getTimeZoneId());
            entry.setPointTag(CardMatchHelper.getPointTag(entry.getMustPointUtc(), matchVo.getLocalDate(), matchVo.getTimeDiff()));
            return new ArrayList<SignCard>(1);
        }
        if (CollectionUtils.isEmpty(signCardList)) {
            return new ArrayList<SignCard>(1);
        }
        LocalDateTime previousEffectiveSignPoint = CardMatchServiceImpl.getPreviousEffectiveSignPoint(taskVo, entryList, matchVo, shiftVo, index);
        List<Object> legalSignCards = signCardList;
        if (!HRObjectUtils.isEmpty((Object)nextEffectiveSignPoint)) {
            legalSignCards = signCardList.stream().filter(signCard -> signCard.getSignPointUtc() != null && signCard.getSignPointUtc().isBefore(nextEffectiveSignPoint)).collect(Collectors.toList());
        }
        if (!HRObjectUtils.isEmpty((Object)previousEffectiveSignPoint)) {
            legalSignCards = legalSignCards.stream().filter(signCard -> signCard.getSignPointUtc() != null && signCard.getSignPointUtc().isAfter(previousEffectiveSignPoint)).collect(Collectors.toList());
        }
        if (null != shiftVo.getPreMustSignLast()) {
            legalSignCards = legalSignCards.stream().filter(signCard -> signCard.getSignPointUtc() != null && !signCard.getSignPointUtc().isBefore(shiftVo.getPreMustSignLast())).collect(Collectors.toList());
        }
        if (null != shiftVo.getNextMustSignFirst()) {
            legalSignCards = legalSignCards.stream().filter(signCard -> signCard.getSignPointUtc() != null && !signCard.getSignPointUtc().isAfter(shiftVo.getNextMustSignFirst())).collect(Collectors.toList());
        }
        LOG.debug("cardmatch,previousEffectiveSignPoint[{}],nextEffectiveSignPoint[{}]", (Object)previousEffectiveSignPoint, (Object)nextEffectiveSignPoint);
        if (index > 0) {
            MultiCardEntry preEntry = entryList.get(index - 1);
            legalSignCards = legalSignCards.stream().filter(signCard -> signCard.getSignPointUtc() != null && signCard.getSignPointUtc().compareTo(preEntry.getMustPointUtc()) >= 0).collect(Collectors.toList());
        }
        if (index < entryList.size() - 1) {
            MultiCardEntry nextEntry = entryList.get(index + 1);
            legalSignCards = legalSignCards.stream().filter(signCard -> signCard.getSignPointUtc() != null && signCard.getSignPointUtc().isBefore(nextEntry.getMustPointUtc())).collect(Collectors.toList());
        }
        LOG.debug("cardmatch,legalCardsize[{}]", (Object)legalSignCards.size());
        return legalSignCards;
    }

    private static void fillMultiCardByTakeCardRule(MustSignInfoVo info, List<SignCard> signCards, MultiCardEntry entry, MatchVo matchVo) {
        SignCard signCard = CardMatchServiceImpl.getSignCardByTaskCardRule(signCards, info);
        if (null != signCard) {
            CardMatchServiceImpl.fillMultiCard(signCard, entry, matchVo);
        }
    }

    private static SignCard getSignCardByIntersection(MustSignInfoVo mustSignInfo, List<SignCard> signCards, MatchVo matchVo, MatchTaskVo taskVo, List<MultiCardEntry> entryList, MultiCardEntry entry, ShiftVo shiftVo) {
        boolean lastEntry;
        if (!matchVo.getTakeCardRule().isIntersectionRule() || HRCollUtil.isEmpty(signCards)) {
            return null;
        }
        String takeCardRule = mustSignInfo.getTakeCardRule();
        int index = entryList.indexOf(entry);
        boolean firstEntry = index == 0;
        boolean bl = lastEntry = index == entryList.size() - 1;
        if (firstEntry && !TaskCardModeEnum.EARLIEST.getCode().equals(takeCardRule) || lastEntry && !TaskCardModeEnum.LATEST.getCode().equals(takeCardRule)) {
            return null;
        }
        if (firstEntry && (null == matchVo.getPreTakeCardRule() || !matchVo.getPreTakeCardRule().isIntersectionRule())) {
            return null;
        }
        if (lastEntry && (null == matchVo.getNextTakeCardRule() || !matchVo.getNextTakeCardRule().isIntersectionRule())) {
            return null;
        }
        if (!matchVo.getTakeCardRule().isCardShare() && firstEntry) {
            return CardMatchServiceImpl.getOnIntersectionSignCard(matchVo, taskVo, signCards, shiftVo);
        }
        if (!matchVo.getNextTakeCardRule().isCardShare() && matchVo.getNextTakeCardRule().isIntersectionRule() && lastEntry) {
            return CardMatchServiceImpl.getOffIntersectionSignCard(matchVo, taskVo, signCards, shiftVo);
        }
        return null;
    }

    private static SignCard getOffIntersectionSignCard(MatchVo matchVo, MatchTaskVo taskVo, List<SignCard> signCards, ShiftVo shiftVo) {
        boolean needIntersection;
        List<SignCard> nextSignCards;
        PointTagLog start;
        Map map;
        TakeCardRangeVo range = CardMatchServiceImpl.getNextOnRange(matchVo, taskVo, shiftVo);
        if (null == range) {
            return null;
        }
        Map tagMap = (Map)taskVo.getPointTagMap().get(matchVo.getAttPersonId());
        if (null != tagMap && null != (map = (Map)tagMap.get(matchVo.getLocalDate().plusDays(1L))) && null != (start = (PointTagLog)map.get("start")) && (null != range.getNextRangeEnd() && start.getMultiPointUtc().isBefore(range.getNextRangeEnd()) || start.getMultiPointUtc().isBefore(range.getRangeEnd()))) {
            return null;
        }
        List<SignCard> curSignCards = signCards.stream().filter(signCard -> null != signCard.getSignPointUtc() && signCard.getSignPointUtc().compareTo(range.getRangeStart()) >= 0 && signCard.getSignPointUtc().compareTo(range.getRangeEnd()) <= 0).collect(Collectors.toList());
        if (HRCollUtil.isEmpty(curSignCards) || curSignCards.size() < 2) {
            return null;
        }
        if (null != range.getNextRangeStart() && null != range.getNextRangeEnd() && HRCollUtil.isNotEmpty(nextSignCards = matchVo.getAllSignCards().stream().filter(signCard -> null != signCard.getSignPointUtc() && signCard.getSignPointUtc().compareTo(range.getNextRangeStart()) >= 0 && signCard.getSignPointUtc().compareTo(range.getNextRangeEnd()) <= 0 && !HRStringUtils.equalsIgnoreCase((String)"off", (String)signCard.getAccessTag())).collect(Collectors.toList())) && !(needIntersection = CardMatchServiceImpl.processIntersectionExt(taskVo, nextSignCards, matchVo))) {
            return null;
        }
        return CardMatchServiceImpl.getNextIntersectionSignCardOffShift(curSignCards, matchVo, taskVo);
    }

    private static boolean processIntersectionExt(MatchTaskVo taskVo, List<SignCard> nextSignCards, MatchVo matchVo) {
        boolean needIntersection = false;
        if (taskVo.getIntersectionExtPluginProxy().hasPlugin()) {
            ArrayList<SignCardExtImpl> signCardExtList = new ArrayList<SignCardExtImpl>(nextSignCards.size());
            for (SignCard signCard : nextSignCards) {
                SignCardExtImpl signCardExt = new SignCardExtImpl(signCard);
                signCardExtList.add(signCardExt);
            }
            CardMatchTaskVoExtImpl taskVoExtImpl = new CardMatchTaskVoExtImpl(taskVo);
            boolean nextOffShift = null != matchVo.getNextShift() && matchVo.getNextShift().isOff() && matchVo.getNextShift().getOffNonPlan();
            LocalDateTime nextMustSignFirst = CardMatchHelper.getNextShiftMustFirst(matchVo);
            MatchVoExtImpl matchVoExtImpl = new MatchVoExtImpl(matchVo, nextOffShift, nextMustSignFirst);
            BeforeCardMatchIntersectionEvent param = new BeforeCardMatchIntersectionEvent((CardMatchTaskVoExt)taskVoExtImpl, (CardMatchVoExt)matchVoExtImpl, signCardExtList);
            taskVo.getIntersectionExtPluginProxy().invokeReplace(extPlugin -> {
                extPlugin.beforeIntersection(param);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("cardmatch,\u3010\u4e8c\u5f00\u57cb\u70b9\u3011\u4ea4\u96c6\u6269\u5c55\u65b9\u6cd5:[beforeIntersection]\u8c03\u7528\u5f00\u59cb,\u8c03\u7528\u6269\u5c55\u7c7b\uff1a{},\u8003\u52e4\u4eba[{}],\u5339\u914d\u65e5\u671f[{}],\u662f\u5426\u7ee7\u7eed\u6267\u884c\u4ea4\u96c6\u53d6\u5361[{}]", new Object[]{extPlugin.getClass().getName(), param.getMatchVoExt().getAttPersonId(), param.getMatchVoExt().getLocalDate(), param.isNeedIntersection()});
                }
            });
            needIntersection = param.isNeedIntersection();
        }
        return needIntersection;
    }

    private static SignCard getOnIntersectionSignCard(MatchVo matchVo, MatchTaskVo taskVo, List<SignCard> signCards, ShiftVo shiftVo) {
        PointTagLog end;
        Map map;
        TakeCardRangeVo range = CardMatchServiceImpl.getPreOutRange(matchVo, taskVo);
        if (null == range) {
            return null;
        }
        Map tagMap = (Map)taskVo.getPointTagMap().get(matchVo.getAttPersonId());
        if (null != tagMap && null != (map = (Map)tagMap.get(matchVo.getLocalDate().minusDays(1L))) && null != (end = (PointTagLog)map.get("end")) && (null != range.getPreRangeStart() && end.getMultiPointUtc().isAfter(range.getPreRangeStart()) || end.getMultiPointUtc().isAfter(range.getRangeStart()))) {
            return null;
        }
        List<SignCard> curSignCards = signCards.stream().filter(signCard -> null != signCard.getSignPointUtc() && signCard.getSignPointUtc().compareTo(range.getRangeStart()) >= 0 && signCard.getSignPointUtc().compareTo(range.getRangeEnd()) <= 0).collect(Collectors.toList());
        if (null != shiftVo.getPreActualSignLast()) {
            curSignCards = curSignCards.stream().filter(signCard -> !signCard.getSignPointUtc().isBefore(shiftVo.getPreActualSignLast())).collect(Collectors.toList());
        }
        if (HRCollUtil.isEmpty(curSignCards) || curSignCards.size() < 2) {
            return null;
        }
        return CardMatchServiceImpl.getOnIntersectionSignCard(curSignCards, matchVo, taskVo, range, shiftVo);
    }

    private static SignCard getOffSignCardByIntersection(List<SignCard> signCards, MatchVo matchVo, MatchTaskVo taskVo, int index, LocalDateTime firstDateTime, ShiftVo shiftVo) {
        if (!matchVo.getTakeCardRule().isIntersectionRule()) {
            return null;
        }
        boolean firstEntry = index == 0;
        boolean lastEntry = index == 1;
        List<Object> signList = signCards;
        if (null != firstDateTime) {
            signList = signList.stream().filter(signCard -> signCard.getSignPointUtc().isAfter(firstDateTime)).collect(Collectors.toList());
        }
        if (!matchVo.getTakeCardRule().isCardShare() && null != matchVo.getPreTakeCardRule() && matchVo.getPreTakeCardRule().isIntersectionRule() && firstEntry) {
            return CardMatchServiceImpl.getOnSignCardByIntersectionOffShift(matchVo, taskVo, signList, shiftVo);
        }
        if (!matchVo.getNextTakeCardRule().isCardShare() && null != matchVo.getNextTakeCardRule() && matchVo.getNextTakeCardRule().isIntersectionRule() && lastEntry) {
            return CardMatchServiceImpl.getOffSignCardByIntersectionOffShift(matchVo, taskVo, signList);
        }
        return null;
    }

    private static SignCard getOffSignCardByIntersectionOffShift(MatchVo matchVo, MatchTaskVo taskVo, List<SignCard> signCards) {
        boolean needIntersection;
        List<SignCard> nextSignCards;
        PointTagLog start;
        Map map;
        TakeCardRangeVo range = CardMatchServiceImpl.getOffNextOnRange(matchVo, taskVo);
        if (null == range) {
            return null;
        }
        Map tagMap = (Map)taskVo.getPointTagMap().get(matchVo.getAttPersonId());
        if (null != tagMap && null != (map = (Map)tagMap.get(matchVo.getLocalDate().plusDays(1L))) && null != (start = (PointTagLog)map.get("start")) && (null != range.getNextRangeEnd() && start.getMultiPointUtc().isBefore(range.getNextRangeEnd()) || start.getMultiPointUtc().isBefore(range.getRangeEnd()))) {
            return null;
        }
        List<SignCard> curSignCards = signCards.stream().filter(signCard -> null != signCard.getSignPointUtc() && signCard.getSignPointUtc().compareTo(range.getRangeStart()) >= 0 && signCard.getSignPointUtc().compareTo(range.getRangeEnd()) <= 0).collect(Collectors.toList());
        if (HRCollUtil.isEmpty(curSignCards) || curSignCards.size() < 2) {
            return null;
        }
        if (null != range.getNextRangeStart() && null != range.getNextRangeEnd() && HRCollUtil.isNotEmpty(nextSignCards = matchVo.getAllSignCards().stream().filter(signCard -> null != signCard.getSignPointUtc() && signCard.getSignPointUtc().compareTo(range.getNextRangeStart()) >= 0 && signCard.getSignPointUtc().compareTo(range.getNextRangeEnd()) <= 0).collect(Collectors.toList())) && !(needIntersection = CardMatchServiceImpl.processIntersectionExt(taskVo, nextSignCards, matchVo))) {
            return null;
        }
        return CardMatchServiceImpl.getNextIntersectionSignCardOffShift(curSignCards, matchVo, taskVo);
    }

    private static SignCard getOnSignCardByIntersectionOffShift(MatchVo matchVo, MatchTaskVo taskVo, List<SignCard> signCards, ShiftVo shiftVo) {
        PointTagLog end;
        Map map;
        TakeCardRangeVo range = CardMatchServiceImpl.getOffPreOutRange(matchVo, taskVo);
        if (null == range) {
            return null;
        }
        Map tagMap = (Map)taskVo.getPointTagMap().get(matchVo.getAttPersonId());
        if (null != tagMap && null != (map = (Map)tagMap.get(matchVo.getLocalDate().minusDays(1L))) && null != (end = (PointTagLog)map.get("end")) && (null != range.getPreRangeStart() && end.getMultiPointUtc().isAfter(range.getPreRangeStart()) || end.getMultiPointUtc().isAfter(range.getRangeStart()))) {
            return null;
        }
        List<SignCard> curSignCards = signCards.stream().filter(signCard -> null != signCard.getSignPointUtc() && signCard.getSignPointUtc().compareTo(range.getRangeStart()) >= 0 && signCard.getSignPointUtc().compareTo(range.getRangeEnd()) <= 0).collect(Collectors.toList());
        if (null != shiftVo.getPreActualSignLast()) {
            curSignCards = curSignCards.stream().filter(signCard -> !signCard.getSignPointUtc().isBefore(shiftVo.getPreActualSignLast())).collect(Collectors.toList());
        }
        if (HRCollUtil.isEmpty(curSignCards) || curSignCards.size() < 2) {
            return null;
        }
        return CardMatchServiceImpl.getOnIntersectionSignCard(curSignCards, matchVo, taskVo, range, shiftVo);
    }

    private static SignCard getOnIntersectionSignCard(List<SignCard> curSignCards, MatchVo matchVo, MatchTaskVo taskVo, TakeCardRangeVo range, ShiftVo shiftVo) {
        if (curSignCards.size() == 2) {
            SignCard first = curSignCards.get(0);
            SignCard last = curSignCards.get(1);
            if (HRStringUtils.equalsIgnoreCase((String)"off", (String)last.getAccessTag()) || HRStringUtils.equalsIgnoreCase((String)"on", (String)first.getAccessTag())) {
                return null;
            }
            HashMap<LocalDate, SignCard> offMap = new HashMap<LocalDate, SignCard>(2);
            offMap.put(matchVo.getLocalDate().minusDays(1L), first);
            taskVo.getOffSignMap().put(matchVo.getAttPersonId(), offMap);
            return last;
        }
        if (curSignCards.size() < 3) {
            return null;
        }
        SignCard startSign = null;
        SignCard endSign = null;
        long interval = 0L;
        for (int index = 0; index < curSignCards.size() - 1; ++index) {
            SignCard signCard = curSignCards.get(index);
            if (index >= curSignCards.size() - 1 || HRStringUtils.equalsIgnoreCase((String)"on", (String)signCard.getAccessTag())) continue;
            SignCard nextSignCard = curSignCards.get(index + 1);
            int diff = WTCDateUtils.calcDuringSecond((LocalDateTime)signCard.getSignPointUtc(), (LocalDateTime)nextSignCard.getSignPointUtc());
            if ((long)diff < interval || HRStringUtils.equalsIgnoreCase((String)"off", (String)nextSignCard.getAccessTag())) continue;
            startSign = signCard;
            endSign = nextSignCard;
            interval = diff;
        }
        if (null == startSign) {
            return null;
        }
        return endSign;
    }

    private static SignCard getNextIntersectionSignCardOffShift(List<SignCard> curSignCards, MatchVo matchVo, MatchTaskVo taskVo) {
        if (curSignCards.size() == 2) {
            SignCard first = curSignCards.get(0);
            SignCard last = curSignCards.get(1);
            if (HRStringUtils.equalsIgnoreCase((String)"off", (String)last.getAccessTag()) || HRStringUtils.equalsIgnoreCase((String)"on", (String)first.getAccessTag())) {
                return null;
            }
            HashMap<LocalDate, SignCard> onMap = new HashMap<LocalDate, SignCard>(2);
            onMap.put(matchVo.getLocalDate().plusDays(1L), last);
            taskVo.getOnSignMap().put(matchVo.getAttPersonId(), onMap);
            return curSignCards.get(0);
        }
        if (curSignCards.size() < 3) {
            return null;
        }
        SignCard startSign = null;
        SignCard endSign = null;
        long interval = 0L;
        for (int index = 0; index < curSignCards.size() - 1; ++index) {
            SignCard signCard = curSignCards.get(index);
            if (index >= curSignCards.size() - 1 || HRStringUtils.equalsIgnoreCase((String)"on", (String)signCard.getAccessTag())) continue;
            SignCard nextSignCard = curSignCards.get(index + 1);
            int diff = WTCDateUtils.calcDuringSecond((LocalDateTime)signCard.getSignPointUtc(), (LocalDateTime)nextSignCard.getSignPointUtc());
            if ((long)diff < interval || HRStringUtils.equalsIgnoreCase((String)"off", (String)nextSignCard.getAccessTag())) continue;
            startSign = signCard;
            endSign = nextSignCard;
            interval = diff;
        }
        if (null == endSign) {
            return null;
        }
        return startSign;
    }

    private static TakeCardRangeVo getPreOutRange(MatchVo matchVo, MatchTaskVo taskVo) {
        if (null == matchVo.getPreShift()) {
            return null;
        }
        List<MustSignInfoVo> mustList = CardMatchHelper.getShiftMustSignList(matchVo.getShift().getShiftDetailList(), matchVo.getTakeCardRule().getTimeSeqList(), matchVo.getLocalDate());
        if (HRCollUtil.isEmpty(mustList)) {
            return null;
        }
        MustSignInfoVo curInfo = mustList.get(0);
        curInfo.setAbsoluteSignUtc(curInfo.getAbsoluteSign().minusHours(matchVo.getTimeDiff()));
        curInfo.setTimeDiff(matchVo.getTimeDiff());
        boolean isVaPreLast = CardMatchServiceImpl.checkVaCoverMustPoint(curInfo, taskVo, matchVo);
        if (isVaPreLast) {
            return null;
        }
        LocalDateTime curStart = curInfo.getStartBeforeScope();
        LocalDateTime curEnd = curInfo.getStartAfterScope();
        if (matchVo.getPreShift().isOff() && matchVo.getPreShift().getOffNonPlan()) {
            LocalDateTime end;
            Map map;
            OffRangeVo offRangeVo = CardMatchServiceImpl.genOffRangeVo(TakeCardRuleRefDayEnum.PREVIOUS_DAY.refDay, matchVo, taskVo);
            if (offRangeVo.getRangeEnd().isAfter(curInfo.getAbsoluteSignUtc())) {
                offRangeVo.setRangeEnd(curInfo.getAbsoluteSignUtc());
            }
            if (null != (map = (Map)taskVo.getWorkStartMap().get(matchVo.getAttPersonId())) && null != map.get(matchVo.getLocalDate().minusDays(1L)) && offRangeVo.getRangeStart().isBefore((ChronoLocalDateTime)map.get(matchVo.getLocalDate().minusDays(1L)))) {
                offRangeVo.setRangeStart(((LocalDateTime)map.get(matchVo.getLocalDate().minusDays(1L))).plusSeconds(1L));
            }
            LocalDateTime start = curStart.isAfter(offRangeVo.getRangeStart()) ? curStart : offRangeVo.getRangeStart();
            LocalDateTime localDateTime = end = curEnd.isBefore(offRangeVo.getRangeEnd()) ? curEnd : offRangeVo.getRangeEnd();
            if (end.isAfter(start)) {
                TakeCardRangeVo rangeVo = new TakeCardRangeVo();
                if (offRangeVo.getRangeStart().isBefore(start)) {
                    rangeVo.setPreRangeStart(offRangeVo.getRangeStart());
                    rangeVo.setPreRangeEnd(start.minusSeconds(1L));
                }
                if (end.isBefore(curEnd)) {
                    rangeVo.setRangeOutStart(end.plusSeconds(1L));
                    rangeVo.setRangeOutEnd(curEnd);
                }
                rangeVo.setRangeStart(start);
                rangeVo.setRangeEnd(end);
                return rangeVo;
            }
        } else {
            return CardMatchServiceImpl.genNotOffPreOutRange(matchVo, taskVo, curInfo);
        }
        return null;
    }

    private static TakeCardRangeVo genNotOffPreOutRange(MatchVo matchVo, MatchTaskVo taskVo, MustSignInfoVo curInfo) {
        LocalDateTime end;
        LocalDateTime curStart = curInfo.getStartBeforeScope();
        LocalDateTime curEnd = curInfo.getStartAfterScope();
        List<MustSignInfoVo> preMustList = CardMatchHelper.getShiftMustSignList(matchVo.getPreShift().getShiftDetailList(), matchVo.getPreTakeCardRule().getTimeSeqList(), matchVo.getLocalDate().minusDays(1L));
        if (HRCollUtil.isEmpty(preMustList)) {
            return null;
        }
        MustSignInfoVo preInfo = preMustList.get(preMustList.size() - 1);
        if (!TaskCardModeEnum.LATEST.getCode().equals(preInfo.geteTakeCardRule())) {
            return null;
        }
        preInfo.setAbsoluteSignUtc(preInfo.getAbsoluteSign().minusHours(matchVo.getPreTimeDiff()));
        preInfo.setTimeDiff(matchVo.getPreTimeDiff());
        LocalDateTime preStart = preInfo.getEndBeforeScope();
        LocalDateTime preEnd = preInfo.getEndAfterScope();
        if (preEnd.isAfter(curInfo.getAbsoluteSignUtc())) {
            preEnd = curInfo.getAbsoluteSignUtc();
        }
        if (curStart.isBefore(preInfo.getAbsoluteSignUtc())) {
            curStart = preInfo.getAbsoluteSignUtc();
        }
        if (preMustList.size() > 1) {
            MustSignInfoVo preInfoPre = preMustList.get(preMustList.size() - 2);
            preInfoPre.setAbsoluteSignUtc(preInfoPre.getAbsoluteSign().minusHours(matchVo.getPreTimeDiff()));
            preInfoPre.setTimeDiff(matchVo.getPreTimeDiff());
            if (preStart.isBefore(preInfoPre.getAbsoluteSignUtc())) {
                preStart = preInfoPre.getAbsoluteSignUtc().plusSeconds(1L);
            }
        }
        LocalDateTime start = curStart.isAfter(preStart) ? curStart : preStart;
        LocalDateTime localDateTime = end = curEnd.isBefore(preEnd) ? curEnd : preEnd;
        if (end.isAfter(start)) {
            TakeCardRangeVo rangeVo = new TakeCardRangeVo();
            if (preStart.isBefore(start)) {
                rangeVo.setPreRangeStart(preStart);
                rangeVo.setPreRangeEnd(start.minusSeconds(1L));
            }
            if (end.isBefore(curEnd)) {
                rangeVo.setRangeOutStart(end.plusSeconds(1L));
                rangeVo.setRangeOutEnd(curEnd);
            }
            rangeVo.setRangeStart(start);
            rangeVo.setRangeEnd(end);
            return rangeVo;
        }
        return null;
    }

    private static boolean checkVaCoverMustPoint(MustSignInfoVo mustInfo, MatchTaskVo taskVo, MatchVo matchVo) {
        List vaBills = (List)taskVo.getVaBillMap().get(matchVo.getAttFileBoId());
        if (HRCollUtil.isEmpty((Collection)vaBills)) {
            return false;
        }
        for (VaBillWithTimeVo vo : vaBills) {
            boolean isVaCoverMustPoint;
            List entryList = vo.getEntryEntities();
            if (HRCollUtil.isEmpty((Collection)entryList) || !(isVaCoverMustPoint = CardMatchServiceImpl.checkVaEntryCoverMustPoint(entryList, mustInfo))) continue;
            return true;
        }
        return false;
    }

    private static boolean checkVaEntryCoverMustPoint(List<VaBillEntryEntityValidVo> entryList, MustSignInfoVo mustInfo) {
        Date mustPoint = WTCDateUtils.toDate((LocalDateTime)mustInfo.getAbsoluteSign());
        for (VaBillEntryEntityValidVo subVo : entryList) {
            List subList = subVo.getVaEntryValidTimeVoList();
            if (HRCollUtil.isEmpty((Collection)subList)) continue;
            for (VaEntryValidTimeVo validTimeVo : subList) {
                if (null == validTimeVo.getStartDateTime() || null == validTimeVo.getEndDateTime()) continue;
                Date vaStart = WTCDateUtils.cutDateSecondAndMillisecond((Date)validTimeVo.getStartDateTime());
                Date vaEnd = WTCDateUtils.cutDateSecondAndMillisecond((Date)validTimeVo.getEndDateTime());
                if (vaStart.after(mustPoint) || vaEnd.before(mustPoint)) continue;
                return true;
            }
        }
        return false;
    }

    private static TakeCardRangeVo getOffPreOutRange(MatchVo matchVo, MatchTaskVo taskVo) {
        if (null == matchVo.getPreShift()) {
            return null;
        }
        OffRangeVo offRangeVo = CardMatchServiceImpl.genOffRangeVo(TakeCardRuleRefDayEnum.CURRENT_DAY.refDay, matchVo, taskVo);
        LocalDateTime curStart = offRangeVo.getRangeStart();
        LocalDateTime curEnd = offRangeVo.getRangeEnd();
        if (matchVo.getPreShift().isOff() && matchVo.getPreShift().getOffNonPlan()) {
            LocalDateTime end;
            OffRangeVo preOffRangeVo = CardMatchServiceImpl.genOffRangeVo(TakeCardRuleRefDayEnum.PREVIOUS_DAY.refDay, matchVo, taskVo);
            Map map = (Map)taskVo.getWorkStartMap().get(matchVo.getAttPersonId());
            if (null != map && null != map.get(matchVo.getLocalDate().minusDays(1L)) && preOffRangeVo.getRangeStart().isBefore((ChronoLocalDateTime)map.get(matchVo.getLocalDate().minusDays(1L)))) {
                preOffRangeVo.setRangeStart(((LocalDateTime)map.get(matchVo.getLocalDate().minusDays(1L))).plusSeconds(1L));
            }
            LocalDateTime start = curStart.isAfter(preOffRangeVo.getRangeStart()) ? curStart : preOffRangeVo.getRangeStart();
            LocalDateTime localDateTime = end = curEnd.isBefore(preOffRangeVo.getRangeEnd()) ? curEnd : preOffRangeVo.getRangeEnd();
            if (end.isAfter(start)) {
                TakeCardRangeVo rangeVo = new TakeCardRangeVo();
                if (preOffRangeVo.getRangeStart().isBefore(start)) {
                    rangeVo.setPreRangeStart(preOffRangeVo.getRangeStart());
                    rangeVo.setPreRangeEnd(start.minusSeconds(1L));
                }
                if (end.isBefore(curEnd)) {
                    rangeVo.setRangeOutStart(end.plusSeconds(1L));
                    rangeVo.setRangeOutEnd(curEnd);
                }
                rangeVo.setRangeStart(start);
                rangeVo.setRangeEnd(end);
                return rangeVo;
            }
        } else {
            return CardMatchServiceImpl.genNotOffPreOutRangeOffShift(matchVo, taskVo, offRangeVo);
        }
        return null;
    }

    private static TakeCardRangeVo genNotOffPreOutRangeOffShift(MatchVo matchVo, MatchTaskVo taskVo, OffRangeVo offRangeVo) {
        LocalDateTime end;
        LocalDateTime curStart = offRangeVo.getRangeStart();
        LocalDateTime curEnd = offRangeVo.getRangeEnd();
        List<MustSignInfoVo> preMustList = CardMatchHelper.getShiftMustSignList(matchVo.getPreShift().getShiftDetailList(), matchVo.getPreTakeCardRule().getTimeSeqList(), matchVo.getLocalDate().minusDays(1L));
        if (HRCollUtil.isEmpty(preMustList)) {
            return null;
        }
        MustSignInfoVo preInfo = preMustList.get(preMustList.size() - 1);
        if (!TaskCardModeEnum.LATEST.getCode().equals(preInfo.geteTakeCardRule())) {
            return null;
        }
        preInfo.setAbsoluteSignUtc(preInfo.getAbsoluteSign().minusHours(matchVo.getPreTimeDiff()));
        preInfo.setTimeDiff(matchVo.getPreTimeDiff());
        LocalDateTime preStart = preInfo.getEndBeforeScope();
        LocalDateTime preEnd = preInfo.getEndAfterScope();
        if (curStart.isBefore(preInfo.getAbsoluteSignUtc())) {
            curStart = preInfo.getAbsoluteSignUtc();
        }
        if (preMustList.size() > 1) {
            MustSignInfoVo preInfoPre = preMustList.get(preMustList.size() - 2);
            preInfoPre.setAbsoluteSignUtc(preInfoPre.getAbsoluteSign().minusHours(matchVo.getPreTimeDiff()));
            preInfoPre.setTimeDiff(matchVo.getPreTimeDiff());
            if (preStart.isBefore(preInfoPre.getAbsoluteSignUtc())) {
                preStart = preInfoPre.getAbsoluteSignUtc().plusSeconds(1L);
            }
        }
        LocalDateTime start = curStart.isAfter(preStart) ? curStart : preStart;
        LocalDateTime localDateTime = end = curEnd.isBefore(preEnd) ? curEnd : preEnd;
        if (end.isAfter(start)) {
            TakeCardRangeVo rangeVo = new TakeCardRangeVo();
            if (preStart.isBefore(start)) {
                rangeVo.setPreRangeStart(preStart);
                rangeVo.setPreRangeEnd(start.minusSeconds(1L));
            }
            if (end.isBefore(curEnd)) {
                rangeVo.setRangeOutStart(end.plusSeconds(1L));
                rangeVo.setRangeOutEnd(curEnd);
            }
            rangeVo.setRangeStart(start);
            rangeVo.setRangeEnd(end);
            return rangeVo;
        }
        return null;
    }

    private static TakeCardRangeVo getNextOnRange(MatchVo matchVo, MatchTaskVo taskVo, ShiftVo shiftVo) {
        if (null == matchVo.getNextShift()) {
            return null;
        }
        List<MustSignInfoVo> mustList = CardMatchHelper.getShiftMustSignList(matchVo.getShift().getShiftDetailList(), matchVo.getTakeCardRule().getTimeSeqList(), matchVo.getLocalDate());
        if (HRCollUtil.isEmpty(mustList)) {
            return null;
        }
        MustSignInfoVo curInfo = mustList.get(mustList.size() - 1);
        curInfo.setAbsoluteSignUtc(curInfo.getAbsoluteSign().minusHours(matchVo.getTimeDiff()));
        curInfo.setTimeDiff(matchVo.getTimeDiff());
        LocalDateTime curStart = curInfo.getEndBeforeScope();
        LocalDateTime curEnd = curInfo.getEndAfterScope();
        if (null != shiftVo.getOtEndLast() && shiftVo.getOtEndLast().isAfter(curInfo.getAbsoluteSignUtc())) {
            Duration duration = Duration.between(curInfo.getAbsoluteSignUtc(), shiftVo.getOtEndLast());
            curEnd = curEnd.plusSeconds(duration.getSeconds());
        }
        if (matchVo.getNextShift().isOff() && matchVo.getNextShift().getOffNonPlan()) {
            LocalDateTime end;
            OffRangeVo nextOffRangeVo = CardMatchServiceImpl.genOffRangeVo(TakeCardRuleRefDayEnum.NEXT_DAY.refDay, matchVo, taskVo);
            Date nextNextDate = WTCDateUtils.getCustomDate((Date)matchVo.getMatchDate(), (Integer)2);
            Optional nextShiftOptional = taskVo.getDutyShift().getCurrShiftHis(matchVo.getAttFileBoId(), nextNextDate);
            if (nextShiftOptional.isPresent() && !((Shift)nextShiftOptional.get()).getOffNonPlan()) {
                Shift nextShift = (Shift)nextShiftOptional.get();
                long ruleBoId = nextShift.getTakeCardRule().getId();
                List ruleList = (List)taskVo.getRuleMap().get(ruleBoId);
                DynamicObject nextTakeCardRuleDy = SignCardCommonService.getDyDate(ruleList, nextNextDate, true);
                if (null != nextTakeCardRuleDy) {
                    TakeCardRule nextRule = CardMatchServiceImpl.setTakeCardRuleProperties(nextTakeCardRuleDy, matchVo);
                    List<MustSignInfoVo> shiftMustSignList = CardMatchHelper.getShiftMustSignList(nextShift.getShiftDetailList(), nextRule.getTimeSeqList(), WTCDateUtils.toLocalDate((Date)nextNextDate));
                    if (HRCollUtil.isNotEmpty(shiftMustSignList)) {
                        MustSignInfoVo infoVo = shiftMustSignList.get(0);
                        TimeZoneVo timeZoneVo = CardMatchServiceImpl.getTimeDiff(taskVo, WTCDateUtils.toLocalDate((Date)nextNextDate), matchVo);
                        if (null != infoVo && null != timeZoneVo) {
                            infoVo.setAbsoluteSignUtc(infoVo.getAbsoluteSign().minusHours(timeZoneVo.getTimeDiff()));
                            if (infoVo.getAbsoluteSignUtc().isBefore(nextOffRangeVo.getRangeEnd())) {
                                nextOffRangeVo.setRangeEnd(infoVo.getAbsoluteSignUtc());
                            }
                        }
                    }
                }
            }
            if (nextOffRangeVo.getRangeStart().isBefore(curInfo.getAbsoluteSignUtc())) {
                nextOffRangeVo.setRangeStart(curInfo.getAbsoluteSignUtc());
            }
            LocalDateTime start = nextOffRangeVo.getRangeStart().isAfter(curStart) ? nextOffRangeVo.getRangeStart() : curStart;
            LocalDateTime localDateTime = end = curEnd.isBefore(nextOffRangeVo.getRangeEnd()) ? curEnd : nextOffRangeVo.getRangeEnd();
            if (end.isAfter(start)) {
                TakeCardRangeVo rangeVo = new TakeCardRangeVo();
                if (nextOffRangeVo.getRangeEnd().isAfter(end)) {
                    rangeVo.setNextRangeStart(end.plusSeconds(1L));
                    rangeVo.setNextRangeEnd(nextOffRangeVo.getRangeEnd());
                }
                if (start.isAfter(curStart)) {
                    rangeVo.setRangeOutStart(curStart);
                    rangeVo.setRangeOutEnd(start.minusSeconds(1L));
                }
                rangeVo.setRangeStart(start);
                rangeVo.setRangeEnd(end);
                return rangeVo;
            }
        } else {
            return CardMatchServiceImpl.genNotOffNextOnRange(matchVo, taskVo, curInfo, curStart, curEnd);
        }
        return null;
    }

    private static TakeCardRangeVo genNotOffNextOnRange(MatchVo matchVo, MatchTaskVo taskVo, MustSignInfoVo curInfo, LocalDateTime curStart, LocalDateTime curEnd) {
        LocalDateTime end;
        OtDutyDateStartEndTime otApply;
        List<MustSignInfoVo> nextMustList = CardMatchHelper.getShiftMustSignList(matchVo.getNextShift().getShiftDetailList(), matchVo.getNextTakeCardRule().getTimeSeqList(), matchVo.getLocalDate().plusDays(1L));
        if (HRCollUtil.isEmpty(nextMustList)) {
            return null;
        }
        MustSignInfoVo nextInfo = nextMustList.get(0);
        if (!TaskCardModeEnum.EARLIEST.getCode().equals(nextInfo.getsTakeCardRule())) {
            return null;
        }
        boolean isVaPreLast = CardMatchServiceImpl.checkVaCoverMustPoint(nextInfo, taskVo, matchVo);
        if (isVaPreLast) {
            return null;
        }
        nextInfo.setAbsoluteSignUtc(nextInfo.getAbsoluteSign().minusHours(matchVo.getNextTimeDiff()));
        nextInfo.setTimeDiff(matchVo.getNextTimeDiff());
        LocalDateTime nextStart = nextInfo.getStartBeforeScope();
        LocalDateTime nextEnd = nextInfo.getStartAfterScope();
        Map map = (Map)taskVo.getOtApplyMap().get(matchVo.getAttPersonId());
        if (!CollectionUtils.isEmpty((Map)map) && null != map.get(WTCDateUtils.toDate((LocalDate)matchVo.getLocalDate().plusDays(1L))) && null != (otApply = (OtDutyDateStartEndTime)map.get(WTCDateUtils.toDate((LocalDate)matchVo.getLocalDate().plusDays(1L)))) && otApply.getStartTime() != null) {
            LocalDateTime start = WTCDateUtils.toLocalDateTime((Date)otApply.getStartTime());
            start = start.minusHours(matchVo.getNextTimeDiff());
            if (nextInfo.getAbsoluteSignUtc().isAfter(start)) {
                Duration duration = Duration.between(start, nextInfo.getAbsoluteSignUtc());
                nextStart = nextStart.minusSeconds(duration.getSeconds());
            }
        }
        if (curEnd.isAfter(nextInfo.getAbsoluteSignUtc())) {
            curEnd = nextInfo.getAbsoluteSignUtc();
        }
        if (nextStart.isBefore(curInfo.getAbsoluteSignUtc())) {
            nextStart = curInfo.getAbsoluteSignUtc();
        }
        if (nextMustList.size() > 1) {
            MustSignInfoVo nextInfoNext = nextMustList.get(1);
            nextInfoNext.setAbsoluteSignUtc(nextInfoNext.getAbsoluteSign().minusHours(matchVo.getNextTimeDiff()));
            nextInfoNext.setTimeDiff(matchVo.getNextTimeDiff());
            if (nextEnd.isAfter(nextInfoNext.getAbsoluteSignUtc())) {
                nextEnd = nextInfoNext.getAbsoluteSignUtc().minusSeconds(1L);
            }
        }
        LocalDateTime start = nextStart.isAfter(curStart) ? nextStart : curStart;
        LocalDateTime localDateTime = end = curEnd.isBefore(nextEnd) ? curEnd : nextEnd;
        if (end.isAfter(start)) {
            TakeCardRangeVo rangeVo = new TakeCardRangeVo();
            if (nextEnd.isAfter(end)) {
                rangeVo.setNextRangeStart(end.plusSeconds(1L));
                rangeVo.setNextRangeEnd(nextEnd);
            }
            if (start.isAfter(curStart)) {
                rangeVo.setRangeOutStart(curStart);
                rangeVo.setRangeOutEnd(start.minusSeconds(1L));
            }
            rangeVo.setRangeStart(start);
            rangeVo.setRangeEnd(end);
            return rangeVo;
        }
        return null;
    }

    private static TakeCardRangeVo getOffNextOnRange(MatchVo matchVo, MatchTaskVo taskVo) {
        if (null == matchVo.getNextShift()) {
            return null;
        }
        OffRangeVo offRangeVo = CardMatchServiceImpl.genOffRangeVo(TakeCardRuleRefDayEnum.CURRENT_DAY.refDay, matchVo, taskVo);
        LocalDateTime curStart = offRangeVo.getRangeStart();
        LocalDateTime curEnd = offRangeVo.getRangeEnd();
        if (matchVo.getNextShift().isOff() && matchVo.getNextShift().getOffNonPlan()) {
            LocalDateTime end;
            OffRangeVo nextOffRangeVo = CardMatchServiceImpl.genOffRangeVo(TakeCardRuleRefDayEnum.NEXT_DAY.refDay, matchVo, taskVo);
            Date nextNextDate = WTCDateUtils.getCustomDate((Date)matchVo.getMatchDate(), (Integer)2);
            Optional nextShiftOptional = taskVo.getDutyShift().getCurrShiftHis(matchVo.getAttFileBoId(), nextNextDate);
            if (nextShiftOptional.isPresent() && !((Shift)nextShiftOptional.get()).getOffNonPlan()) {
                Shift nextShift = (Shift)nextShiftOptional.get();
                long ruleBoId = nextShift.getTakeCardRule().getId();
                List ruleList = (List)taskVo.getRuleMap().get(ruleBoId);
                DynamicObject nextTakeCardRuleDy = SignCardCommonService.getDyDate(ruleList, nextNextDate, true);
                if (null != nextTakeCardRuleDy) {
                    TakeCardRule nextRule = CardMatchServiceImpl.setTakeCardRuleProperties(nextTakeCardRuleDy, matchVo);
                    List<MustSignInfoVo> shiftMustSignList = CardMatchHelper.getShiftMustSignList(nextShift.getShiftDetailList(), nextRule.getTimeSeqList(), WTCDateUtils.toLocalDate((Date)nextNextDate));
                    if (HRCollUtil.isNotEmpty(shiftMustSignList)) {
                        MustSignInfoVo infoVo = shiftMustSignList.get(0);
                        TimeZoneVo timeZoneVo = CardMatchServiceImpl.getTimeDiff(taskVo, WTCDateUtils.toLocalDate((Date)nextNextDate), matchVo);
                        if (null != infoVo && null != timeZoneVo) {
                            infoVo.setAbsoluteSignUtc(infoVo.getAbsoluteSign().minusHours(timeZoneVo.getTimeDiff()));
                            if (infoVo.getAbsoluteSignUtc().isBefore(nextOffRangeVo.getRangeEnd())) {
                                nextOffRangeVo.setRangeEnd(infoVo.getAbsoluteSignUtc());
                            }
                        }
                    }
                }
            }
            LocalDateTime start = nextOffRangeVo.getRangeStart().isAfter(curStart) ? nextOffRangeVo.getRangeStart() : curStart;
            LocalDateTime localDateTime = end = curEnd.isBefore(nextOffRangeVo.getRangeEnd()) ? curEnd : nextOffRangeVo.getRangeEnd();
            if (end.isAfter(start)) {
                TakeCardRangeVo rangeVo = new TakeCardRangeVo();
                if (nextOffRangeVo.getRangeEnd().isAfter(end)) {
                    rangeVo.setNextRangeStart(end.plusSeconds(1L));
                    rangeVo.setNextRangeEnd(nextOffRangeVo.getRangeEnd());
                }
                if (start.isAfter(curStart)) {
                    rangeVo.setRangeOutStart(curStart);
                    rangeVo.setRangeOutEnd(start.minusSeconds(1L));
                }
                rangeVo.setRangeStart(start);
                rangeVo.setRangeEnd(end);
                return rangeVo;
            }
        } else {
            return CardMatchServiceImpl.genNotOffNextOnRangeOffShift(matchVo, taskVo, offRangeVo);
        }
        return null;
    }

    private static TakeCardRangeVo genNotOffNextOnRangeOffShift(MatchVo matchVo, MatchTaskVo taskVo, OffRangeVo offRangeVo) {
        LocalDateTime end;
        LocalDateTime curStart = offRangeVo.getRangeStart();
        LocalDateTime curEnd = offRangeVo.getRangeEnd();
        List<MustSignInfoVo> nextMustList = CardMatchHelper.getShiftMustSignList(matchVo.getNextShift().getShiftDetailList(), matchVo.getNextTakeCardRule().getTimeSeqList(), matchVo.getLocalDate().plusDays(1L));
        if (HRCollUtil.isEmpty(nextMustList)) {
            return null;
        }
        MustSignInfoVo nextInfo = nextMustList.get(0);
        if (!TaskCardModeEnum.EARLIEST.getCode().equals(nextInfo.getsTakeCardRule())) {
            return null;
        }
        boolean isVaPreLast = CardMatchServiceImpl.checkVaCoverMustPoint(nextInfo, taskVo, matchVo);
        if (isVaPreLast) {
            return null;
        }
        nextInfo.setAbsoluteSignUtc(nextInfo.getAbsoluteSign().minusHours(matchVo.getNextTimeDiff()));
        nextInfo.setTimeDiff(matchVo.getNextTimeDiff());
        LocalDateTime nextStart = nextInfo.getStartBeforeScope();
        LocalDateTime nextEnd = nextInfo.getStartAfterScope();
        if (curEnd.isAfter(nextInfo.getAbsoluteSignUtc())) {
            curEnd = nextInfo.getAbsoluteSignUtc();
        }
        if (nextMustList.size() > 1) {
            MustSignInfoVo nextInfoNext = nextMustList.get(1);
            nextInfoNext.setAbsoluteSignUtc(nextInfoNext.getAbsoluteSign().minusHours(matchVo.getNextTimeDiff()));
            nextInfoNext.setTimeDiff(matchVo.getNextTimeDiff());
            if (nextEnd.isAfter(nextInfoNext.getAbsoluteSignUtc())) {
                nextEnd = nextInfoNext.getAbsoluteSignUtc().minusSeconds(1L);
            }
        }
        LocalDateTime start = nextStart.isAfter(curStart) ? nextStart : curStart;
        LocalDateTime localDateTime = end = curEnd.isBefore(nextEnd) ? curEnd : nextEnd;
        if (end.isAfter(start)) {
            TakeCardRangeVo rangeVo = new TakeCardRangeVo();
            if (nextEnd.isAfter(end)) {
                rangeVo.setNextRangeStart(end.plusSeconds(1L));
                rangeVo.setNextRangeEnd(nextEnd);
            }
            if (start.isAfter(curStart)) {
                rangeVo.setRangeOutStart(curStart);
                rangeVo.setRangeOutEnd(start.minusSeconds(1L));
            }
            rangeVo.setRangeStart(start);
            rangeVo.setRangeEnd(end);
            return rangeVo;
        }
        return null;
    }

    private static List<MultiCardEntryDTO> initMultiCardEntryForTrial(MatchVo matchVo) {
        ArrayList<MultiCardEntryDTO> entryList = new ArrayList<MultiCardEntryDTO>(matchVo.getShiftMustSignList().size());
        List shiftMustSignList = matchVo.getShiftMustSignList();
        for (MustSignInfoVo mustSign : shiftMustSignList) {
            MultiCardEntryDTO entry = new MultiCardEntryDTO();
            entry.setAttPersonId(matchVo.getAttPersonId());
            entry.setMatchDate(Date.from(matchVo.getLocalDate().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()));
            entry.setMustPoint(Date.from(mustSign.getAbsoluteSign().atZone(ZoneId.systemDefault()).toInstant()));
            entry.setMustPointUtc(Date.from(mustSign.getAbsoluteSign().minusHours(mustSign.getTimeDiff()).atZone(ZoneId.systemDefault()).toInstant()));
            entry.setPointDescId(mustSign.getShiftParPointId());
            entryList.add(entry);
        }
        return entryList;
    }

    private static MultiCard initMultiCard(MatchVo matchVo) {
        MultiCard multiCard = new MultiCard();
        ArrayList<MultiCardEntry> entryList = new ArrayList<MultiCardEntry>(matchVo.getShiftMustSignList().size());
        multiCard.setAttPersonId(matchVo.getAttPersonId());
        multiCard.setAttFileId(matchVo.getAttFileId());
        multiCard.setAttFileBoId(matchVo.getAttFileBoId());
        multiCard.setAttFileTimeZoneId(matchVo.getTimeZoneId());
        multiCard.setOrgId(matchVo.getOrgId());
        multiCard.setAdminOrgId(matchVo.getAdminOrgId());
        multiCard.setAttCard(matchVo.getAttCardNo());
        multiCard.setShiftDate(matchVo.getLocalDate());
        multiCard.setShiftId(matchVo.getShift().getId());
        multiCard.setPositionId(matchVo.getPositionId());
        multiCard.setJobId(matchVo.getJobId());
        multiCard.setManagingScopeId(matchVo.getManagingScopeId());
        multiCard.setCompanyId(matchVo.getCompanyId());
        multiCard.setAffiliateAdminOrgId(matchVo.getAffiliateAdminOrgId());
        multiCard.setEmpGroupId(matchVo.getEmpGroupId());
        multiCard.setDependencyId(matchVo.getDependencyId());
        multiCard.setDependencyTypeId(matchVo.getDependencyTypeId());
        multiCard.setWorkplaceId(matchVo.getWorkplaceId());
        multiCard.setAgreedLocationId(matchVo.getAgreedLocationId());
        multiCard.setWeek(matchVo.getWeek());
        multiCard.setDateTypeId(matchVo.getDateTypeId());
        multiCard.setOffShift(matchVo.getShift().isOff());
        multiCard.setNotPlan(matchVo.getShift().getOffNonPlan());
        List shiftMustSignList = matchVo.getShiftMustSignList();
        for (MustSignInfoVo mustSign : shiftMustSignList) {
            MultiCardEntry entry = new MultiCardEntry();
            entry.setAttPersonId(matchVo.getAttPersonId());
            entry.setMatchDate(matchVo.getLocalDate());
            entry.setMustPoint(mustSign.getAbsoluteSign());
            entry.setMustPointUtc(mustSign.getAbsoluteSign().minusHours(mustSign.getTimeDiff()));
            entry.setPointDescId(mustSign.getShiftParPointId());
            entryList.add(entry);
        }
        multiCard.setEntryList(entryList);
        return multiCard;
    }

    private static void processOnceCard(MatchTaskVo taskVo, MatchVo matchVo, List<SignCard> signCardList, ShiftVo shiftVo) {
        SignCard signCard = CardMatchServiceImpl.calculateOnceCard(taskVo, matchVo, signCardList, shiftVo);
        CardMatchHelper.saveOnceCard(taskVo, false, signCard, matchVo);
    }

    private static SignCard calculateOnceCard(MatchTaskVo taskVo, MatchVo matchVo, List<SignCard> signCardList, ShiftVo shiftVo) {
        if (CollectionUtils.isEmpty(signCardList)) {
            return null;
        }
        LocalDateTime nextEffectiveSignPoint = CardMatchServiceImpl.getNextEffectiveSignPoint(taskVo, matchVo, shiftVo);
        LocalDateTime previousEffectiveSignPoint = CardMatchServiceImpl.getPreviousEffectiveSignPoint(matchVo, shiftVo);
        List<Object> legalSignCards = signCardList;
        if (null != nextEffectiveSignPoint) {
            legalSignCards = signCardList.stream().filter(signCard -> signCard.getSignPointUtc() != null && signCard.getSignPointUtc().isBefore(nextEffectiveSignPoint)).collect(Collectors.toList());
        }
        if (null != previousEffectiveSignPoint) {
            legalSignCards = legalSignCards.stream().filter(signCard -> signCard.getSignPointUtc() != null && signCard.getSignPointUtc().isAfter(previousEffectiveSignPoint)).collect(Collectors.toList());
        }
        if (null != shiftVo && null != shiftVo.getPreMustSignLast()) {
            legalSignCards = legalSignCards.stream().filter(signCard -> signCard.getSignPointUtc() != null && !signCard.getSignPointUtc().isBefore(shiftVo.getPreMustSignLast())).collect(Collectors.toList());
        }
        if (null != shiftVo && null != shiftVo.getNextMustSignFirst()) {
            legalSignCards = legalSignCards.stream().filter(signCard -> signCard.getSignPointUtc() != null && !signCard.getSignPointUtc().isAfter(shiftVo.getNextMustSignFirst())).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(legalSignCards)) {
            return null;
        }
        String onceTaskCardMode = matchVo.getShift().getOneCardType();
        List mustSignInfoList = matchVo.getShiftMustSignList();
        return CardMatchServiceImpl.getSignCardByOnceTaskCardMode(onceTaskCardMode, mustSignInfoList, shiftVo, legalSignCards, matchVo);
    }

    private static SignCard getSignCardByOnceTaskCardMode(String onceTaskCardMode, List<MustSignInfoVo> mustSignInfoList, ShiftVo shiftVo, List<SignCard> legalSignCards, MatchVo matchVo) {
        SignCard signCard = null;
        if (HRStringUtils.isEmpty((String)onceTaskCardMode) || OnceCardModeEnum.RANGE.getCode().equals(onceTaskCardMode)) {
            for (MustSignInfoVo mustSign : mustSignInfoList) {
                LocalDateTime endDateTime;
                int index = mustSignInfoList.indexOf(mustSign);
                LocalDateTime startDateTime = CardMatchServiceImpl.getSignRangeStart(index, mustSignInfoList, shiftVo);
                List<SignCard> signCards = CardMatchHelper.getSignCardsInRange(startDateTime, endDateTime = CardMatchServiceImpl.getSignRangeEnd(index, mustSignInfoList, shiftVo), legalSignCards);
                if (CollectionUtils.isEmpty(signCards)) continue;
                signCard = signCards.get(0);
                break;
            }
        } else if (OnceCardModeEnum.START.getCode().equals(onceTaskCardMode)) {
            LocalDateTime firstEnd;
            MustSignInfoVo mustSignFirst = mustSignInfoList.get(0);
            LocalDateTime firstStart = CardMatchServiceImpl.getSignRangeStart(0, mustSignInfoList, shiftVo);
            List<SignCard> firstSignCards = CardMatchHelper.getSignCardsInRange(firstStart, firstEnd = CardMatchServiceImpl.getSignRangeEnd(0, mustSignInfoList, shiftVo), legalSignCards);
            if (!CollectionUtils.isEmpty(firstSignCards)) {
                signCard = CardMatchServiceImpl.getSignCardByTaskCardRule(firstSignCards, mustSignFirst);
            }
        } else if (OnceCardModeEnum.END.getCode().equals(onceTaskCardMode)) {
            LocalDateTime lastEnd;
            MustSignInfoVo mustSignLast = mustSignInfoList.get(mustSignInfoList.size() - 1);
            LocalDateTime lastStart = CardMatchServiceImpl.getSignRangeStart(mustSignInfoList.size() - 1, mustSignInfoList, shiftVo);
            List<SignCard> lastSignCards = CardMatchHelper.getSignCardsInRange(lastStart, lastEnd = CardMatchServiceImpl.getSignRangeEnd(mustSignInfoList.size() - 1, mustSignInfoList, shiftVo), legalSignCards);
            if (!CollectionUtils.isEmpty(lastSignCards)) {
                signCard = CardMatchServiceImpl.getSignCardByTaskCardRule(lastSignCards, mustSignLast);
            }
        } else if (OnceCardModeEnum.NOT_REST.getCode().equals(onceTaskCardMode)) {
            List<ShiftDetail> shiftDetails = matchVo.getShift().getShiftDetailList().stream().filter(detail -> !StringUtils.equals((CharSequence)detail.getOutWorkType(), (CharSequence)"B")).collect(Collectors.toList());
            signCard = CardMatchHelper.getFirstSignCard(matchVo, legalSignCards, shiftDetails, matchVo.getLocalDate());
        } else if (OnceCardModeEnum.REST.getCode().equals(onceTaskCardMode)) {
            List details = matchVo.getShift().getShiftDetailList();
            signCard = CardMatchHelper.getFirstSignCard(matchVo, legalSignCards, details, matchVo.getLocalDate());
        }
        return signCard;
    }

    private static SignCard getSignCardByTaskCardRule(List<SignCard> signCards, MustSignInfoVo mustSign) {
        String takeCardRule = mustSign.getTakeCardRule();
        if (TaskCardModeEnum.EARLIEST.getCode().equals(takeCardRule)) {
            return signCards.get(0);
        }
        if (TaskCardModeEnum.LATEST.getCode().equals(takeCardRule)) {
            return signCards.get(signCards.size() - 1);
        }
        if (TaskCardModeEnum.FORWARD.getCode().equals(takeCardRule)) {
            List preRecentList = signCards.stream().filter(sign -> sign.getSignPointUtc().compareTo(mustSign.getAbsoluteSignUtc()) <= 0).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(preRecentList)) {
                return null;
            }
            return (SignCard)preRecentList.get(preRecentList.size() - 1);
        }
        if (TaskCardModeEnum.BACKWARD.getCode().equals(takeCardRule)) {
            List nextRecentList = signCards.stream().filter(sign -> sign.getSignPointUtc().compareTo(mustSign.getAbsoluteSignUtc()) >= 0).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(nextRecentList)) {
                return null;
            }
            return (SignCard)nextRecentList.get(0);
        }
        if (TaskCardModeEnum.NEAREST.getCode().equals(takeCardRule)) {
            String takeCardSameLen = mustSign.getTakeCardSameLen();
            return CardMatchServiceImpl.getRecentPoint(signCards, takeCardSameLen, mustSign.getAbsoluteSignUtc());
        }
        return null;
    }

    private static LocalDateTime getSignRangeStart(int index, List<MustSignInfoVo> mustSignList, ShiftVo shiftVo) {
        LocalDateTime startDateTime;
        MustSignInfoVo mustSignInfoVo = mustSignList.get(index);
        LocalDateTime localDateTime = startDateTime = Boolean.TRUE.equals(mustSignInfoVo.getSignOn()) ? mustSignInfoVo.getStartBeforeScope() : mustSignInfoVo.getEndBeforeScope();
        if (shiftVo != null) {
            LocalDateTime otStartFirst;
            BigDecimal coreEndRange;
            if (index == mustSignList.size() - 1 && (coreEndRange = shiftVo.getCoreEndRange()) != null) {
                startDateTime = startDateTime.minusMinutes(coreEndRange.intValue());
            }
            if (index == 0 && (otStartFirst = shiftVo.getOtStartFirst()) != null) {
                startDateTime = otStartFirst.minusMinutes(mustSignInfoVo.getsBeforeScope().intValue());
            }
        }
        return startDateTime;
    }

    private static LocalDateTime getSignRangeEnd(int index, List<MustSignInfoVo> mustSignList, ShiftVo shiftVo) {
        LocalDateTime otEndLast;
        BigDecimal coreStartRange;
        LocalDateTime endDateTime;
        MustSignInfoVo mustSignInfoVo = mustSignList.get(index);
        LocalDateTime localDateTime = endDateTime = Boolean.TRUE.equals(mustSignInfoVo.getSignOn()) ? mustSignInfoVo.getStartAfterScope() : mustSignInfoVo.getEndAfterScope();
        if (index == 0 && (coreStartRange = shiftVo.getCoreStartRange()) != null) {
            endDateTime = endDateTime.plusMinutes(coreStartRange.intValue());
        }
        if (index == mustSignList.size() - 1 && (otEndLast = shiftVo.getOtEndLast()) != null) {
            endDateTime = otEndLast.plusMinutes(mustSignInfoVo.geteAfterScope().intValue());
        }
        return endDateTime;
    }

    private static boolean isFrozenDate(MatchVo matchVo) {
        if (Objects.nonNull(matchVo.getFrozenStartDate()) && Objects.nonNull(matchVo.getFrozenEndDate())) {
            boolean startFlag = matchVo.getMatchDate().compareTo(matchVo.getFrozenStartDate()) >= 0;
            boolean endFlag = matchVo.getMatchDate().compareTo(matchVo.getFrozenEndDate()) <= 0;
            return startFlag && endFlag;
        }
        return false;
    }

    private static ShiftVo generateShiftVo(MatchTaskVo taskVo, List<MustSignInfoVo> shiftMustSignList, MatchVo matchVo) {
        LocalDateTime shiftFirstDateTime = null;
        LocalDateTime shiftLastDateTime = null;
        if (!CollectionUtils.isEmpty(shiftMustSignList)) {
            shiftFirstDateTime = shiftMustSignList.get(0).getAbsoluteSignUtc();
            shiftLastDateTime = shiftMustSignList.get(shiftMustSignList.size() - 1).getAbsoluteSignUtc();
        }
        ShiftVo shiftVo = new ShiftVo();
        shiftVo.setMustSignFirst(shiftFirstDateTime);
        shiftVo.setMustSignLast(shiftLastDateTime);
        LocalDate preDate = matchVo.getLocalDate().minusDays(1L);
        CardMatchServiceImpl.processPreShift(preDate, taskVo, shiftFirstDateTime, shiftVo, matchVo);
        LocalDate nextDate = matchVo.getLocalDate().plusDays(1L);
        CardMatchServiceImpl.processNextShift(nextDate, taskVo, shiftLastDateTime, shiftVo, matchVo);
        if (matchVo.getTakeCardRule().isOvertimeTakeCardMode()) {
            CardMatchHelper.getOverTime(matchVo, shiftVo, taskVo);
        }
        CardMatchServiceImpl.setCoreWorkTime(matchVo.getShift(), shiftVo, matchVo);
        return shiftVo;
    }

    private static ShiftVo generateOffShiftVo(MatchTaskVo taskVo, MatchVo matchVo, OffRangeVo offRangeVo) {
        LocalDateTime start = offRangeVo.getRangeStart();
        LocalDateTime end = offRangeVo.getRangeEnd();
        ShiftVo shiftVo = new ShiftVo();
        shiftVo.setMustSignFirst(start);
        shiftVo.setMustSignLast(end);
        LocalDate preDate = matchVo.getLocalDate().minusDays(1L);
        CardMatchServiceImpl.processPreShift(preDate, taskVo, start, shiftVo, matchVo);
        LocalDate nextDate = matchVo.getLocalDate().plusDays(1L);
        CardMatchServiceImpl.processNextShift(nextDate, taskVo, end, shiftVo, matchVo);
        return shiftVo;
    }

    private static void setCoreWorkTime(Shift shift, ShiftVo shiftVo, MatchVo matchVo) {
        List details = shift.getShiftDetailList();
        if (CollectionUtils.isEmpty((Collection)details)) {
            return;
        }
        List coreWorkList = details.stream().filter(detail -> StringUtils.equals((CharSequence)detail.getOutWorkType(), (CharSequence)"S")).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(coreWorkList)) {
            ShiftDetail coreWorkStart = (ShiftDetail)coreWorkList.get(0);
            LocalDateTime coreStart = CardMatchHelper.getAbsoluteDateTime(matchVo.getLocalDate(), coreWorkStart.getRefStartDay(), coreWorkStart.getShiftStartDate());
            LocalDateTime coreStartUtc = coreStart.minusHours(matchVo.getTimeDiff());
            Duration coreStartRange = Duration.between(shiftVo.getMustSignFirst(), coreStartUtc);
            shiftVo.setCoreStartRange(BigDecimal.valueOf(coreStartRange.toMinutes()));
            ShiftDetail coreWorkEnd = (ShiftDetail)coreWorkList.get(coreWorkList.size() - 1);
            LocalDateTime coreEnd = CardMatchHelper.getAbsoluteDateTime(matchVo.getLocalDate(), coreWorkEnd.getRefEndDay(), coreWorkEnd.getShiftEndDate());
            LocalDateTime coreEndUtc = coreEnd.minusHours(matchVo.getTimeDiff());
            Duration coreEndRange = Duration.between(coreEndUtc, shiftVo.getMustSignLast());
            shiftVo.setCoreEndRange(BigDecimal.valueOf(coreEndRange.toMinutes()));
        }
    }

    private static void processPreShift(LocalDate preDate, MatchTaskVo taskVo, LocalDateTime shiftFirstDateTime, ShiftVo shiftVo, MatchVo matchVo) {
        LocalDateTime preMustSignLast = CardMatchServiceImpl.getAbsoluteMustSignPoint(preDate, matchVo, shiftVo, true);
        shiftVo.setPreMustSignLast(preMustSignLast);
        LocalDateTime preActualSignLast = null;
        preActualSignLast = CardMatchServiceImpl.getPreActualSignLastFromPointTag(preActualSignLast, taskVo, matchVo, shiftVo, preDate);
        if (null == preActualSignLast) {
            PointTagLog end;
            Map map;
            Map tagMap;
            Map workEndMap = (Map)taskVo.getWorkEndMap().get(matchVo.getAttPersonId());
            if (null != workEndMap && null != workEndMap.get(preDate)) {
                preActualSignLast = (LocalDateTime)workEndMap.get(preDate);
            } else {
                Map workStartMap = (Map)taskVo.getWorkStartMap().get(matchVo.getAttPersonId());
                if (null != workStartMap && null != workStartMap.get(preDate)) {
                    preActualSignLast = (LocalDateTime)workStartMap.get(preDate);
                    shiftVo.setPreActualSignLastOff(false);
                }
            }
            if (null == preActualSignLast && null != (tagMap = (Map)taskVo.getPointTagMap().get(matchVo.getAttPersonId())) && null != (map = (Map)tagMap.get(preDate)) && null != (end = (PointTagLog)map.get("end"))) {
                preActualSignLast = end.getMultiPointUtc();
            }
        }
        if (null == preMustSignLast || null != preActualSignLast && preActualSignLast.isAfter(preMustSignLast)) {
            shiftVo.setPreActualSignLast(preActualSignLast);
        }
        CardMatchServiceImpl.processPreOffShift(shiftVo, taskVo, matchVo);
        if (preMustSignLast != null && shiftFirstDateTime != null && matchVo.getTakeCardRule().isContinueCard()) {
            shiftVo.setContinuePre(Boolean.valueOf(preMustSignLast.compareTo(shiftFirstDateTime) == 0));
        }
    }

    private static LocalDateTime getPreActualSignLastFromPointTag(LocalDateTime preActualSignLast, MatchTaskVo taskVo, MatchVo matchVo, ShiftVo shiftVo, LocalDate preDate) {
        PointTagLog end;
        Map map;
        Map tagMap;
        if (taskVo.isManualPointTag() && null != (tagMap = (Map)taskVo.getPointTagMap().get(matchVo.getAttPersonId())) && null != (map = (Map)tagMap.get(preDate)) && null != (end = (PointTagLog)map.get("end"))) {
            preActualSignLast = end.getMultiPointUtc();
        }
        return preActualSignLast;
    }

    private static void processPreOffShift(ShiftVo shiftVo, MatchTaskVo taskVo, MatchVo matchVo) {
        if (null != shiftVo.getPreMustSignLast() || null != shiftVo.getPreActualSignLast()) {
            return;
        }
        Map workEndMap = (Map)taskVo.getWorkEndMap().get(matchVo.getAttPersonId());
        LocalDate beforePreDate = matchVo.getLocalDate().minusDays(2L);
        LocalDateTime beforePreActualSignLast = null;
        if (null != workEndMap && null != workEndMap.get(beforePreDate)) {
            beforePreActualSignLast = (LocalDateTime)workEndMap.get(beforePreDate);
        } else {
            Map workStartMap = (Map)taskVo.getWorkStartMap().get(matchVo.getAttPersonId());
            if (null != workStartMap && null != workStartMap.get(beforePreDate)) {
                beforePreActualSignLast = (LocalDateTime)workStartMap.get(beforePreDate);
            }
        }
        if (null != beforePreActualSignLast) {
            shiftVo.setPreActualSignLast(beforePreActualSignLast.plusSeconds(1L));
        }
    }

    private static void processNextOffShift(ShiftVo shiftVo, MatchTaskVo taskVo, MatchVo matchVo) {
        if (null != shiftVo.getNextMustSignFirst() || null != shiftVo.getNextActualSignFirst()) {
            return;
        }
        LocalDate afterNextDate = matchVo.getLocalDate().plusDays(2L);
        LocalDateTime afterNextActualSignFirst = null;
        Map workStartMap = (Map)taskVo.getWorkStartMap().get(matchVo.getAttPersonId());
        if (null != workStartMap && null != workStartMap.get(afterNextDate)) {
            afterNextActualSignFirst = (LocalDateTime)workStartMap.get(afterNextDate);
        } else {
            Map workEndMap = (Map)taskVo.getWorkEndMap().get(matchVo.getAttPersonId());
            if (null != workEndMap && null != workEndMap.get(afterNextDate)) {
                afterNextActualSignFirst = (LocalDateTime)workEndMap.get(afterNextDate);
            }
        }
        if (null != afterNextActualSignFirst) {
            shiftVo.setNextActualSignFirst(afterNextActualSignFirst.minusSeconds(1L));
        }
    }

    private static void processNextShift(LocalDate nextDate, MatchTaskVo taskVo, LocalDateTime shiftFirstDateTime, ShiftVo shiftVo, MatchVo matchVo) {
        LocalDateTime nextMustSignFirst = CardMatchServiceImpl.getAbsoluteMustSignPoint(nextDate, matchVo, shiftVo, false);
        shiftVo.setNextMustSignFirst(nextMustSignFirst);
        LocalDateTime nextActualSignFirst = null;
        nextActualSignFirst = CardMatchServiceImpl.getNextActualSignFirstFromPointTag(nextActualSignFirst, taskVo, matchVo, shiftVo, nextDate);
        if (null == nextActualSignFirst) {
            PointTagLog start;
            Map map;
            Map tagMap;
            Map workStartMap = (Map)taskVo.getWorkStartMap().get(matchVo.getAttPersonId());
            if (null != workStartMap && null != workStartMap.get(nextDate)) {
                nextActualSignFirst = (LocalDateTime)workStartMap.get(nextDate);
            } else {
                Map workEndMap = (Map)taskVo.getWorkEndMap().get(matchVo.getAttPersonId());
                if (null != workEndMap && null != workEndMap.get(nextDate)) {
                    nextActualSignFirst = (LocalDateTime)workEndMap.get(nextDate);
                    shiftVo.setNextActualSignFirstOn(false);
                }
            }
            if (null == nextActualSignFirst && null != (tagMap = (Map)taskVo.getPointTagMap().get(matchVo.getAttPersonId())) && null != (map = (Map)tagMap.get(nextDate)) && null != (start = (PointTagLog)map.get("start"))) {
                nextActualSignFirst = start.getMultiPointUtc();
            }
        }
        if (null == nextMustSignFirst || null != nextActualSignFirst && nextActualSignFirst.isBefore(nextMustSignFirst)) {
            shiftVo.setNextActualSignFirst(nextActualSignFirst);
        }
        CardMatchServiceImpl.processNextOffShift(shiftVo, taskVo, matchVo);
        if (nextMustSignFirst != null && shiftFirstDateTime != null && matchVo.getTakeCardRule().isContinueCard()) {
            shiftVo.setContinueNext(Boolean.valueOf(nextMustSignFirst.compareTo(shiftFirstDateTime) == 0));
        }
    }

    private static LocalDateTime getNextActualSignFirstFromPointTag(LocalDateTime nextActualSignFirst, MatchTaskVo taskVo, MatchVo matchVo, ShiftVo shiftVo, LocalDate nextDate) {
        PointTagLog start;
        Map map;
        Map tagMap;
        if (taskVo.isManualPointTag() && null != (tagMap = (Map)taskVo.getPointTagMap().get(matchVo.getAttPersonId())) && null != (map = (Map)tagMap.get(nextDate)) && null != (start = (PointTagLog)map.get("start"))) {
            nextActualSignFirst = start.getMultiPointUtc();
        }
        return nextActualSignFirst;
    }

    private static LocalDateTime getAbsoluteMustSignPoint(LocalDate calculateDate, MatchVo matchVo, ShiftVo shiftVo, boolean isUpShift) {
        List<MustSignInfoVo> mustSignInfoList;
        List details;
        if (isUpShift) {
            Shift preShift = matchVo.getPreShift();
            if (HRObjectUtils.isEmpty((Object)preShift) || HRObjectUtils.isEmpty((Object)preShift.getTakeCardRule())) {
                return null;
            }
            details = preShift.getShiftDetailList();
            mustSignInfoList = CardMatchHelper.getShiftMustSignList(details, preShift.getTakeCardRule().getTimeSeqList(), calculateDate);
            for (MustSignInfoVo info : mustSignInfoList) {
                info.setAbsoluteSignUtc(info.getAbsoluteSign().minusHours(matchVo.getPreTimeDiff()));
                info.setTimeDiff(matchVo.getPreTimeDiff());
            }
        } else {
            Shift nextShift = matchVo.getNextShift();
            if (HRObjectUtils.isEmpty((Object)nextShift) || HRObjectUtils.isEmpty((Object)nextShift.getTakeCardRule())) {
                return null;
            }
            details = nextShift.getShiftDetailList();
            mustSignInfoList = CardMatchHelper.getShiftMustSignList(details, nextShift.getTakeCardRule().getTimeSeqList(), calculateDate);
            for (MustSignInfoVo info : mustSignInfoList) {
                info.setAbsoluteSignUtc(info.getAbsoluteSign().minusHours(matchVo.getNextTimeDiff()));
                info.setTimeDiff(matchVo.getNextTimeDiff());
            }
        }
        if (!CollectionUtils.isEmpty(mustSignInfoList)) {
            MustSignInfoVo mustSignInfoVo = mustSignInfoList.get(isUpShift ? mustSignInfoList.size() - 1 : 0);
            LocalDateTime absoluteMustSignPoint = mustSignInfoVo.getAbsoluteSignUtc();
            if (isUpShift) {
                shiftVo.setPreMustSignLast(absoluteMustSignPoint);
            } else {
                shiftVo.setNextMustSignFirst(absoluteMustSignPoint);
            }
            return absoluteMustSignPoint;
        }
        return null;
    }

    private static void processCheckCard(MultiCard multiCard, MatchTaskVo taskVo, MatchVo matchVo, List<SignCard> signCardList) {
        List details = matchVo.getShift().getShiftDetailList();
        List restShiftDetail = details.stream().filter(element -> StringUtils.equals((CharSequence)element.getOutWorkType(), (CharSequence)"B")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(restShiftDetail)) {
            return;
        }
        Long takeCardRuleBoId = matchVo.getShift().getTakeCardRule().getId();
        List takeCardRules = (List)taskVo.getRuleMap().get(takeCardRuleBoId);
        DynamicObject takeCardRule = SignCardCommonService.getDyDate(takeCardRules, matchVo.getMatchDate(), true);
        long configBoId = takeCardRule.getLong("takecardconfig.id");
        if (configBoId == 0L) {
            LOG.warn("\u53d6\u5361\u5339\u914d\u4efb\u52a1,\u5904\u7406\u6821\u9a8c\u5361\u672a\u627e\u5230\u53d6\u5361\u914d\u7f6e");
            return;
        }
        DynamicObject takeCardConfig = SignCardCommonService.getDyDate((List)taskVo.getRuleConfigMap().get(configBoId), matchVo.getMatchDate(), true);
        if (null == takeCardConfig) {
            LOG.warn("\u53d6\u5361\u5339\u914d\u4efb\u52a1,\u5904\u7406\u6821\u9a8c\u5361\u672a\u627e\u5230\u53d6\u5361\u914d\u7f6e");
            return;
        }
        List takeCardConfigRest = takeCardConfig.getDynamicObjectCollection("entryentity").stream().filter(e1 -> HRStringUtils.equalsIgnoreCase((String)e1.getString("classtimetype"), (String)"2")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(takeCardConfigRest) || restShiftDetail.size() != takeCardConfigRest.size()) {
            return;
        }
        List needCheckList = takeCardConfigRest.stream().filter(element -> element.getBoolean("isopenvalid")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(needCheckList)) {
            return;
        }
        CheckCard checkCard = new CheckCard();
        checkCard.setAttPersonId(matchVo.getAttPersonId());
        checkCard.setAttFileId(matchVo.getAttFileId());
        checkCard.setAttFileBoId(matchVo.getAttFileBoId());
        checkCard.setWeek(matchVo.getWeek());
        checkCard.setDateTypeId(matchVo.getDateTypeId());
        checkCard.setOrgId(matchVo.getOrgId());
        checkCard.setAttCard(matchVo.getAttCardNo());
        checkCard.setShiftDate(matchVo.getLocalDate());
        checkCard.setShiftId(matchVo.getShift().getId());
        ArrayList<CheckCardEntry> entryList = new ArrayList<CheckCardEntry>(needCheckList.size());
        for (int i = 0; i < restShiftDetail.size(); ++i) {
            ShiftDetail detail = (ShiftDetail)restShiftDetail.get(i);
            DynamicObject rest = (DynamicObject)takeCardConfigRest.get(i);
            if (!rest.getBoolean("isopenvalid")) continue;
            CheckCardEntry entry = new CheckCardEntry();
            entry.setPointDesc(detail.getShiftPeriodId());
            LocalDateTime restStartDateTime = CardMatchHelper.getAbsoluteDateTime(matchVo.getLocalDate(), detail.getRefStartDay(), detail.getShiftStartDate());
            LocalDateTime restStartUtc = restStartDateTime.minusHours(matchVo.getTimeDiff());
            LocalDateTime restEndDateTime = CardMatchHelper.getAbsoluteDateTime(matchVo.getLocalDate(), detail.getRefEndDay(), detail.getShiftEndDate());
            LocalDateTime restEndUtc = restEndDateTime.minusHours(matchVo.getTimeDiff());
            if (!CollectionUtils.isEmpty(signCardList)) {
                entry = CardMatchServiceImpl.fillCheckCard(entry, signCardList, multiCard, restStartUtc, restEndUtc, matchVo);
            }
            entryList.add(entry);
        }
        checkCard.setEntryList(entryList);
        taskVo.getCheckCardSet().add(checkCard);
    }

    private static CheckCardEntry fillCheckCard(CheckCardEntry entry, List<SignCard> signCardList, MultiCard multiCard, LocalDateTime restStartUtc, LocalDateTime restEndUtc, MatchVo matchVo) {
        LocalDate localDate = matchVo.getLocalDate();
        for (SignCard signCard : signCardList) {
            LocalDateTime signPointUtc = signCard.getSignPointUtc();
            long sourceId = signCard.getSource();
            if (restStartUtc.compareTo(signPointUtc) > 0 || signPointUtc.compareTo(restEndUtc) > 0) continue;
            List entries = multiCard.getEntryList();
            boolean legal = true;
            for (MultiCardEntry multiCardEntry : entries) {
                if (null == multiCardEntry.getMultiPointUtc() || !multiCardEntry.getMultiPointUtc().isEqual(signPointUtc) || null == multiCardEntry.getSourceId() || sourceId != multiCardEntry.getSourceId()) continue;
                legal = false;
                break;
            }
            if (!legal) continue;
            entry.setTimeZoneId(signCard.getTimeZoneId());
            entry.setCheckPoint(signCard.getSignPoint());
            entry.setCheckPointUtc(signPointUtc);
            entry.setSource(signCard.getSource());
            entry.setAccessTag(signCard.getAccessTag());
            entry.setDeviceId(signCard.getDeviceId());
            entry.setSignCardId(signCard.getId().longValue());
            String pointTag = CardMatchHelper.getPointTag(signCard.getSignPointUtc(), localDate, matchVo.getTimeDiff());
            entry.setPointTag(pointTag);
            entry.setPresetBiz1(signCard.getPresetBiz1());
            entry.setPresetBiz2(signCard.getPresetBiz2());
            break;
        }
        return entry;
    }

    private static LocalDateTime getSearchCardEndPoint(MatchVo matchVo, List<TimeSeq> timeSeqList, ShiftVo shiftVo, Shift shift) {
        String lastRefEndDay = shift.getLastRefEndDay();
        int lastShiftEndDate = shift.getLastShiftEndDate();
        LocalDateTime endTime = CardMatchServiceImpl.getSpecificDateTime(matchVo.getLocalDate(), lastRefEndDay, lastShiftEndDate, timeSeqList, false);
        endTime = endTime.minusHours(matchVo.getTimeDiff());
        LocalDateTime otEndLast = shiftVo.getOtEndLast();
        LocalDateTime mustSignLast = shiftVo.getMustSignLast();
        if (otEndLast != null && mustSignLast.compareTo(otEndLast) < 0) {
            endTime = otEndLast.plusMinutes(timeSeqList.get(timeSeqList.size() - 1).getEndAfterScope().intValue());
        } else {
            shiftVo.setOtEndLast(null);
        }
        return endTime;
    }

    private static LocalDateTime getSpecificDateTime(LocalDate matchDate, String refDay, int startDate, List<TimeSeq> timeSeqList, boolean forward) {
        LocalDateTime absoluteDateTime = CardMatchHelper.getAbsoluteDateTime(matchDate, refDay, startDate);
        if (!timeSeqList.isEmpty()) {
            if (forward) {
                int minute = timeSeqList.get(0).getStartBeforeScope();
                absoluteDateTime = absoluteDateTime.minusMinutes(minute);
            } else {
                int minute = timeSeqList.get(timeSeqList.size() - 1).getEndAfterScope();
                absoluteDateTime = absoluteDateTime.plusMinutes(minute);
            }
        }
        return absoluteDateTime;
    }

    private static LocalDateTime getSearchCardBeginPoint(MatchVo matchVo, List<TimeSeq> timeSeqList, ShiftVo shiftVo, Shift shift) {
        String lastRefStartDay = shift.getLastRefStartDay();
        int lastShiftStartDate = shift.getLastShiftStartDate();
        LocalDateTime beginTime = CardMatchServiceImpl.getSpecificDateTime(matchVo.getLocalDate(), lastRefStartDay, lastShiftStartDate, timeSeqList, true);
        beginTime = beginTime.minusHours(matchVo.getTimeDiff());
        LocalDateTime otStartFirst = shiftVo.getOtStartFirst();
        LocalDateTime mustSignFirst = shiftVo.getMustSignFirst();
        if (otStartFirst != null && mustSignFirst.compareTo(otStartFirst) > 0) {
            beginTime = otStartFirst.minusMinutes(timeSeqList.get(0).getStartBeforeScope().intValue());
        } else {
            shiftVo.setOtStartFirst(null);
        }
        return beginTime;
    }

    private static void fillMultiCard(SignCard signCard, MultiCardEntry entry, MatchVo matchVo) {
        LocalDateTime signPointUtc = signCard.getSignPointUtc();
        entry.setEffectivePoint(signCard.getSignPoint());
        entry.setSourceId(signCard.getSource());
        entry.setDeviceId(signCard.getDeviceId());
        entry.setAccessTag(signCard.getAccessTag());
        entry.setMultiPointUtc(signPointUtc);
        entry.setTimeZoneId(signCard.getTimeZoneId());
        entry.setPresetBiz1(signCard.getPresetBiz1());
        entry.setPresetBiz2(signCard.getPresetBiz2());
        if (signCard.getId() != null) {
            entry.setSignCardId(signCard.getId().longValue());
        }
        entry.setApplyReasonId(signCard.getApplyReasonId());
        if (matchVo.getLocalDate() != null) {
            String pointTag = CardMatchHelper.getPointTag(signPointUtc, matchVo.getLocalDate(), matchVo.getTimeDiff());
            entry.setPointTag(pointTag);
        }
    }

    private static SignCard getRecentPoint(List<SignCard> signCardList, String takeCardSameLen, LocalDateTime mustSignPoint) {
        if (signCardList.size() == 1) {
            return signCardList.get(0);
        }
        ArrayList<SignCard> result = new ArrayList<SignCard>(2);
        result.add(signCardList.get(0));
        long nearest = Math.abs(signCardList.get(0).getSignPointUtc().toInstant(ZoneOffset.UTC).getEpochSecond() - mustSignPoint.toInstant(ZoneOffset.UTC).getEpochSecond());
        for (int index = 1; index < signCardList.size(); ++index) {
            SignCard signCard = signCardList.get(index);
            long duration = Math.abs(signCard.getSignPointUtc().toInstant(ZoneOffset.UTC).getEpochSecond() - mustSignPoint.toInstant(ZoneOffset.UTC).getEpochSecond());
            if (nearest < duration) continue;
            if (nearest > duration) {
                nearest = duration;
                result.clear();
                result.add(signCard);
                continue;
            }
            result.add(signCard);
        }
        if (result.size() == 1) {
            return (SignCard)result.get(0);
        }
        return HRStringUtils.equals((String)"1", (String)takeCardSameLen) ? (SignCard)result.get(0) : (SignCard)result.get(result.size() - 1);
    }

    private static LocalDateTime getPreviousEffectiveSignPoint(MatchTaskVo taskVo, List<MultiCardEntry> entryList, MatchVo matchVo, ShiftVo shiftVo, int index) {
        boolean notShare;
        PointTagLog end;
        LocalDate preDate;
        Map map;
        List effectiveCardDataList = entryList.stream().filter(entry -> !HRObjectUtils.isEmpty((Object)entry.getEffectivePoint()) && index > 0 && entryList.indexOf(entry) < index).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(effectiveCardDataList)) {
            return ((MultiCardEntry)effectiveCardDataList.get(effectiveCardDataList.size() - 1)).getMultiPointUtc();
        }
        if (null == shiftVo) {
            return null;
        }
        LocalDateTime previousEffectiveSignPoint = shiftVo.getPreActualSignLast();
        TakeCardRule rule = matchVo.getTakeCardRule();
        LocalDateTime prePointTag = null;
        Map tagMap = (Map)taskVo.getPointTagMap().get(matchVo.getAttPersonId());
        if (!(null == tagMap || null == (map = (Map)tagMap.get(preDate = matchVo.getLocalDate().minusDays(1L))) || null == (end = (PointTagLog)map.get("end")) || null == end.getMultiPointUtc() || end.getMultiPointUtc().isAfter(shiftVo.getMustSignFirst()) || null != shiftVo.getPreMustSignLast() && end.getMultiPointUtc().isBefore(shiftVo.getPreMustSignLast()))) {
            prePointTag = end.getMultiPointUtc();
        }
        boolean bl = notShare = previousEffectiveSignPoint != null && (rule == null || !rule.isCardShare());
        if (notShare) {
            if (null != prePointTag) {
                return !prePointTag.isAfter(entryList.get(0).getMustPointUtc()) ? prePointTag : shiftVo.getPreMustSignLast();
            }
            return !previousEffectiveSignPoint.isAfter(entryList.get(0).getMustPointUtc()) ? previousEffectiveSignPoint : shiftVo.getPreMustSignLast();
        }
        if (rule != null && rule.isCardShare() && previousEffectiveSignPoint != null) {
            if (shiftVo.isPreActualSignLastOff()) {
                return previousEffectiveSignPoint.minusSeconds(1L);
            }
            return null != shiftVo.getPreMustSignLast() && shiftVo.getPreMustSignLast().isAfter(previousEffectiveSignPoint) ? shiftVo.getPreMustSignLast() : previousEffectiveSignPoint;
        }
        return null;
    }

    private static LocalDateTime getPreviousEffectiveSignPoint(MatchVo matchVo, ShiftVo shiftVo) {
        if (shiftVo != null) {
            boolean notShare;
            LocalDateTime previousEffectiveSignPoint = shiftVo.getPreActualSignLast();
            TakeCardRule rule = matchVo.getTakeCardRule();
            boolean bl = notShare = previousEffectiveSignPoint != null && (rule == null || !rule.isCardShare());
            if (notShare) {
                return previousEffectiveSignPoint;
            }
            if (rule != null && rule.isCardShare() && previousEffectiveSignPoint != null) {
                return previousEffectiveSignPoint.minusSeconds(1L);
            }
        }
        return null;
    }

    private static LocalDateTime getNextEffectiveSignPoint(MatchTaskVo taskVo, MatchVo matchVo, ShiftVo shiftVo) {
        LocalDateTime date = null;
        if (!HRObjectUtils.isEmpty((Object)shiftVo)) {
            boolean notShare;
            TakeCardRule rule = matchVo.getTakeCardRule();
            LocalDateTime nextEffectiveSignPoint = shiftVo.getNextActualSignFirst();
            LocalDateTime nextSignPointTag = CardMatchServiceImpl.getNextShiftPointTag(nextEffectiveSignPoint, taskVo, matchVo, shiftVo);
            boolean bl = notShare = !(nextEffectiveSignPoint == null && nextSignPointTag == null || rule != null && rule.isCardShare());
            if (notShare) {
                LocalDateTime last = ((MustSignInfoVo)matchVo.getShiftMustSignList().get(matchVo.getShiftMustSignList().size() - 1)).getAbsoluteSignUtc();
                if (null != nextSignPointTag) {
                    return !nextSignPointTag.isBefore(last) ? nextSignPointTag : shiftVo.getNextMustSignFirst();
                }
                return nextEffectiveSignPoint.isAfter(last) ? nextEffectiveSignPoint : shiftVo.getNextMustSignFirst();
            }
            if (rule != null && rule.isCardShare() && nextEffectiveSignPoint != null) {
                return nextEffectiveSignPoint.plusSeconds(1L);
            }
        }
        return date;
    }

    private static LocalDateTime getNextShiftPointTag(LocalDateTime nextEffectiveSignPoint, MatchTaskVo taskVo, MatchVo matchVo, ShiftVo shiftVo) {
        PointTagLog start;
        LocalDate nextDate;
        Map map;
        Map tagMap = (Map)taskVo.getPointTagMap().get(matchVo.getAttPersonId());
        if (!(null == tagMap || null == (map = (Map)tagMap.get(nextDate = matchVo.getLocalDate().plusDays(1L))) || null == (start = (PointTagLog)map.get("start")) || null == start.getMultiPointUtc() || start.getMultiPointUtc().isBefore(shiftVo.getMustSignLast()) || null != shiftVo.getNextMustSignFirst() && start.getMultiPointUtc().isAfter(shiftVo.getNextMustSignFirst()))) {
            return start.getMultiPointUtc();
        }
        return null;
    }

    private static ShiftVo generateShiftVo(List<MustSignInfoVo> shiftMustSignList, MatchVo matchVo) {
        LocalDateTime shiftFirstDateTime = null;
        LocalDateTime shiftLastDateTime = null;
        if (!CollectionUtils.isEmpty(shiftMustSignList)) {
            shiftFirstDateTime = shiftMustSignList.get(0).getAbsoluteSignUtc();
            shiftLastDateTime = shiftMustSignList.get(shiftMustSignList.size() - 1).getAbsoluteSignUtc();
        }
        ShiftVo shiftVo = new ShiftVo();
        shiftVo.setMustSignFirst(shiftFirstDateTime);
        shiftVo.setMustSignLast(shiftLastDateTime);
        CardMatchServiceImpl.setCoreWorkTime(matchVo.getShift(), shiftVo, matchVo);
        return shiftVo;
    }

    public static List<MultiCardEntryDTO> getEffectiveCard(List<SignCardDTO> signCardList, Shift shift, TakeCardRule takeCardRule, LocalDate matchDate) {
        if (shift == null) {
            return new ArrayList<MultiCardEntryDTO>();
        }
        List shiftDetailList = shift.getShiftDetailList();
        List<MustSignInfoVo> shiftMustSignList = CardMatchHelper.getShiftMustSignList(shiftDetailList, takeCardRule.getTimeSeqList(), matchDate);
        for (MustSignInfoVo mustSignInfoVo : shiftMustSignList) {
            mustSignInfoVo.setAbsoluteSignUtc(mustSignInfoVo.getAbsoluteSign());
        }
        MatchVo matchVo = new MatchVo();
        matchVo.setTimeDiff(0);
        matchVo.setPreTimeDiff(0);
        matchVo.setNextTimeDiff(0);
        matchVo.setShift(shift);
        matchVo.setShiftMustSignList(shiftMustSignList);
        matchVo.setLocalDate(matchDate);
        ShiftVo shiftVo = CardMatchServiceImpl.generateShiftVo(shiftMustSignList, matchVo);
        List<MultiCardEntryDTO> entryList = CardMatchServiceImpl.initMultiCardEntryForTrial(matchVo);
        return CardMatchServiceImpl.matchEffectiveCard(entryList, matchVo, signCardList, shiftVo);
    }

    private static List<MultiCardEntryDTO> matchEffectiveCard(List<MultiCardEntryDTO> entryList, MatchVo matchVo, List<SignCardDTO> signCardList, ShiftVo shiftVo) {
        if (CollectionUtils.isEmpty(signCardList)) {
            return entryList;
        }
        ArrayList<SignCard> signCards = new ArrayList<SignCard>(signCardList.size());
        for (SignCardDTO signCardDTO : signCardList) {
            SignCard signCard = new SignCard();
            signCard.setSignPointUtc(signCardDTO.getSignDateTimeUtc().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
            signCard.setSignPoint(signCardDTO.getSignDateTimeUtc().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
            signCards.add(signCard);
        }
        ArrayList<MultiCardEntry> multiCardEntries = new ArrayList<MultiCardEntry>(entryList.size());
        for (MultiCardEntryDTO dto : entryList) {
            MultiCardEntry entry = new MultiCardEntry();
            entry.setAttPersonId(matchVo.getAttPersonId());
            entry.setMatchDate(matchVo.getLocalDate());
            entry.setMustPoint(dto.getMustPoint().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
            entry.setMustPointUtc(dto.getMustPointUtc().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
            entry.setPointDescId(dto.getPointDescId());
            multiCardEntries.add(entry);
        }
        for (MultiCardEntry entry : multiCardEntries) {
            int index = multiCardEntries.indexOf(entry);
            List<SignCard> legalSignCards = CardMatchServiceImpl.getLegalSignCards(new MatchTaskVo(), shiftVo, entry, multiCardEntries, signCards, matchVo, null);
            List mustSignInfoList = matchVo.getShiftMustSignList();
            MustSignInfoVo info = (MustSignInfoVo)mustSignInfoList.get(index);
            LocalDateTime startDateTime = CardMatchServiceImpl.getSignRangeStart(index, mustSignInfoList, shiftVo);
            LocalDateTime endDateTime = CardMatchServiceImpl.getSignRangeEnd(index, mustSignInfoList, shiftVo);
            List<SignCard> finalSignCards = legalSignCards.stream().filter(sign -> startDateTime.isBefore(sign.getSignPointUtc()) && endDateTime.isAfter(sign.getSignPointUtc()) || startDateTime.equals(sign.getSignPointUtc()) || endDateTime.equals(sign.getSignPointUtc())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(finalSignCards)) continue;
            boolean isSignOn = info.getSignOn();
            if (CollectionUtils.isEmpty(finalSignCards = finalSignCards.stream().filter(sign -> isSignOn ? !StringUtils.equals((CharSequence)"off", (CharSequence)sign.getAccessTag()) : !StringUtils.equals((CharSequence)"on", (CharSequence)sign.getAccessTag())).collect(Collectors.toList()))) continue;
            CardMatchServiceImpl.fillMultiCardByTakeCardRule(info, finalSignCards, entry, matchVo);
        }
        int n = multiCardEntries.size();
        ArrayList<MultiCardEntryDTO> result = new ArrayList<MultiCardEntryDTO>(n);
        for (MultiCardEntry entry : multiCardEntries) {
            MultiCardEntryDTO dto = new MultiCardEntryDTO();
            if (null != entry.getMultiPointUtc()) {
                dto.setEffectivePoint(Date.from(entry.getMultiPointUtc().atZone(ZoneId.systemDefault()).toInstant()));
            }
            result.add(dto);
        }
        return result;
    }

    private static TimeZoneVo getTimeDiff(MatchTaskVo taskVo, LocalDate date, MatchVo matchVo) {
        List entry = (List)taskVo.getTimeZoneMap().get(matchVo.getAttFileBoId());
        if (CollectionUtils.isEmpty((Collection)entry)) {
            LOG.debug("\u53d6\u5361\u5339\u914d\u4efb\u52a1,\u8003\u52e4\u4eba[{}]\u5728\u8003\u52e4\u65e5\u671f[{}]\u4e0d\u5b58\u5728\u8003\u52e4\u6863\u6848\u7684\u65f6\u533a\u4fe1\u606f", (Object)matchVo.getAttPersonId(), (Object)date);
            return null;
        }
        for (DynamicObject timeZone : entry) {
            LocalDate start = timeZone.getDate("bsed").toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            LocalDate end = timeZone.getDate("bsled").toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            int timeDiff = timeZone.getInt("tz.timedif");
            if (start == null || start.compareTo(date) > 0 || end == null || end.compareTo(date) < 0) continue;
            TimeZoneVo vo = new TimeZoneVo();
            vo.setTimeDiff(timeDiff);
            vo.setTimeZoneId(timeZone.getLong("tz.id"));
            return vo;
        }
        return null;
    }

    private void costLog(String message, long start) {
        long now = new Date().getTime();
        LOG.info("cardmatch, step[{}], cost[{}]ms", (Object)message, (Object)(now - start));
    }
}

