/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.cardmatch;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtpm.business.WTPMSignCardHelper;
import kd.sdk.wtc.wtpm.business.cardmatch.CardMatchTaskParam;
import kd.wtc.wtbs.business.task.base.WTCDistributeTaskHelper;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtpm.constants.sign.CardMatchKDString;

public class CardMatchTaskSDKGenerator
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(WTCDistributeTaskHelper.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        CardMatchTaskParam param = this.beforeGenTask(requestContext, map);
        ApiResult apiResult = WTPMSignCardHelper.executeCustomCardMatchTask((CardMatchTaskParam)param);
        if (null != apiResult && !apiResult.getSuccess()) {
            throw new KDException(new ErrorCode(apiResult.getErrorCode(), apiResult.getMessage()), new Object[0]);
        }
    }

    private CardMatchTaskParam beforeGenTask(RequestContext requestContext, Map<String, Object> map) {
        String tmpAttFileBoIds;
        String endDateStr;
        String startDateStr;
        JSONObject orgJson;
        CardMatchTaskParam param = new CardMatchTaskParam();
        String tmpOrgId = (String)map.get("attOrg");
        if (WTCStringUtils.isNotEmpty((String)tmpOrgId) && (orgJson = JSON.parseObject((String)tmpOrgId)).containsKey((Object)"id")) {
            param.setAttOrgId(orgJson.getLong("id").longValue());
        }
        if (HRStringUtils.isNotEmpty((String)(startDateStr = (String)map.get("startDate")))) {
            Date startDate = WTCDateUtils.str2Date((String)startDateStr, (String)"yyyy-MM-dd");
            param.setStartDate(startDate);
        }
        if (HRStringUtils.isNotEmpty((String)(endDateStr = (String)map.get("endDate")))) {
            Date endDate = WTCDateUtils.str2Date((String)endDateStr, (String)"yyyy-MM-dd");
            param.setEndDate(endDate);
        }
        if (WTCStringUtils.isNotEmpty((String)(tmpAttFileBoIds = (String)map.get("attFileBoIds")))) {
            try {
                Set attFileBoIds = Arrays.stream(tmpAttFileBoIds.split(",")).map(Long::parseLong).collect(Collectors.toSet());
                param.setAttFileBoIds(attFileBoIds);
            }
            catch (Exception exception) {
                LOG.warn("CardMatchTaskSDKGenerator.beforeGenTask getAttFileBoIds error", (Throwable)exception);
                String msg = CardMatchKDString.attFileBoIdsInputTips();
                throw new KDException(new ErrorCode("fail", msg), new Object[0]);
            }
        }
        param.setTaskDesc((String)map.get("taskDesc"));
        param.setCreatorId(requestContext.getCurrUserId());
        param.setTaskType((String)map.get("taskType"));
        return param;
    }
}

