/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.cardmatch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.auth.HRAuthUtil;
import kd.wtc.wtbs.business.caltask.common.WTCTaskRequestStd;
import kd.wtc.wtbs.business.formtask.TaskFormProcessorService;
import kd.wtc.wtbs.business.formtask.WTCTaskForm;
import kd.wtc.wtbs.business.task.base.WTCDistributeTaskHelper;
import kd.wtc.wtbs.business.task.common.WTCSource;
import kd.wtc.wtbs.business.task.common.WTCTaskRequest;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.model.attfile.AttFileF7QueryParam;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtpm.common.vo.cardmatch.CardMatchReqVo;
import kd.wtc.wtpm.constants.sign.CardMatchConstants;
import kd.wtc.wtpm.constants.sign.CardMatchKDString;

public class MatchTaskDisPatchServiceImpl
implements TaskFormProcessorService,
CardMatchConstants {
    private static final Log logger = LogFactory.getLog(MatchTaskDisPatchServiceImpl.class);

    public void beforeGenTaskForm(Object param) {
    }

    public WTCTaskForm genTaskForm(Object param) {
        WTCTaskForm taskForm = (WTCTaskForm)param;
        Map customParams = taskForm.getCustomParams();
        CardMatchReqVo reqVo = this.getMatchData(customParams);
        if (CollectionUtils.isEmpty((Collection)reqVo.getDetail())) {
            String msg = CardMatchKDString.notAuthAttFiles();
            HashMap errMsg = Maps.newHashMapWithExpectedSize((int)2);
            errMsg.put("msgType", "notAttFiles");
            errMsg.put("msg", msg);
            taskForm.setErrMsg(SerializationUtils.toJsonString((Object)errMsg));
            return taskForm;
        }
        long taskId = this.saveInitTask(customParams, reqVo);
        WTCTaskRequestStd request = this.setDistributedTaskRequest(taskId, reqVo);
        List subTaskDispatchRequestList = WTCDistributeTaskHelper.shardingSaveAndSlimReqStd((WTCTaskRequestStd)request);
        taskForm.setTaskRequest((WTCTaskRequest)request);
        taskForm.setSubTaskDispatchRequestList(subTaskDispatchRequestList);
        return taskForm;
    }

    public void afterGenTaskForm(Object param) {
    }

    private WTCTaskRequestStd setDistributedTaskRequest(long taskId, CardMatchReqVo reqVo) {
        WTCTaskRequestStd request = new WTCTaskRequestStd();
        request.setTaskId(taskId);
        request.setVersion(reqVo.getVersion());
        request.setCategory("wtpm_match");
        request.setCreatorId(RequestContext.get().getCurrUserId());
        request.setSource(WTCSource.MANUAL.code);
        request.setTrial(false);
        request.setStartDate(reqVo.getStartDate());
        request.setEndDate(reqVo.getEndDate());
        request.setAppId("wtpm");
        request.setDetail(reqVo.getDetail());
        HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
        paramMap.put("number", taskId);
        paramMap.put("name", ResManager.loadKDString((String)"\u53d6\u5361\u5339\u914d", (String)"MatchTaskDisPatchServiceImpl_0", (String)"wtc-wtpm-business", (Object[])new Object[0]));
        request.setParams(paramMap);
        return request;
    }

    private CardMatchReqVo getMatchData(Map<String, Object> data) {
        QFilter qFilter;
        CardMatchReqVo reqVo = new CardMatchReqVo();
        reqVo.setCreateUserId(Long.valueOf(RequestContext.get().getCurrUserId()));
        reqVo.setStartDate((Date)data.get("startdate"));
        reqVo.setEndDate((Date)data.get("enddate"));
        reqVo.setAttFileIds((Set)data.get("attFileBoIds"));
        reqVo.setOrgIds((Set)data.get("adminOrgSet"));
        reqVo.setExAttFileIds((Set)data.get("excludeAttFileBoIds"));
        reqVo.setVersion((String)data.get("version"));
        String newTaskStr = (String)data.get("newTask");
        long start = System.currentTimeMillis();
        ArrayList allAttFileDyList = Lists.newArrayListWithExpectedSize((int)16);
        if (!CollectionUtils.isEmpty((Collection)reqVo.getAttFileIds())) {
            logger.info("\u53d6\u5361\u5339\u914d,\u67e5\u8be2\u8003\u52e4\u6863\u6848(\u6309boid)\u5f00\u59cb,size={}", (Object)reqVo.getAttFileIds().size());
            AttFileF7QueryParam queryParam = new AttFileF7QueryParam();
            queryParam.setStartDate(reqVo.getStartDate());
            queryParam.setEndDate(reqVo.getEndDate());
            queryParam.setqFilter(new QFilter("bsed", "<=", (Object)reqVo.getEndDate()).and("bsled", ">=", (Object)reqVo.getStartDate()));
            queryParam.setFormId("wtpm_matchtaskdetail");
            queryParam.setAppId("wtpm");
            queryParam.setPermField("attfile");
            queryParam.setProperties(HRAuthUtil.ATT_FILE_SHARD_TASK_PROPERTY);
            queryParam.setSetBoIds(reqVo.getAttFileIds());
            queryParam.setBoDelSetIds(reqVo.getExAttFileIds());
            queryParam.setAttStatus(null);
            if (HRStringUtils.isEmpty((String)newTaskStr)) {
                queryParam.setUsableStatus((Set)Sets.newHashSet((Object[])new String[]{"0", "-1"}));
            }
            qFilter = new QFilter("attperson.id", "!=", (Object)0L);
            queryParam.setqFilter(qFilter);
            List attFiles = AttFileQueryServiceImpl.getInstance().queryAttFilesByCustomAuth(queryParam);
            logger.info("\u53d6\u5361\u5339\u914d,\u67e5\u8be2\u8003\u52e4\u6863\u6848(\u6309boid)\u8fd4\u56de,size={}", (Object)attFiles.size());
            allAttFileDyList.addAll(attFiles);
        }
        if (!CollectionUtils.isEmpty((Collection)reqVo.getOrgIds())) {
            AttFileF7QueryParam orgParam = new AttFileF7QueryParam();
            orgParam.setStartDate(reqVo.getStartDate());
            orgParam.setEndDate(reqVo.getEndDate());
            orgParam.setqFilter(new QFilter("bsed", "<=", (Object)reqVo.getEndDate()).and("bsled", ">=", (Object)reqVo.getStartDate()));
            orgParam.setFormId("wtpm_matchtaskdetail");
            orgParam.setAppId("wtpm");
            orgParam.setPermField("attfile");
            orgParam.setBoDelSetIds(reqVo.getExAttFileIds());
            orgParam.setProperties(HRAuthUtil.ATT_FILE_SHARD_TASK_PROPERTY);
            orgParam.setAffiliateAdminOrgSetIds(reqVo.getOrgIds());
            orgParam.setAttStatus(null);
            if (HRStringUtils.isEmpty((String)newTaskStr)) {
                orgParam.setUsableStatus((Set)Sets.newHashSet((Object[])new String[]{"0", "-1"}));
            }
            qFilter = new QFilter("attperson.id", "!=", (Object)0L);
            orgParam.setqFilter(qFilter);
            logger.info("\u53d6\u5361\u5339\u914d,\u67e5\u8be2\u8003\u52e4\u6863\u6848(\u6309\u6302\u9760\u884c\u653f\u7ec4\u7ec7)\u5f00\u59cb");
            List orgAttFiles = AttFileQueryServiceImpl.getInstance().queryAttFilesByCustomAuth(orgParam);
            logger.info("\u53d6\u5361\u5339\u914d,\u67e5\u8be2\u8003\u52e4\u6863\u6848(\u6309\u6302\u9760\u884c\u653f\u7ec4\u7ec7)\u8fd4\u56de,responseSize = {}", (Object)orgAttFiles.size());
            allAttFileDyList.addAll(orgAttFiles);
        }
        long end = System.currentTimeMillis();
        long cost = end - start;
        logger.info("\u53d6\u5361\u5339\u914d,\u67e5\u8be2\u8003\u52e4\u6863\u6848,\u7ed3\u675f,\u8017\u65f6={}ms", (Object)cost);
        if (CollectionUtils.isEmpty((Collection)allAttFileDyList)) {
            return reqVo;
        }
        ArrayList attFileDyList = Lists.newArrayListWithExpectedSize((int)allAttFileDyList.size());
        Map<Long, List<DynamicObject>> map = allAttFileDyList.stream().collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
        for (Map.Entry<Long, List<DynamicObject>> entry : map.entrySet()) {
            reqVo.getAuthAttFileBoIds().add(entry.getKey());
            List<DynamicObject> list = entry.getValue();
            list.sort(Comparator.comparing(dy -> dy.getDate("bsed")));
            attFileDyList.add(list.get(list.size() - 1));
        }
        attFileDyList.sort(Comparator.comparing(dy -> dy.getLong("boid")));
        List detail = HRAuthUtil.getAuthFieldByAttFileDynBatch((List)attFileDyList);
        reqVo.setDetail(detail);
        return reqVo;
    }

    private long saveInitTask(Map<String, Object> data, CardMatchReqVo reqVo) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtpm_matchresult");
        Long id = DB.genGlobalLongId();
        DynamicObject result = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"wtpm_matchresult"));
        result.set("id", (Object)id);
        result.set("task", (Object)id);
        result.set("org", data.get("org"));
        result.set("version", (Object)reqVo.getVersion());
        result.set("startdate", (Object)reqVo.getStartDate());
        result.set("enddate", (Object)reqVo.getEndDate());
        result.set("desc", data.get("desc"));
        result.set("creator", (Object)RequestContext.get().getCurrUserId());
        result.set("createtime", (Object)new Date());
        DynamicObject resultDy = (DynamicObject)serviceHelper.saveOne(result);
        return resultDy.getLong("id");
    }
}

