/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.cardmatch;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.schedule.api.JobInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtpm.business.cardmatch.CardMatchIntersectionExtPlugin;
import kd.sdk.wtc.wtpm.business.cardmatch.CardMatchOffShiftExtPlugin;
import kd.sdk.wtc.wtpm.business.cardmatch.CardMatchTaskParam;
import kd.wtc.wtbs.business.auth.HRAuthUtil;
import kd.wtc.wtbs.business.caltask.common.WTCTaskRequestStd;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.task.base.WTCDistributeTaskHelper;
import kd.wtc.wtbs.business.task.common.WTCSource;
import kd.wtc.wtbs.business.task.common.WTCTaskRequest;
import kd.wtc.wtbs.business.web.applybill.ruleengine.PlanRuleEngineService;
import kd.wtc.wtbs.business.web.attendperson.AttendPersonServiceImpl;
import kd.wtc.wtbs.business.web.evaluation.EvaluationServiceHelper;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.file.schedule.AttFileScheduleServiceImpl;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.enums.AttModeEnum;
import kd.wtc.wtbs.common.enums.bill.PlanSceneEnum;
import kd.wtc.wtbs.common.enums.signcard.SupplementModeEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.attfile.AttFileScheduleQueryParam;
import kd.wtc.wtbs.common.model.bill.PlanRuleEngineInParam;
import kd.wtc.wtbs.common.model.bill.PlanRuleEngineOutParam;
import kd.wtc.wtbs.common.model.evaluation.DutyShiftResponse;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.model.evaluation.ShiftDetail;
import kd.wtc.wtbs.common.model.sign.PointTagLog;
import kd.wtc.wtbs.common.model.sign.SignCard;
import kd.wtc.wtbs.common.model.sign.SignCardDailyResp;
import kd.wtc.wtbs.common.model.sign.TimeSeq;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCOrgUnitServiceHelper;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.MapUtils;
import kd.wtc.wtpm.business.cardmatch.CardMatchHelper;
import kd.wtc.wtpm.business.cardmatch.CardMatchServiceImpl;
import kd.wtc.wtpm.business.signcard.SignCardCommonService;
import kd.wtc.wtpm.business.signcard.supplyapply.helper.SupSignHisHelper;
import kd.wtc.wtpm.business.supquotapool.SupQuotaPoolTaskService;
import kd.wtc.wtpm.common.vo.cardmatch.MatchTaskVo;
import kd.wtc.wtpm.common.vo.cardmatch.MustSignInfoVo;
import kd.wtc.wtpm.common.vo.cardmatch.TaskSummaryVo;
import kd.wtc.wtpm.constants.sign.CardMatchConstants;

public class SignCardService
implements CardMatchConstants {
    private static final Log LOG = LogFactory.getLog(SignCardService.class);

    public Map<Date, Map<String, Object>> getShiftAndSignCardDetail(Long attPersonId, Date startDate, Date endDate) {
        HashMap<Date, Map<String, Object>> result = new HashMap<Date, Map<String, Object>>(4);
        Map<Date, List<ShiftDetail>> shiftDetailMap = this.getShiftInfo(attPersonId, startDate, endDate, result);
        if (MapUtils.isEmpty(shiftDetailMap)) {
            return result;
        }
        for (Map.Entry<Date, List<ShiftDetail>> entry : shiftDetailMap.entrySet()) {
            Date shiftDate = entry.getKey();
            List<ShiftDetail> shiftDetails = entry.getValue();
            String attMode = this.getAttModeInfo(shiftDate, attPersonId);
            QFilter[] qFilters = new QFilter[]{new QFilter("shiftdate", "=", (Object)shiftDate), new QFilter("attperson", "=", (Object)attPersonId)};
            this.getEffectiveCardInfoByAttMode(result, shiftDetails, shiftDate, qFilters, attMode);
        }
        return result;
    }

    public Map<Long, Map<Date, Map<String, Object>>> getSignCardDetailByAttFileBoIds(Map<Long, Map<String, Date>> req) {
        HashMap<Long, Map<Date, Map<String, Object>>> result = new HashMap<Long, Map<Date, Map<String, Object>>>(4);
        ArrayList<Date> startDateList = new ArrayList<Date>(2);
        ArrayList<Date> endDateList = new ArrayList<Date>(2);
        ArrayList<Long> attFileBoIds = new ArrayList<Long>(req.size());
        for (Map.Entry<Long, Map<String, Date>> entry : req.entrySet()) {
            startDateList.add(entry.getValue().get("startdate"));
            endDateList.add(entry.getValue().get("enddate"));
            attFileBoIds.add(entry.getKey());
        }
        Comparator comparator = Date::compareTo;
        startDateList.sort(comparator);
        endDateList.sort(comparator);
        DutyShiftResponse dutyShifts = EvaluationServiceHelper.getDutyShiftsByAttFileBoId(attFileBoIds, (Date)((Date)startDateList.get(0)), (Date)((Date)endDateList.get(endDateList.size() - 1)));
        for (Map.Entry<Long, Map<String, Date>> entry : req.entrySet()) {
            long attFileBoId = entry.getKey();
            Date startDate = entry.getValue().get("startdate");
            Date endDate = entry.getValue().get("enddate");
            if (null == startDate || null == endDate) {
                LOG.warn("getSignCardDetailByAttFileBoIds, date is empty");
                return null;
            }
            HashMap<Date, Map<String, Object>> singleResult = new HashMap<Date, Map<String, Object>>(4);
            Map<Date, List<ShiftDetail>> shiftDetailMap = this.getShiftInfoByAttFileBoId(dutyShifts, attFileBoId, startDate, endDate, singleResult);
            if (MapUtils.isEmpty(shiftDetailMap)) {
                result.put(attFileBoId, singleResult);
                continue;
            }
            for (Map.Entry<Date, List<ShiftDetail>> shiftEntry : shiftDetailMap.entrySet()) {
                Date shiftDate = shiftEntry.getKey();
                List<ShiftDetail> shiftDetails = shiftEntry.getValue();
                String attMode = this.getAttModeInfoByAttFileBoId(shiftDate, attFileBoId);
                QFilter[] qFilters = new QFilter[]{new QFilter("shiftdate", "=", (Object)shiftDate), new QFilter("attfile.boid", "=", (Object)attFileBoId)};
                this.getEffectiveCardInfoByAttMode(singleResult, shiftDetails, shiftDate, qFilters, attMode);
            }
            result.put(attFileBoId, singleResult);
        }
        return result;
    }

    private void getEffectiveCardInfoByAttMode(Map<Date, Map<String, Object>> result, List<ShiftDetail> shiftDetails, Date shiftDate, QFilter[] qFilters, String attMode) {
        if (null == shiftDetails || HRStringUtils.isEmpty((String)attMode)) {
            return;
        }
        Map<String, Object> data = result.get(shiftDate);
        if (AttModeEnum.NO_CARD.getCode().equals(attMode)) {
            data.put("type", AttModeEnum.NO_CARD.getCode());
        } else if (AttModeEnum.ONES_CARD.getCode().equals(attMode)) {
            data.put("type", AttModeEnum.ONES_CARD.getCode());
            HRBaseServiceHelper onceCardHelper = new HRBaseServiceHelper("wtpm_oncecard");
            DynamicObject onceCard = onceCardHelper.queryOne("oncepoint,device.address,presetbiz1,presetbiz2", qFilters);
            if (!HRObjectUtils.isEmpty((Object)onceCard)) {
                Date oncePoint = onceCard.getDate("oncepoint");
                data.put("sign", WTCDateUtils.date2Str((Date)oncePoint, (String)"yyyy-MM-dd HH:mm:ss"));
                data.put("signaddress", onceCard.getString("device.address"));
                data.put("presetbiz1", onceCard.getString("presetbiz1"));
                data.put("presetbiz2", onceCard.getString("presetbiz2"));
            }
        } else if (AttModeEnum.MANY_CARD.getCode().equals(attMode)) {
            data.put("type", AttModeEnum.MANY_CARD.getCode());
            this.getMultiCardInfo(shiftDetails, data, qFilters, shiftDate);
        }
    }

    private void getMultiCardInfo(List<ShiftDetail> shiftDetails, Map<String, Object> data, QFilter[] qFilters, Date shiftDate) {
        HRBaseServiceHelper multiCardHelper = new HRBaseServiceHelper("wtpm_multicard");
        DynamicObject multiCard = multiCardHelper.loadDynamicObject(qFilters);
        if (!HRObjectUtils.isEmpty((Object)multiCard)) {
            DynamicObjectCollection multiEntry = multiCard.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)multiEntry)) {
                return;
            }
            String offShiftStr = (String)data.get("offshift");
            ArrayList<Map<String, String>> signCardList = new ArrayList<Map<String, String>>(shiftDetails.size());
            if (Boolean.parseBoolean(offShiftStr)) {
                this.getMultiCardForOffShift(multiEntry, signCardList);
            } else {
                for (ShiftDetail detail : shiftDetails) {
                    detail.setCheckDate(shiftDate);
                    HashMap<String, String> signCard = new HashMap<String, String>(16);
                    signCard.put("needsignon", String.valueOf(detail.isWorkTimeStart()));
                    if (detail.isWorkTimeStart()) {
                        this.fillStartWork(signCard, detail, multiEntry);
                    }
                    signCard.put("needsignoff", String.valueOf(detail.isWorkTimeEnd()));
                    if (detail.isWorkTimeEnd()) {
                        this.fillEndWork(signCard, detail, multiEntry);
                    }
                    signCardList.add(signCard);
                }
            }
            data.put("sign", signCardList);
        }
    }

    private void getMultiCardForOffShift(DynamicObjectCollection multiEntry, List<Map<String, String>> signCardList) {
        DynamicObject end;
        DynamicObject start = (DynamicObject)multiEntry.get(0);
        if (!HRObjectUtils.isEmpty((Object)start)) {
            HashMap<String, String> signCard = new HashMap<String, String>(16);
            signCard.put("hassignedon", String.valueOf(null != start.getDate("effectivepoint")));
            signCard.put("signon", null == start.getDate("effectivepoint") ? "" : WTCDateUtils.date2Str((Date)start.getDate("effectivepoint"), (String)"yyyy-MM-dd HH:mm:ss"));
            signCard.put("signonaddress", start.getString("device.address"));
            signCard.put("presetbiz1", start.getString("presetbiz1"));
            signCard.put("presetbiz2", start.getString("presetbiz2"));
            signCardList.add(signCard);
        }
        if (!HRObjectUtils.isEmpty((Object)(end = (DynamicObject)multiEntry.get(multiEntry.size() - 1)))) {
            HashMap<String, String> signCard = new HashMap<String, String>(16);
            signCard.put("hassignedoff", String.valueOf(null != end.getDate("effectivepoint")));
            signCard.put("signoff", null == end.getDate("effectivepoint") ? "" : WTCDateUtils.date2Str((Date)end.getDate("effectivepoint"), (String)"yyyy-MM-dd HH:mm:ss"));
            signCard.put("signoffaddress", end.getString("device.address"));
            signCard.put("presetbiz1", end.getString("presetbiz1"));
            signCard.put("presetbiz2", end.getString("presetbiz2"));
            signCardList.add(signCard);
        }
    }

    private void fillEndWork(Map<String, String> signCard, ShiftDetail detail, DynamicObjectCollection multiEntry) {
        if (CollectionUtils.isEmpty((Collection)multiEntry)) {
            return;
        }
        Date mustSignPoint = detail.getAbsoluteShiftEndDate();
        for (DynamicObject entry : multiEntry) {
            Date must;
            if (null == entry || null == (must = entry.getDate("mustpoint")) || null == mustSignPoint || must.compareTo(mustSignPoint) != 0) continue;
            signCard.put("mustsignpoint", WTCDateUtils.date2Str((Date)mustSignPoint, (String)"yyyy-MM-dd HH:mm:ss"));
            Date effectivePoint = entry.getDate("effectivepoint");
            signCard.put("hassignedoff", String.valueOf(null != effectivePoint));
            signCard.put("signoff", null == effectivePoint ? "" : WTCDateUtils.date2Str((Date)effectivePoint, (String)"yyyy-MM-dd HH:mm:ss"));
            signCard.put("signoffaddress", entry.getString("device.address"));
            signCard.put("presetbiz1", entry.getString("presetbiz1"));
            signCard.put("presetbiz2", entry.getString("presetbiz2"));
            break;
        }
    }

    private void fillStartWork(Map<String, String> signCard, ShiftDetail detail, DynamicObjectCollection multiEntry) {
        if (CollectionUtils.isEmpty((Collection)multiEntry)) {
            return;
        }
        Date mustSignPoint = detail.getAbsoluteShiftStartDate();
        for (DynamicObject entry : multiEntry) {
            Date must;
            if (null == entry || null == (must = entry.getDate("mustpoint")) || null == mustSignPoint || must.compareTo(mustSignPoint) != 0) continue;
            Date effectivePoint = entry.getDate("effectivepoint");
            signCard.put("mustsignpoint", WTCDateUtils.date2Str((Date)mustSignPoint, (String)"yyyy-MM-dd HH:mm:ss"));
            signCard.put("hassignedon", String.valueOf(null != effectivePoint));
            signCard.put("signon", null == effectivePoint ? "" : WTCDateUtils.date2Str((Date)effectivePoint, (String)"yyyy-MM-dd HH:mm:ss"));
            signCard.put("signonaddress", entry.getString("device.address"));
            signCard.put("presetbiz1", entry.getString("presetbiz1"));
            signCard.put("presetbiz2", entry.getString("presetbiz2"));
            break;
        }
    }

    private String getAttModeInfo(Date shiftDate, Long attPersonId) {
        String attMode = null;
        AttFileQueryParam param = new AttFileQueryParam(shiftDate, shiftDate);
        param.setProperties(AttFileQueryParam.baseProperties);
        param.setAttPersonId(attPersonId.longValue());
        param.setAuthCheck(Boolean.FALSE);
        List attFiles = AttFileQueryServiceImpl.getInstance().queryAttFiles(param);
        if (CollectionUtils.isEmpty((Collection)attFiles)) {
            LOG.info("getSignCardDetail, personId:{}, date:{},\u672a\u627e\u5230\u8003\u52e4\u6863\u6848\u4fe1\u606f", (Object)attPersonId, (Object)shiftDate);
            return null;
        }
        long attFileBoId = ((DynamicObject)attFiles.get(0)).getLong("boid");
        ArrayList<Long> attFileBoIds = new ArrayList<Long>(1);
        attFileBoIds.add(attFileBoId);
        AttFileScheduleQueryParam modeParam = new AttFileScheduleQueryParam();
        modeParam.setFileBoIdSet(new HashSet(attFileBoIds));
        Map attModeMap = AttFileScheduleServiceImpl.getInstance().queryAttFileSchedule(AttFileScheduleEnum.MODE, modeParam);
        if (attModeMap == null) {
            LOG.warn("getSignCardDetail, personId:{}, date:{},\u672a\u627e\u5230\u8003\u52e4\u65b9\u5f0f", (Object)attPersonId, (Object)shiftDate);
            return null;
        }
        List modeEntry = (List)attModeMap.get(attFileBoId);
        if (CollectionUtils.isEmpty((Collection)modeEntry)) {
            LOG.warn("getSignCardDetail, personId:{}, date:{},\u672a\u627e\u5230\u8003\u52e4\u65b9\u5f0f", (Object)attPersonId, (Object)shiftDate);
            return null;
        }
        for (DynamicObject mode : modeEntry) {
            if (mode.getDate("bsed") == null || mode.getDate("bsed").compareTo(shiftDate) > 0 || mode.getDate("bsled") == null || mode.getDate("bsled").compareTo(shiftDate) < 0) continue;
            attMode = mode.getString(AttFileScheduleEnum.MODE.getKey());
            break;
        }
        return attMode;
    }

    private String getAttModeInfoByAttFileBoId(Date shiftDate, Long attFileBoId) {
        String attMode = null;
        ArrayList<Long> attFileBoIds = new ArrayList<Long>(1);
        attFileBoIds.add(attFileBoId);
        AttFileScheduleQueryParam modeParam = new AttFileScheduleQueryParam();
        modeParam.setFileBoIdSet(new HashSet(attFileBoIds));
        Map attModeMap = AttFileScheduleServiceImpl.getInstance().queryAttFileSchedule(AttFileScheduleEnum.MODE, modeParam);
        if (attModeMap == null) {
            LOG.warn("getSignCardDetail, attFileBoId:{}, date:{},\u672a\u627e\u5230\u8003\u52e4\u65b9\u5f0f", (Object)attFileBoId, (Object)shiftDate);
            return null;
        }
        List modeEntry = (List)attModeMap.get(attFileBoId);
        if (CollectionUtils.isEmpty((Collection)modeEntry)) {
            LOG.warn("getSignCardDetail, attFileBoId:{}, date:{},\u672a\u627e\u5230\u8003\u52e4\u65b9\u5f0f", (Object)attFileBoId, (Object)shiftDate);
            return null;
        }
        for (DynamicObject mode : modeEntry) {
            if (mode.getDate("bsed") == null || mode.getDate("bsed").compareTo(shiftDate) > 0 || mode.getDate("bsled") == null || mode.getDate("bsled").compareTo(shiftDate) < 0) continue;
            attMode = mode.getString(AttFileScheduleEnum.MODE.getKey());
            break;
        }
        return attMode;
    }

    private Map<Date, List<ShiftDetail>> getShiftInfo(Long attPersonId, Date startDate, Date endDate, Map<Date, Map<String, Object>> result) {
        HashMap<Date, List<ShiftDetail>> map = new HashMap<Date, List<ShiftDetail>>(8);
        AttFileQueryParam param = new AttFileQueryParam(startDate, endDate);
        param.setProperties("boid");
        param.setAttPersonId(attPersonId.longValue());
        param.setAuthCheck(Boolean.FALSE);
        List attFiles = AttFileQueryServiceImpl.getInstance().queryAttFiles(param);
        HashMap<String, String> message = new HashMap<String, String>(16);
        if (null == attFiles || CollectionUtils.isEmpty((Collection)attFiles)) {
            LOG.info("getSignCardDetail, personId:{}, startDate:{}, endDate:{},\u672a\u627e\u5230\u6863\u6848\u4fe1\u606f", new Object[]{attPersonId, startDate, endDate});
            message.put("message", "attfilebase is not found");
            result.put(startDate, message);
            return Collections.emptyMap();
        }
        List attFileBoIds = attFiles.stream().map(dy -> dy.getLong("boid")).collect(Collectors.toList());
        DutyShiftResponse dutyShifts = EvaluationServiceHelper.getDutyShiftsByAttFileBoId(attFileBoIds, (Date)startDate, (Date)endDate);
        if (null == dutyShifts.getShiftDetailMap()) {
            message.put("message", "shift id is not set");
            result.put(startDate, message);
            LOG.info("getSignCardDetail, personId:{}, startDate:{}, endDate:{},\u672a\u627e\u5230\u73ed\u6b21\u4fe1\u606f", new Object[]{attPersonId, startDate, endDate});
            return Collections.emptyMap();
        }
        List allDates = WTCDateUtils.getDays((Date)startDate, (Date)endDate);
        for (Date date : allDates) {
            boolean haveShift = false;
            HashMap<String, Object> data = new HashMap<String, Object>(16);
            for (Long attFileBoId : attFileBoIds) {
                Optional shifts = dutyShifts.getShiftByAttFileBoId(attFileBoId, date);
                if (!shifts.isPresent()) continue;
                Shift shift = (Shift)shifts.get();
                data.put("attfileboid", attFileBoId);
                data.put("offshift", shift.isOff() && shift.getOffNonPlan() ? "true" : "false");
                List shiftDetails = shift.getShiftDetailList();
                shiftDetails = shiftDetails.stream().filter(detail -> !StringUtils.equals((CharSequence)detail.getOutWorkType(), (CharSequence)"B")).collect(Collectors.toList());
                ArrayList shiftSeqList = new ArrayList(shiftDetails.size());
                for (ShiftDetail detail2 : shiftDetails) {
                    HashMap<String, String> shiftSeq = new HashMap<String, String>(4);
                    detail2.setCheckDate(date);
                    shiftSeq.put("start", WTCDateUtils.date2Str((Date)detail2.getAbsoluteShiftStartDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                    shiftSeq.put("end", WTCDateUtils.date2Str((Date)detail2.getAbsoluteShiftEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                    shiftSeqList.add(shiftSeq);
                }
                map.put(date, shiftDetails);
                data.put("shift", shiftSeqList);
                result.put(date, data);
                haveShift = true;
                break;
            }
            if (haveShift) continue;
            message.put("message", "shift scheduling is not set");
            result.put(date, message);
            LOG.info("getSignCardDetail, personId:{}, date:{},\u672a\u627e\u5230\u73ed\u6b21\u4fe1\u606f", (Object)attPersonId, (Object)date);
        }
        return map;
    }

    private Map<Date, List<ShiftDetail>> getShiftInfoByAttFileBoId(DutyShiftResponse dutyShifts, Long attFileBoId, Date startDate, Date endDate, Map<Date, Map<String, Object>> singleResult) {
        HashMap<String, String> message = new HashMap<String, String>(16);
        HashMap<Date, List<ShiftDetail>> map = new HashMap<Date, List<ShiftDetail>>(8);
        if (null == dutyShifts.getShiftDetailMap()) {
            message.put("message", "shift id is not set");
            singleResult.put(startDate, message);
            LOG.info("getShiftInfoByAttFileBoId, attFileBoId:{}, startDate:{}, endDate:{},\u672a\u627e\u5230\u73ed\u6b21\u4fe1\u606f", new Object[]{attFileBoId, startDate, endDate});
            return Collections.emptyMap();
        }
        List allDates = WTCDateUtils.getDays((Date)startDate, (Date)endDate);
        for (Date date : allDates) {
            boolean haveShift = false;
            HashMap<String, Object> data = new HashMap<String, Object>(16);
            Optional shifts = dutyShifts.getShiftByAttFileBoId(attFileBoId, date);
            if (shifts.isPresent()) {
                LOG.info("getShiftInfoByAttFileBoId, shiftId:{}", (Object)((Shift)shifts.get()).getId());
                Shift shift = (Shift)shifts.get();
                data.put("shiftid", shift.getId());
                data.put("attfileboid", attFileBoId);
                data.put("shiftname", shift.getName());
                data.put("offshift", shift.isOff() && shift.getOffNonPlan() ? "true" : "false");
                List shiftDetails = shift.getShiftDetailList();
                shiftDetails = shiftDetails.stream().filter(detail -> !StringUtils.equals((CharSequence)detail.getOutWorkType(), (CharSequence)"B")).collect(Collectors.toList());
                ArrayList shiftSeqList = new ArrayList(shiftDetails.size());
                for (ShiftDetail detail2 : shiftDetails) {
                    HashMap<String, String> shiftSeq = new HashMap<String, String>(4);
                    detail2.setCheckDate(date);
                    shiftSeq.put("start", WTCDateUtils.date2Str((Date)detail2.getAbsoluteShiftStartDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                    shiftSeq.put("end", WTCDateUtils.date2Str((Date)detail2.getAbsoluteShiftEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                    shiftSeq.put("isWorkTimeEnd", String.valueOf(detail2.isWorkTimeEnd()));
                    shiftSeq.put("isWorkTimeStart", String.valueOf(detail2.isWorkTimeStart()));
                    shiftSeqList.add(shiftSeq);
                }
                map.put(date, shiftDetails);
                data.put("shift", shiftSeqList);
                singleResult.put(date, data);
                haveShift = true;
            }
            if (haveShift) continue;
            message.put("message", "shift scheduling is not set");
            singleResult.put(date, message);
            LOG.info("getSignCardDetail, attFileBoId:{}, date:{},\u672a\u627e\u5230\u73ed\u6b21\u4fe1\u606f", (Object)attFileBoId, (Object)date);
        }
        return map;
    }

    public MatchTaskVo startMatch(Date startDate, Date endDate, Collection<Long> attPersonIds, Collection<Long> attFileIds, int triggerType) {
        CardMatchServiceImpl cardMatchService = new CardMatchServiceImpl();
        MatchTaskVo taskVo = new MatchTaskVo();
        taskVo.setStartDate(startDate);
        taskVo.setEndDate(endDate);
        LocalDate localDateStart = startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate localDateEnd = endDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        taskVo.setStart(localDateStart);
        taskVo.setEnd(localDateEnd);
        taskVo.setAttFileIds(new HashSet(2));
        taskVo.setAttFileBoIds(new HashSet(2));
        taskVo.setAttPersonIds(new HashSet(2));
        taskVo.getAttPersonIds().addAll(attPersonIds);
        List attFileList = new ArrayList(2);
        if (triggerType == 1) {
            attFileList = AttFileQueryServiceImpl.getInstance().queryAttFileByIds(null, new ArrayList<Long>(attFileIds));
        } else if (triggerType == 2) {
            AttFileQueryParam queryParam = new AttFileQueryParam();
            queryParam.setqFilter(new QFilter("bsed", "<=", (Object)taskVo.getEndDate()).and("bsled", ">=", (Object)taskVo.getStartDate()));
            queryParam.setAuthCheck(Boolean.FALSE);
            queryParam.setSetBoIds(new HashSet<Long>(attFileIds));
            queryParam.setAttStatus(null);
            queryParam.setUsableStatus((Set)Sets.newHashSet((Object[])new String[]{"0", "-1"}));
            attFileList = AttFileQueryServiceImpl.getInstance().queryAttFiles(queryParam);
        }
        if (CollectionUtils.isEmpty(attFileList)) {
            return taskVo;
        }
        HashSet<Long> attFileBoIds = new HashSet<Long>(attFileList.size());
        TaskSummaryVo summary = new TaskSummaryVo();
        HashMap<Long, List> personAttFileMap = new HashMap<Long, List>(2);
        for (DynamicObject attFile : attFileList) {
            attFileBoIds.add(attFile.getLong("boid"));
            taskVo.getAttFileIds().add(attFile.getLong("id"));
            taskVo.getAttFileBoIds().add(attFile.getLong("boid"));
            List affFiles = (List)personAttFileMap.get(attFile.getLong("attperson_id"));
            if (CollectionUtils.isEmpty((Collection)affFiles)) {
                ArrayList<DynamicObject> fileList = new ArrayList<DynamicObject>(1);
                fileList.add(attFile);
                personAttFileMap.put(attFile.getLong("attperson_id"), fileList);
                continue;
            }
            affFiles.add(attFile);
            personAttFileMap.put(attFile.getLong("attperson_id"), affFiles);
        }
        summary.setAttFileBoIds(attFileBoIds);
        summary.setAttPersonIds(new HashSet(taskVo.getAttPersonIds()));
        taskVo.setPersonAttFileMap(personAttFileMap);
        AttFileScheduleQueryParam param = new AttFileScheduleQueryParam();
        param.setFileBoIdSet(attFileBoIds);
        taskVo.setAttFileBoIds(attFileBoIds);
        Map attModeMap = AttFileScheduleServiceImpl.getInstance().queryAttFileSchedule(AttFileScheduleEnum.MODE, param);
        if (attModeMap == null) {
            return taskVo;
        }
        taskVo.setAttModeMap(attModeMap);
        Map attCardMap = AttFileScheduleServiceImpl.getInstance().queryAttFileSchedule(AttFileScheduleEnum.CARD, param);
        taskVo.setAttCardMap(attCardMap);
        param.setLoad(Boolean.TRUE);
        Map timeZoneMap = AttFileScheduleServiceImpl.getInstance().queryAttFileSchedule(AttFileScheduleEnum.TZ, param);
        taskVo.setTimeZoneMap(timeZoneMap);
        Date shiftStart = WTCDateUtils.getCustomDate((Date)taskVo.getStartDate(), (Integer)-2);
        Date shiftEnd = WTCDateUtils.getCustomDate((Date)taskVo.getEndDate(), (Integer)2);
        LocalDate shiftStartLocal = WTCDateUtils.toLocalDate((Date)shiftStart);
        LocalDate shiftEndLocal = WTCDateUtils.toLocalDate((Date)shiftEnd);
        DutyShiftResponse dutyShifts = EvaluationServiceHelper.getDutyShiftsByAttFileBoId(new ArrayList(taskVo.getAttFileBoIds()), (Date)shiftStart, (Date)shiftEnd);
        taskVo.setDutyShift(dutyShifts);
        Map<Long, List<DynamicObject>> ruleConfigMap = CardMatchHelper.getAllTakeRuleConfigs(shiftStart, shiftEnd);
        taskVo.setRuleConfigMap(ruleConfigMap);
        Map<Long, List<DynamicObject>> ruleMap = CardMatchHelper.getAllTakeRules(shiftStart, shiftEnd);
        taskVo.setRuleMap(ruleMap);
        Map<Long, List<DynamicObject>> shiftMap = CardMatchHelper.getAllShifts(shiftStart, shiftEnd);
        taskVo.setShiftMap(shiftMap);
        List<SignCard> allSignCards = CardMatchHelper.getAllSignCardsByAttPersons(taskVo.getAttPersonIds(), shiftStartLocal, shiftEndLocal);
        Map<Long, List<SignCard>> signCardMap = allSignCards.stream().collect(Collectors.groupingBy(SignCard::getAttPersonId));
        taskVo.setSignCardMap(signCardMap);
        Map<Long, Map<LocalDate, Map<String, PointTagLog>>> pointTagMap = CardMatchHelper.getAllManualPointTag(taskVo, shiftStartLocal, shiftEndLocal);
        taskVo.setPointTagMap(pointTagMap);
        CardMatchHelper.getWorkEffectivePoints(false, shiftStartLocal, taskVo.getAttPersonIds(), taskVo);
        CardMatchHelper.getWorkEffectivePoints(true, shiftEndLocal, taskVo.getAttPersonIds(), taskVo);
        taskVo.setSummary(summary);
        taskVo.setManualPointTag(1 == triggerType);
        taskVo.setFromAdTrigger(2 == triggerType);
        CardMatchHelper.getAllVaApplyBills(taskVo);
        Map otApplyBills = (Map)WTCServiceHelper.invokeWtcWtomBizService((String)"IOverTimeApplyBillService", (String)"queryDutyDateMaxAndMinTime", (Object[])new Object[]{taskVo.getAttPersonIds(), taskVo.getStartDate(), taskVo.getEndDate()});
        taskVo.setOtApplyMap(otApplyBills);
        WTCPluginProxy offShiftExtInstance = WTCPluginProxyFactory.create(null, CardMatchOffShiftExtPlugin.class, (String)"kd.sdk.wtc.wtpm.business.cardmatch.CardMatchOffShiftExtPlugin", null);
        taskVo.setOffShiftExtWTCPluginProxy(offShiftExtInstance);
        WTCPluginProxy intersectionExtInstance = WTCPluginProxyFactory.create(null, CardMatchIntersectionExtPlugin.class, (String)"kd.sdk.wtc.wtpm.business.cardmatch.CardMatchIntersectionExtPlugin", null);
        taskVo.setIntersectionExtPluginProxy(intersectionExtInstance);
        for (long attPersonId : attPersonIds) {
            cardMatchService.singleAttMatch(attPersonId, taskVo);
        }
        if (taskVo.isManualPointTag() || taskVo.isFromAdTrigger()) {
            SupQuotaPoolTaskService.updateAdQuotaPool(startDate, endDate, taskVo.getAttPersonIds(), false);
        }
        return taskVo;
    }

    public void startMatch(Date date, long attPersonId, long attFileId) {
        ArrayList attPersonIds = Lists.newArrayList((Object[])new Long[]{attPersonId});
        ArrayList attFileIds = Lists.newArrayList((Object[])new Long[]{attFileId});
        this.startMatch(date, date, attPersonIds, attFileIds, 1);
    }

    public void startMatchScheduledTask() {
        Map<String, Date> dateMap = this.getTaskDateRange();
        Date startDate = dateMap.get("start");
        Date endDate = dateMap.get("end");
        LOG.info("\u53d6\u5361\u5339\u914d\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\u6267\u884c,\u5f00\u59cb\u65e5\u671f[{}]\uff0c\u7ed3\u675f\u65e5\u671f[{}]", (Object)startDate, (Object)endDate);
        this.startMatch(startDate, endDate, Collections.EMPTY_SET, WTCSource.SCHEDULE.code, "");
    }

    @Deprecated
    public void startMatch(Date startDate, Date endDate, Set<Long> attFileIds, String source, String desc) {
        CardMatchTaskParam param = new CardMatchTaskParam();
        param.setStartDate(startDate);
        param.setEndDate(endDate);
        param.setAttFileBoIds(attFileIds);
        param.setTaskType(source);
        param.setTaskDesc(desc);
        this.startMatch(param);
    }

    public void startMatch(CardMatchTaskParam taskParam) {
        LOG.info("\u89e6\u53d1\u53d6\u5361\u5339\u914d\u5f00\u59cb,request[{}]", (Object)taskParam.toString());
        Date startDate = WTCDateUtils.getDayStart((Date)taskParam.getStartDate());
        Date endDate = WTCDateUtils.getDayStart((Date)taskParam.getEndDate());
        WTCTaskRequestStd request = new WTCTaskRequestStd();
        String version = CodeRuleServiceHelper.getNumber((String)"wtpm_matchresult", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"wtpm_matchresult"), null);
        long taskId = this.saveInitTask(startDate, endDate, version, taskParam.getTaskDesc(), taskParam);
        request.setTaskId(taskId);
        request.setVersion(version);
        request.setCategory("wtpm_match");
        request.setCreatorId(taskParam.getCreatorId() == 0L ? 1L : taskParam.getCreatorId());
        request.setSource(HRStringUtils.isEmpty((String)taskParam.getTaskType()) ? WTCSource.SCHEDULE.code : taskParam.getTaskType());
        request.setTrial(false);
        request.setStartDate(startDate);
        request.setEndDate(endDate);
        request.setAppId("wtpm");
        LOG.info("\u53d6\u5361\u5339\u914d,\u67e5\u8be2\u8003\u52e4\u6863\u6848\u5f00\u59cb");
        AttFileQueryParam param = new AttFileQueryParam();
        param.setqFilter(new QFilter("bsed", "<=", (Object)endDate).and("bsled", ">=", (Object)startDate));
        param.setAuthCheck(Boolean.FALSE);
        param.setProperties(HRAuthUtil.ATT_FILE_SHARD_TASK_PROPERTY);
        if (HRCollUtil.isNotEmpty((Collection)taskParam.getAttFileBoIds())) {
            param.setSetBoIds(taskParam.getAttFileBoIds());
        }
        if (!WTCSource.SCHEDULE.code.equals(taskParam.getTaskType()) && !CollectionUtils.isEmpty((Collection)taskParam.getAttFileBoIds())) {
            param.setSetBoIds(taskParam.getAttFileBoIds());
            param.setAttStatus(null);
            param.setAuthCheck(Boolean.FALSE);
        }
        List attFiles = AttFileQueryServiceImpl.getInstance().queryAttFiles(param);
        LOG.info("\u53d6\u5361\u5339\u914d,\u67e5\u8be2\u8003\u52e4\u6863\u6848\u8fd4\u56de,size={}", (Object)attFiles.size());
        List detail = HRAuthUtil.getAuthFieldByAttFileDynBatch((List)attFiles);
        request.setDetail(detail);
        LOG.info("\u53d6\u5361\u5339\u914d\u5b9a\u65f6\u4efb\u52a1,\u8003\u52e4\u6863\u6848\u5165\u53c2 size[{}]", (Object)detail.size());
        request.setDetail(detail);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
        paramMap.put("number", taskId);
        paramMap.put("name", ResManager.loadKDString((String)"\u53d6\u5361\u5339\u914d", (String)"SignCardService_0", (String)"wtc-wtpm-business", (Object[])new Object[0]));
        request.setParams(paramMap);
        List subTaskDispatchRequestList = WTCDistributeTaskHelper.shardingSaveAndSlimReqStd((WTCTaskRequestStd)request);
        JobInfo mainTaskExecutorJobInfo = WTCDistributeTaskHelper.getMainTaskExecutorJobInfo((WTCTaskRequest)request, (List)subTaskDispatchRequestList);
        ScheduleServiceHelper.dispatch((JobInfo)mainTaskExecutorJobInfo);
    }

    private Map<String, Date> getTaskDateRange() {
        Date startDate;
        LocalDate now = LocalDate.now();
        LocalDate yesterday = now.minusDays(1L);
        Date endDate = Date.from(yesterday.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        LocalDateTime yesterdayMin = LocalDateTime.of(yesterday.with(TemporalAdjusters.lastDayOfMonth()), LocalTime.MIN);
        LocalDateTime yesterdayMax = LocalDateTime.of(yesterday.with(TemporalAdjusters.lastDayOfMonth()), LocalTime.MAX);
        if (yesterday.atStartOfDay().compareTo(yesterdayMin) >= 0 && yesterday.atStartOfDay().compareTo(yesterdayMax) <= 0) {
            LocalDate start = yesterday.minusMonths(2L).plusDays(1L);
            startDate = Date.from(start.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        } else {
            startDate = endDate;
        }
        HashMap<String, Date> result = new HashMap<String, Date>(4);
        result.put("start", startDate);
        result.put("end", endDate);
        return result;
    }

    private long saveInitTask(Date startDate, Date endDate, String version, String desc, CardMatchTaskParam taskParam) {
        List orgList;
        HasPermOrgResult orgResult;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtpm_matchresult");
        Long id = DB.genGlobalLongId();
        DynamicObject result = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"wtpm_matchresult"));
        result.set("id", (Object)id);
        result.set("task", (Object)id);
        long orgId = WTCOrgUnitServiceHelper.getHRDefaultRootOrgId();
        List allOrgList = OrgUnitServiceHelper.getAllOrgByViewId((long)26L, (boolean)false);
        if (null != taskParam && taskParam.getAttOrgId() > 0L) {
            if (HRCollUtil.isNotEmpty((Collection)allOrgList) && allOrgList.contains(taskParam.getAttOrgId())) {
                orgId = taskParam.getAttOrgId();
            }
        } else if (null != taskParam && taskParam.getAttOrgId() == 0L && taskParam.getCreatorId() > 0L && null != (orgResult = PermissionServiceHelper.getUserHasPermOrgs((long)taskParam.getCreatorId())) && !orgResult.hasAllOrgPerm() && orgResult.getHasPermOrgs() != null && HRCollUtil.isNotEmpty((Collection)(orgList = orgResult.getHasPermOrgs()))) {
            orgList = orgList.stream().filter(allOrgList::contains).collect(Collectors.toList());
            Comparator<Long> comparator = Comparator.comparingLong(Long::longValue);
            orgList.sort(comparator);
            if (HRCollUtil.isNotEmpty(orgList)) {
                orgId = (Long)orgList.get(0);
            }
        }
        result.set("org", (Object)orgId);
        result.set("version", (Object)version);
        result.set("startdate", (Object)startDate);
        result.set("enddate", (Object)endDate);
        long createId = null != taskParam && taskParam.getCreatorId() > 0L ? taskParam.getCreatorId() : RequestContext.get().getCurrUserId();
        result.set("creator", (Object)createId);
        result.set("createtime", (Object)new Date());
        result.set("desc", (Object)desc);
        DynamicObject resultDy = (DynamicObject)serviceHelper.saveOne(result);
        return resultDy.getLong("id");
    }

    public SignCardDailyResp getSignCardDaily(Date date, Set<Long> attFileBoIds) {
        DynamicObject[] multiResult;
        SignCardDailyResp resp = new SignCardDailyResp();
        AttFileQueryParam param = new AttFileQueryParam(date);
        param.setProperties("attperson.id,id");
        param.setSetBoIds(attFileBoIds);
        param.setAttStatus(null);
        param.setAuthCheck(Boolean.FALSE);
        List attFileList = AttFileQueryServiceImpl.getInstance().queryAttFiles(param);
        if (CollectionUtils.isEmpty((Collection)attFileList)) {
            LOG.info("getSignCardDaily, attFile not found.");
            return resp;
        }
        Set attPersonIds = attFileList.stream().map(dy -> dy.getLong("attperson.id")).collect(Collectors.toSet());
        HashSet<Long> mustSign = new HashSet<Long>(attPersonIds.size());
        HashSet<Long> multiActual = new HashSet<Long>(attPersonIds.size());
        DutyShiftResponse dutyShifts = EvaluationServiceHelper.getDutyShiftsByAttFileBoId(new ArrayList<Long>(attFileBoIds), (Date)date, (Date)date);
        for (Long attFileBoId : attFileBoIds) {
            Optional shift = dutyShifts.getShiftByAttFileBoId(attFileBoId, date);
            if (!shift.isPresent() || ((Shift)shift.get()).isOff()) continue;
            mustSign.add(attFileBoId);
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("shiftdate", "=", (Object)date), new QFilter("attperson", "in", attPersonIds)};
        HRBaseServiceHelper multiHelper = new HRBaseServiceHelper("wtpm_multicard");
        block1: for (DynamicObject multi : multiResult = multiHelper.query("attperson.id,entryentity.mustpoint,entryentity.effectivepoint", qFilters)) {
            Long attPersonId = multi.getLong("attperson.id");
            DynamicObjectCollection entity = multi.getDynamicObjectCollection("entryentity");
            for (DynamicObject item : entity) {
                if (null == item.getDate("effectivepoint")) continue;
                multiActual.add(attPersonId);
                continue block1;
            }
        }
        HRBaseServiceHelper onceHelper = new HRBaseServiceHelper("wtpm_oncecard");
        DynamicObject[] onceResult = onceHelper.query("attperson.id,oncepoint,oncerange", qFilters);
        HashSet<Long> onceActual = new HashSet<Long>(onceResult.length);
        for (DynamicObject once : onceResult) {
            Long attPersonId = once.getLong("attperson.id");
            if (null == once.getDate("oncepoint")) continue;
            onceActual.add(attPersonId);
        }
        resp.setMustSignCount(mustSign.size());
        resp.setActualSignCount(multiActual.size() + onceActual.size());
        return resp;
    }

    public Map<Long, Boolean> getStopAttendanceEffectiveCards(Map<Long, Map<String, Date>> request) {
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>(request.size());
        ArrayList<Long> attFileBoIds = new ArrayList<Long>(request.size());
        ArrayList<Date> dateList = new ArrayList<Date>(request.size() * 2);
        for (Map.Entry<Long, Map<String, Date>> entry : request.entrySet()) {
            attFileBoIds.add(entry.getKey());
            Map<String, Date> value = entry.getValue();
            Date startDate = value.get("startdate");
            Date endDate = value.get("enddate");
            if (null != startDate) {
                dateList.add(startDate);
            }
            if (null == endDate) continue;
            dateList.add(endDate);
        }
        dateList.sort((o1, o2) -> {
            if (o1.before((Date)o2)) {
                return -1;
            }
            if (o1.after((Date)o2)) {
                return 1;
            }
            return 0;
        });
        QFilter[] qFilters = new QFilter[]{new QFilter("attfile.boid", "in", attFileBoIds), new QFilter("shiftdate", ">=", dateList.get(0)), new QFilter("shiftdate", "<=", dateList.get(dateList.size() - 1))};
        HRBaseServiceHelper multiHelper = new HRBaseServiceHelper("wtpm_multicard");
        DynamicObject[] multiResult = multiHelper.query("attfile.boid,shiftdate,entryentity.effectivepoint", qFilters);
        Map<Long, List<DynamicObject>> multiMap = Arrays.stream(multiResult).filter(element -> element.getLong("attfile.boid") > 1L).collect(Collectors.groupingBy(dy -> dy.getLong("attfile.boid")));
        HRBaseServiceHelper onceHelper = new HRBaseServiceHelper("wtpm_oncecard");
        DynamicObject[] onceResult = onceHelper.query("attfile.boid,shiftdate,oncepoint", qFilters);
        Map<Long, List<DynamicObject>> onceMap = Arrays.stream(onceResult).filter(element -> element.getLong("attfile.boid") > 1L).collect(Collectors.groupingBy(dy -> dy.getLong("attfile.boid")));
        for (Long attFileBoId : attFileBoIds) {
            Map<String, Date> dateMap = request.get(attFileBoId);
            this.setStopAttendanceEffectiveCard(dateMap, result, attFileBoId, multiMap, onceMap);
        }
        return result;
    }

    private void setStopAttendanceEffectiveCard(Map<String, Date> dateMap, Map<Long, Boolean> result, Long attFileBoId, Map<Long, List<DynamicObject>> multiMap, Map<Long, List<DynamicObject>> onceMap) {
        Date startDate = dateMap.get("startdate");
        Date endDate = dateMap.get("enddate");
        result.put(attFileBoId, Boolean.FALSE);
        boolean flag = false;
        List<DynamicObject> multiList = multiMap.get(attFileBoId);
        if (!CollectionUtils.isEmpty(multiList)) {
            block0: for (DynamicObject multiCard : multiList) {
                if (flag) break;
                Date shiftDate = multiCard.getDate("shiftdate");
                DynamicObjectCollection collection = multiCard.getDynamicObjectCollection("entryentity");
                for (DynamicObject dy : collection) {
                    Date multiPoint = dy.getDate("effectivepoint");
                    if (null == startDate || null == endDate || shiftDate.getTime() < startDate.getTime() || shiftDate.getTime() > endDate.getTime() || null == multiPoint) continue;
                    result.put(attFileBoId, Boolean.TRUE);
                    flag = true;
                    continue block0;
                }
            }
        }
        this.setStopAttendanceOnceCard(onceMap, attFileBoId, flag, result, startDate, endDate);
    }

    private void setStopAttendanceOnceCard(Map<Long, List<DynamicObject>> onceMap, Long attFileBoId, boolean flag, Map<Long, Boolean> result, Date startDate, Date endDate) {
        List<DynamicObject> onceList = onceMap.get(attFileBoId);
        if (!flag && !CollectionUtils.isEmpty(onceList)) {
            for (DynamicObject onceCard : onceList) {
                Date shiftDate = onceCard.getDate("shiftdate");
                Date oncePoint = onceCard.getDate("oncepoint");
                if (null == startDate || null == endDate || shiftDate.getTime() < startDate.getTime() || shiftDate.getTime() > endDate.getTime() || null == oncePoint) continue;
                result.put(attFileBoId, Boolean.TRUE);
                break;
            }
        }
    }

    public void startAutoSignApplyScheduledTask(Date startDate, Date endDate) {
        AttFileQueryParam param = new AttFileQueryParam(startDate, endDate);
        param.setAuthCheck(Boolean.FALSE);
        List attFiles = AttFileQueryServiceImpl.getInstance().queryAttFiles(param);
        Map<Long, List<DynamicObject>> attFileMap = attFiles.stream().collect(Collectors.groupingBy(dy -> dy.getLong("attperson.id")));
        Map<String, Object> personInfoMap = this.getFinalPersonInfos(attFiles, startDate, endDate, attFileMap);
        Set finalPersonIds = (Set)personInfoMap.get("finalPersonIds");
        if (finalPersonIds.size() == 0) {
            LOG.info("AutoSignApplyTask,not found match personId");
            return;
        }
        Map entryMap = (Map)personInfoMap.get("entryMap");
        Map quitMap = (Map)personInfoMap.get("quitMap");
        Set attFileBoIds = (Set)personInfoMap.get("attFileBoIds");
        Map filePersonMap = (Map)personInfoMap.get("filePersonMap");
        AttFileScheduleQueryParam modeParam = new AttFileScheduleQueryParam();
        modeParam.setFileBoIdSet(attFileBoIds);
        Map attModeMap = AttFileScheduleServiceImpl.getInstance().queryAttFileSchedule(AttFileScheduleEnum.MODE, modeParam);
        Map attCardMap = AttFileScheduleServiceImpl.getInstance().queryAttFileSchedule(AttFileScheduleEnum.CARD, modeParam);
        AttFileScheduleQueryParam timeZoneParam = new AttFileScheduleQueryParam();
        timeZoneParam.setFileBoIdSet(attFileBoIds);
        timeZoneParam.setLoad(Boolean.TRUE);
        Map timeZoneMap = AttFileScheduleServiceImpl.getInstance().queryAttFileSchedule(AttFileScheduleEnum.TZ, timeZoneParam);
        Map<Long, List<DynamicObject>> planSimpleMap = SupSignHisHelper.getAttFilePlanHis(attFileBoIds, startDate, endDate);
        if (CollectionUtils.isEmpty(planSimpleMap)) {
            LOG.info("AutoSignApplyTask,not found match sign apply plans");
            return;
        }
        HashSet<Long> planBoIds = new HashSet<Long>(planSimpleMap.size());
        HashMap<Long, Long> planFileMap = new HashMap<Long, Long>(planSimpleMap.size());
        HashMap<Long, Long> filePlanMap = new HashMap<Long, Long>(planSimpleMap.size());
        for (Map.Entry<Long, List<DynamicObject>> entry : planSimpleMap.entrySet()) {
            List<DynamicObject> list = entry.getValue();
            this.setPlanInfo(list, planBoIds, planFileMap, entry, filePlanMap);
        }
        Map<Long, List<DynamicObject>> planMap = SupSignHisHelper.getPlanHis(planBoIds, startDate, endDate);
        HashSet<Long> ruleBoIds = new HashSet<Long>(planMap.size());
        HashMap<Long, Long> planRuleMap = new HashMap<Long, Long>(planMap.size());
        this.setRuleInfo(ruleBoIds, planRuleMap, planMap, startDate, planFileMap, filePersonMap, attFileMap);
        Map<Long, List<DynamicObject>> ruleMap = SupSignHisHelper.querySuppleRuleHis(ruleBoIds, startDate, endDate);
        if (CollectionUtils.isEmpty(ruleMap)) {
            LOG.info("AutoSignApplyTask,not found match sign apply rules");
            return;
        }
        DutyShiftResponse dutyShifts = EvaluationServiceHelper.getDutyShiftsByAttFileBoId(new ArrayList(attFileBoIds), (Date)startDate, (Date)endDate);
        Map<Long, List<DynamicObject>> takeCardRuleMap = CardMatchHelper.getAllTakeRules(startDate, endDate);
        ArrayList<SignCard> finalList = new ArrayList<SignCard>(attFileBoIds.size());
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("planRuleMap", planRuleMap);
        map.put("planFileMap", planFileMap);
        map.put("filePlanMap", filePlanMap);
        map.put("filePersonMap", filePersonMap);
        map.put("attModeMap", attModeMap);
        map.put("timeZoneMap", timeZoneMap);
        map.put("takeCardRuleMap", takeCardRuleMap);
        map.put("entryMap", entryMap);
        map.put("quitMap", quitMap);
        map.put("attFileMap", attFileMap);
        map.put("attCardMap", attCardMap);
        for (Long attFileBoId : attFileBoIds) {
            this.getFinalSignCards(ruleMap, startDate, map, finalList, dutyShifts, attFileBoId);
        }
        CardMatchHelper.batchSaveSignCards(finalList);
    }

    private void getFinalSignCards(Map<Long, List<DynamicObject>> ruleMap, Date startDate, Map<String, Object> map, List<SignCard> finalList, DutyShiftResponse dutyShifts, Long attFileBoId) {
        List list;
        List list2;
        Map filePlanMap = (Map)map.get("filePlanMap");
        Long planBoId = (Long)filePlanMap.get(attFileBoId);
        Map planRuleMap = (Map)map.get("planRuleMap");
        Long ruleBoId = (Long)planRuleMap.get(planBoId);
        List<DynamicObject> ruleList = ruleMap.get(ruleBoId);
        DynamicObject rule = SignCardCommonService.getDyDate(ruleList, startDate, true);
        if (null == rule) {
            LOG.info("AutoSignApplyTask,not found match rule info,attFileBoId={}", (Object)attFileBoId);
            return;
        }
        Map filePersonMap = (Map)map.get("filePersonMap");
        Long attPersonId = (Long)filePersonMap.get(attFileBoId);
        Map attModeMap = (Map)map.get("attModeMap");
        List attModeDys = (List)attModeMap.get(attFileBoId);
        DynamicObject attModeDy = SignCardCommonService.getDyDate(attModeDys, startDate, true);
        if (null == attModeDy) {
            LOG.info("AutoSignApplyTask,not found match attMode info,attFileBoId={}", (Object)attFileBoId);
            return;
        }
        Map timeZoneMap = (Map)map.get("timeZoneMap");
        List timeZoneDys = (List)timeZoneMap.get(attFileBoId);
        if (CollectionUtils.isEmpty((Collection)timeZoneDys)) {
            LOG.info("AutoSignApplyTask,not found match timeZone info,attfileboid={}", (Object)attFileBoId);
            return;
        }
        Map takeCardRuleMap = (Map)map.get("takeCardRuleMap");
        List<MustSignInfoVo> shiftMustSignList = this.generateShiftMustSignList(dutyShifts, attFileBoId, startDate, attPersonId, takeCardRuleMap);
        String entryType = rule.getString("entextsuppleset.entrydateset");
        Map entryMap = (Map)map.get("entryMap");
        Map attFileMap = (Map)map.get("attFileMap");
        Map attCardMap = (Map)map.get("attCardMap");
        if (HRStringUtils.isNotEmpty((String)entryType) && !CollectionUtils.isEmpty((Collection)(list2 = (List)entryMap.get(attPersonId)))) {
            String attMode = attModeDy.getString(AttFileScheduleEnum.MODE.getKey());
            List<SignCard> signCards = this.processSignCard(attMode, entryType, shiftMustSignList, attPersonId, startDate, timeZoneDys);
            this.fillSignCards(signCards, attPersonId, attFileBoId, attFileMap, attCardMap, startDate);
            finalList.addAll(signCards);
        }
        String quitType = rule.getString("entextsuppleset.exitdateset");
        Map quitMap = (Map)map.get("quitMap");
        if (HRStringUtils.isNotEmpty((String)quitType) && !CollectionUtils.isEmpty((Collection)(list = (List)quitMap.get(attPersonId)))) {
            String attMode = attModeDy.getString(AttFileScheduleEnum.MODE.getKey());
            List<SignCard> signCards = this.processSignCard(attMode, quitType, shiftMustSignList, attPersonId, startDate, timeZoneDys);
            this.fillSignCards(signCards, attPersonId, attFileBoId, attFileMap, attCardMap, startDate);
            finalList.addAll(signCards);
        }
    }

    private Map<String, Object> getFinalPersonInfos(List<DynamicObject> attFiles, Date startDate, Date endDate, Map<Long, List<DynamicObject>> attFileMap) {
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        Set attPersonIds = attFiles.stream().map(dy -> dy.getLong("attperson.id")).collect(Collectors.toSet());
        QFilter qFilterEntry = new QFilter("hirestartdate", ">=", (Object)startDate).and("hirestartdate", "<=", (Object)endDate);
        DynamicObject[] entryAttPersonDys = AttendPersonServiceImpl.getInstance().batchQueryAttendPersonByPersonIds(attPersonIds, qFilterEntry);
        Set entryPersonIds = Arrays.stream(entryAttPersonDys).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        Map<Long, List<DynamicObject>> entryMap = Arrays.stream(entryAttPersonDys).collect(Collectors.groupingBy(dy -> dy.getLong("id")));
        QFilter qFilterQuit = new QFilter("lastworkdate", ">=", (Object)startDate).and("lastworkdate", "<=", (Object)endDate);
        DynamicObject[] quitAttPersonDys = AttendPersonServiceImpl.getInstance().batchQueryAttendPersonByPersonIds(attPersonIds, qFilterQuit);
        Map<Long, List<DynamicObject>> quitMap = Arrays.stream(quitAttPersonDys).collect(Collectors.groupingBy(dy -> dy.getLong("id")));
        Set quitPersonIds = Arrays.stream(quitAttPersonDys).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        HashSet finalPersonIds = new HashSet(attPersonIds.size());
        finalPersonIds.addAll(entryPersonIds);
        finalPersonIds.addAll(quitPersonIds);
        HashSet<Long> attFileBoIds = new HashSet<Long>(finalPersonIds.size());
        HashMap<Long, Long> filePersonMap = new HashMap<Long, Long>(finalPersonIds.size());
        for (Long personId : finalPersonIds) {
            List<DynamicObject> list = attFileMap.get(personId);
            attFileBoIds.add(list.get(0).getLong("boid"));
            filePersonMap.put(list.get(0).getLong("boid"), personId);
        }
        result.put("finalPersonIds", finalPersonIds);
        result.put("entryMap", entryMap);
        result.put("quitMap", quitMap);
        result.put("attFileBoIds", attFileBoIds);
        result.put("filePersonMap", filePersonMap);
        return result;
    }

    private void setPlanInfo(List<DynamicObject> list, Set<Long> planBoIds, Map<Long, Long> planFileMap, Map.Entry<Long, List<DynamicObject>> entry, Map<Long, Long> filePlanMap) {
        for (DynamicObject dy : list) {
            planBoIds.add(dy.getLong("ad.id"));
            planFileMap.put(dy.getLong("ad.id"), entry.getKey());
            filePlanMap.put(entry.getKey(), dy.getLong("ad.id"));
        }
    }

    private void setRuleInfo(Set<Long> ruleBoIds, Map<Long, Long> planRuleMap, Map<Long, List<DynamicObject>> planMap, Date startDate, Map<Long, Long> planFileMap, Map<Long, Long> filePersonMap, Map<Long, List<DynamicObject>> attFileMap) {
        for (Map.Entry<Long, List<DynamicObject>> entry : planMap.entrySet()) {
            DynamicObject plan = SignCardCommonService.getDyDate(entry.getValue(), startDate, true);
            if (null == plan) continue;
            if (HRStringUtils.equalsIgnoreCase((String)plan.getString("ruletype"), (String)"1")) {
                ruleBoIds.add(plan.getLong("rule.id"));
                planRuleMap.put(entry.getKey(), plan.getLong("rule.id"));
                continue;
            }
            PlanRuleEngineInParam inParam = new PlanRuleEngineInParam();
            inParam.setDate(startDate);
            inParam.setPlan(plan);
            Long attFileBoId = planFileMap.get(plan.getLong("boid"));
            Long attPersonId = filePersonMap.get(attFileBoId);
            List<DynamicObject> list = attFileMap.get(attPersonId);
            DynamicObject attFileDy = SignCardCommonService.getDyDate(list, startDate, true);
            inParam.setAttFile(attFileDy);
            List outParamList = PlanRuleEngineService.getInstance().batchCallRuleEngine(PlanSceneEnum.AD, (List)Lists.newArrayList((Object[])new PlanRuleEngineInParam[]{inParam}));
            PlanRuleEngineOutParam outParam = (PlanRuleEngineOutParam)outParamList.get(0);
            DynamicObject rule = outParam.getRule();
            if (null == rule) continue;
            ruleBoIds.add(rule.getLong("boid"));
            planRuleMap.put(entry.getKey(), rule.getLong("boid"));
        }
    }

    private void fillSignCards(List<SignCard> signCards, Long attPersonId, Long attFileBoId, Map<Long, List<DynamicObject>> attFileMap, Map<Long, List<DynamicObject>> attCardMap, Date startDate) {
        for (SignCard signCard : signCards) {
            List<DynamicObject> cards;
            DynamicObject cardDy;
            signCard.setAttPersonId(attPersonId);
            signCard.setAttFileBoId(attFileBoId);
            List<DynamicObject> list = attFileMap.get(attPersonId);
            DynamicObject attFileDy = SignCardCommonService.getDyDate(list, startDate, true);
            if (null != attFileDy) {
                signCard.setAttFileId(Long.valueOf(attFileDy.getLong("id")));
                signCard.setOrgId(Long.valueOf(attFileDy.getLong("org.id")));
            }
            if (null == (cardDy = SignCardCommonService.getDyDate(cards = attCardMap.get(attFileBoId), startDate, true))) continue;
            signCard.setAttCard(cardDy.getString(AttFileScheduleEnum.CARD.getKey()));
        }
    }

    private List<SignCard> processSignCard(String attMode, String type, List<MustSignInfoVo> shiftMustSignList, Long attPersonId, Date startDate, List<DynamicObject> timeZoneDys) {
        if (CollectionUtils.isEmpty(shiftMustSignList)) {
            LOG.info("AutoSignApplyTask,not found shiftMustSignList,attPersonId={},date={}", (Object)attPersonId, (Object)startDate.toString());
            return Collections.emptyList();
        }
        Long timeZoneId = null;
        int timeDif = 0;
        for (DynamicObject timeZone : timeZoneDys) {
            Date start = timeZone.getDate("bsed");
            Date end = timeZone.getDate("bsled");
            int timeDiff = timeZone.getInt("tz.timedif");
            if (start == null || start.compareTo(startDate) > 0 || end == null || end.compareTo(startDate) < 0) continue;
            timeZoneId = timeZone.getLong("tz.id");
            timeDif = timeDiff;
            break;
        }
        for (MustSignInfoVo info : shiftMustSignList) {
            info.setAbsoluteSignUtc(info.getAbsoluteSign().minusHours(timeDif));
            info.setTimeDiff(timeDif);
            info.setTimeZoneId(timeZoneId);
        }
        return this.createSignCards(attMode, type, shiftMustSignList, startDate, attPersonId);
    }

    private List<SignCard> createSignCards(String attMode, String type, List<MustSignInfoVo> shiftMustSignList, Date startDate, Long attPersonId) {
        if (HRStringUtils.equalsIgnoreCase((String)attMode, (String)AttModeEnum.ONES_CARD.getCode()) && HRStringUtils.equalsIgnoreCase((String)type, (String)SupplementModeEnum.NONE.getCode())) {
            return this.generateSignCards(shiftMustSignList, true, true);
        }
        if (HRStringUtils.equalsIgnoreCase((String)attMode, (String)AttModeEnum.MANY_CARD.getCode())) {
            if (HRStringUtils.equals((String)type, (String)SupplementModeEnum.NONE.getCode())) {
                return this.generateSignCards(shiftMustSignList, true, true);
            }
            if (HRStringUtils.equals((String)type, (String)SupplementModeEnum.START.getCode())) {
                return this.generateSignCards(shiftMustSignList, false, true);
            }
            if (HRStringUtils.equals((String)type, (String)SupplementModeEnum.END.getCode())) {
                return this.generateSignCards(shiftMustSignList, true, false);
            }
            return this.createSignCardsFromMultiCard(startDate, attPersonId, shiftMustSignList, type);
        }
        return Collections.emptyList();
    }

    private List<SignCard> createSignCardsFromMultiCard(Date startDate, Long attPersonId, List<MustSignInfoVo> shiftMustSignList, String type) {
        HRBaseServiceHelper multiCardHelper = new HRBaseServiceHelper("wtpm_multicard");
        QFilter[] qFilters = new QFilter[]{new QFilter("shiftdate", "=", (Object)startDate), new QFilter("attperson", "=", (Object)attPersonId)};
        DynamicObject multiCard = multiCardHelper.loadDynamicObject(qFilters);
        if (!HRObjectUtils.isEmpty((Object)multiCard)) {
            DynamicObjectCollection multiEntry = multiCard.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)multiEntry)) {
                return Collections.emptyList();
            }
            for (DynamicObject dy : multiEntry) {
                if (null == dy.get("effectivepoint") || !HRStringUtils.equalsIgnoreCase((String)type, (String)SupplementModeEnum.ONCE.getCode())) continue;
                return this.generateSignCards(shiftMustSignList, true, true);
            }
        }
        return Collections.emptyList();
    }

    private List<SignCard> generateSignCards(List<MustSignInfoVo> shiftMustSignList, boolean needStart, boolean needEnd) {
        ArrayList<SignCard> signCards = new ArrayList<SignCard>(shiftMustSignList.size());
        for (MustSignInfoVo vo : shiftMustSignList) {
            int index = shiftMustSignList.indexOf(vo);
            if (!needStart && index == 0 || !needEnd && index == shiftMustSignList.size() - 1) continue;
            SignCard signCard = new SignCard();
            signCard.setTimeZoneId(vo.getTimeZoneId());
            signCard.setTimeDiff(vo.getTimeDiff());
            signCard.setSignPoint(vo.getAbsoluteSign());
            signCard.setSignPointUtc(vo.getAbsoluteSignUtc());
            signCard.setSource(Long.valueOf(SOURCE_AUTO_ID));
            signCard.setAccessTag(vo.getSignOn() != false ? "on" : "off");
            signCards.add(signCard);
        }
        return signCards;
    }

    private List<MustSignInfoVo> generateShiftMustSignList(DutyShiftResponse dutyShifts, Long attFileBoId, Date startDate, Long attPersonId, Map<Long, List<DynamicObject>> takeCardRuleMap) {
        boolean illegal;
        Optional shiftOptional = dutyShifts.getShiftByAttFileBoId(attFileBoId, startDate);
        boolean bl = illegal = !shiftOptional.isPresent() || ((Shift)shiftOptional.get()).isOff() && ((Shift)shiftOptional.get()).getOffNonPlan();
        if (illegal) {
            LOG.info("AutoSignApplyTask,not found shift,attPersonId={},date={}", (Object)attPersonId, (Object)startDate.toString());
            return Collections.emptyList();
        }
        Long takeCardRuleBoId = ((Shift)shiftOptional.get()).getTakeCardRule().getId();
        List<DynamicObject> takeCardRules = takeCardRuleMap.get(takeCardRuleBoId);
        DynamicObject takeCardRule = SignCardCommonService.getDyDate(takeCardRules, startDate, true);
        if (null == takeCardRule) {
            LOG.info("AutoSignApplyTask,not found takeCardRule,attPersonId={},date={}", (Object)attPersonId, (Object)startDate.toString());
            return Collections.emptyList();
        }
        DynamicObjectCollection ruleEntry = takeCardRule.getDynamicObjectCollection("wtbd_tcardruleentry");
        ArrayList<TimeSeq> timeSeqList = new ArrayList<TimeSeq>(ruleEntry.size());
        for (DynamicObject entry : ruleEntry) {
            TimeSeq timeSeq = new TimeSeq();
            timeSeq.setTimeSeq(Integer.valueOf(entry.getInt("timeseq")));
            timeSeq.setStartBeforeScope(Integer.valueOf(entry.getInt("sbeforescope")));
            timeSeq.setStartAfterScope(Integer.valueOf(entry.getInt("safterscope")));
            timeSeq.setStartTakeCardRule(entry.getString("stakecardrule"));
            timeSeq.setStartTakeCardSameLen((String)entry.get("stakecardsamelen"));
            timeSeq.setEndBeforeScope(Integer.valueOf(entry.getInt("ebeforescope")));
            timeSeq.setEndAfterScope(Integer.valueOf(entry.getInt("eafterscope")));
            timeSeq.setEndTakeCardRule(entry.getString("etakecardrule"));
            timeSeq.setEndTakeCardSameLen((String)entry.get("etakecardsamelen"));
            timeSeqList.add(timeSeq);
        }
        LocalDate localDate = startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        return CardMatchHelper.getShiftMustSignList(((Shift)shiftOptional.get()).getShiftDetailList(), timeSeqList, localDate);
    }

    public void invalidEffectiveCards(Set<Long> attFileBoIds) {
        HRBaseServiceHelper multiCardHelper = new HRBaseServiceHelper("wtpm_multicard");
        QFilter filter = new QFilter("attfile.boid", "in", attFileBoIds);
        multiCardHelper.deleteByFilter(new QFilter[]{filter});
        HRBaseServiceHelper checkCardHelper = new HRBaseServiceHelper("wtpm_checkcard");
        checkCardHelper.deleteByFilter(new QFilter[]{filter});
        HRBaseServiceHelper onceCardHelper = new HRBaseServiceHelper("wtpm_oncecard");
        onceCardHelper.deleteByFilter(new QFilter[]{filter});
    }

    public void invalidLackCards(Set<Long> attFileBoIds) {
        HRBaseServiceHelper lackCardHelper = new HRBaseServiceHelper("wtpm_lackcard");
        QFilter filter = new QFilter("attfile.boid", "in", attFileBoIds);
        lackCardHelper.deleteByFilter(new QFilter[]{filter});
    }
}

