/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.mobile.suppleapply;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.wtc.wtbs.common.bill.SupplePolicy;
import kd.wtc.wtbs.common.model.bill.BillSystemParam;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtpm.business.mobile.suppleapply.IMobileSupSignService;
import kd.wtc.wtpm.business.signcard.supplyapply.service.SupSignService;
import kd.wtc.wtpm.vo.mobile.suppleapply.MultipleCountLimitVo;
import kd.wtc.wtpm.vo.suppleapply.AdCheckVo;

public class MobileSupSignServiceImpl
implements IMobileSupSignService {
    private static final Log LOG = LogFactory.getLog(MobileSupSignServiceImpl.class);

    @Override
    public Optional<DynamicObject> getPlan(long attFileBoId, Date signDate) {
        LOG.info("MobileSupSignServiceImpl.getPlan.attFileBoId={},signDate={}", (Object)attFileBoId, (Object)signDate);
        return SupSignService.getPlan(attFileBoId, signDate);
    }

    @Override
    public Optional<List<DynamicObject>> getReasonByFile(long attFileBoId, Date signDate) {
        LOG.info("MobileSupSignServiceImpl.getReasonByFile.attFileBoId={},signDate={}", (Object)attFileBoId, (Object)signDate);
        return SupSignService.getSupSignReason(attFileBoId, signDate);
    }

    @Override
    public Optional<String> getPolicyByReason(long attFileBoId, long reasonId, Date signDate) {
        Optional<Long> policyOptional = SupSignService.getPolicyByReason(attFileBoId, reasonId, signDate);
        return policyOptional.flatMap(policyId -> SupSignService.getPolicyContent(Collections.singletonList(policyId)));
    }

    @Override
    public Optional<SupplePolicy> getSupplePolicyByReason(long attFileBoId, long reasonId, Date signDate) {
        Optional<Long> policyOptional = SupSignService.getPolicyByReason(attFileBoId, reasonId, signDate);
        if (policyOptional.isPresent()) {
            Optional<String> policyContent = SupSignService.getPolicyContent(Collections.singletonList(policyOptional.get()));
            SupplePolicy supplePolicy = new SupplePolicy();
            supplePolicy.setPolicyId(policyOptional.get());
            supplePolicy.setPolicyContent(policyContent.isPresent() ? policyContent.get() : "");
            return Optional.of(supplePolicy);
        }
        return Optional.empty();
    }

    @Override
    public Optional<MultipleCountLimitVo> getCountLimit(long personId, long attFileBoId, DynamicObject reasonDy, Date signDate) {
        LOG.info("MobileSupSignServiceImpl.getCountLimit.personId={},attFileBoId={},signDate={}", new Object[]{personId, attFileBoId, signDate});
        AdCheckVo adCheckVo = new AdCheckVo();
        adCheckVo.setId(Long.valueOf(0L));
        adCheckVo.setPersonId(Long.valueOf(personId));
        adCheckVo.setAttFileId(Long.valueOf(attFileBoId));
        adCheckVo.setSignDate(signDate);
        adCheckVo.setShiftBelongDate(signDate);
        adCheckVo.setReason(reasonDy);
        List<String> multipleCountLimitList = SupSignService.getMultipleCountLimitList(Lists.newArrayList((Object[])new AdCheckVo[]{adCheckVo}));
        if (!CollectionUtils.isEmpty(multipleCountLimitList)) {
            MultipleCountLimitVo multipleCountLimitVo = new MultipleCountLimitVo();
            multipleCountLimitVo.setCountLimitDesc(multipleCountLimitList.get(0));
            DynamicObject supQuotaPool = adCheckVo.getSupQuotaPool();
            int normalUsable = supQuotaPool.getInt("normalusable");
            int normalRemain = supQuotaPool.getInt("normalremain");
            int aboveUsable = supQuotaPool.getInt("aboveusable");
            int aboveRemain = supQuotaPool.getInt("aboveremain");
            boolean isAllowAbove = "1".equals(supQuotaPool.getString("allowabove"));
            if (isAllowAbove && aboveUsable <= 0) {
                multipleCountLimitVo.setLimitCount(Integer.MAX_VALUE);
                multipleCountLimitVo.setRemainCount(Integer.MAX_VALUE);
            } else {
                multipleCountLimitVo.setLimitCount(normalUsable + aboveUsable);
                multipleCountLimitVo.setRemainCount(normalRemain + aboveRemain);
            }
            return Optional.of(multipleCountLimitVo);
        }
        return Optional.empty();
    }

    @Override
    public boolean hasGenerationApply() {
        SystemParamQueryUtil.getBillSystemParam();
        return true;
    }

    @Override
    public boolean accessTagIsMustInput() {
        BillSystemParam billSystemParam = SystemParamQueryUtil.getBillSystemParam();
        return billSystemParam.isAccessTag();
    }
}

