/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.sign.mobile;

import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TimeEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.mobile.MobileCommonServiceHelper;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.file.schedule.AttFileScheduleServiceImpl;
import kd.wtc.wtbs.common.concurrent.WTCMutexHelper;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.enums.signcard.PointTagEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileScheduleQueryParam;
import kd.wtc.wtbs.common.model.mobile.AbnormalDealModel;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.ArrayUtils;
import kd.wtc.wtbs.common.util.third.util.MapUtils;
import kd.wtc.wtpm.business.mobile.suppleapply.MobileSupSignServiceImpl;
import kd.wtc.wtpm.constants.sign.mobile.SupSignConstants;
import kd.wtc.wtpm.vo.mobile.suppleapply.MultipleCountLimitVo;

public class MobSupSignBusiness {
    private static final String OPERATE_KEY = "modify";
    private static final String MUTEX_OPERATE_KEY = "operationkey";
    private static final String MUTEX_ENTITY_ID = "entitykey";
    private static final String MUTEX_PK_ID = "objectid";
    private static final String MUTEX_DATA_LOCK_USER = "user";
    private static final Log logger = LogFactory.getLog(MobSupSignBusiness.class);
    private MobileSupSignServiceImpl mobileSupSignService = new MobileSupSignServiceImpl();

    private MobSupSignBusiness() {
    }

    public static MobSupSignBusiness getInstance() {
        return Instance.INSTANCE;
    }

    public void initOverworkPerson(IFormView iFormView, boolean isInit) {
        String entityId = iFormView.getEntityId();
        if ("wtpm_supsignself_m".equals(entityId) || "wtpm_supsignself".equals(entityId)) {
            logger.info("mobsupsign initOverworkPerson self begin...");
            this.setApplyName(iFormView);
            DateTimeEdit dateEdit = (DateTimeEdit)iFormView.getControl("signpoint");
            dateEdit.setMaxDate(this.getMaxDate());
        } else if ("wtpm_supsignpc_addm".equals(entityId) || "wtpm_supsignpc".equals(entityId)) {
            logger.info("mobsupsign initOverworkPerson other begin...");
            iFormView.setEnable(Boolean.TRUE, new String[]{"flexsignmantext"});
            DynamicObject person = iFormView.getModel().getDataEntity().getDynamicObject("personid");
            Label signMan = (Label)iFormView.getControl("labelsignman");
            if (person != null && isInit) {
                signMan.setText(person.getString("name"));
                iFormView.setVisible(Boolean.FALSE, new String[]{"labelchoose"});
            } else {
                signMan.setText("");
                iFormView.getModel().setValue("personid", null);
                iFormView.getModel().setValue("attfile", null);
                iFormView.setVisible(Boolean.TRUE, new String[]{"labelchoose"});
                iFormView.setVisible(Boolean.TRUE, new String[]{"vectorchoose"});
                iFormView.getPageCache().put("canChoosePerson", Boolean.TRUE.toString());
            }
            DateTimeEdit dateEdit = (DateTimeEdit)iFormView.getControl("suppletime");
            dateEdit.setMaxDate(this.getMaxDate());
        }
    }

    private void setApplyName(IFormView iFormView) {
        String entityTypeId;
        IPageCache pageCache = iFormView.getPageCache();
        Long userId = MobileCommonServiceHelper.getInstance().getUserId();
        FormShowParameter formShowParameter = iFormView.getFormShowParameter();
        String appId = BillCommonService.getInstance().getAuthAppIdForFormPlugin(iFormView);
        int boCount = this.getCurrUserAttFileTop1Ver(iFormView, userId, appId, entityTypeId = formShowParameter.getFormConfig().getEntityTypeId(), null);
        if (boCount > 0) {
            IDataModel model = iFormView.getModel();
            DynamicObject dataEntity = model.getDataEntity();
            DynamicObject person = dataEntity.getDynamicObject("personid");
            String personName = person.getString("name");
            logger.info("mobsupsign setApplyName person:{}", (Object)personName);
            Label signMan = (Label)iFormView.getControl("labelsignman");
            signMan.setText(personName);
            boolean canChoosePerson = boCount > 1;
            iFormView.setVisible(Boolean.valueOf(canChoosePerson), new String[]{"vectorchoose"});
            pageCache.put("canChoosePerson", Boolean.TRUE.toString());
            if (!canChoosePerson) {
                iFormView.setEnable(Boolean.FALSE, new String[]{"flexsignmantext"});
            }
            logger.info("mobsupsign setApplyName setFlexEnable...");
            long boAttFileId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dataEntity, (String)"attfile");
            long tzid = this.getAttfileTimeZone(boAttFileId, WTCDateUtils.toDate((LocalDate)LocalDate.now()));
            pageCache.put("cacheTimeZone", String.valueOf(tzid));
            iFormView.setVisible(Boolean.FALSE, new String[]{"labelchoose"});
        }
    }

    public void setPersonName(IFormView iFormView, Map<String, String> returnData) {
        String personId = returnData.get("personid");
        String attFile = returnData.get("attfile");
        String id = returnData.get("id");
        logger.info("mobsupsign MobSupSignBusiness.setPersonName.personId:{}", (Object)personId);
        logger.info("mobsupsign MobSupSignBusiness.setPersonName.attFile:{}", (Object)attFile);
        if (personId != null && attFile != null) {
            iFormView.getModel().setValue("attfile", (Object)Long.parseLong(attFile));
            iFormView.getModel().setValue("personid", (Object)Long.parseLong(personId));
            iFormView.getModel().setValue("attfilebasef7", (Object)Long.parseLong(id));
            Label signMan = (Label)iFormView.getControl("labelsignman");
            DynamicObject person = iFormView.getModel().getDataEntity().getDynamicObject("personid");
            signMan.setText(person.getString("name"));
            iFormView.setVisible(Boolean.FALSE, new String[]{"labelchoose"});
            long tzid = this.getAttfileTimeZone(Long.parseLong(attFile), WTCDateUtils.toDate((LocalDate)LocalDate.now()));
            iFormView.getPageCache().put("cacheTimeZone", String.valueOf(tzid));
        }
    }

    public void initAbnormal(IFormView iFormView, AbnormalDealModel abnormalDealModel) {
        Date chooseDate;
        String entityTypeId;
        Long userId = MobileCommonServiceHelper.getInstance().getUserId();
        FormShowParameter formShowParameter = iFormView.getFormShowParameter();
        String appId = BillCommonService.getInstance().getAuthAppIdForFormPlugin(iFormView);
        int boCount = this.getCurrUserAttFileTop1Ver(iFormView, userId, appId, entityTypeId = formShowParameter.getFormConfig().getEntityTypeId(), chooseDate = WTCDateUtils.str2Date((String)abnormalDealModel.getAbnormalDate(), (String)"yyyy-MM-dd"));
        if (boCount <= 0) {
            return;
        }
        IDataModel model = iFormView.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        long boAttFileId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dataEntity, (String)"attfile");
        this.initAbnormalDealList(iFormView, abnormalDealModel);
        boolean isHavePlan = this.isHavePlan(boAttFileId, chooseDate);
        if (!isHavePlan) {
            iFormView.showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u65e5\u671f\u4e0d\u5b58\u5728\u8865\u7b7e\u65b9\u6848\u3002", (String)"MobSupSignBusiness_0", (String)"wtc-wtpm-business", (Object[])new Object[0]));
            return;
        }
        DynamicObject person = dataEntity.getDynamicObject("personid");
        String personName = person.getString("name");
        logger.info("mobsupsign setApplyName person:{}", (Object)personName);
        Label signMan = (Label)iFormView.getControl("labelsignman");
        signMan.setText(personName);
        iFormView.setVisible(Boolean.FALSE, new String[]{"labelchoose"});
        boolean canChoosePerson = false;
        iFormView.setVisible(Boolean.valueOf(canChoosePerson), new String[]{"vectorchoose"});
        iFormView.getPageCache().put("canChoosePerson", Boolean.TRUE.toString());
        if (!canChoosePerson) {
            iFormView.setEnable(Boolean.FALSE, new String[]{"flexsignmantext"});
        }
        int focusRow = 0;
        AbnormalDealModel.AbnormalDetail selectedAbnormal = abnormalDealModel.getSelectedAbnormal();
        if (selectedAbnormal != null) {
            Date shouldCardTime = this.getShouldCardTime(selectedAbnormal);
            if (shouldCardTime != null) {
                iFormView.getModel().setValue("signpoint", (Object)shouldCardTime, focusRow);
                Date signDate = WTCDateUtils.date2date((Date)shouldCardTime, (String)"yyyy-MM-dd");
                model.setValue("signdate", (Object)signDate, focusRow);
            }
            model.setValue("onoffwork", (Object)selectedAbnormal.getCardTypePointName(), focusRow);
            String pointTag = this.getPointTag(abnormalDealModel.getAbnormalDate(), selectedAbnormal.getShouldCardTime());
            model.setValue("pointtag", (Object)pointTag, focusRow);
            model.setValue("accesstag", (Object)selectedAbnormal.getCardType(), focusRow);
        }
        long tzid = this.getAttfileTimeZone(boAttFileId, chooseDate);
        iFormView.getPageCache().put("cacheTimeZone", String.valueOf(tzid));
        model.setValue("timezone", (Object)tzid, focusRow);
    }

    private Date getShouldCardTime(AbnormalDealModel.AbnormalDetail selectedAbnormal) {
        String shouldCardTimeStr;
        Date shouldCardTime = null;
        if (selectedAbnormal != null && HRStringUtils.isNotEmpty((String)(shouldCardTimeStr = selectedAbnormal.getShouldCardTime()))) {
            try {
                shouldCardTime = WTCDateUtils.parseDate((String)shouldCardTimeStr, (String)"yyyy-MM-dd HH:mm:ss");
            }
            catch (ParseException e) {
                logger.warn("MobSupSignBusiness.initAbnormal.parseDate error,shouldCardTime:{}", (Object)shouldCardTimeStr);
            }
        }
        return shouldCardTime;
    }

    private int getCurrUserAttFileTop1Ver(IFormView view, Long userId, String appId, String entityTypeId, Date date) {
        if (date == null) {
            return BillUnifyService.initAttFileTopVersion((IFormView)view, (Long)userId, (String)appId, (String)entityTypeId, (String)"attfilebasef7");
        }
        return BillUnifyService.initAttFileByDate((IFormView)view, (Long)userId, (String)appId, (String)entityTypeId, (String)"attfilebasef7", (Date)date);
    }

    public void showInitEntryCard(IFormView iFormView, boolean isAbnormal) {
        TimeEdit edit;
        CardEntry entryGrid = (CardEntry)iFormView.getControl("entryentity");
        Object[] items = entryGrid.getEntryData().getDataEntitys();
        IPageCache pageCache = iFormView.getPageCache();
        String mustInput = pageCache.get("cacheMustInput");
        String timezone = pageCache.get("cacheTimeZone");
        Boolean moreThanOne = Boolean.TRUE;
        if (ArrayUtils.isNotEmpty((Object[])items) && items.length == 1) {
            moreThanOne = Boolean.FALSE;
        }
        entryGrid.setChildVisible(moreThanOne.booleanValue(), 0, new String[]{"cardentryheadflex"});
        if (!StringUtils.isEmpty((CharSequence)timezone) && iFormView.getModel().getValue("timezone", 0) == null) {
            iFormView.getModel().setValue("timezone", (Object)Long.parseLong(timezone), 0);
        }
        this.cardEntryInitWithAbnormal(iFormView, entryGrid, 0, isAbnormal, Boolean.parseBoolean(mustInput));
        if (moreThanOne.booleanValue()) {
            int index;
            IDataModel model = iFormView.getModel();
            for (index = 0; index < items.length; ++index) {
                String billEntryName = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8865\u7b7e\u660e\u7ec6%d", (String)"MobSupSignBusiness_2", (String)"wtc-wtpm-business", (Object[])new Object[0]), index + 1);
                model.setValue("billentryname", (Object)billEntryName, index);
                Object value = model.getValue("timezone", index);
                if (StringUtils.isEmpty((CharSequence)timezone) || value != null) continue;
                model.setValue("timezone", (Object)Long.parseLong(timezone), index);
            }
            for (index = 0; index < items.length; ++index) {
                this.cardEntryInitWithAbnormal(iFormView, entryGrid, index, isAbnormal, Boolean.parseBoolean(mustInput));
            }
        }
        if ((edit = (TimeEdit)iFormView.getControl("suppleworktime")) != null) {
            LocalTime localTime = LocalTime.now();
            localTime = localTime.withSecond(0);
            localTime = localTime.withNano(0);
            int secondOfDay = localTime.toSecondOfDay();
            for (int index = 0; index < items.length; ++index) {
                edit.setEntryTimeFocusValue((long)secondOfDay, index);
            }
        }
    }

    public void deleteEntry(IFormView iFormView) {
        CardEntry entryGrid = (CardEntry)iFormView.getControl("entryentity");
        IPageCache pageCache = iFormView.getPageCache();
        int focusRow = entryGrid.getEntryState().getFocusRow();
        entryGrid.getEntryState().selectRow(focusRow);
        iFormView.invokeOperation("deleteentry");
    }

    public void cardEntryInitWithAbnormal(IFormView iFormView, CardEntry entryGrid, int rowindex, boolean isAbnormal, boolean isMustInput) {
        entryGrid.setChildVisible(isAbnormal, rowindex, new String[]{"cardentrypointflex"});
        entryGrid.setChildVisible(!isAbnormal, rowindex, new String[]{"supsigndatetimeflex"});
        entryGrid.setChildVisible(isAbnormal, rowindex, new String[]{"suppleworktime"});
        entryGrid.setChildVisible(!isAbnormal, rowindex, new String[]{"flexaccessflag"});
        entryGrid.setChildVisible(!isAbnormal, rowindex, new String[]{"pointtag"});
        Object timesValue = iFormView.getModel().getValue("signtimestip", rowindex);
        boolean isShowSupTimes = timesValue != null && !StringUtils.isEmpty((CharSequence)timesValue.toString());
        entryGrid.setChildVisible(isShowSupTimes, rowindex, new String[]{"suptimestipflex"});
        entryGrid.setChildVisible(isMustInput, rowindex, new String[]{"labelmustinput"});
        entryGrid.setChildVisible(isAbnormal, rowindex, new String[]{"signdate"});
        entryGrid.setChildEnable(Boolean.FALSE.booleanValue(), rowindex, new String[]{"signdate"});
    }

    public void pageInitWithAbnormal(IFormView view, boolean isAbnormal) {
    }

    public void initViewWithStatus(IFormView view) {
        if (view.getFormShowParameter() instanceof MobileBillShowParameter && BillOperationStatus.EDIT.equals((Object)((MobileBillShowParameter)view.getFormShowParameter()).getBillStatus())) {
            view.setEnable(Boolean.FALSE, new String[]{"applytyperadio"});
            view.setEnable(Boolean.FALSE, new String[]{"applytyperadio"});
            boolean sourceWF = BillCommonService.getInstance().sourceWF(view);
            if (sourceWF) {
                view.setEnable(Boolean.FALSE, new String[]{"flexsignmantext"});
                view.setVisible(Boolean.FALSE, new String[]{"vectorchoose"});
            }
        }
    }

    public boolean isHavePlan(long attFileBoId, Date signDate) {
        logger.info("mobsupsign isHavePlan attFileBoId:{} signDate:{}", (Object)attFileBoId, (Object)signDate.toString());
        Optional<DynamicObject> plan = this.mobileSupSignService.getPlan(attFileBoId, signDate);
        return plan.isPresent();
    }

    public Optional<String> getSupTimes(IFormView iFormView, long personId, long attFileBoId, DynamicObject reasonDy, Date signDate) {
        logger.info("mobsupsign getSupTimes personId:{} attFileBoId:{} signDate:{}", new Object[]{personId, attFileBoId, signDate.toString()});
        Optional<MultipleCountLimitVo> countLimit = this.mobileSupSignService.getCountLimit(personId, attFileBoId, reasonDy, signDate);
        Optional<String> limitDescOptional = Optional.empty();
        if (countLimit.isPresent()) {
            MultipleCountLimitVo countLimitVo = countLimit.get();
            int leftTimes = countLimitVo.getRemainCount();
            leftTimes = Math.max(leftTimes, 0);
            iFormView.getPageCache().put("supTimes", String.valueOf(leftTimes));
            limitDescOptional = Optional.of(countLimitVo.getCountLimitDesc());
            logger.info("mobsupsign getSupTimes countLimit tip:{}", (Object)SerializationUtils.toJsonString((Object)countLimitVo));
        }
        return limitDescOptional;
    }

    private void initAbnormalDealList(IFormView iFormView, AbnormalDealModel abnormalDealModel) {
        ArrayList<AbnormalDealModel.AbnormalDetail> abnormalDeal = new ArrayList<AbnormalDealModel.AbnormalDetail>(1);
        List abnormalAdd = abnormalDealModel.getOtherAbnormal();
        abnormalDeal.add(abnormalDealModel.getSelectedAbnormal());
        IPageCache pageCache = iFormView.getPageCache();
        pageCache.put("abnormalDeal", SerializationUtils.serializeToBase64(abnormalDeal));
        pageCache.put("abnormalAdd", SerializationUtils.serializeToBase64((Object)abnormalAdd));
        pageCache.put("abnormalDate", abnormalDealModel.getAbnormalDate());
        pageCache.put("abnormalAllTimeRange", SerializationUtils.serializeToBase64((Object)abnormalDealModel.getAllTimeRange()));
    }

    public List<Map<String, String>> getReasonByFile(IFormView iFormView, int rowId, long attFileBoId, Date signDate) {
        Optional<List<DynamicObject>> reasonByFileFromUnify = this.mobileSupSignService.getReasonByFile(attFileBoId, signDate);
        if (reasonByFileFromUnify.isPresent() && reasonByFileFromUnify.get().size() > 0) {
            logger.info("mobsupsign getReasonByFile reasonByFile:{}", (Object)SerializationUtils.toJsonString(reasonByFileFromUnify.get()));
            Set ids = reasonByFileFromUnify.get().stream().map(re -> re.getLong("id")).collect(Collectors.toSet());
            QFilter qFilter = new QFilter("id", "in", ids);
            qFilter.and(WTCHisServiceHelper.statusValidQFilter());
            DynamicObject orgDy = (DynamicObject)iFormView.getModel().getValue("org");
            if (orgDy != null) {
                QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"wtbd_reason", (Long)orgDy.getLong("id"));
                if (baseDataFilter != null) {
                    qFilter.and(baseDataFilter);
                }
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8003\u52e4\u7ba1\u7406\u7ec4\u7ec7\u3002", (String)"MobSupSignBusiness_6", (String)"wtc-wtpm-business", (Object[])new Object[0]));
            }
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbd_reason");
            DynamicObject[] reasonDyArr = serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
            ArrayList result = Lists.newArrayListWithExpectedSize((int)reasonDyArr.length);
            DynamicObject dynamicObject = (DynamicObject)iFormView.getModel().getValue("applyreason", rowId);
            for (DynamicObject reasonType : reasonDyArr) {
                HashMap param = Maps.newHashMapWithExpectedSize((int)5);
                long id = reasonType.getLong("id");
                if (dynamicObject != null && id == dynamicObject.getLong("id")) {
                    param.put("select", "1");
                }
                param.put("id", String.valueOf(id));
                param.put("text", reasonType.getString("name"));
                param.put("attFileBoId", String.valueOf(attFileBoId));
                param.put("chooseDate", WTCDateUtils.date2Str((Date)signDate, (String)"yyyy-MM-dd"));
                result.add(param);
            }
            logger.info("mobsupsign getReasonByFile rowId:{} attFileBoId:{} result:{}", new Object[]{rowId, attFileBoId, SerializationUtils.toJsonString((Object)result)});
            return result;
        }
        return null;
    }

    public int getSeconds(Date chooseDate) {
        LocalDateTime localDateTime = WTCDateUtils.toLocalDateTime((Date)chooseDate);
        LocalTime localTime = localDateTime.toLocalTime();
        int secondOfDay = localTime.toSecondOfDay();
        return secondOfDay;
    }

    public void setReason(IFormView iFormView, Map<String, String> returnData) {
        if (MapUtils.isEmpty(returnData)) {
            return;
        }
        CardEntry entryGrid = (CardEntry)iFormView.getControl("entryentity");
        int focusRow = entryGrid.getEntryState().getFocusRow();
        logger.info("mobsupsign setReason focusRow:{} returnData:{}", (Object)focusRow, (Object)SerializationUtils.toJsonString(returnData));
        long id = Long.parseLong(returnData.get("id"));
        long policyId = Long.parseLong(returnData.get("supsignexpid"));
        iFormView.getModel().setValue("applyreason", (Object)id, focusRow);
        iFormView.getModel().setValue("attpolicy", (Object)policyId, focusRow);
    }

    public int getShiftIndex(IFormView iFormView, String timeRange) {
        String allStr = iFormView.getPageCache().get("abnormalAllTimeRange");
        if (!StringUtils.isEmpty((CharSequence)allStr)) {
            List allTimeRanges = (List)SerializationUtils.deSerializeFromBase64((String)allStr);
            for (int index = 0; index < allTimeRanges.size(); ++index) {
                if (!StringUtils.equals((CharSequence)((CharSequence)allTimeRanges.get(index)), (CharSequence)timeRange)) continue;
                return index + 1;
            }
        }
        return 0;
    }

    public void accessTagIsMustInput(IFormView iFormView) {
        boolean isMustInput = this.mobileSupSignService.accessTagIsMustInput();
        Control control = iFormView.getControl("accesstag");
        FieldEdit fieldEdit = (FieldEdit)control;
        fieldEdit.setMustInput(isMustInput);
        iFormView.getPageCache().put("cacheMustInput", String.valueOf(isMustInput));
    }

    public void setDefaltTimeZone(IFormView iFormView, long attfileid, Date chooseDate, int index) {
        long tzid = this.getAttfileTimeZone(attfileid, chooseDate);
        Object tz = iFormView.getModel().getValue("timezone");
        if (tz == null) {
            iFormView.getModel().setValue("timezone", (Object)tzid, index);
        }
    }

    public long getAttfileTimeZone(long attfileid, Date chooseDate) {
        List timeZone;
        AttFileScheduleQueryParam attFileScheduleQueryParam = new AttFileScheduleQueryParam();
        attFileScheduleQueryParam.setBoId(attfileid);
        attFileScheduleQueryParam.setStartDate(chooseDate);
        attFileScheduleQueryParam.setEndDate(chooseDate);
        Map longListMap = AttFileScheduleServiceImpl.getInstance().queryAttFileSchedule(AttFileScheduleEnum.TZ, attFileScheduleQueryParam);
        long tzid = SupSignConstants.DEFAULT_TIME_ZONE;
        if (longListMap != null && longListMap.get(attfileid) != null && !CollectionUtils.isEmpty((Collection)(timeZone = (List)longListMap.get(attfileid)))) {
            tzid = ((DynamicObject)timeZone.get(0)).getLong("tz.id");
        }
        return tzid;
    }

    public boolean currentUserHasMutex(Long supsignId, String formId) {
        QFilter operateKeyFilter = new QFilter(MUTEX_OPERATE_KEY, "=", (Object)OPERATE_KEY);
        QFilter entityKeyFilter = new QFilter(MUTEX_ENTITY_ID, "=", (Object)formId);
        QFilter objectIdFilter = new QFilter(MUTEX_PK_ID, "=", (Object)String.valueOf(supsignId));
        QFilter userFilter = new QFilter(MUTEX_DATA_LOCK_USER, "=", (Object)RequestContext.get().getCurrUserId());
        HRBaseServiceHelper dataLockHelper = new HRBaseServiceHelper("bos_datalock");
        DynamicObject[] dynamicObjects = dataLockHelper.query("id", new QFilter[]{objectIdFilter, operateKeyFilter, entityKeyFilter, userFilter});
        return dynamicObjects != null && dynamicObjects.length > 0;
    }

    public void releaseMutex(Long supsignId, String formId) {
        boolean release = WTCMutexHelper.release((String)formId, (String)OPERATE_KEY, (String)String.valueOf(supsignId));
        logger.info("mobsupsign releaseMutex entityId:{},pkId:{},operateKey:{},result:{}", new Object[]{formId, supsignId, OPERATE_KEY, release});
    }

    public void releaseMutexIfIsCurrentUser(Long supsignId, String formId) {
        if (this.currentUserHasMutex(supsignId, formId)) {
            this.releaseMutex(supsignId, formId);
        }
    }

    public void initStringBuilder(StringBuilder stringBuilder, List<AbnormalDealModel.AbnormalDetail> abnormalDeal, int index) {
        stringBuilder.append(": ");
        stringBuilder.append(abnormalDeal.get(index).getCardTypeName());
        stringBuilder.append(' ');
        stringBuilder.append(abnormalDeal.get(index).getAbnormalTime() == null ? "" : abnormalDeal.get(index).getAbnormalTime());
        stringBuilder.append(' ');
        stringBuilder.append(abnormalDeal.get(index).getAbnormalStatusName());
    }

    private Date getMaxDate() {
        String todayStr = WTCDateUtils.date2Str((Date)new Date(), (String)"yyyy-MM-dd");
        todayStr = todayStr + " 23:59:59";
        return WTCDateUtils.str2Date((String)todayStr, (String)"yyyy-MM-dd HH:mm:ss");
    }

    public String getPointTag(String dateDeal, String datePoint) {
        Date pointDate;
        if (StringUtils.isEmpty((CharSequence)dateDeal) || StringUtils.isEmpty((CharSequence)datePoint) || StringUtils.equals((CharSequence)dateDeal, (CharSequence)datePoint)) {
            return PointTagEnum.MANUAL_CURRENT.getCode();
        }
        Date dealDate = WTCDateUtils.str2Date((String)dateDeal, (String)"yyyy-MM-dd");
        if (dealDate.after(pointDate = WTCDateUtils.str2Date((String)datePoint, (String)"yyyy-MM-dd"))) {
            return PointTagEnum.MANUAL_NEXT.getCode();
        }
        if (dealDate.before(pointDate)) {
            return PointTagEnum.MANUAL_PREVIOUS.getCode();
        }
        return PointTagEnum.MANUAL_CURRENT.getCode();
    }

    public void setMobileSignPoint(IDataModel model) {
        DynamicObject billDy = model.getDataEntity();
        DynamicObjectCollection dynamicObjectCollection = billDy.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryEntity : dynamicObjectCollection) {
            Date signDate;
            Date signPoint = entryEntity.getDate("signpoint");
            if (signPoint != null || (signDate = entryEntity.getDate("signdate")) == null) continue;
            int suppleTime = entryEntity.getInt("suppleworktime");
            if (suppleTime < 0) {
                entryEntity.set("signpoint", (Object)signDate);
                continue;
            }
            LocalTime localTime = LocalTime.ofSecondOfDay(suppleTime);
            LocalDate localDate = WTCDateUtils.toLocalDate((Date)signDate);
            LocalDateTime localDateTime = LocalDateTime.of(localDate, localTime);
            signPoint = WTCDateUtils.toDate((LocalDateTime)localDateTime);
            entryEntity.set("signpoint", (Object)signPoint);
        }
    }

    private static class Instance {
        private static final MobSupSignBusiness INSTANCE = new MobSupSignBusiness();

        private Instance() {
        }
    }
}

