/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.sign.mobile;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.mcontrol.mobtable.IMobTablePackageDataHandler;
import kd.bos.form.mcontrol.mobtable.MobTable;
import kd.bos.form.mcontrol.mobtable.MobTableRowBuilder;
import kd.bos.form.mcontrol.mobtable.MobTableRowData;
import kd.bos.form.mcontrol.mobtable.events.MobTableHandleResult;
import kd.bos.form.mcontrol.mobtable.events.MobTablePackageDataHandlerArgs;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.web.mservice.HAOSMServiceImpl;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.proxy.Joiner;
import kd.wtc.wtpm.business.signcard.supplyapply.helper.SupSignHelper;
import kd.wtc.wtpm.business.signcard.supplyapply.service.SupSignService;
import kd.wtc.wtpm.constants.suppleapply.SupSignKDString;
import kd.wtc.wtpm.vo.mobile.suppleapply.MobileAdBatchOrgPerson;
import kd.wtc.wtpm.vo.mobile.suppleapply.MobileAdBatchOrgPersonItem;

public class MobileAdBatchService {
    private MobileAdBatchService() {
    }

    public static String getAdBatchMobileListQueryProp() {
        ArrayList propList = Lists.newArrayList((Object[])new String[]{"id", "billno", "attfile.id", "attfile.name", "supsigninfo.signdate", "supsigninfo.suppleworktime", "supsigninfo.applyreason.name", "attfilev.affiliateadminorg.id"});
        return Joiner.on((char)',').join((Iterable)propList);
    }

    public static String getAdBatchMobilePersonQueryProp() {
        return Joiner.on((char)',').join((Object[])new String[]{"id", "billno", "attfile.id", "attfilev.affiliateadminorg.id"});
    }

    public static String getAdBatchPersonQueryProp() {
        ArrayList propList = Lists.newArrayList((Object[])new String[]{"id", "billno", "attfile.id", "attfile.name", "attfilev.adminorg.name", "attfilev.position.name", "attfilev.affiliateadminorg.id"});
        return Joiner.on((char)',').join((Iterable)propList);
    }

    public static void handleAdBatchPubDetailBindData(IFormView view, QFilter cusFilter) {
        List<DynamicObject> adBatchDataList;
        FormShowParameter formShowParameter = view.getFormShowParameter();
        String billIdStr = (String)formShowParameter.getCustomParam("billid");
        long billId = Long.parseLong(billIdStr);
        DynamicObject adBatchDy = SupSignHelper.queryBatchBillById(billId);
        if (adBatchDy == null) {
            return;
        }
        String currOrgIdStr = (String)formShowParameter.getCustomParam("currentOrgId");
        long currOrgId = Long.parseLong(currOrgIdStr);
        String queryProp = MobileAdBatchService.getAdBatchPersonQueryProp();
        String listOrderBy = SupSignService.getAdBatchListOrderBy();
        if (0L == currOrgId) {
            DynamicObjectCollection personColl = adBatchDy.getDynamicObjectCollection("entryentityperson");
            Set attFileIdSet = personColl.stream().map(item -> item.getLong("exteaattfile.boid")).collect(Collectors.toSet());
            QFilter qFilter = new QFilter("attfile", "in", attFileIdSet);
            if (cusFilter != null) {
                qFilter.and(cusFilter);
            }
            adBatchDataList = SupSignHelper.queryBatchBillDetailByBillId(Lists.newArrayList((Object[])new Long[]{billId}), Boolean.TRUE, queryProp, listOrderBy, qFilter);
            view.setVisible(Boolean.FALSE, new String[]{"exppersonflex"});
        } else {
            DynamicObject orgDy;
            Set<Long> excludeAttFileBoIds;
            DynamicObjectCollection orgColl;
            Optional<DynamicObject> any;
            List adminOrgAllSubList = HAOSMServiceImpl.getInstance().batchGetAllSubOrg((List)Lists.newArrayList((Object[])new Long[]{currOrgId}), new Date());
            List subOrgIdList = adminOrgAllSubList.stream().map(item -> (Long)item.get("orgId")).collect(Collectors.toList());
            subOrgIdList.add(currOrgId);
            QFilter qFilter = new QFilter("attfilev.affiliateadminorg.id", "in", subOrgIdList);
            if (cusFilter != null) {
                qFilter.and(cusFilter);
            }
            if ((any = (orgColl = adBatchDy.getDynamicObjectCollection("entryentityorg")).stream().filter(item -> currOrgId == item.getLong("orgclass.id")).findAny()).isPresent() && WTCCollections.isNotEmpty(excludeAttFileBoIds = MobileAdBatchService.excludeAttFileBoIds(orgDy = any.get()))) {
                qFilter.and("attfile.id", "not in", excludeAttFileBoIds);
            }
            adBatchDataList = SupSignHelper.queryBatchBillDetailByBillId(Lists.newArrayList((Object[])new Long[]{billId}), Boolean.TRUE, queryProp, listOrderBy, qFilter);
            MobileAdBatchService.handleExcludePersonDesc(any, view);
        }
        HashSet attFileIdSet = Sets.newHashSetWithExpectedSize((int)adBatchDataList.size());
        List<DynamicObject> distinctDataList = adBatchDataList.stream().filter(item -> attFileIdSet.add(item.getLong("attfile.id"))).collect(Collectors.toList());
        MobileAdBatchService.handleMobTablePubDetail(distinctDataList, view);
        MobileAdBatchService.showLimitDesc(distinctDataList.size(), 200, SupSignKDString::detailLimitDesc, view, "");
    }

    private static void handleExcludePersonDesc(Optional<DynamicObject> orgDyOp, IFormView view) {
        if (orgDyOp.isPresent()) {
            ArrayList excludeFileName = new ArrayList(16);
            DynamicObjectCollection excludePersonColl = orgDyOp.get().getDynamicObjectCollection("excperson");
            excludePersonColl.forEach(excludePersonDy -> {
                DynamicObject dynamicObject = excludePersonDy.getDynamicObject("fbasedataid");
                if (dynamicObject != null) {
                    excludeFileName.add(dynamicObject.getString("name"));
                }
            });
            if (WTCCollections.isNotEmpty(excludeFileName)) {
                view.setVisible(Boolean.TRUE, new String[]{"exppersonflex"});
                Label excludeDescLabel = (Label)view.getControl("exppersondesclbl");
                if (excludeDescLabel != null) {
                    String join = Joiner.on((char)',').join(excludeFileName);
                    String desc = SupSignKDString.expCountDetailDesc((Object)excludeFileName.size(), (Object)join);
                    excludeDescLabel.setText(desc);
                }
            } else {
                view.setVisible(Boolean.FALSE, new String[]{"exppersonflex"});
            }
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"exppersonflex"});
        }
    }

    private static void handleMobTablePubDetail(final List<DynamicObject> adBatchDataList, IFormView view) {
        MobTable mobTablePubDetail = (MobTable)view.getControl("adpubdetail");
        mobTablePubDetail.addMobTablePackageDataHandlerListener(mobTablePackageDataHandlerEvent -> {
            final int showSize = Math.min(adBatchDataList.size(), 200);
            mobTablePackageDataHandlerEvent.setMobTablePackageDataHandler(new IMobTablePackageDataHandler(){

                public MobTableHandleResult handleData(MobTablePackageDataHandlerArgs mobTablePackageDataHandlerArgs) {
                    List mobTableColumns = mobTablePackageDataHandlerArgs.getMobTableColumns();
                    MobTableHandleResult result = new MobTableHandleResult();
                    ArrayList<MobTableRowData> mobTableRowDataList = new ArrayList<MobTableRowData>(16);
                    for (int index = 0; index < showSize; ++index) {
                        DynamicObject adBatchData = (DynamicObject)adBatchDataList.get(index);
                        MobTableRowData mobTableRowData = MobTableRowBuilder.buildTemplateRowData((int)index, (List)mobTableColumns);
                        mobTableRowData.setValue("attfile", (Object)adBatchData.getString("attfile.name"));
                        mobTableRowData.setValue("adminorg", (Object)adBatchData.getString("attfilev.adminorg.name"));
                        mobTableRowData.setValue("position", (Object)adBatchData.getString("attfilev.position.name"));
                        mobTableRowDataList.add(mobTableRowData);
                    }
                    result.setMobTableRowDataList(mobTableRowDataList);
                    return result;
                }

                public Map<String, Object> getFmtInfo(MobTablePackageDataHandlerArgs mobTablePackageDataHandlerArgs) {
                    return Collections.emptyMap();
                }
            });
        });
    }

    public static QFilter getSearchPersonDataFilter(String searchText) {
        QFilter qFilter = null;
        if (HRStringUtils.isNotEmpty((String)searchText)) {
            String likeText = "%" + searchText + "%";
            qFilter = new QFilter("attfile.name", "like", (Object)likeText);
            qFilter.or(new QFilter("attfilev.adminorg.name", "like", (Object)likeText));
            qFilter.or(new QFilter("attfilev.position.name", "like", (Object)likeText));
        }
        return qFilter;
    }

    public static MobileAdBatchOrgPerson getMobileAdBatchOrgPerson(DynamicObject dataEntity, List<DynamicObject> adBatchDataList) {
        DynamicObjectCollection extraPersonColl;
        Set successExtraPersons;
        MobileAdBatchOrgPersonItem orgPersonItem;
        HashSet attFileIdSet = Sets.newHashSetWithExpectedSize((int)adBatchDataList.size());
        ArrayList<DynamicObject> disDataList = new ArrayList<DynamicObject>(adBatchDataList.size());
        HashSet succOrgIdSet = Sets.newHashSetWithExpectedSize((int)adBatchDataList.size());
        for (DynamicObject adBatchData : adBatchDataList) {
            if (attFileIdSet.add(adBatchData.getLong("attfile.id"))) {
                disDataList.add(adBatchData);
            }
            succOrgIdSet.add(adBatchData.getLong("attfilev.affiliateadminorg.id"));
        }
        Map<Long, List<Long>> adminOrgAllSubMap = MobileAdBatchService.batchGetAllSubOrgMap(dataEntity, succOrgIdSet);
        int limit = 10;
        int size = 0;
        boolean moreLimit = false;
        DynamicObjectCollection orgColl = dataEntity.getDynamicObjectCollection("entryentityorg");
        ArrayList<MobileAdBatchOrgPersonItem> orgPersonItems = new ArrayList<MobileAdBatchOrgPersonItem>(orgColl.size());
        for (DynamicObject orgDy : orgColl) {
            long orgId = orgDy.getLong("orgclass.id");
            String name = orgDy.getString("orgclass.name");
            List<Long> subOrgIdList = adminOrgAllSubMap.get(orgId);
            Set<Long> excludeAttFileBoIds = MobileAdBatchService.excludeAttFileBoIds(orgDy);
            if (!WTCCollections.isNotEmpty(subOrgIdList)) continue;
            Stream<Long> distinct = disDataList.stream().filter(item -> subOrgIdList.contains(item.getLong("attfilev.affiliateadminorg.id"))).map(item -> item.getLong("attfile.id")).distinct();
            long totalPerson = WTCCollections.isNotEmpty(excludeAttFileBoIds) ? distinct.filter(item -> !excludeAttFileBoIds.contains(item)).count() : distinct.count();
            if (totalPerson <= 0L) continue;
            if (size < limit) {
                int expPerson = excludeAttFileBoIds.size();
                orgPersonItem = new MobileAdBatchOrgPersonItem();
                orgPersonItem.setOrgId(orgId);
                orgPersonItem.setOrgName(name);
                orgPersonItem.setAllOrgId(subOrgIdList);
                orgPersonItem.setTotalPerson(totalPerson);
                orgPersonItem.setExpPerson((long)expPerson);
                orgPersonItems.add(orgPersonItem);
                ++size;
                continue;
            }
            moreLimit = true;
            break;
        }
        if (WTCCollections.isNotEmpty(successExtraPersons = (extraPersonColl = dataEntity.getDynamicObjectCollection("entryentityperson")).stream().filter(item -> attFileIdSet.contains(item.getLong("exteaattfile.boid"))).collect(Collectors.toSet()))) {
            orgPersonItem = new MobileAdBatchOrgPersonItem();
            orgPersonItem.setOrgId(0L);
            orgPersonItem.setOrgName(SupSignKDString.attachPerson());
            orgPersonItem.setTotalPerson((long)successExtraPersons.size());
            orgPersonItems.add(orgPersonItem);
        }
        return new MobileAdBatchOrgPerson(attFileIdSet.size(), moreLimit, orgPersonItems);
    }

    private static Set<Long> excludeAttFileBoIds(DynamicObject orgDy) {
        DynamicObjectCollection excludePersonColl = orgDy.getDynamicObjectCollection("excperson");
        HashSet excludeAttFileBoIds = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject excludePersonDy : excludePersonColl) {
            DynamicObject dynamicObject = excludePersonDy.getDynamicObject("fbasedataid");
            if (dynamicObject == null) continue;
            long attFileBoId = dynamicObject.getLong("boid");
            excludeAttFileBoIds.add(attFileBoId);
        }
        return excludeAttFileBoIds;
    }

    public static Map<Long, List<Long>> batchGetAllSubOrgMap(DynamicObject dataEntity, Set<Long> succOrgIdSet) {
        DynamicObjectCollection orgColl = dataEntity.getDynamicObjectCollection("entryentityorg");
        if (WTCCollections.isEmpty((Collection)orgColl) || WTCCollections.isEmpty(succOrgIdSet)) {
            return Collections.emptyMap();
        }
        List orgIdList = orgColl.stream().map(item -> item.getLong("orgclass.id")).collect(Collectors.toList());
        succOrgIdSet.addAll(orgIdList);
        LocalDate now = LocalDate.now();
        Date beginDate = WTCDateUtils.toDate((LocalDate)now);
        List orgInfoList = HAOSMServiceImpl.getInstance().batchQuerySubOrgWithLevel((List)Lists.newArrayList(succOrgIdSet), beginDate, 0);
        HashMap adminOrgAllSubMap = Maps.newHashMapWithExpectedSize((int)orgIdList.size());
        HashMap adminOrgLongNumberMap = Maps.newHashMapWithExpectedSize((int)orgIdList.size());
        for (Map map : orgInfoList) {
            long orgId = (Long)map.get("orgId");
            if (!orgIdList.contains(orgId)) continue;
            String longNumber = (String)map.get("structLongNumber");
            adminOrgLongNumberMap.put(orgId, longNumber);
            adminOrgAllSubMap.put(orgId, Lists.newArrayList((Object[])new Long[]{orgId}));
        }
        for (Map.Entry entry : adminOrgLongNumberMap.entrySet()) {
            String structLongNumber = (String)entry.getValue();
            Long parentOrgId = (Long)entry.getKey();
            for (Map adminOrgMap : orgInfoList) {
                String longNumber = (String)adminOrgMap.get("structLongNumber");
                if (!longNumber.startsWith(structLongNumber)) continue;
                long orgId = (Long)adminOrgMap.get("orgId");
                List subOrgIds = adminOrgAllSubMap.computeIfAbsent(parentOrgId, key -> new ArrayList(16));
                subOrgIds.add(orgId);
            }
        }
        return adminOrgAllSubMap;
    }

    public static void showLimitDesc(int totalSize, int limitSize, Function<Object, String> function, IFormView view, String suffix) {
        if (totalSize > limitSize) {
            view.setVisible(Boolean.TRUE, new String[]{"maxlimitflex" + suffix});
            Label limitDescLabel = (Label)view.getControl("limitdesc" + suffix);
            if (limitDescLabel != null) {
                String limitDesc = function.apply(limitSize);
                limitDescLabel.setText(limitDesc);
            }
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"maxlimitflex" + suffix});
        }
    }
}

