/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.sign.mobile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.mcontrol.mobtable.IMobTablePackageDataHandler;
import kd.bos.form.mcontrol.mobtable.MobTableRowBuilder;
import kd.bos.form.mcontrol.mobtable.MobTableRowData;
import kd.bos.form.mcontrol.mobtable.events.MobTableHandleResult;
import kd.bos.form.mcontrol.mobtable.events.MobTablePackageDataHandlerArgs;
import kd.bos.form.mcontrol.mobtable.tablecolumn.DateMobTableColumn;
import kd.bos.form.mcontrol.mobtable.tablecolumn.MobTableColumn;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.util.WTCDateUtils;

public class MobileAdBatchTablePackageHandler
implements IMobTablePackageDataHandler {
    private List<DynamicObject> adBatchDataList;
    private DynamicObjectCollection adBatchInfoColl;
    private int maxShowLine;
    private String batchSupType;

    public MobileAdBatchTablePackageHandler(List<DynamicObject> adBatchDataList, int maxShowLine) {
        this.adBatchDataList = adBatchDataList;
        this.maxShowLine = maxShowLine;
        this.batchSupType = "1";
    }

    public MobileAdBatchTablePackageHandler(DynamicObjectCollection adBatchInfoColl, int maxShowLine) {
        this.adBatchInfoColl = adBatchInfoColl;
        this.maxShowLine = maxShowLine;
        this.batchSupType = "2";
    }

    public MobTableHandleResult handleData(MobTablePackageDataHandlerArgs mobTablePackageDataHandlerArgs) {
        List mobTableColumns = mobTablePackageDataHandlerArgs.getMobTableColumns();
        MobTableHandleResult result = new MobTableHandleResult();
        ArrayList<MobTableRowData> mobTableRowDataList = new ArrayList<MobTableRowData>(16);
        if ("1".equals(this.batchSupType)) {
            int length = Math.min(this.adBatchDataList.size(), this.maxShowLine);
            String dateFormat = this.getDateFormat(mobTableColumns, "supsigninfo.signdate");
            for (int index = 0; index < length; ++index) {
                DynamicObject adBatchData = this.adBatchDataList.get(index);
                MobTableRowData mobTableRowData = MobTableRowBuilder.buildTemplateRowData((int)index, (List)mobTableColumns);
                mobTableRowData.setValue("multipriattfile", (Object)adBatchData.getString("attfile.name"));
                Date date = adBatchData.getDate("supsigninfo.signdate");
                mobTableRowData.setValue("prisigndate", (Object)WTCDateUtils.date2Str((Date)date, (String)dateFormat));
                mobTableRowData.setValue("prisuppleworktime", adBatchData.get("supsigninfo.suppleworktime"));
                mobTableRowData.setValue("priapplyreason", (Object)adBatchData.getString("supsigninfo.applyreason.name"));
                mobTableRowDataList.add(mobTableRowData);
            }
        } else {
            int length = Math.min(this.adBatchInfoColl.size(), this.maxShowLine);
            String dateFormat = this.getDateFormat(mobTableColumns, "signdate");
            for (int index = 0; index < length; ++index) {
                DynamicObject adBatchInfo = (DynamicObject)this.adBatchInfoColl.get(index);
                MobTableRowData mobTableRowData = MobTableRowBuilder.buildTemplateRowData((int)index, (List)mobTableColumns);
                Date date = adBatchInfo.getDate("signdate");
                mobTableRowData.setValue("signdate", (Object)WTCDateUtils.date2Str((Date)date, (String)dateFormat));
                mobTableRowData.setValue("suppleworktime", adBatchInfo.get("suppleworktime"));
                mobTableRowData.setValue("applyreason", (Object)adBatchInfo.getString("applyreason.name"));
                mobTableRowDataList.add(mobTableRowData);
            }
        }
        result.setMobTableRowDataList(mobTableRowDataList);
        return result;
    }

    public Map<String, Object> getFmtInfo(MobTablePackageDataHandlerArgs mobTablePackageDataHandlerArgs) {
        return Collections.emptyMap();
    }

    private String getDateFormat(List<MobTableColumn> mobTableColumns, String fieldKey) {
        DateMobTableColumn dateMobTableColumn;
        String cusDateFormat;
        MobTableColumn mobTableColumn;
        String dateFormat = "yyyy-MM-dd";
        Optional<MobTableColumn> first = mobTableColumns.stream().filter(item -> item.getFieldKey().equals(fieldKey)).findFirst();
        if (first.isPresent() && (mobTableColumn = first.get()) instanceof DateMobTableColumn && HRStringUtils.isNotEmpty((String)(cusDateFormat = (dateMobTableColumn = (DateMobTableColumn)mobTableColumn).getDateFormat()))) {
            dateFormat = dateMobTableColumn.getDateFormat();
        }
        return dateFormat;
    }
}

