/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.signcard;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.time.StopWatch;
import kd.wtc.wtpm.business.signcard.SignCardCommonService;
import kd.wtc.wtpm.business.signcard.validator.AttFileCheckService;
import kd.wtc.wtpm.business.signcard.validator.AttFilePlanCheckService;
import kd.wtc.wtpm.business.signcard.validator.AttPeriodCheckService;
import kd.wtc.wtpm.business.signcard.validator.CountSetCheckService;
import kd.wtc.wtpm.business.signcard.validator.PlanCheckService;
import kd.wtc.wtpm.business.signcard.validator.RuleCheckService;
import kd.wtc.wtpm.enums.SignCardBillTypeEnum;
import kd.wtc.wtpm.vo.suppleapply.AdCheckContext;
import kd.wtc.wtpm.vo.suppleapply.AdCheckVo;

public class AdCheckService {
    private static final Log LOG = LogFactory.getLog(AdCheckService.class);

    private AdCheckService() {
    }

    public static List<AdCheckVo> genAdCheckVoList(List<DynamicObject> batchBillDetailList) {
        if (CollectionUtils.isEmpty(batchBillDetailList)) {
            return new ArrayList<AdCheckVo>(0);
        }
        ArrayList<AdCheckVo> adCheckVoList = new ArrayList<AdCheckVo>(batchBillDetailList.size());
        for (DynamicObject listData : batchBillDetailList) {
            AdCheckVo adCheckVo = AdCheckService.genAdCheckVo(listData, listData.getDynamicObject("supsigninfo"));
            adCheckVo.setId(Long.valueOf(listData.getLong("id")));
            adCheckVoList.add(adCheckVo);
        }
        return adCheckVoList;
    }

    private static AdCheckVo genAdCheckVo(DynamicObject listDataDy, DynamicObject signInfoDy) {
        DynamicObject attFileBo;
        AdCheckVo adCheckVo = new AdCheckVo();
        DynamicObject attPerson = listDataDy.getDynamicObject("attperson");
        if (attPerson != null) {
            adCheckVo.setPersonId(Long.valueOf(attPerson.getLong("id")));
            adCheckVo.setPersonName(attPerson.getString("name"));
        }
        if ((attFileBo = listDataDy.getDynamicObject("attfile")) != null) {
            adCheckVo.setAttFileId(Long.valueOf(attFileBo.getLong("id")));
            adCheckVo.setAttFile(attFileBo);
        }
        adCheckVo.setSignDate(signInfoDy.getDate("signdate"));
        adCheckVo.setShiftBelongDate(SignCardCommonService.getShiftBelongDate(signInfoDy));
        adCheckVo.setSuppleWorkTime(signInfoDy.getInt("suppleworktime"));
        adCheckVo.setReason(signInfoDy.getDynamicObject("applyreason"));
        adCheckVo.setSupSignInfoId(Long.valueOf(signInfoDy.getLong("id")));
        return adCheckVo;
    }

    public static List<AdCheckVo> genAdCheckVoList(long billId, List<DynamicObject> currAttFileList, List<DynamicObject> supSignInfoList) {
        int size = currAttFileList.size() * supSignInfoList.size();
        ArrayList<AdCheckVo> adCheckVoList = new ArrayList<AdCheckVo>(size);
        for (DynamicObject attFileDy : currAttFileList) {
            for (DynamicObject signInfoDy : supSignInfoList) {
                if (signInfoDy.getDate("signdate") == null) continue;
                AdCheckVo adCheckVo = new AdCheckVo();
                adCheckVo.setId(Long.valueOf(billId));
                adCheckVo.setPersonId(Long.valueOf(attFileDy.getLong("attperson.id")));
                adCheckVo.setPersonName(attFileDy.getString("attperson.name"));
                adCheckVo.setAttFileId(Long.valueOf(attFileDy.getLong("boid")));
                adCheckVo.setAttFile(attFileDy);
                adCheckVo.setSignDate(signInfoDy.getDate("signdate"));
                adCheckVo.setShiftBelongDate(SignCardCommonService.getShiftBelongDate(signInfoDy));
                adCheckVo.setSuppleWorkTime(signInfoDy.getInt("suppleworktime"));
                adCheckVo.setReason(signInfoDy.getDynamicObject("applyreason"));
                adCheckVo.setSupSignInfoId(Long.valueOf(signInfoDy.getLong("id")));
                adCheckVoList.add(adCheckVo);
            }
        }
        return adCheckVoList;
    }

    public static List<AdCheckVo> genAdCheckVoList(List<DynamicObject> currAttFileList, List<DynamicObject> supSignInfoList) {
        return AdCheckService.genAdCheckVoList(0L, currAttFileList, supSignInfoList);
    }

    public static List<AdCheckVo> genAdCheckVoListByMulPriSup(List<DynamicObject> currentAttFileList, List<DynamicObject> cardInfoList) {
        Map currentAttFileMap = currentAttFileList.stream().collect(Collectors.toMap(item -> item.getLong("boid"), Function.identity(), (k1, k2) -> k1));
        ArrayList<AdCheckVo> adCheckVoList = new ArrayList<AdCheckVo>(cardInfoList.size());
        for (DynamicObject cardInfo : cardInfoList) {
            long attFileBoId;
            DynamicObject currAttFile;
            AdCheckVo adCheckVo = new AdCheckVo();
            DynamicObject priAttFile = cardInfo.getDynamicObject("multipriattfile");
            if (priAttFile == null || (currAttFile = (DynamicObject)currentAttFileMap.get(attFileBoId = priAttFile.getLong("boid"))) == null) continue;
            adCheckVo.setPersonId(Long.valueOf(currAttFile.getLong("attperson.id")));
            adCheckVo.setPersonName(currAttFile.getString("attperson.name"));
            adCheckVo.setAttFileId(Long.valueOf(currAttFile.getLong("boid")));
            adCheckVo.setAttFile(currAttFile);
            adCheckVo.setSignDate(cardInfo.getDate("prisigndate"));
            adCheckVo.setShiftBelongDate(SignCardCommonService.getMulPriShiftBelongDate(cardInfo));
            adCheckVo.setSuppleWorkTime(cardInfo.getInt("prisuppleworktime"));
            adCheckVo.setReason(cardInfo.getDynamicObject("priapplyreason"));
            adCheckVo.setSupSignInfoId(Long.valueOf(cardInfo.getLong("id")));
            adCheckVoList.add(adCheckVo);
        }
        return adCheckVoList;
    }

    public static List<AdCheckVo> genAdCheckVoListForSingleBill(List<DynamicObject> billDataEntityList) {
        ArrayList<AdCheckVo> adCheckVoList = new ArrayList<AdCheckVo>(16);
        for (DynamicObject dataEntity : billDataEntityList) {
            long billId = dataEntity.getLong("id");
            DynamicObject attFileDy = dataEntity.getDynamicObject("attfile");
            DynamicObjectCollection supSignColl = dataEntity.getDynamicObjectCollection("entryentity");
            adCheckVoList.addAll(AdCheckService.genAdCheckVoList(billId, Lists.newArrayList((Object[])new DynamicObject[]{attFileDy}), (List<DynamicObject>)supSignColl));
        }
        return adCheckVoList;
    }

    public static void initCalcAdCheckVoQuotaPool(List<AdCheckVo> adCheckVoList, String opKey, SignCardBillTypeEnum signCardBillTypeEnum) {
        StopWatch stopWatch = StopWatch.createStarted();
        AdCheckService.initCalcAdCheckVoQuotaPool(adCheckVoList, opKey, signCardBillTypeEnum, false);
        stopWatch.stop();
        LOG.info("AdCheckService.initCalcAdCheckVoQuotaPool use time:{}", (Object)stopWatch.getTime());
    }

    public static void initCalcAdCheckVoQuotaPool(List<AdCheckVo> adCheckVoList, String opKey, SignCardBillTypeEnum signCardBillTypeEnum, boolean countSetCheck) {
        LOG.info("AdCheckService.initCalcAdCheckVoQuotaPool adCheckVoList.size :{}", (Object)adCheckVoList.size());
        if (CollectionUtils.isEmpty(adCheckVoList)) {
            return;
        }
        AdCheckContext ctx = new AdCheckContext();
        ctx.setAdCheckVoList(adCheckVoList);
        ctx.setOpKey(opKey);
        ctx.setBillType(signCardBillTypeEnum);
        ctx.setBillMaxDateRange(AdCheckService.getAdCheckMaxTimeRange(adCheckVoList));
        AttFileCheckService attFileCheckService = new AttFileCheckService(ctx, false);
        attFileCheckService.init();
        attFileCheckService.check();
        AttFilePlanCheckService attFilePlanCheckService = new AttFilePlanCheckService(ctx);
        attFilePlanCheckService.init();
        attFilePlanCheckService.check();
        PlanCheckService planCheckService = new PlanCheckService(ctx);
        planCheckService.init();
        planCheckService.check();
        RuleCheckService ruleCheckService = new RuleCheckService(ctx, false);
        ruleCheckService.init();
        ruleCheckService.check();
        AttPeriodCheckService attPeriodCheckService = new AttPeriodCheckService(ctx, false, true);
        attPeriodCheckService.init();
        attPeriodCheckService.check();
        CountSetCheckService countSetCheckService = new CountSetCheckService(ctx, countSetCheck);
        countSetCheckService.init();
        countSetCheckService.check();
    }

    public static Tuple<Date, Date> getAdCheckMaxTimeRange(List<AdCheckVo> adCheckVoList) {
        HashSet allDateSet = Sets.newHashSetWithExpectedSize((int)adCheckVoList.size());
        for (AdCheckVo adCheckVo : adCheckVoList) {
            allDateSet.add(adCheckVo.getShiftBelongDate());
        }
        List sortedAllDateList = allDateSet.stream().sorted().collect(Collectors.toList());
        return new Tuple(sortedAllDateList.get(0), sortedAllDateList.get(sortedAllDateList.size() - 1));
    }
}

