/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.signcard;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboEdit;
import kd.bos.id.ID;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.wtc.wtbs.business.web.WTCInvokeServiceHelper;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.model.bill.BillSystemParam;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtpm.vo.suppleapply.AdCheckVo;
import kd.wtc.wtpm.vo.suppleapply.AdDispatchTaskParam;

public class SignCardCommonService {
    private SignCardCommonService() {
    }

    public static long getObjectId(DynamicObject dy, String objKey) {
        if (dy == null) {
            return 0L;
        }
        Object targetObj = dy.get(objKey);
        if (targetObj == null) {
            return 0L;
        }
        if (targetObj instanceof DynamicObject) {
            return ((DynamicObject)targetObj).getLong("id");
        }
        return (Long)targetObj;
    }

    public static String getObjectName(DynamicObject dy, String objKey) {
        Object targetObj = dy.get(objKey);
        if (targetObj == null) {
            return "";
        }
        if (targetObj instanceof DynamicObject) {
            return ((DynamicObject)targetObj).getString("name");
        }
        return "";
    }

    public static void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("isexistsworkflow");
        fieldKeys.add("isinworkflow");
        fieldKeys.add("billstatus");
        fieldKeys.add("auditstatus");
        fieldKeys.add("modifytime");
        fieldKeys.add("modifier");
        fieldKeys.add("auditdate");
        fieldKeys.add("auditor");
        args.setFieldKeys(fieldKeys);
    }

    public static Tuple<Date, Date> getSignInfoDateRange(List<DynamicObject> signInfos) {
        List sortedSignInfoDates = signInfos.stream().filter(signInfo -> signInfo.getDate("signdate") != null).map(SignCardCommonService::getShiftBelongDate).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(sortedSignInfoDates)) {
            Date beginDate = (Date)sortedSignInfoDates.get(0);
            Date endDate = (Date)sortedSignInfoDates.get(sortedSignInfoDates.size() - 1);
            return new Tuple((Object)beginDate, (Object)endDate);
        }
        return null;
    }

    public static void setPkId(List<DynamicObject> dys) {
        if (CollectionUtils.isEmpty(dys)) {
            return;
        }
        long[] ids = ID.genLongIds((int)dys.size());
        int index = 0;
        for (DynamicObject dy : dys) {
            long pkId = dy.getLong("id");
            if (pkId != 0L) continue;
            dy.set("id", (Object)ids[index]);
            ++index;
        }
    }

    public static Date getShiftBelongDate(DynamicObject supSignInfoDy) {
        String pointTag = supSignInfoDy.getString("pointtag");
        Date signDate = supSignInfoDy.getDate("signdate");
        return SignCardCommonService.getShiftBelongDate(signDate, pointTag);
    }

    public static Date getMulPriShiftBelongDate(DynamicObject supSignInfoDy) {
        String pointTag = supSignInfoDy.getString("pripointtag");
        Date signDate = supSignInfoDy.getDate("prisigndate");
        return SignCardCommonService.getShiftBelongDate(signDate, pointTag);
    }

    public static Date getShiftBelongDate(Date signDate, String pointTag) {
        if (signDate == null) {
            return null;
        }
        if ("E".equals(pointTag)) {
            signDate = WTCDateUtils.getBeforeDate((Date)signDate);
        } else if ("F".equals(pointTag)) {
            signDate = WTCDateUtils.getNextDate((Date)signDate);
        }
        return signDate;
    }

    public static void setAccessTagMustInput(IFormView view) {
        ComboEdit priAccessTag;
        BillSystemParam billSystemParam = SystemParamQueryUtil.getBillSystemParam();
        ComboEdit comboEdit = (ComboEdit)view.getControl("accesstag");
        if (comboEdit != null) {
            comboEdit.setMustInput(billSystemParam.isAccessTag());
        }
        if ((priAccessTag = (ComboEdit)view.getControl("priaccesstag")) != null) {
            priAccessTag.setMustInput(billSystemParam.isAccessTag());
        }
    }

    public static DynamicObject getDyDate(List<DynamicObject> dys, Date date, boolean isTimeHis) {
        if (CollectionUtils.isEmpty(dys)) {
            return null;
        }
        String beginDate = isTimeHis ? "bsed" : "startdate";
        String endDate = isTimeHis ? "bsled" : "enddate";
        Optional<DynamicObject> any = dys.stream().filter(dy -> date.compareTo(dy.getDate(beginDate)) >= 0 && date.compareTo(dy.getDate(endDate)) <= 0).findAny();
        return any.isPresent() ? any.get() : null;
    }

    public static List<DynamicObject> filterAttFileByDateRange(List<DynamicObject> attFileList, Date startDate, Date endDate) {
        AttFileQueryServiceImpl queryService = AttFileQueryServiceImpl.getInstance();
        return queryService.filterAttFileByDateRange(attFileList, startDate, endDate);
    }

    public static void setDataChangedFalse(DynamicObject dataEntity, List<String> propList) {
        IDataEntityType dataEntityType = dataEntity.getDataEntityType();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        DataEntityState dataEntityState = dataEntity.getDataEntityState();
        String iD = "_id";
        for (String prop : propList) {
            IDataEntityProperty iDataEntityPropertyId;
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)prop);
            if (iDataEntityProperty == null) continue;
            if (iDataEntityProperty instanceof DynamicComplexProperty && (iDataEntityPropertyId = (IDataEntityProperty)properties.get((Object)(prop + iD))) != null) {
                dataEntityState.setBizChanged(iDataEntityPropertyId.getOrdinal(), false);
            }
            dataEntityState.setBizChanged(iDataEntityProperty.getOrdinal(), false);
        }
    }

    public static AdDispatchTaskParam getTaskParamObj(Map<String, Object> map) {
        Object obj = map.get("bill_params");
        if (obj instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)obj;
            return (AdDispatchTaskParam)JSON.parseObject((String)jsonObject.toJSONString(), AdDispatchTaskParam.class);
        }
        return (AdDispatchTaskParam)obj;
    }

    public static int getApplyCount(List<AdCheckVo> adCheckVoList, Date rangeBeginDate, Date rangeEndDate, long reasonId) {
        if (CollectionUtils.isEmpty(adCheckVoList)) {
            return 0;
        }
        List dateRangeApplyList = reasonId != 0L ? adCheckVoList.stream().filter(adCheckVo -> adCheckVo.isCheckPass() && adCheckVo.getReason() != null && adCheckVo.getReason().getLong("id") == reasonId && adCheckVo.getShiftBelongDate().compareTo(rangeBeginDate) >= 0 && adCheckVo.getShiftBelongDate().compareTo(rangeEndDate) <= 0).collect(Collectors.toList()) : adCheckVoList.stream().filter(adCheckVo -> adCheckVo.isCheckPass() && adCheckVo.getShiftBelongDate().compareTo(rangeBeginDate) >= 0 && adCheckVo.getShiftBelongDate().compareTo(rangeEndDate) <= 0).collect(Collectors.toList());
        return dateRangeApplyList.size();
    }

    public static int getBatchCheckedApplyCount(List<AdCheckVo> adCheckVoList, Date rangeBeginDate, Date rangeEndDate, long reasonId) {
        if (CollectionUtils.isEmpty(adCheckVoList)) {
            return 0;
        }
        List dateRangeApplyList = reasonId != 0L ? adCheckVoList.stream().filter(adCheckVo -> adCheckVo.isCountReasonChecked() && adCheckVo.isCheckPass() && adCheckVo.getReason() != null && adCheckVo.getReason().getLong("id") == reasonId && adCheckVo.getShiftBelongDate().compareTo(rangeBeginDate) >= 0 && adCheckVo.getShiftBelongDate().compareTo(rangeEndDate) <= 0).collect(Collectors.toList()) : adCheckVoList.stream().filter(adCheckVo -> adCheckVo.isCountChecked() && adCheckVo.isCheckPass() && adCheckVo.getShiftBelongDate().compareTo(rangeBeginDate) >= 0 && adCheckVo.getShiftBelongDate().compareTo(rangeEndDate) <= 0).collect(Collectors.toList());
        return dateRangeApplyList.size();
    }

    public static void setSubmitDate(DynamicObject[] dataEntities) {
        long submitter = RequestContext.get().getCurrUserId();
        Date submitDate = WTCDateUtils.toDate((LocalDateTime)LocalDateTime.now());
        for (DynamicObject dynamicObject : dataEntities) {
            dynamicObject.set("submitter", (Object)submitter);
            dynamicObject.set("submitdate", (Object)submitDate);
        }
    }

    @Deprecated
    public static List<Long> getAuthorizedAdminOrgResult(String appId, String entityNumber, String propKey, String permItemId) {
        if (PermissionServiceHelper.isSuperUser((long)RequestContext.get().getCurrUserId())) {
            return WTCInvokeServiceHelper.getAllAdminOrgIds((boolean)false);
        }
        AuthorizedOrgResult authorizedAdminOrgSet = WTCInvokeServiceHelper.getAuthorizedAdminOrgSet((String)appId, (String)entityNumber, (String)permItemId, (String)propKey);
        boolean hasAllOrgPerm = authorizedAdminOrgSet.isHasAllOrgPerm();
        List hasPermOrgs = authorizedAdminOrgSet.getHasPermOrgs();
        if (hasAllOrgPerm && CollectionUtils.isEmpty((Collection)hasPermOrgs)) {
            hasPermOrgs = WTCInvokeServiceHelper.getAllAdminOrgIds((boolean)false);
        }
        return hasPermOrgs;
    }

    @Deprecated
    public static void setAuthorizedAdminOrgFilter(ListShowParameter listShowParameter, IFormView view) {
        String propKey;
        String entityNumber;
        FormShowParameter formShowParameter = view.getFormShowParameter();
        String appId = formShowParameter.getAppId();
        AuthorizedOrgResult authorizedAdminOrgSet = WTCInvokeServiceHelper.getAuthorizedAdminOrgSet((String)appId, (String)(entityNumber = (String)formShowParameter.getCustomParam("customHREntityNumber")), (String)"47150e89000000ac", (String)(propKey = (String)formShowParameter.getCustomParam("custom_parent_f7_prop")));
        boolean hasAllOrgPerm = authorizedAdminOrgSet.isHasAllOrgPerm();
        if (!hasAllOrgPerm) {
            List hasPermOrgs = authorizedAdminOrgSet.getHasPermOrgs();
            QFilter filter = !WTCCollections.isEmpty((Collection)hasPermOrgs) ? new QFilter("id", "in", (Object)hasPermOrgs) : new QFilter("id", "=", (Object)0L);
            listShowParameter.getListFilterParameter().getQFilters().add(filter);
        }
    }
}

