/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.signcard.job;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.wtc.wtbs.business.task.common.WTCSource;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.time.StopWatch;
import kd.wtc.wtpm.business.cardmatch.SignCardService;
import kd.wtc.wtpm.business.signcard.AdCheckService;
import kd.wtc.wtpm.business.signcard.SignCardBatchService;
import kd.wtc.wtpm.business.signcard.job.AdBillTask;
import kd.wtc.wtpm.business.signcard.supplyapply.helper.SupSignHelper;
import kd.wtc.wtpm.business.supquotapool.SupQuotaPoolTaskService;
import kd.wtc.wtpm.constants.suppleapply.SupSignKDString;
import kd.wtc.wtpm.enums.SignCardBillTypeEnum;
import kd.wtc.wtpm.vo.suppleapply.AdCheckVo;
import kd.wtc.wtpm.vo.suppleapply.AdDispatchTaskParam;
import kd.wtc.wtpm.vo.suppleapply.AdTriggerMatch;

public class AdUpdatePoolTask
extends AdBillTask {
    private static final Log LOG = LogFactory.getLog(AdUpdatePoolTask.class);
    private String billNo;

    @Override
    public void executeTask(RequestContext requestContext, AdDispatchTaskParam param) throws KDException {
        String opType = param.getOpType();
        List<AdCheckVo> adCheckVoList = this.handleOp(param);
        LOG.info("AdUpdatePoolTask.execute begin opType:{}", (Object)opType);
        boolean needCardMatch = this.needCardMatch(opType);
        StopWatch stopWatch = StopWatch.createStarted();
        if (!needCardMatch) {
            LOG.info("AdUpdatePoolTask.execute not need execute card match");
            if ("card_match".equals(opType)) {
                SupQuotaPoolTaskService.updateQuotaPoolByCardMatch(param);
            } else {
                AdCheckService.initCalcAdCheckVoQuotaPool(adCheckVoList, opType, SignCardBillTypeEnum.SUPSIGN_BATCHBILL);
            }
        } else {
            LOG.info("AdUpdatePoolTask.execute need execute card match");
            List<AdTriggerMatch> adTriggerMatches = SupQuotaPoolTaskService.getSupInfoByAdjoinDate(adCheckVoList);
            SignCardService signCardService = new SignCardService();
            if (SignCardBillTypeEnum.SUPSIGN_BATCHBILL == param.getBillType()) {
                String desc = SupSignKDString.supSignInfoTag() + "\uff1a" + this.billNo;
                for (AdTriggerMatch adTriggerMatch : adTriggerMatches) {
                    signCardService.startMatch(adTriggerMatch.getStartDate(), adTriggerMatch.getEndDate(), adTriggerMatch.getAttFileIds(), WTCSource.BATCH_AD.getCode(), desc);
                }
            } else {
                for (AdTriggerMatch adTriggerMatch : adTriggerMatches) {
                    signCardService.startMatch(adTriggerMatch.getStartDate(), adTriggerMatch.getEndDate(), adTriggerMatch.getAttPersonIds(), adTriggerMatch.getAttFileIds(), 2);
                }
            }
        }
        stopWatch.stop();
        LOG.info("AdUpdatePoolTask.execute end use time:{}", (Object)stopWatch.getTime());
    }

    private List<AdCheckVo> handleOp(AdDispatchTaskParam param) {
        boolean genSignCard;
        LOG.info("AdUpdatePoolTask.handleOp begin");
        Set dataIds = param.getDataIds();
        SignCardBillTypeEnum billType = param.getBillType();
        String opType = param.getOpType();
        List<AdCheckVo> allAdCheckVoList = new ArrayList<AdCheckVo>(0);
        if (billType == null || "card_match".equals(opType)) {
            return allAdCheckVoList;
        }
        boolean bl = genSignCard = ("audit".equals(opType) || "submiteffect".equals(opType)) && param.isNeedGenSignCard();
        if (SignCardBillTypeEnum.SUPSIGN_BATCHBILL == billType) {
            List<DynamicObject> billDetailList = SupSignHelper.queryBatchBillDetailCheckPass(dataIds);
            if (!CollectionUtils.isEmpty(billDetailList)) {
                if (genSignCard) {
                    LOG.info("AdUpdatePoolTask.handleOp batch ad bill gen signcard");
                    SignCardBatchService.genPunchCardByListDataList(billDetailList);
                }
                this.billNo = billDetailList.get(0).getString("billno");
                allAdCheckVoList = AdCheckService.genAdCheckVoList(billDetailList);
            }
        } else {
            Object[] billList = SupSignHelper.querySupSignBillById(dataIds);
            if (billList != null && billList.length > 0) {
                if (genSignCard) {
                    LOG.info("AdUpdatePoolTask.handleOp ad bill gen signcard");
                    SignCardBatchService.genPunchCardByBillEntity((DynamicObject[])billList);
                }
                allAdCheckVoList = AdCheckService.genAdCheckVoListForSingleBill(Lists.newArrayList((Object[])billList));
            }
        }
        return allAdCheckVoList;
    }

    private boolean needCardMatch(String opType) {
        boolean calcCountBySignCard = SignCardBatchService.isCalcCountBySignCard();
        if (calcCountBySignCard) {
            return false;
        }
        return "audit".equals(opType) || "submiteffect".equals(opType);
    }
}

