/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.signcard.supplyapply.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.web.file.AttFileQueryHelper;
import kd.wtc.wtbs.business.web.file.schedule.AttFileScheduleServiceImpl;
import kd.wtc.wtbs.common.enums.AttFilePlanEnum;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtpm.business.signcard.SignCardHelperFactory;

public class SupSignHisHelper {
    private static final HRBaseServiceHelper AD_PLAN_DAO = new HRBaseServiceHelper(AttFilePlanEnum.AD.getEntityNumber());

    private SupSignHisHelper() {
    }

    public static Map<Long, List<DynamicObject>> getAttFilePlanHis(Collection<Long> attFileIds) {
        if (CollectionUtils.isEmpty(attFileIds)) {
            return new HashMap<Long, List<DynamicObject>>(0);
        }
        AttFileScheduleServiceImpl scheduleService = new AttFileScheduleServiceImpl();
        return scheduleService.queryAttFileSchedule((Collection)Lists.newArrayList(attFileIds), AttFileScheduleEnum.AD, false);
    }

    public static Map<Long, List<DynamicObject>> getAttFilePlanHis(Collection<Long> attFileIds, Date beginDate, Date endDate) {
        if (CollectionUtils.isEmpty(attFileIds)) {
            return new HashMap<Long, List<DynamicObject>>(0);
        }
        AttFileScheduleServiceImpl scheduleService = new AttFileScheduleServiceImpl();
        return scheduleService.queryFileScheduleByFileBoidAndDate((List)Lists.newArrayList(attFileIds), AttFileScheduleEnum.AD, beginDate, endDate);
    }

    public static Map<Long, List<DynamicObject>> getPlanHis(Map<Long, Tuple<Date, Date>> dateList) {
        if (CollectionUtils.isEmpty(dateList)) {
            return Collections.emptyMap();
        }
        QFilter planFilter = WTCHisServiceHelper.dataStatusValidQFilter();
        planFilter.and(WTCHisServiceHelper.isCurrentVersion((boolean)false));
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(dateList.size());
        for (Map.Entry<Long, Tuple<Date, Date>> entry : dateList.entrySet()) {
            QFilter qFilter = new QFilter("boid", "=", (Object)entry.getKey());
            QFilter dateFilter = AttFileQueryHelper.getDateQFilter((Date)((Date)entry.getValue().item1), (Date)((Date)entry.getValue().item2), (boolean)true);
            qFilter.and(dateFilter);
            qFilterList.add(qFilter);
        }
        QFilter qFilter = (QFilter)qFilterList.remove(0);
        for (QFilter filter : qFilterList) {
            qFilter.or(filter);
        }
        planFilter.and(qFilter);
        DynamicObject[] dynamicObjectArray = AD_PLAN_DAO.loadDynamicObjectArray(planFilter.toArray());
        return Arrays.stream(dynamicObjectArray).collect(Collectors.groupingBy(plan -> plan.getLong("boid")));
    }

    public static Map<Long, List<DynamicObject>> getPlanHis(Collection<Long> planIds) {
        return SupSignHisHelper.getPlanHis(planIds, null, null);
    }

    public static Map<Long, List<DynamicObject>> getPlanHis(Collection<Long> planIds, Date beginDate, Date endDate) {
        QFilter planFilter = WTCHisServiceHelper.dataStatusValidQFilter();
        planFilter.and("boid", "in", planIds);
        planFilter.and(WTCHisServiceHelper.isCurrentVersion((boolean)false));
        if (beginDate != null && endDate != null) {
            QFilter dateFilter = AttFileQueryHelper.getDateQFilter((Date)beginDate, (Date)endDate, (boolean)true);
            planFilter.and(dateFilter);
        }
        DynamicObject[] planArr = AD_PLAN_DAO.loadDynamicObjectArray(planFilter.toArray());
        return Arrays.stream(planArr).collect(Collectors.groupingBy(plan -> plan.getLong("boid")));
    }

    public static Map<Long, List<DynamicObject>> querySuppleRuleHis(Collection<Long> ruleIds, Date beginDate, Date endDate) {
        HRBaseServiceHelper serviceHelper;
        DynamicObject[] ruleArr;
        if (CollectionUtils.isEmpty(ruleIds)) {
            return Collections.emptyMap();
        }
        QFilter qFilter = WTCHisServiceHelper.dataStatusValidQFilter();
        qFilter.and("boid", "in", ruleIds);
        qFilter.and(WTCHisServiceHelper.isCurrentVersion((boolean)false));
        if (beginDate != null && endDate != null) {
            QFilter dateFilter = AttFileQueryHelper.getDateQFilter((Date)beginDate, (Date)endDate, (boolean)true);
            qFilter.and(dateFilter);
        }
        if ((ruleArr = (serviceHelper = SignCardHelperFactory.getHelper("wtp_supplerule")).loadDynamicObjectArray(qFilter.toArray())) == null || ruleArr.length == 0) {
            return Collections.emptyMap();
        }
        return Arrays.stream(ruleArr).collect(Collectors.groupingBy(rule -> rule.getLong("boid")));
    }

    public static DynamicObject getTimeZoneHis(long attFileBoId, Date signDate) {
        AttFileScheduleServiceImpl scheduleService = new AttFileScheduleServiceImpl();
        Map longListMap = scheduleService.queryFileScheduleByFileBoidAndDate((List)Lists.newArrayList((Object[])new Long[]{attFileBoId}), AttFileScheduleEnum.TZ, signDate, signDate);
        if (CollectionUtils.isEmpty((Map)longListMap)) {
            return null;
        }
        List list = (List)longListMap.get(attFileBoId);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        return (DynamicObject)list.get(0);
    }
}

