/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.signcard.supplyapply.service;

import java.time.LocalDate;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import kd.bos.dataentity.Tuple;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.wtc.wtbs.business.web.attperiod.PerAttPeriodQueryServiceImpl;
import kd.wtc.wtbs.business.web.billservice.attfile.BillAttFileService;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.model.period.PerAttPeriodQueryParam;
import kd.wtc.wtbs.common.model.period.PeriodBillCheckResult;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.ImmutableMap;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtpm.constants.suppleapply.SupSignKDString;
import kd.wtc.wtpm.enums.TimeRangeEnum;
import kd.wtc.wtpm.vo.suppleapply.FunctionTuple;

public class LimitationRangeService {
    private static final Log LOG = LogFactory.getLog(LimitationRangeService.class);
    @Deprecated
    public static final Map<String, Supplier<String>> TIME_RANGE_DESC_MAP = ImmutableMap.of((Object)TimeRangeEnum.WEEK.getCode(), SupSignKDString::week, (Object)TimeRangeEnum.MONTH.getCode(), SupSignKDString::month, (Object)TimeRangeEnum.PERIOD.getCode(), SupSignKDString::attPeriod, (Object)TimeRangeEnum.QUARTER.getCode(), SupSignKDString::quarter, (Object)TimeRangeEnum.YEAR.getCode(), SupSignKDString::year);
    public static final Map<String, FunctionTuple<Date, Date>> TIME_RANGE_FUN = ImmutableMap.of((Object)TimeRangeEnum.WEEK.getCode(), (Object)new FunctionTuple(WTCDateUtils::getBeginDayOfWeek, WTCDateUtils::getEndDayOfWeek), (Object)TimeRangeEnum.MONTH.getCode(), (Object)new FunctionTuple(WTCDateUtils::getBeginDayOfMonth, WTCDateUtils::getEndDayOfMonth), (Object)TimeRangeEnum.QUARTER.getCode(), (Object)new FunctionTuple(WTCDateUtils::getStartDayOfQuarter, WTCDateUtils::getEndDayOfQuarter), (Object)TimeRangeEnum.YEAR.getCode(), (Object)new FunctionTuple(WTCDateUtils::getBeginDayOfYear, WTCDateUtils::getEndDayOfYear));

    private LimitationRangeService() {
    }

    @Deprecated
    public static List<PerAttPeriod> getPerAttPeriodList(Collection<Long> personIds, Date beginDate, Date endDate) {
        PerAttPeriodQueryParam queryParam = new PerAttPeriodQueryParam();
        queryParam.setAttPersonIdSet((Set)Sets.newHashSet(personIds));
        queryParam.setStartDate(beginDate);
        queryParam.setEndDate(endDate);
        return PerAttPeriodQueryServiceImpl.getInstance().queryPerAttPeriodEntity(queryParam);
    }

    public static PeriodBillCheckResult getPerAttPeriods(Map<Long, List<LocalDate>> needQueryPeriodPersonMap) {
        Optional periodBillCheckResultOptional = BillAttFileService.getInstance().getPerAttPeriods(needQueryPeriodPersonMap);
        PeriodBillCheckResult periodBillCheckResult = periodBillCheckResultOptional.orElse(null);
        BillAttFileService.getBillPeriodKeyInfoLog((PeriodBillCheckResult)periodBillCheckResult, (Log)LOG);
        return periodBillCheckResult;
    }

    public static List<PerAttPeriod> getPerAttPeriodList(Long personId, Date beginDate, Date endDate) {
        return LimitationRangeService.getPerAttPeriodList(Lists.newArrayList((Object[])new Long[]{personId}), beginDate, endDate);
    }

    public static Tuple<Date, Date> getTimeScope(String countSco, Date signDate) {
        FunctionTuple<Date, Date> functionTuple;
        Date rangeBeginDate = null;
        Date rangeEndDate = null;
        if (!CollectionUtils.isEmpty(TIME_RANGE_FUN) && signDate != null && countSco != null && (functionTuple = TIME_RANGE_FUN.get(countSco)) != null) {
            rangeBeginDate = (Date)functionTuple.getF1().apply(signDate);
            rangeEndDate = (Date)functionTuple.getF2().apply(signDate);
        }
        return new Tuple(rangeBeginDate, rangeEndDate);
    }
}

