/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.signcard.task;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.ExceptionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskDetailEntity;
import kd.wtc.wtbs.business.caltask.common.billapply.BillApplyTaskDetail;
import kd.wtc.wtbs.business.caltask.common.billapply.BillApplyTaskDetailStatus;
import kd.wtc.wtbs.business.task.common.WTCTaskDetailStatus;
import kd.wtc.wtbs.business.task.executor.WTCShardingAbleTask;
import kd.wtc.wtbs.business.task.executor.WTCTaskParam;
import kd.wtc.wtbs.business.task.sharding.std.WTCTaskCalShardingDetail;
import kd.wtc.wtbs.business.web.file.AttFileQueryHelper;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.time.StopWatch;
import kd.wtc.wtpm.business.signcard.AdCheckService;
import kd.wtc.wtpm.business.signcard.SignCardBatchService;
import kd.wtc.wtpm.business.signcard.SignCardHelperFactory;
import kd.wtc.wtpm.business.signcard.supplyapply.helper.SupSignHelper;
import kd.wtc.wtpm.business.signcard.task.BillApplyTaskFactoryService;
import kd.wtc.wtpm.business.signcard.task.BillApplyTaskHelper;
import kd.wtc.wtpm.business.signcard.task.BillTaskEntity;
import kd.wtc.wtpm.constants.suppleapply.SupSignKDString;
import kd.wtc.wtpm.constants.suppleapply.SuppleApplyConstants;
import kd.wtc.wtpm.enums.SignCardBillTypeEnum;
import kd.wtc.wtpm.vo.suppleapply.AdCheckVo;
import kd.wtc.wtpm.vo.suppleapply.BillExDetailVo;
import kd.wtc.wtpm.vo.suppleapply.BillSubTaskVo;
import kd.wtc.wtpm.vo.suppleapply.BillTaskProcessVo;

public abstract class BillApplyTaskHandleService {
    protected static final Log LOG = LogFactory.getLog(BillApplyTaskHandleService.class);
    protected BillTaskEntity billtaskvo = new BillTaskEntity();
    protected SignCardBillTypeEnum billType;
    protected BillTaskProcessVo taskProcessVo = new BillTaskProcessVo();
    protected int cacheTime = 1800;

    public void doTaskProcess(WTCTaskParam taskParams) {
        LOG.info("BillApplyTaskHandleService.doTaskProcess begin");
        StopWatch watch = StopWatch.createStarted();
        this.billtaskvo.setStartDate(WTCDateUtils.toDate((LocalDateTime)LocalDateTime.now()));
        this.beforeProcess(taskParams);
        this.reportProgress(this.taskProcessVo.getSubTaskId(), 5);
        try {
            this.initProcess();
            boolean stop = WTCShardingAbleTask.WTCShardingTaskHelper.isStop((long)taskParams.getTaskId());
            if (stop) {
                this.stopTask();
                this.reportProgress(this.taskProcessVo.getSubTaskId(), 100);
                return;
            }
            this.reportProgress(this.taskProcessVo.getSubTaskId(), 10);
            this.beginProcess();
            this.reportProgress(this.taskProcessVo.getSubTaskId(), 60);
            this.endProcess();
            this.reportProgress(this.taskProcessVo.getSubTaskId(), 90);
            this.afterProcess();
            this.reportProgress(this.taskProcessVo.getSubTaskId(), 100);
        }
        catch (Exception ex) {
            LOG.info("BillApplyTaskHandleService.applyTaskProcess.Exception:{}", (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
            this.errorProcess();
            throw ex;
        }
        watch.stop();
        LOG.info("BillApplyTaskHandleService.doTaskProcess.taskParams&shardingAbleTask.end,time:{}ms", (Object)watch.getTime());
    }

    private void beforeProcess(WTCTaskParam taskParams) {
        List details = taskParams.getTaskShardingDetails();
        Map params = taskParams.getParams();
        Long billId = (Long)params.get("billid");
        String taskCategory = taskParams.getTaskCategory();
        String dataChanged = (String)params.get("dataChanged");
        this.taskProcessVo.setTaskId(taskParams.getMainTaskId());
        this.taskProcessVo.setSubTaskId(taskParams.getTaskId());
        this.taskProcessVo.setShardingDetails(details);
        this.taskProcessVo.setDataChanged(dataChanged);
        this.taskProcessVo.setBillId(billId);
        this.taskProcessVo.setTaskCategory(taskCategory);
        this.taskProcessVo.setOpType((String)params.get("opType"));
    }

    private void initProcess() {
        List<AdCheckVo> adCheckVoList;
        this.getBillDateEntity();
        List shardingDetails = this.taskProcessVo.getShardingDetails();
        HashSet attFileBoIds = Sets.newHashSetWithExpectedSize((int)shardingDetails.size());
        for (Object detail : shardingDetails) {
            WTCTaskCalShardingDetail shardingDetail = (WTCTaskCalShardingDetail)detail;
            attFileBoIds.add(shardingDetail.getAttFileBoId());
        }
        this.taskProcessVo.setAttFileBoIds((Set)attFileBoIds);
        List attFileBoList = AttFileQueryHelper.queryAttFileByIds((String)SuppleApplyConstants.QUERY_ATTFILE_FIELD, (List)Lists.newArrayList((Iterable)this.taskProcessVo.getAttFileBoIds()));
        DynamicObject billInfoDy = this.taskProcessVo.getBillDataEntity();
        boolean isMulPriSup = SignCardBatchService.billIsMulPri(billInfoDy);
        if (isMulPriSup) {
            DynamicObjectCollection supSignInfoBatchColl = billInfoDy.getDynamicObjectCollection("entryentitymultipri");
            adCheckVoList = AdCheckService.genAdCheckVoListByMulPriSup(attFileBoList, (List<DynamicObject>)supSignInfoBatchColl);
        } else {
            DynamicObjectCollection supSignInfoBatchColl = billInfoDy.getDynamicObjectCollection("entryentitysupinfo");
            adCheckVoList = AdCheckService.genAdCheckVoList(attFileBoList, (List<DynamicObject>)supSignInfoBatchColl);
        }
        this.taskProcessVo.setAdCheckVoList(adCheckVoList);
    }

    private void beginProcess() {
        this.beginCheckData();
        List adCheckVoList = this.taskProcessVo.getAdCheckVoList();
        HashSet checkPassAttFileBoIds = Sets.newHashSetWithExpectedSize((int)adCheckVoList.size());
        for (AdCheckVo adCheckVo : adCheckVoList) {
            if (!adCheckVo.isCheckPass()) continue;
            checkPassAttFileBoIds.add(adCheckVo.getAttFileId());
        }
        this.taskProcessVo.setCheckPassAttFileBoIds((Set)checkPassAttFileBoIds);
        Map<Long, List<DynamicObject>> cardHisDyListMap = SupSignHelper.queryCardHis(this.taskProcessVo.getCheckPassAttFileBoIds());
        this.taskProcessVo.setCardMap(cardHisDyListMap);
    }

    private void endProcess() {
        this.saveBillDetailData();
    }

    private void afterProcess() {
        List adCheckVoList = this.taskProcessVo.getAdCheckVoList();
        List shardingDetails = this.taskProcessVo.getShardingDetails();
        ArrayList<WTCCalTaskDetailEntity> billApplyTaskDetailList = new ArrayList<WTCCalTaskDetailEntity>(adCheckVoList.size());
        HashMap attFileAdCheckVoMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap personAdCheckVoMap = Maps.newHashMapWithExpectedSize((int)16);
        this.groupAdCheckVoList(adCheckVoList, attFileAdCheckVoMap, personAdCheckVoMap);
        for (Object detail : shardingDetails) {
            WTCTaskCalShardingDetail shardingDetail = (WTCTaskCalShardingDetail)detail;
            BillApplyTaskDetail billApplyTaskDetail = new BillApplyTaskDetail();
            billApplyTaskDetail.setTaskId(this.taskProcessVo.getTaskId());
            billApplyTaskDetail.setSubTaskId(this.taskProcessVo.getSubTaskId());
            long attFileBoId = shardingDetail.getAttFileBoId();
            billApplyTaskDetail.setAttFileId(shardingDetail.getAttFileId());
            billApplyTaskDetail.setAttFileBoId(attFileBoId);
            Long attPersonId = shardingDetail.getAttPersonId();
            billApplyTaskDetail.setAttPersonId(attPersonId.longValue());
            List attFileAdCheckVoList = (List)attFileAdCheckVoMap.get(attFileBoId);
            if (CollectionUtils.isEmpty((Collection)attFileAdCheckVoList)) continue;
            Tuple<Date, Date> dateRangeTuple = this.getAttFileApplyDateRange(attFileAdCheckVoList);
            billApplyTaskDetail.setRealCalStartDate((Date)dateRangeTuple.item1);
            billApplyTaskDetail.setRealCalEndDate((Date)dateRangeTuple.item2);
            Optional<AdCheckVo> any = attFileAdCheckVoList.stream().filter(item -> !item.isCheckPass()).findAny();
            WTCTaskDetailStatus status = WTCTaskDetailStatus.SUCCESS;
            if (any.isPresent()) {
                status = WTCTaskDetailStatus.FAIL;
            }
            billApplyTaskDetail.setTaskDetailState(status);
            this.getBillApplyTaskDetailCount((List)attFileAdCheckVoMap.get(attFileBoId), billApplyTaskDetail);
            billApplyTaskDetailList.add((WTCCalTaskDetailEntity)billApplyTaskDetail);
        }
        BillSubTaskVo billSubTaskVo = new BillSubTaskVo();
        long successCount = adCheckVoList.stream().filter(AdCheckVo::isCheckPass).count();
        billSubTaskVo.setSuccessCard(Integer.valueOf(Math.toIntExact(successCount)));
        this.getSubTaskInfo(billSubTaskVo, attFileAdCheckVoMap, 1);
        this.getSubTaskInfo(billSubTaskVo, personAdCheckVoMap, 0);
        this.billtaskvo.setBillSubTaskVo(billSubTaskVo);
        this.billtaskvo.setTaskId(this.taskProcessVo.getTaskId());
        this.billtaskvo.setSubTaskId(this.taskProcessVo.getSubTaskId());
        this.billtaskvo.setTaskCategory(this.taskProcessVo.getTaskCategory());
        this.billtaskvo.setBillApplyTaskDetailList(billApplyTaskDetailList);
        BillApplyTaskHelper.callBackDispatchTask(this.billtaskvo);
        this.getBillExDetail(adCheckVoList);
        BillApplyTaskHelper.saveExDetail(this.billtaskvo);
    }

    private void groupAdCheckVoList(List<AdCheckVo> adCheckVoList, Map<Long, List<AdCheckVo>> attFileAdCheckVoMap, Map<Long, List<AdCheckVo>> personAdCheckVoMap) {
        for (AdCheckVo adCheckVo : adCheckVoList) {
            Long attFileId = adCheckVo.getAttFileId();
            Long attPersonId = adCheckVo.getPersonId();
            List adCheckVoListOfAttFile = attFileAdCheckVoMap.computeIfAbsent(attFileId, item -> Lists.newArrayListWithCapacity((int)16));
            adCheckVoListOfAttFile.add(adCheckVo);
            List adCheckVoListOfPerson = personAdCheckVoMap.computeIfAbsent(attPersonId, item -> Lists.newArrayListWithCapacity((int)16));
            adCheckVoListOfPerson.add(adCheckVo);
        }
    }

    private void errorProcess() {
        BillApplyTaskHelper.callBackDispatchTaskOfError(this.taskProcessVo);
    }

    protected void getBillDateEntity() {
    }

    protected void beginCheckData() {
    }

    protected void saveBillDetailData() {
    }

    private Tuple<Date, Date> getAttFileApplyDateRange(List<AdCheckVo> adCheckVos) {
        Set signDateSet = adCheckVos.stream().map(AdCheckVo::getSignDate).collect(Collectors.toSet());
        List signDateList = signDateSet.stream().sorted(Date::compareTo).collect(Collectors.toList());
        return new Tuple(signDateList.get(0), signDateList.get(signDateList.size() - 1));
    }

    private void getBillApplyTaskDetailCount(List<AdCheckVo> adCheckVos, BillApplyTaskDetail billApplyTaskDetail) {
        int count = 0;
        int success = 0;
        int fail = 0;
        int notRun = 0;
        if (!CollectionUtils.isEmpty(adCheckVos)) {
            count = adCheckVos.size();
            for (AdCheckVo adCheckVo : adCheckVos) {
                if (adCheckVo.isCheckPass()) {
                    ++success;
                    continue;
                }
                if (adCheckVo.getNotRunType() != 0) continue;
                ++fail;
            }
            notRun = count - success - fail;
        }
        billApplyTaskDetail.setTotal(Integer.valueOf(count));
        billApplyTaskDetail.setSuccess(Integer.valueOf(success));
        billApplyTaskDetail.setFail(Integer.valueOf(notRun + fail));
        if (success == count) {
            billApplyTaskDetail.setStatus(BillApplyTaskDetailStatus.SUCCESS);
        } else if (notRun == count) {
            billApplyTaskDetail.setStatus(BillApplyTaskDetailStatus.NOTRUN);
        } else {
            billApplyTaskDetail.setStatus(BillApplyTaskDetailStatus.FAIL);
        }
    }

    private void getBillExDetail(List<AdCheckVo> adCheckVoList) {
        List notCheckPass = adCheckVoList.stream().filter(item -> HRStringUtils.isNotEmpty((String)item.getErrorMsg())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(notCheckPass)) {
            ArrayList<BillExDetailVo> billExDetailVoList = new ArrayList<BillExDetailVo>(notCheckPass.size());
            for (AdCheckVo adCheckVo : notCheckPass) {
                BillExDetailVo billExDetailVo = new BillExDetailVo();
                billExDetailVo.setEvaDate(adCheckVo.getSignDate());
                billExDetailVo.setAttFileId(adCheckVo.getAttFileId());
                billExDetailVo.setExCode("0");
                billExDetailVo.setExInfo(adCheckVo.getErrorMsg());
                billExDetailVo.setSuppleWorkTime(adCheckVo.getSuppleWorkTime());
                billExDetailVoList.add(billExDetailVo);
            }
            this.billtaskvo.setBillExDetailVoList(billExDetailVoList);
        }
    }

    private void getSubTaskInfo(BillSubTaskVo billSubTaskVo, Map<Long, List<AdCheckVo>> adCheckVoMap, int type) {
        int total = adCheckVoMap.size();
        int fail = 0;
        int notRun = 0;
        for (Map.Entry<Long, List<AdCheckVo>> entry : adCheckVoMap.entrySet()) {
            Long key = entry.getKey();
            if (key == null || key.equals(0L)) {
                --total;
                continue;
            }
            List<AdCheckVo> value = entry.getValue();
            int tz = value.size();
            int fz = 0;
            int nz = 0;
            for (AdCheckVo adCheckVo : value) {
                if (adCheckVo.isCheckPass()) continue;
                if (adCheckVo.getNotRunType() == 0) {
                    ++fz;
                    continue;
                }
                ++nz;
            }
            if (nz == tz) {
                ++notRun;
                continue;
            }
            if (fz + nz <= 0) continue;
            ++fail;
        }
        int success = total - fail - notRun;
        if (type == 0) {
            billSubTaskVo.setTotalAttPerson(Integer.valueOf(total));
            billSubTaskVo.setFailAttPerson(Integer.valueOf(fail));
            billSubTaskVo.setSuccessAttPerson(Integer.valueOf(success));
            billSubTaskVo.setNotRunAttPerson(Integer.valueOf(notRun));
        } else {
            billSubTaskVo.setTotalAttFile(Integer.valueOf(total));
            billSubTaskVo.setFailAttFile(Integer.valueOf(fail));
            billSubTaskVo.setSuccessAttFile(Integer.valueOf(success));
            billSubTaskVo.setNotRunAttFile(Integer.valueOf(notRun));
        }
    }

    private void reportProgress(long subTaskId, int process) {
        try {
            WTCShardingAbleTask.WTCShardingTaskHelper.reportProgress((long)subTaskId, (int)process);
        }
        catch (Exception ex) {
            LOG.error("BillApplyTaskHandleService.reportProgress.error", (Throwable)ex);
            this.errorProcess();
        }
    }

    protected boolean isPartSuccessSubmit() {
        String opType;
        boolean partSuccessSubmit = SignCardBatchService.isPartSuccessSubmit();
        return partSuccessSubmit && ("submit".equals(opType = this.taskProcessVo.getOpType()) || "submiteffect".equals(opType));
    }

    protected List<DynamicObject> genBillDataList(boolean isBatchSup) {
        DynamicObject billDataEntity = this.taskProcessVo.getBillDataEntity();
        List allAdCheckVoList = this.taskProcessVo.getAdCheckVoList();
        Map<Long, List<AdCheckVo>> attFileMap = allAdCheckVoList.stream().collect(Collectors.groupingBy(AdCheckVo::getAttFileId));
        List shardingDetails = this.taskProcessVo.getShardingDetails();
        Map cardMap = this.taskProcessVo.getCardMap();
        HRBaseServiceHelper serviceHelper = SignCardHelperFactory.getHelper(BillApplyTaskFactoryService.getBillListEntityId(this.taskProcessVo.getTaskCategory()));
        long billId = billDataEntity.getLong("id");
        String billNo = billDataEntity.getString("billno");
        ArrayList<DynamicObject> listDys = new ArrayList<DynamicObject>(allAdCheckVoList.size());
        long userId = RequestContext.get().getCurrUserId();
        boolean checkFailIsValid = true;
        if (this.isPartSuccessSubmit() && !CollectionUtils.isEmpty((Collection)this.taskProcessVo.getCheckPassAttFileBoIds())) {
            checkFailIsValid = false;
        }
        for (Object detail : shardingDetails) {
            WTCTaskCalShardingDetail shardingDetail = (WTCTaskCalShardingDetail)detail;
            long attFileBoId = shardingDetail.getAttFileBoId();
            List<AdCheckVo> adCheckVoList = attFileMap.get(attFileBoId);
            if (CollectionUtils.isEmpty(adCheckVoList)) continue;
            for (AdCheckVo adCheckVo : adCheckVoList) {
                DynamicObject listDy = serviceHelper.generateEmptyDynamicObject();
                listDy.set("billid", (Object)billId);
                listDy.set("billno", (Object)billNo);
                listDy.set("org", billDataEntity.get("org"));
                listDy.set("isexistsworkflow", (Object)Boolean.FALSE);
                listDy.set("isinworkflow", (Object)Boolean.FALSE);
                listDy.set("supsigninfo", (Object)adCheckVo.getSupSignInfoId());
                listDy.set("attperson", (Object)adCheckVo.getPersonId());
                listDy.set("attfile", (Object)shardingDetail.getAttFileBoId());
                listDy.set("attfilev", (Object)adCheckVo.getAttFileVid());
                List cardList = (List)cardMap.get(shardingDetail.getAttFileBoId());
                listDy.set("card", (Object)SignCardBatchService.getCardHisByDate(cardList, adCheckVo.getShiftBelongDate()));
                listDy.set("creator", (Object)userId);
                listDy.set("isvalid", (Object)(adCheckVo.isCheckPass() || checkFailIsValid ? 1 : 0));
                if (isBatchSup) {
                    listDy.set("ischeckpass", (Object)adCheckVo.isCheckPass());
                    DynamicObject reason = adCheckVo.getReason();
                    if (reason != null) {
                        listDy.set("applyreason", reason.get("id"));
                    }
                }
                listDys.add(listDy);
            }
        }
        return listDys;
    }

    private void stopTask() {
        List adCheckVoList = this.taskProcessVo.getAdCheckVoList();
        String errorMsg = SupSignKDString.stopNotRun();
        for (AdCheckVo adCheckVo : adCheckVoList) {
            adCheckVo.setCheckPass(false);
            adCheckVo.setErrorMsg(errorMsg);
            adCheckVo.setNotRunType(4);
        }
        this.afterProcess();
    }
}

