/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.signcard.task;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.wtc.wtbs.common.util.WTCCacheUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.time.StopWatch;
import kd.wtc.wtpm.business.signcard.signcardapply.helper.SignCardApplyHelper;
import kd.wtc.wtpm.business.signcard.task.BillApplyTaskHandleService;
import kd.wtc.wtpm.business.signcard.task.BillApplyTaskService;
import kd.wtc.wtpm.business.signcard.validator.SupSignCheckServiceHandler;
import kd.wtc.wtpm.enums.SignCardBillTypeEnum;

public class SignCardTaskHandleService
extends BillApplyTaskHandleService {
    @Override
    public void getBillDateEntity() {
        this.billType = SignCardBillTypeEnum.SIGNCARD_BILL;
        DynamicObject billInfoDy = SignCardApplyHelper.querySignCardApply(this.taskProcessVo.getBillId());
        this.taskProcessVo.setBillDataEntity(billInfoDy);
    }

    @Override
    public void beginCheckData() {
        List adCheckVoList = this.taskProcessVo.getAdCheckVoList();
        SupSignCheckServiceHandler serviceHandler = new SupSignCheckServiceHandler(adCheckVoList, SignCardBillTypeEnum.SIGNCARD_BILL);
        serviceHandler.signCardApplyCheck();
    }

    @Override
    public void saveBillDetailData() {
        if ("0".equals(this.taskProcessVo.getDataChanged()) && !this.isPartSuccessSubmit()) {
            return;
        }
        try (TXHandle tx = TX.required();){
            try {
                DynamicObject billDataEntity = this.taskProcessVo.getBillDataEntity();
                long billId = billDataEntity.getLong("id");
                String cacheKey = WTCCacheUtils.getKey((String)"wtpm", (String)BillApplyTaskService.getTaskCacheKey(billId));
                try (DLock lock = DLock.create((String)cacheKey);){
                    String isDeleted;
                    if (lock.tryLock() && !"1".equals(isDeleted = (String)WTCCacheUtils.getCache().get(cacheKey))) {
                        billDataEntity.set("isvalid", (Object)Boolean.FALSE);
                        SignCardApplyHelper.updateSignCardBill(billDataEntity);
                        SignCardApplyHelper.deleteSignCardList(Lists.newArrayList((Object[])new Long[]{billId}));
                        LOG.info("SignCardTaskHandleService.endProcess.deleteApplyBillInfos success");
                        WTCCacheUtils.getCache().put(cacheKey, (Object)"1", this.cacheTime);
                    }
                }
                List<DynamicObject> listDys = this.genBillDataList(false);
                StopWatch watch = StopWatch.createStarted();
                SignCardApplyHelper.saveSignCardList(listDys);
                watch.stop();
                LOG.info("SignCardTaskHandleService.endProcess.saveSignCardList.size:{},time:{}ms", (Object)listDys.size(), (Object)watch.getTime());
            }
            catch (Exception throwable) {
                String errorMsg = throwable.getMessage();
                LOG.error("SignCardTaskHandleService.endProcess.Exception:{}", (Object)errorMsg);
                tx.markRollback();
                throw new KDBizException((Throwable)throwable, new ErrorCode("", errorMsg), new Object[0]);
            }
        }
    }
}

