/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.signcard.task;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.business.caltask.common.WTCTaskRequestStd;
import kd.wtc.wtbs.business.formtask.TaskFormProcessorService;
import kd.wtc.wtbs.business.formtask.WTCTaskForm;
import kd.wtc.wtbs.business.helper.WTCTaskInstanceHelper;
import kd.wtc.wtbs.business.task.base.WTCDistributeTaskHelper;
import kd.wtc.wtbs.business.task.common.WTCTaskBusinessStatusEnum;
import kd.wtc.wtbs.business.task.common.WTCTaskRequest;
import kd.wtc.wtbs.business.task.repository.WTCTaskRepository;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtpm.business.signcard.SignCardBatchService;
import kd.wtc.wtpm.business.signcard.signcardapply.helper.SignCardApplyHelper;
import kd.wtc.wtpm.business.signcard.supplyapply.helper.SupSignHelper;
import kd.wtc.wtpm.business.signcard.task.BillApplyTaskHelper;
import kd.wtc.wtpm.business.signcard.task.BillApplyTaskService;
import kd.wtc.wtpm.constants.suppleapply.SupSignKDString;
import kd.wtc.wtpm.vo.suppleapply.ApplyReqVo;

public class TaskFormProcessorServiceImpl
implements TaskFormProcessorService {
    protected static final Log LOG = LogFactory.getLog(TaskFormProcessorServiceImpl.class);

    public void beforeGenTaskForm(Object param) {
    }

    public WTCTaskForm genTaskForm(Object param) {
        this.log("TaskFormProcessorServiceImpl.genTaskForm begin", new Object[0]);
        WTCTaskForm taskForm = (WTCTaskForm)param;
        Map customParams = taskForm.getCustomParams();
        ApplyReqVo applyReqVo = (ApplyReqVo)JSON.parseObject((String)JSON.toJSONString((Object)customParams), ApplyReqVo.class);
        String dataChanged = applyReqVo.getDataChanged();
        List<Map<String, Object>> attFileIdMapList = "1".equals(dataChanged) ? this.getFormProcessAttFileIds(applyReqVo) : this.getBatchBillAttFileIds(applyReqVo);
        this.log("TaskFormProcessorServiceImpl.genTaskForm.getCurrentAttFilesBoIds.size={}", attFileIdMapList.size());
        if (CollectionUtils.isEmpty(attFileIdMapList)) {
            String msg = SupSignKDString.noAttFile();
            taskForm.setErrMsg(msg);
            return taskForm;
        }
        this.removeLeaveAttFile(attFileIdMapList);
        this.saveTaskLog(applyReqVo);
        WTCTaskRequestStd request = BillApplyTaskService.setDistributedTaskRequest(applyReqVo);
        request.setDetail(attFileIdMapList);
        List subTaskDispatchRequestList = WTCDistributeTaskHelper.shardingSaveAndSlimReqStd((WTCTaskRequestStd)request);
        BillApplyTaskService.deleteTaskStatusCache(applyReqVo.getBillId());
        taskForm.setTaskRequest((WTCTaskRequest)request);
        taskForm.setSubTaskDispatchRequestList(subTaskDispatchRequestList);
        this.log("TaskFormProcessorServiceImpl.genTaskForm end", new Object[0]);
        return taskForm;
    }

    private List<Map<String, Object>> getFormProcessAttFileIds(ApplyReqVo applyReqVo) {
        String taskCategory = applyReqVo.getTaskCategory();
        long billId = applyReqVo.getBillId();
        DynamicObject dataEntity = "wtpm_supsign".equals(taskCategory) ? SupSignHelper.queryBatchBillById(billId) : SignCardApplyHelper.querySignCardApply(billId);
        return SignCardBatchService.getCurrentAttFilesBoIds(dataEntity);
    }

    private List<Map<String, Object>> getBatchBillAttFileIds(ApplyReqVo applyReqVo) {
        List<Map<String, Object>> batchBillAttFileIds = SignCardBatchService.getBatchBillAttFileIds(applyReqVo);
        if (WTCCollections.isEmpty(batchBillAttFileIds)) {
            batchBillAttFileIds = this.getFormProcessAttFileIds(applyReqVo);
        }
        return batchBillAttFileIds;
    }

    private void saveTaskLog(ApplyReqVo applyReqVo) {
        long[] longs = DB.genGlobalLongIds((int)2);
        applyReqVo.setTaskId(Long.valueOf(longs[0]));
        applyReqVo.setVersion(String.valueOf(longs[1]));
        BillApplyTaskHelper.saveTaskLog(applyReqVo);
    }

    public void afterGenTaskForm(Object param, IFormView view) {
        WTCTaskForm taskForm = (WTCTaskForm)param;
        Map customParams = taskForm.getCustomParams();
        ApplyReqVo applyReqVo = (ApplyReqVo)JSON.parseObject((String)JSON.toJSONString((Object)customParams), ApplyReqVo.class);
        String opKey = applyReqVo.getOpType();
        if ("submit".equals(opKey) || "submiteffect".equals(opKey)) {
            boolean partSuccessSubmit = SignCardBatchService.isPartSuccessSubmit();
            String tip = partSuccessSubmit ? SupSignKDString.oneSuccessSubmit() : SupSignKDString.batchSubmitTip();
            view.showTipNotification(tip);
        }
    }

    public void afterGenTaskForm(Object param) {
        WTCTaskForm taskForm = (WTCTaskForm)param;
        WTCTaskRequest taskRequest = taskForm.getTaskRequest();
        long taskId = taskRequest.getTaskId();
        String category = taskRequest.getCategory();
        WTCTaskRepository repository = WTCTaskInstanceHelper.getRepository((String)category);
        DynamicObject dyn = repository.loadTaskDynByTaskId(taskId, null);
        dyn.set("matchstatus", (Object)WTCTaskBusinessStatusEnum.RUNNING.getSign());
        repository.updateTaskDyn(dyn);
    }

    private void log(String log, Object ... params) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(log, params);
        }
    }

    private void removeLeaveAttFile(List<Map<String, Object>> attFileIdMapList) {
        Long userId = BillUnifyService.getUserId();
        Set attFileLevelBoIds = BillCommonService.getInstance().getAttFileLevelBoIds(userId);
        if (WTCCollections.isNotEmpty((Collection)attFileLevelBoIds)) {
            attFileIdMapList.removeIf(item -> attFileLevelBoIds.contains(item.get("attFileBoId")));
        }
    }
}

