/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.signcard.validator;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtpm.business.signcard.SignCardCommonService;
import kd.wtc.wtpm.business.signcard.validator.ISupSignCheckService;
import kd.wtc.wtpm.enums.SignCardBillTypeEnum;
import kd.wtc.wtpm.enums.SupSignCheckErrorMsgEnum;
import kd.wtc.wtpm.vo.suppleapply.AdCheckContext;
import kd.wtc.wtpm.vo.suppleapply.AdCheckVo;

public abstract class AbstractSupSignCheckService
implements ISupSignCheckService {
    protected static final Log LOG = LogFactory.getLog(AbstractSupSignCheckService.class);
    protected AdCheckContext ctx;
    protected List<AdCheckVo> remainAdCheckVoList;
    protected List<Long> attFileBoIdList;
    protected List<Long> attPersonIdList;

    protected AbstractSupSignCheckService(AdCheckContext adCheckContext) {
        this.ctx = adCheckContext;
    }

    public DynamicObject getDyDate(List<DynamicObject> dys, Date date, boolean isTimeHis) {
        return SignCardCommonService.getDyDate(dys, date, isTimeHis);
    }

    public void setErrorMsg(AdCheckVo adCheckVo, SupSignCheckErrorMsgEnum msgEnum, Object ... params) {
        adCheckVo.setCheckPass(false);
        if (this.ctx.getBillType() == SignCardBillTypeEnum.SELF_BILL || this.ctx.getBillType() == SignCardBillTypeEnum.OTHER_BILL) {
            adCheckVo.setErrorMsg(String.format(Locale.ROOT, (String)msgEnum.getSingleSupSign().get(), params));
        } else if (this.ctx.getBillType() == SignCardBillTypeEnum.SUPSIGN_BATCHBILL) {
            adCheckVo.setErrorMsg(String.format(Locale.ROOT, (String)msgEnum.getBatchSupSign().get(), params));
        } else if (this.ctx.getBillType() == SignCardBillTypeEnum.SIGNCARD_BILL) {
            adCheckVo.setErrorMsg(String.format(Locale.ROOT, (String)msgEnum.getSignCardApply().get(), params));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("AbstractSupSignCheckService setErrorMsg result:{}", (Object)adCheckVo.getErrorMsg());
        }
    }

    protected void setErrorMsg(AdCheckVo adCheckVo, String format, Object ... params) {
        String errorMsg;
        block3: {
            adCheckVo.setCheckPass(false);
            errorMsg = MessageFormat.format(format, params);
            try {
                errorMsg = String.format(Locale.ROOT, errorMsg, params);
            }
            catch (Exception exception) {
                if (!LOG.isWarnEnabled()) break block3;
                LOG.warn("AbstractSupSignCheckService setErrorMsg error result:{}", (Object)errorMsg);
            }
        }
        adCheckVo.setErrorMsg(errorMsg);
        if (LOG.isDebugEnabled()) {
            LOG.debug("AbstractSupSignCheckService setErrorMsg result:{}", (Object)adCheckVo.getErrorMsg());
        }
    }

    protected void getRemainAdCheckVoList() {
        this.remainAdCheckVoList = new ArrayList<AdCheckVo>(10);
        HashSet attFileIdSet = Sets.newHashSetWithExpectedSize((int)10);
        HashSet attPersonIdSet = Sets.newHashSetWithExpectedSize((int)10);
        for (AdCheckVo adCheckVo : this.ctx.getAdCheckVoList()) {
            if (!adCheckVo.isCheckPass() || !this.busDiffCheck(adCheckVo)) continue;
            this.remainAdCheckVoList.add(adCheckVo);
            attFileIdSet.add(adCheckVo.getAttFileId());
            attPersonIdSet.add(adCheckVo.getPersonId());
        }
        this.attPersonIdList = Lists.newArrayList((Iterable)attPersonIdSet);
        this.attFileBoIdList = Lists.newArrayList((Iterable)attFileIdSet);
    }

    protected boolean busDiffCheck(AdCheckVo adCheckVo) {
        return true;
    }

    public String date2Str(Date date) {
        if (date == null) {
            return "";
        }
        return WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)date);
    }
}

