/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.signcard.validator;

import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.exception.ORMDesignException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.web.billservice.attfile.BillAttFileService;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.enums.file.AttStatusEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileF7QueryParam;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtpm.business.signcard.SignCardCommonService;
import kd.wtc.wtpm.business.signcard.validator.AbstractSupSignCheckService;
import kd.wtc.wtpm.constants.suppleapply.SupSignKDString;
import kd.wtc.wtpm.enums.SignCardBillTypeEnum;
import kd.wtc.wtpm.enums.SupSignCheckErrorMsgEnum;
import kd.wtc.wtpm.vo.suppleapply.AdCheckContext;
import kd.wtc.wtpm.vo.suppleapply.AdCheckVo;

public class AttFileCheckService
extends AbstractSupSignCheckService {
    private boolean checkPerm = true;
    protected static final Log LOG = LogFactory.getLog(AttFileCheckService.class);
    private Map<Long, List<DynamicObject>> attFileVListMap = new HashMap<Long, List<DynamicObject>>(0);
    private Map<Long, List<DynamicObject>> attFileVAuthListMap = new HashMap<Long, List<DynamicObject>>(0);
    private boolean checkResult = true;
    private static final Set<String> USABLESTATUS = Sets.newHashSet((Object[])new String[]{"0", "-1"});

    public AttFileCheckService(AdCheckContext ctx) {
        super(ctx);
    }

    public AttFileCheckService(AdCheckContext ctx, boolean checkPerm) {
        super(ctx);
        this.checkPerm = checkPerm;
    }

    @Override
    public void init() {
        if (this.remainAdCheckVoList != null) {
            return;
        }
        this.getRemainAdCheckVoList();
        List<DynamicObject> attFileList = this.queryAttFiles(false, null);
        this.attFileVListMap = attFileList.stream().collect(Collectors.groupingBy(item -> item.getLong("boid")));
        List<DynamicObject> attFileAuthList = this.queryAttFiles(true, "id,boid");
        this.attFileVAuthListMap = attFileAuthList.stream().collect(Collectors.groupingBy(item -> item.getLong("boid")));
    }

    @Override
    public boolean check() {
        if (CollectionUtils.isEmpty((Collection)this.remainAdCheckVoList)) {
            return true;
        }
        for (AdCheckVo adCheckVo : this.remainAdCheckVoList) {
            if (!adCheckVo.isCheckPass()) continue;
            this.checkAttFile(adCheckVo);
        }
        if (this.ctx.getBillType().isCheckPerm() && this.checkPerm) {
            this.checkPermission();
        }
        if (this.ctx.getBillType() != SignCardBillTypeEnum.OTHER_BILL && this.ctx.getBillType() != SignCardBillTypeEnum.SELF_BILL) {
            this.checkAttFileUsableStatus();
        }
        return this.checkResult;
    }

    private void checkPermission() {
        if (!CollectionUtils.isEmpty((Collection)this.attFileBoIdList)) {
            for (AdCheckVo adCheckVo : this.remainAdCheckVoList) {
                Set hasAuthIdSet;
                if (!adCheckVo.isCheckPass()) continue;
                Long attFileId = adCheckVo.getAttFileId();
                List<DynamicObject> attFileVList = this.attFileVAuthListMap.get(attFileId);
                if (attFileVList == null) {
                    attFileVList = new ArrayList<DynamicObject>(0);
                }
                if ((hasAuthIdSet = attFileVList.stream().map(item -> item.getLong("id")).collect(Collectors.toSet())).contains(adCheckVo.getAttFileVid())) continue;
                if (this.ctx.getBillType() == SignCardBillTypeEnum.OTHER_BILL) {
                    this.setErrorMsg(adCheckVo, SupSignKDString.outPerm(), adCheckVo.getPersonName(), this.date2Str(adCheckVo.getSignDate()));
                } else if (this.ctx.getBillType() == SignCardBillTypeEnum.SELF_BILL) {
                    this.setErrorMsg(adCheckVo, SupSignKDString.outPermSelf(), this.date2Str(adCheckVo.getSignDate()));
                } else {
                    adCheckVo.setCheckPass(false);
                }
                adCheckVo.setNotRunType(1);
                this.checkResult = false;
            }
        }
    }

    private void checkAttFile(AdCheckVo adCheckVo) {
        if (!CollectionUtils.isEmpty((Collection)this.attFileBoIdList)) {
            List<DynamicObject> attFileVList = this.attFileVListMap.get(adCheckVo.getAttFileId());
            if (CollectionUtils.isEmpty(attFileVList)) {
                LOG.info("AttFileCheckService.checkAttFile shiftBelongDate is not in attFile effDate.");
                this.setAttFileCheckErrorMsg(adCheckVo);
                this.checkResult = false;
                return;
            }
            List<DynamicObject> filterAttFileList = SignCardCommonService.filterAttFileByDateRange(attFileVList, adCheckVo.getShiftBelongDate(), adCheckVo.getShiftBelongDate());
            if (!CollectionUtils.isEmpty(filterAttFileList)) {
                DynamicObject attFileVDy = filterAttFileList.get(0);
                this.checkAttFileStatus(attFileVDy, adCheckVo);
                if (!adCheckVo.isCheckPass()) {
                    return;
                }
                adCheckVo.setAttFileVid(Long.valueOf(attFileVDy.getLong("id")));
                adCheckVo.setAttFileVersion(attFileVDy);
                Date shiftBelongDate = adCheckVo.getShiftBelongDate();
                LocalDate localDate = WTCDateUtils.toLocalDate((Date)shiftBelongDate);
                List tuple2s = BillAttFileService.getInstance().missWorkExperience(localDate, localDate, (List)Lists.newArrayList((Object[])new DynamicObject[]{attFileVDy}));
                if (WTCCollections.isNotEmpty((Collection)tuple2s)) {
                    if (this.ctx.getBillType() == SignCardBillTypeEnum.OTHER_BILL || this.ctx.getBillType() == SignCardBillTypeEnum.SELF_BILL) {
                        adCheckVo.setErrorMsg(MessageFormat.format(SupSignKDString.workExpChangeSingle(), BillCommonService.getInstance().handleTimePariInfo(tuple2s)));
                        adCheckVo.setCheckPass(false);
                        this.checkResult = false;
                    } else {
                        adCheckVo.setErrorMsg(SupSignKDString.workExpChange());
                    }
                }
            } else {
                this.setAttFileCheckErrorMsg(adCheckVo);
                adCheckVo.setNotRunType(3);
                this.checkResult = false;
            }
        }
    }

    private void setAttFileCheckErrorMsg(AdCheckVo adCheckVo) {
        Date startDate = null;
        Date endDate = null;
        DynamicObject attFile = adCheckVo.getAttFile();
        if (attFile != null) {
            try {
                startDate = attFile.getDate("startdate");
                endDate = attFile.getDate("enddate");
                Date bSed = attFile.getDate("bsed");
                Date bSled = attFile.getDate("bsled");
                if (endDate.compareTo(bSed) > 0) {
                    startDate = bSed;
                    endDate = bSled;
                }
            }
            catch (ORMDesignException e) {
                LOG.warn("setAttFileCheckErrorMsg warn:{}", (Object)e.getMessage());
            }
        }
        this.setErrorMsg(adCheckVo, SupSignCheckErrorMsgEnum.AttFileEffCheck, this.date2Str(adCheckVo.getSignDate()), this.date2Str(startDate), this.date2Str(endDate));
    }

    private void checkAttFileStatus(DynamicObject attFileVDy, AdCheckVo adCheckVo) {
        if (attFileVDy.containsProperty("atttag.attendstatus") && AttStatusEnum.ATT_STOP.getCode().equals(attFileVDy.getString("atttag.attendstatus"))) {
            this.setErrorMsg(adCheckVo, SupSignCheckErrorMsgEnum.AttFileStatusCheck, this.date2Str(adCheckVo.getSignDate()));
            this.checkResult = false;
            adCheckVo.setNotRunType(2);
        }
    }

    private void checkAttFileUsableStatus() {
        if (!CollectionUtils.isEmpty((Collection)this.attFileBoIdList)) {
            for (AdCheckVo adCheckVo : this.remainAdCheckVoList) {
                String usableStatus;
                DynamicObject attFile;
                if (!adCheckVo.isCheckPass() || (attFile = adCheckVo.getAttFile()) == null || !attFile.containsProperty("usablestatus") || !"-1".equals(usableStatus = attFile.getString("usablestatus"))) continue;
                this.setErrorMsg(adCheckVo, SupSignKDString.attFileDiscard(), new Object[0]);
                adCheckVo.setNotRunType(5);
                this.checkResult = false;
            }
        }
    }

    private List<DynamicObject> queryAttFiles(boolean authCheck, String queryProp) {
        AttFileF7QueryParam attFileQueryParam = new AttFileF7QueryParam();
        attFileQueryParam.setStartDate(null);
        attFileQueryParam.setEndDate(null);
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        attFileQueryParam.setSetBoIds((Set)Sets.newHashSet((Iterable)this.attFileBoIdList));
        attFileQueryParam.setAttStatus(null);
        attFileQueryParam.setProperties(queryProp);
        if (authCheck) {
            attFileQueryParam.setFormId(this.ctx.getBillType().getPermEntityId());
            attFileQueryParam.setPermField(this.ctx.getBillType().getPermPropKey());
            attFileQueryParam.setAppId(this.ctx.getAppId());
            attFileQueryParam.setOrgAuthCheck(true);
        }
        attFileQueryParam.setUsableStatus(USABLESTATUS);
        AttFileQueryServiceImpl attFileQueryService = AttFileQueryServiceImpl.getInstance();
        return attFileQueryService.queryAttFilesByCustomAuth(attFileQueryParam);
    }
}

