/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.signcard.validator;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.util.CollectionUtils;
import kd.wtc.wtbs.business.web.billservice.attfile.BillAttFileService;
import kd.wtc.wtbs.business.web.evaluation.EvaluationServiceHelper;
import kd.wtc.wtbs.common.model.evaluation.RosterRepairAndAdvance;
import kd.wtc.wtbs.common.model.period.PeriodBillCheckResult;
import kd.wtc.wtbs.common.util.Tuples;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtpm.business.signcard.SignCardCommonService;
import kd.wtc.wtpm.business.signcard.supplyapply.helper.SupSignHelper;
import kd.wtc.wtpm.business.signcard.supplyapply.service.LimitationRangeService;
import kd.wtc.wtpm.business.signcard.validator.AbstractSupSignCheckService;
import kd.wtc.wtpm.enums.SupSignCheckErrorMsgEnum;
import kd.wtc.wtpm.enums.TimeRangeEnum;
import kd.wtc.wtpm.vo.suppleapply.AdCheckContext;
import kd.wtc.wtpm.vo.suppleapply.AdCheckVo;

public class AttPeriodCheckService
extends AbstractSupSignCheckService {
    private boolean checkTimeSet = true;
    private boolean checkCountSet = true;
    private PeriodBillCheckResult periodBillCheckResult = null;
    private boolean checkResult = true;
    private Map<Long, List<RosterRepairAndAdvance>> rosterInfoGroupByAttFileMap;

    public AttPeriodCheckService(AdCheckContext ctx) {
        super(ctx);
    }

    public AttPeriodCheckService(AdCheckContext ctx, boolean checkTimeSet, boolean checkCountSet) {
        super(ctx);
        this.checkTimeSet = checkTimeSet;
        this.checkCountSet = checkCountSet;
    }

    @Override
    public void init() {
        if (this.remainAdCheckVoList != null) {
            return;
        }
        this.getRemainAdCheckVoList();
        if (CollectionUtils.isEmpty((Collection)this.remainAdCheckVoList)) {
            return;
        }
        if (this.checkCountSet) {
            DynamicObject[] countSetArr = SupSignHelper.queryCountSet(this.ctx.getCountSetIdSet());
            for (AdCheckVo adCheckVo : this.remainAdCheckVoList) {
                Optional<DynamicObject> any;
                long countSetId = SignCardCommonService.getObjectId(adCheckVo.getAdRuleDy(), "countset");
                if (countSetId == 0L || !(any = Arrays.stream(countSetArr).filter(countSetDy -> countSetId == countSetDy.getLong("id")).findAny()).isPresent()) continue;
                DynamicObject countSetDy2 = any.get();
                adCheckVo.setCountSetDy(countSetDy2);
            }
        }
        this.initTimeSet();
        Map<Long, List<LocalDate>> needQueryPeriodPersonMap = this.initNeedQueryPeriodPersonList(this.remainAdCheckVoList);
        if (!CollectionUtils.isEmpty(needQueryPeriodPersonMap)) {
            this.periodBillCheckResult = LimitationRangeService.getPerAttPeriods(needQueryPeriodPersonMap);
        }
    }

    @Override
    public boolean check() {
        if (CollectionUtils.isEmpty((Collection)this.remainAdCheckVoList)) {
            LOG.info("AbstractSupSignCheckService AttPeriodCheckService remainAdCheckVoList isEmpty");
            return true;
        }
        for (int index = this.remainAdCheckVoList.size() - 1; index >= 0; --index) {
            this.checkAttPeriod((AdCheckVo)this.remainAdCheckVoList.get(index));
        }
        LOG.info("AbstractSupSignCheckService AttPeriodCheckService check result:{}", (Object)this.checkResult);
        return this.checkResult;
    }

    private void checkAttPeriod(AdCheckVo adCheckVo) {
        DynamicObject countSetDy;
        DynamicObject timeSetDy = adCheckVo.getTimeSetDy();
        if (adCheckVo.isCheckPass() && timeSetDy != null && this.checkTimeSet) {
            this.setDateRangeByTime(adCheckVo, this.periodBillCheckResult);
        }
        if ((countSetDy = adCheckVo.getCountSetDy()) != null && this.checkCountSet) {
            if (adCheckVo.isCheckPass()) {
                this.setDateRangeByCount(adCheckVo, this.periodBillCheckResult);
            }
            if (adCheckVo.isCheckPass()) {
                this.setDateRangeByCountReason(adCheckVo, this.periodBillCheckResult);
            }
        }
    }

    private void setDateRangeByTime(AdCheckVo adCheckVo, PeriodBillCheckResult billCheckResult) {
        DynamicObject timeSetDy = adCheckVo.getTimeSetDy();
        boolean hasAttPeriod = true;
        String timeScope = timeSetDy.getString("timescope");
        Date nowDate = WTCDateUtils.toDate((LocalDate)LocalDate.now());
        if (TimeRangeEnum.CUSTOM.getCode().equals(timeScope)) {
            String dayType = timeSetDy.getString("daytype");
            int advDaySco = timeSetDy.getInt("advdaysco");
            Date signDate = adCheckVo.getShiftBelongDate();
            Date timeRangeStart = null;
            if ("B".equals(dayType)) {
                RosterRepairAndAdvance rosterRepairAndAdvance;
                List<RosterRepairAndAdvance> rosterRepairAndAdvances = this.rosterInfoGroupByAttFileMap.get(adCheckVo.getAttFileId());
                Optional<RosterRepairAndAdvance> first = rosterRepairAndAdvances.stream().filter(item -> item.getCompareDate().equals(signDate)).findFirst();
                if (first.isPresent() && (rosterRepairAndAdvance = first.get()).getWorkDays() > rosterRepairAndAdvance.getNeedRepairDays()) {
                    timeRangeStart = rosterRepairAndAdvance.getLatestDate();
                }
            } else {
                timeRangeStart = WTCDateUtils.getZeroDate((Date)WTCDateUtils.getCustomDate((Date)nowDate, (Integer)(advDaySco * -1)));
            }
            adCheckVo.setTimeBeginDate(timeRangeStart);
            adCheckVo.setTimeEndDate(nowDate);
        } else {
            hasAttPeriod = this.setTimeLimitPerAttPeriodDate(timeScope, billCheckResult, adCheckVo);
        }
        this.checkResult = hasAttPeriod;
        if (!hasAttPeriod) {
            this.setErrorMsg(adCheckVo, SupSignCheckErrorMsgEnum.AttPeriodCheck, this.date2Str(nowDate));
        }
    }

    private void setDateRangeByCount(AdCheckVo adCheckVo, PeriodBillCheckResult billCheckResult) {
        DynamicObject countSetDy = adCheckVo.getCountSetDy();
        String limitType = countSetDy.getString("limittype");
        if ("A".equals(limitType)) {
            boolean hasAttPeriod = true;
            String countSco = countSetDy.getString("countsco");
            Date signDate = adCheckVo.getShiftBelongDate();
            if (TimeRangeEnum.PERIOD.getCode().equals(countSco)) {
                Long personId;
                BillAttFileService attFileService;
                Optional periodStartAndEnd;
                Optional<Object> any = Optional.empty();
                if (billCheckResult != null && (periodStartAndEnd = (attFileService = new BillAttFileService()).getPeriodStartAndEnd(this.periodBillCheckResult, (personId = (personId = adCheckVo.getPersonId()) == null ? Long.valueOf(0L) : personId).longValue(), WTCDateUtils.toLocalDate((Date)signDate), WTCDateUtils.toLocalDate((Date)signDate))).isPresent()) {
                    any = Optional.of(new Tuples.Tuple2((Object)WTCDateUtils.toDate((LocalDate)((LocalDate)((Tuples.Tuple2)periodStartAndEnd.get()).item1)), (Object)WTCDateUtils.toDate((LocalDate)((LocalDate)((Tuples.Tuple2)periodStartAndEnd.get()).item2))));
                }
                if (any.isPresent()) {
                    adCheckVo.setCountBeginDate((Date)((Tuples.Tuple2)any.get()).item1);
                    adCheckVo.setCountEndDate((Date)((Tuples.Tuple2)any.get()).item2);
                } else {
                    hasAttPeriod = false;
                }
            } else {
                Tuple<Date, Date> tuple = LimitationRangeService.getTimeScope(countSco, signDate);
                adCheckVo.setCountBeginDate((Date)tuple.item1);
                adCheckVo.setCountEndDate((Date)tuple.item2);
            }
            this.checkResult = hasAttPeriod;
            this.setAttPeriodCheckErrorMsg(adCheckVo, hasAttPeriod);
        }
    }

    private void setDateRangeByCountReason(AdCheckVo adCheckVo, PeriodBillCheckResult billCheckResult) {
        DynamicObject countSetDy = adCheckVo.getCountSetDy();
        String limitType = countSetDy.getString("limittype");
        if (!"B".equals(limitType)) {
            return;
        }
        boolean hasAttPeriod = true;
        DynamicObjectCollection reasonCountSetColl = countSetDy.getDynamicObjectCollection("entryentity");
        DynamicObject reason = adCheckVo.getReason();
        if (reason == null) {
            return;
        }
        long applyReasonId = reason.getLong("id");
        for (DynamicObject reasonCountSet : reasonCountSetColl) {
            long reasonId = reasonCountSet.getLong("reason.id");
            if (reasonId != applyReasonId) continue;
            String entryCountSco = reasonCountSet.getString("enticountsco");
            Date signDate = adCheckVo.getShiftBelongDate();
            if (TimeRangeEnum.PERIOD.getCode().equals(entryCountSco)) {
                Long personId;
                BillAttFileService attFileService;
                Optional periodStartAndEnd;
                Optional<Object> any = Optional.empty();
                if (billCheckResult != null && (periodStartAndEnd = (attFileService = new BillAttFileService()).getPeriodStartAndEnd(this.periodBillCheckResult, (personId = (personId = adCheckVo.getPersonId()) == null ? Long.valueOf(0L) : personId).longValue(), WTCDateUtils.toLocalDate((Date)signDate), WTCDateUtils.toLocalDate((Date)signDate))).isPresent()) {
                    any = Optional.of(new Tuples.Tuple2((Object)WTCDateUtils.toDate((LocalDate)((LocalDate)((Tuples.Tuple2)periodStartAndEnd.get()).item1)), (Object)WTCDateUtils.toDate((LocalDate)((LocalDate)((Tuples.Tuple2)periodStartAndEnd.get()).item2))));
                }
                if (any.isPresent()) {
                    adCheckVo.setCountBeginDate((Date)((Tuples.Tuple2)any.get()).item1);
                    adCheckVo.setCountEndDate((Date)((Tuples.Tuple2)any.get()).item2);
                    continue;
                }
                hasAttPeriod = false;
                continue;
            }
            Tuple<Date, Date> tuple = LimitationRangeService.getTimeScope(entryCountSco, signDate);
            adCheckVo.setCountBeginDate((Date)tuple.item1);
            adCheckVo.setCountEndDate((Date)tuple.item2);
        }
        this.checkResult = hasAttPeriod;
        this.setAttPeriodCheckErrorMsg(adCheckVo, hasAttPeriod);
    }

    private boolean setTimeLimitPerAttPeriodDate(String countSco, PeriodBillCheckResult billCheckResult, AdCheckVo adCheckVo) {
        Date now = WTCDateUtils.toDate((LocalDate)LocalDate.now());
        boolean hasAttPeriod = true;
        if (TimeRangeEnum.PERIOD.getCode().equals(countSco)) {
            Optional<Object> any = Optional.empty();
            if (billCheckResult != null) {
                BillAttFileService billAttFileService;
                Optional periodStartAndEnd;
                Long personId = adCheckVo.getPersonId();
                Date shiftBelongDate = adCheckVo.getShiftBelongDate();
                Long l = personId = personId == null ? Long.valueOf(0L) : personId;
                if (shiftBelongDate != null && (periodStartAndEnd = (billAttFileService = new BillAttFileService()).getPeriodStartAndEnd(billCheckResult, personId.longValue(), WTCDateUtils.toLocalDate((Date)shiftBelongDate), LocalDate.now())).isPresent()) {
                    Tuples.Tuple2 localDateLocalDateTuple = (Tuples.Tuple2)periodStartAndEnd.get();
                    any = Optional.of(new Tuples.Tuple2((Object)WTCDateUtils.toDate((LocalDate)((LocalDate)localDateLocalDateTuple.item1)), (Object)WTCDateUtils.toDate((LocalDate)((LocalDate)localDateLocalDateTuple.item2))));
                }
            }
            if (any.isPresent()) {
                adCheckVo.setTimeBeginDate((Date)((Tuples.Tuple2)any.get()).item1);
                adCheckVo.setTimeEndDate((Date)((Tuples.Tuple2)any.get()).item2);
            } else {
                hasAttPeriod = false;
            }
        } else {
            Tuple<Date, Date> tuple = LimitationRangeService.getTimeScope(countSco, now);
            adCheckVo.setTimeBeginDate((Date)tuple.item1);
            adCheckVo.setTimeEndDate((Date)tuple.item2);
        }
        return hasAttPeriod;
    }

    private void setAttPeriodCheckErrorMsg(AdCheckVo adCheckVo, boolean hasAttPeriod) {
        if (!hasAttPeriod) {
            this.setErrorMsg(adCheckVo, SupSignCheckErrorMsgEnum.AttPeriodCheck, this.date2Str(adCheckVo.getSignDate()));
        }
    }

    private void initTimeSet() {
        if (this.checkTimeSet) {
            List<DynamicObject> timeSetList = SupSignHelper.queryTimeSet(this.ctx.getTimeSetIdSet());
            HashSet rosterRepairAndAdvances = Sets.newHashSetWithExpectedSize((int)this.remainAdCheckVoList.size());
            Date nowDate = new Date();
            for (AdCheckVo adCheckVo : this.remainAdCheckVoList) {
                String dayType;
                Optional<DynamicObject> any;
                long timeSetId = SignCardCommonService.getObjectId(adCheckVo.getAdRuleDy(), "timeset");
                if (timeSetId == 0L || !(any = timeSetList.stream().filter(timeSetDy -> timeSetId == timeSetDy.getLong("id")).findAny()).isPresent()) continue;
                DynamicObject timeSetDy2 = any.get();
                adCheckVo.setTimeSetDy(timeSetDy2);
                String timeScope = timeSetDy2.getString("timescope");
                if (!TimeRangeEnum.CUSTOM.getCode().equals(timeScope) || !"B".equals(dayType = timeSetDy2.getString("daytype"))) continue;
                RosterRepairAndAdvance rosterRepairAndAdvance = new RosterRepairAndAdvance(adCheckVo.getAttFileId(), nowDate, adCheckVo.getShiftBelongDate());
                rosterRepairAndAdvance.setNeedRepairDays(Integer.valueOf(timeSetDy2.getInt("advdaysco")));
                rosterRepairAndAdvances.add(rosterRepairAndAdvance);
            }
            if (!CollectionUtils.isEmpty((Collection)rosterRepairAndAdvances)) {
                Set workDays = EvaluationServiceHelper.getWorkDays((Set)rosterRepairAndAdvances);
                LOG.info("AttPeriodCheckService.EvaluationServiceHelper.getWorkDays.end\uff0crosterRepairAndAdvances size ={},workDays size={}", (Object)rosterRepairAndAdvances.size(), (Object)workDays.size());
                this.rosterInfoGroupByAttFileMap = workDays.stream().collect(Collectors.groupingBy(RosterRepairAndAdvance::getAttFileBoId));
            }
        }
    }

    private Map<Long, List<LocalDate>> initNeedQueryPeriodPersonList(List<AdCheckVo> remainAdCheckVoList) {
        HashMap<Long, List<LocalDate>> needQueryPeriodPersonMap = new HashMap<Long, List<LocalDate>>(16);
        for (AdCheckVo adCheckVo : remainAdCheckVoList) {
            this.initNeedQueryPeriodPersonListByCountSet(adCheckVo, needQueryPeriodPersonMap);
            DynamicObject timeSetDy = adCheckVo.getTimeSetDy();
            if (timeSetDy == null) continue;
            String timeScope = timeSetDy.getString("timescope");
            if (!TimeRangeEnum.PERIOD.getCode().equals(timeScope)) continue;
            Long personId = adCheckVo.getPersonId();
            List localDates = needQueryPeriodPersonMap.computeIfAbsent(personId, k -> new ArrayList(10));
            Date shiftBelongDate = adCheckVo.getShiftBelongDate();
            if (shiftBelongDate != null) {
                localDates.add(WTCDateUtils.toLocalDate((Date)shiftBelongDate));
            }
            localDates.add(LocalDate.now());
        }
        return needQueryPeriodPersonMap;
    }

    private void initNeedQueryPeriodPersonListByCountSet(AdCheckVo adCheckVo, Map<Long, List<LocalDate>> needQueryPeriodPerson) {
        DynamicObject countSetDy = adCheckVo.getCountSetDy();
        Long personId = adCheckVo.getPersonId();
        if (countSetDy != null) {
            String countSco = countSetDy.getString("countsco");
            if (TimeRangeEnum.PERIOD.getCode().equals(countSco)) {
                List localDates = needQueryPeriodPerson.computeIfAbsent(personId, k -> new ArrayList(10));
                Date shiftBelongDate = adCheckVo.getShiftBelongDate();
                if (shiftBelongDate != null) {
                    localDates.add(WTCDateUtils.toLocalDate((Date)shiftBelongDate));
                }
                localDates.add(LocalDate.now());
            } else {
                DynamicObjectCollection byReasonColl = countSetDy.getDynamicObjectCollection("entryentity");
                for (DynamicObject byReasonDy : byReasonColl) {
                    String byReasonCountSco = byReasonDy.getString("enticountsco");
                    if (!TimeRangeEnum.PERIOD.getCode().equals(byReasonCountSco)) continue;
                    List localDates = needQueryPeriodPerson.computeIfAbsent(personId, k -> new ArrayList(10));
                    Date shiftBelongDate = adCheckVo.getShiftBelongDate();
                    if (shiftBelongDate != null) {
                        localDates.add(WTCDateUtils.toLocalDate((Date)shiftBelongDate));
                    }
                    localDates.add(LocalDate.now());
                    break;
                }
            }
        }
    }
}

