/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.signcard.validator;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.orm.util.CollectionUtils;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.WTTESystemParamQueryUtil;
import kd.wtc.wtp.business.attstateinfo.AttStateInfoService;
import kd.wtc.wtp.common.model.attstateinfo.FrozenBO;
import kd.wtc.wtpm.business.signcard.validator.AbstractSupSignCheckService;
import kd.wtc.wtpm.enums.SignCardBillTypeEnum;
import kd.wtc.wtpm.enums.SupSignCheckErrorMsgEnum;
import kd.wtc.wtpm.vo.suppleapply.AdCheckContext;
import kd.wtc.wtpm.vo.suppleapply.AdCheckVo;

public class FrozenDateCheckService
extends AbstractSupSignCheckService {
    private Map<Long, FrozenBO> wtteInfoMap = new HashMap<Long, FrozenBO>(16);
    private boolean checkResult = true;

    public FrozenDateCheckService(AdCheckContext ctx) {
        super(ctx);
    }

    @Override
    public void init() {
        boolean inFrozen;
        boolean frozenAddSignCard;
        if (this.remainAdCheckVoList != null) {
            return;
        }
        this.getRemainAdCheckVoList();
        if (CollectionUtils.isEmpty((Collection)this.remainAdCheckVoList)) {
            return;
        }
        if (this.ctx.getBillType() == SignCardBillTypeEnum.SIGNCARD_BILL ? !(frozenAddSignCard = SystemParamQueryUtil.isFrozenAddSignCard()) : !(inFrozen = WTTESystemParamQueryUtil.getBillTypeSystemParam((long)BillTypeEnum.SUPPLEMENTBILL.getFrozenBillTypeId()))) {
            return;
        }
        this.wtteInfoMap = AttStateInfoService.getInstance().queryFrozenRange(this.attFileBoIdList);
    }

    @Override
    public boolean check() {
        if (CollectionUtils.isEmpty(this.wtteInfoMap)) {
            return true;
        }
        for (AdCheckVo adCheckVo : this.remainAdCheckVoList) {
            FrozenBO wtteInfoDy = this.wtteInfoMap.get(adCheckVo.getAttFileId());
            if (wtteInfoDy == null) continue;
            this.checkFrozenDate(adCheckVo, wtteInfoDy);
        }
        return this.checkResult;
    }

    private void checkFrozenDate(AdCheckVo adCheckVo, FrozenBO wtteInfoDy) {
        Date frozenStartDate = wtteInfoDy.getStart();
        Date frozenEndDate = wtteInfoDy.getEnd();
        if (frozenStartDate == null || frozenEndDate == null) {
            return;
        }
        Date shiftBelongDate = adCheckVo.getShiftBelongDate();
        if (shiftBelongDate.compareTo(frozenStartDate) >= 0 && shiftBelongDate.compareTo(frozenEndDate) <= 0) {
            String signDate = "";
            if (this.ctx.getBillType() == SignCardBillTypeEnum.SELF_BILL || this.ctx.getBillType() == SignCardBillTypeEnum.OTHER_BILL) {
                signDate = this.date2Str(adCheckVo.getSignDate());
            }
            this.setErrorMsg(adCheckVo, SupSignCheckErrorMsgEnum.FrozenDateCheck, signDate, this.date2Str(frozenStartDate), this.date2Str(frozenEndDate));
            this.checkResult = false;
        }
    }
}

