/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.signcard.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.wtc.wtpm.business.signcard.SignCardCommonService;
import kd.wtc.wtpm.business.signcard.supplyapply.helper.SupSignHisHelper;
import kd.wtc.wtpm.business.signcard.validator.AbstractSupSignCheckService;
import kd.wtc.wtpm.enums.SupSignCheckErrorMsgEnum;
import kd.wtc.wtpm.vo.suppleapply.AdCheckContext;
import kd.wtc.wtpm.vo.suppleapply.AdCheckVo;

public class PlanCheckService
extends AbstractSupSignCheckService {
    private boolean checkResult = true;

    public PlanCheckService(AdCheckContext ctx) {
        super(ctx);
    }

    @Override
    public void init() {
        if (this.remainAdCheckVoList != null) {
            return;
        }
        this.getRemainAdCheckVoList();
        if (CollectionUtils.isEmpty((Collection)this.remainAdCheckVoList)) {
            return;
        }
        Map<Long, List<DynamicObject>> planHisMap = SupSignHisHelper.getPlanHis(this.ctx.getPlanIdSet(), (Date)this.ctx.getBillMaxDateRange().item1, (Date)this.ctx.getBillMaxDateRange().item2);
        ArrayList<DynamicObject> adPlanList = new ArrayList<DynamicObject>(this.remainAdCheckVoList.size());
        for (AdCheckVo adCheckVo : this.remainAdCheckVoList) {
            Date signDate;
            DynamicObject planDy2;
            long planId = SignCardCommonService.getObjectId(adCheckVo.getAttPlanDy(), "ad");
            List<DynamicObject> planList = planHisMap.get(planId);
            if (CollectionUtils.isEmpty(planList) || (planDy2 = this.getDyDate(planList, signDate = adCheckVo.getShiftBelongDate(), true)) == null) continue;
            adPlanList.add(planDy2);
            adCheckVo.setAdPlanDy(planDy2);
        }
        Set ruleIdSet = adPlanList.stream().filter(planDy -> !"2".equals(planDy.getString("ruletype"))).map(adPlan -> SignCardCommonService.getObjectId(adPlan, "rule")).collect(Collectors.toSet());
        this.ctx.setRuleIdSet(ruleIdSet);
    }

    @Override
    public boolean check() {
        if (CollectionUtils.isEmpty((Collection)this.remainAdCheckVoList)) {
            LOG.info("AbstractSupSignCheckService PlanCheckService remainAdCheckVoList isEmpty");
            return true;
        }
        for (AdCheckVo adCheckVo : this.remainAdCheckVoList) {
            this.checkPlan(adCheckVo);
        }
        LOG.info("AbstractSupSignCheckService PlanCheckService check result:{}", (Object)this.checkResult);
        return this.checkResult;
    }

    private void checkPlan(AdCheckVo adCheckVo) {
        if (adCheckVo.getAdPlanDy() == null) {
            this.setErrorMsg(adCheckVo, SupSignCheckErrorMsgEnum.PlanCheck, this.date2Str(adCheckVo.getSignDate()));
            this.checkResult = false;
        }
    }
}

