/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.signcard.validator;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtpm.business.signcard.validator.AttFileCheckService;
import kd.wtc.wtpm.business.signcard.validator.AttFilePlanCheckService;
import kd.wtc.wtpm.business.signcard.validator.AttPeriodCheckService;
import kd.wtc.wtpm.business.signcard.validator.CountSetCheckService;
import kd.wtc.wtpm.business.signcard.validator.FrozenDateCheckService;
import kd.wtc.wtpm.business.signcard.validator.ISupSignCheckService;
import kd.wtc.wtpm.business.signcard.validator.PlanCheckService;
import kd.wtc.wtpm.business.signcard.validator.ReasonCheckService;
import kd.wtc.wtpm.business.signcard.validator.RuleCheckService;
import kd.wtc.wtpm.business.signcard.validator.ShiftCheckService;
import kd.wtc.wtpm.business.signcard.validator.SignDateCheckService;
import kd.wtc.wtpm.business.signcard.validator.TimeSetCheckService;
import kd.wtc.wtpm.enums.SignCardBillTypeEnum;
import kd.wtc.wtpm.vo.suppleapply.AdCheckContext;
import kd.wtc.wtpm.vo.suppleapply.AdCheckVo;

public class SupSignCheckServiceHandler {
    private static final Log LOG = LogFactory.getLog(SupSignCheckServiceHandler.class);
    private AdCheckContext ctx;
    private ISupSignCheckService checkService;
    private Map<String, ISupSignCheckService> checkserviceMap = Maps.newHashMapWithExpectedSize((int)10);
    private Map<String, Boolean> hasinitMap = Maps.newHashMapWithExpectedSize((int)10);
    private List<Class<? extends ISupSignCheckService>> singleBillCheck = Lists.newArrayList((Object[])new Class[]{SignDateCheckService.class, AttFileCheckService.class, FrozenDateCheckService.class, ShiftCheckService.class, AttFilePlanCheckService.class, PlanCheckService.class, RuleCheckService.class, AttPeriodCheckService.class, TimeSetCheckService.class, CountSetCheckService.class});
    private List<Class<? extends ISupSignCheckService>> singleBillCheckEdit = Lists.newArrayList(this.singleBillCheck);
    private List<Class<? extends ISupSignCheckService>> batchCheck = Lists.newArrayList((Object[])new Class[]{SignDateCheckService.class, AttFileCheckService.class, FrozenDateCheckService.class, ShiftCheckService.class, AttFilePlanCheckService.class, PlanCheckService.class, RuleCheckService.class, ReasonCheckService.class, AttPeriodCheckService.class, TimeSetCheckService.class, CountSetCheckService.class});
    private List<Class<? extends ISupSignCheckService>> signcardCheck = Lists.newArrayList((Object[])new Class[]{AttFileCheckService.class, ShiftCheckService.class, FrozenDateCheckService.class});

    public SupSignCheckServiceHandler(List<AdCheckVo> adCheckVoList, SignCardBillTypeEnum billType) {
        this(adCheckVoList, billType, null);
    }

    public SupSignCheckServiceHandler(List<AdCheckVo> adCheckVoList, SignCardBillTypeEnum billType, String appId) {
        this.ctx = new AdCheckContext();
        this.ctx.setAdCheckVoList(adCheckVoList);
        this.ctx.setBillType(billType);
        if (HRStringUtils.isNotEmpty((String)appId)) {
            this.ctx.setAppId(appId);
        } else {
            this.ctx.setAppId(billType.getPermAppNumber());
        }
        if (!CollectionUtils.isEmpty(adCheckVoList)) {
            HashSet allDateSet = Sets.newHashSetWithExpectedSize((int)adCheckVoList.size());
            for (AdCheckVo adCheckVo : adCheckVoList) {
                allDateSet.add(adCheckVo.getShiftBelongDate());
            }
            List sortedAllDateList = allDateSet.stream().sorted().collect(Collectors.toList());
            Tuple billMaxDateRange = new Tuple(sortedAllDateList.get(0), sortedAllDateList.get(sortedAllDateList.size() - 1));
            this.ctx.setBillMaxDateRange(billMaxDateRange);
        }
    }

    private SupSignCheckServiceHandler resetCheckService(Class<? extends ISupSignCheckService> checkServiceClass) {
        String className = checkServiceClass.getName();
        this.checkService = this.checkserviceMap.computeIfAbsent(className, key -> {
            try {
                Constructor constructor = checkServiceClass.getConstructor(AdCheckContext.class);
                this.checkService = (ISupSignCheckService)constructor.newInstance(this.ctx);
            }
            catch (Exception ex) {
                LOG.error("SupSignCheckServiceHandler.resetCheckService error.", (Throwable)ex);
                return null;
            }
            return this.checkService;
        });
        return this;
    }

    public boolean supSignCheck() {
        return this.execute(this.singleBillCheck);
    }

    public boolean supSignBatchCheck() {
        return this.execute(this.batchCheck);
    }

    public boolean signCardApplyCheck() {
        return this.execute(this.signcardCheck);
    }

    public boolean singleBillEditCheck() {
        return this.execute(this.singleBillCheckEdit);
    }

    private boolean execute(List<Class<? extends ISupSignCheckService>> serviceList) {
        boolean success = true;
        for (Class<? extends ISupSignCheckService> clazz : serviceList) {
            boolean result = this.resetCheckService(clazz).init().check();
            if (result) continue;
            success = false;
        }
        return success;
    }

    private boolean check() {
        if (CollectionUtils.isEmpty((Collection)this.ctx.getAdCheckVoList())) {
            return false;
        }
        return this.checkService.check();
    }

    private SupSignCheckServiceHandler init() {
        if (CollectionUtils.isEmpty((Collection)this.ctx.getAdCheckVoList())) {
            return this;
        }
        if (!this.hasinitMap.containsKey(this.checkService.toString())) {
            this.checkService.init();
            this.hasinitMap.put(this.checkService.toString(), Boolean.TRUE);
        }
        return this;
    }
}

