/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.signcard.validator;

import java.util.Collection;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.wtc.wtpm.business.signcard.validator.AbstractSupSignCheckService;
import kd.wtc.wtpm.enums.SignCardBillTypeEnum;
import kd.wtc.wtpm.enums.SupSignCheckErrorMsgEnum;
import kd.wtc.wtpm.vo.suppleapply.AdCheckContext;
import kd.wtc.wtpm.vo.suppleapply.AdCheckVo;

public class TimeSetCheckService
extends AbstractSupSignCheckService {
    private static final Log LOG = LogFactory.getLog(TimeSetCheckService.class);
    private boolean checkResult = true;

    public TimeSetCheckService(AdCheckContext ctx) {
        super(ctx);
    }

    @Override
    public void init() {
        LOG.info("TimeSetCheckService.init");
        if (this.remainAdCheckVoList != null) {
            return;
        }
        this.getRemainAdCheckVoList();
    }

    @Override
    public boolean check() {
        if (CollectionUtils.isEmpty((Collection)this.remainAdCheckVoList)) {
            return true;
        }
        LOG.info("TimeSetCheckService.start");
        for (int index = 0; index < this.remainAdCheckVoList.size(); ++index) {
            AdCheckVo adCheckVo = (AdCheckVo)this.remainAdCheckVoList.get(index);
            this.checkTimeSet(adCheckVo);
        }
        LOG.info("TimeSetCheckService.end.checkResult:{}", (Object)this.checkResult);
        return this.checkResult;
    }

    private void checkTimeSet(AdCheckVo adCheckVo) {
        boolean isOutRange;
        DynamicObject timeSetDy = adCheckVo.getTimeSetDy();
        if (timeSetDy == null) {
            return;
        }
        Date signDate = adCheckVo.getShiftBelongDate();
        Date timeRangeStart = adCheckVo.getTimeBeginDate();
        Date timeRangeEnd = adCheckVo.getTimeEndDate();
        if (timeRangeStart == null || timeRangeEnd == null || signDate == null) {
            return;
        }
        boolean bl = isOutRange = signDate.compareTo(timeRangeStart) < 0 || signDate.compareTo(timeRangeEnd) > 0;
        if (isOutRange) {
            this.checkResult = false;
            if (this.ctx.getBillType() == SignCardBillTypeEnum.SELF_BILL || this.ctx.getBillType() == SignCardBillTypeEnum.OTHER_BILL) {
                this.setErrorMsg(adCheckVo, SupSignCheckErrorMsgEnum.TimeSetCheck, this.date2Str(adCheckVo.getSignDate()));
            } else {
                this.setErrorMsg(adCheckVo, SupSignCheckErrorMsgEnum.TimeSetCheck, this.date2Str(timeRangeStart), this.date2Str(timeRangeEnd));
            }
        }
    }
}

