/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.supquotapool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.util.WTCStringUtils;

public class SupQuotaPoolHelper {
    private static final HRBaseServiceHelper POOL_HELPER = new HRBaseServiceHelper("wtpm_supquotapool");

    private SupQuotaPoolHelper() {
    }

    public static Map<String, DynamicObject> queryBySigns(Set<String> signSet) {
        QFilter qFilter = new QFilter("sign", "in", signSet);
        qFilter.and("isvalid", "=", (Object)Boolean.TRUE);
        DynamicObject[] dynamicObjects = POOL_HELPER.loadDynamicObjectArray(qFilter.toArray());
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return new HashMap<String, DynamicObject>(0);
        }
        return Arrays.stream(dynamicObjects).collect(Collectors.toMap(item -> item.getString("sign"), Function.identity()));
    }

    public static DynamicObject genEmptyPoolDy() {
        return POOL_HELPER.generateEmptyDynamicObject();
    }

    public static void updateSupQuotaPool(Collection<DynamicObject> needSavePoolList) {
        if (!CollectionUtils.isEmpty(needSavePoolList)) {
            POOL_HELPER.update(needSavePoolList.toArray(new DynamicObject[0]));
        }
    }

    public static void invalidByAttFileIdAndDate(long attFileBoId, Set<Date> signDateSet, Set<Long> excludePoolIdSet, Set<Long> reasonIds) {
        QFilter qFilter = new QFilter("attfile", "=", (Object)attFileBoId);
        qFilter.and("id", "not in", excludePoolIdSet);
        qFilter.and("isvalid", "=", (Object)Boolean.TRUE);
        String queryField = WTCStringUtils.joinOnComma((String[])new String[]{"timescopebegin", "timescopeend", "isvalid", "reason"});
        DynamicObject[] pools = POOL_HELPER.query(queryField, qFilter.toArray());
        ArrayList<DynamicObject> updatePoolList = new ArrayList<DynamicObject>(pools.length);
        for (Date date : signDateSet) {
            for (DynamicObject poolDy : pools) {
                if (poolDy.getDate("timescopebegin").compareTo(date) > 0 || poolDy.getDate("timescopeend").compareTo(date) < 0) continue;
                long reasonId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)poolDy, (String)"reason");
                if (reasonId != 0L && reasonIds.contains(reasonId)) {
                    updatePoolList.add(poolDy);
                }
                if (reasonId != 0L) continue;
                updatePoolList.add(poolDy);
            }
        }
        if (!CollectionUtils.isEmpty(updatePoolList)) {
            updatePoolList.forEach(item -> item.set("isvalid", (Object)Boolean.FALSE));
            POOL_HELPER.update(updatePoolList.toArray(new DynamicObject[0]));
        }
    }
}

