/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.formplugin.cardmatch;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.wtc.wtbs.business.web.file.schedule.AttFileScheduleServiceImpl;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.enums.signcard.PointTagEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileScheduleQueryParam;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtpm.business.cardmatch.CardMatchHelper;
import kd.wtc.wtpm.business.cardmatch.SignCardService;
import kd.wtc.wtpm.constants.sign.CardMatchConstants;
import kd.wtc.wtpm.constants.sign.CardMatchKDString;

public class MultiCardEditPlugin
extends HRCoreBaseBillEdit
implements CardMatchConstants {
    public void afterCreateNewData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.getModel().deleteEntryData("entryentity");
        Long id = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        this.generateEntry(id);
    }

    private void generateEntry(Long id) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtpm_multicard");
        DynamicObject data = helper.loadSingle((Object)id);
        if (HRObjectUtils.isEmpty((Object)data)) {
            return;
        }
        DynamicObjectCollection multiCardEntry = data.getDynamicObjectCollection("entryentity");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity");
        DynamicObjectCollection entry = model.getEntryEntity("entryentity");
        for (DynamicObject multiCard : multiCardEntry) {
            boolean isLast;
            DynamicObject row = new DynamicObject(entry.getDynamicObjectType());
            boolean isFirst = multiCardEntry.indexOf((Object)multiCard) == 0;
            boolean bl = isLast = multiCardEntry.indexOf((Object)multiCard) == multiCardEntry.size() - 1;
            if (!isFirst && !isLast) continue;
            row.set("attperson", (Object)data.getDynamicObject("attperson"));
            row.set("shift", (Object)data.getDynamicObject("shift"));
            row.set("shiftdate", (Object)data.getDate("shiftdate"));
            row.set("signpoint", (Object)multiCard.getDate("effectivepoint"));
            row.set("multipointutc", (Object)multiCard.getDate("multipointutc"));
            row.set("timezone", (Object)multiCard.getLong("timezone.id"));
            row.set("oldpointtag", (Object)multiCard.getString("pointtag"));
            row.set("accesstag", (Object)multiCard.getString("accesstag"));
            row.set("source", (Object)multiCard.getDynamicObject("source"));
            row.set("device", (Object)multiCard.getLong("device.id"));
            row.set("attfile", (Object)data.getDynamicObject("attfile"));
            row.set("attcard", (Object)data.getString("attcard"));
            row.set("org", (Object)data.getDynamicObject("org"));
            row.set("mustpoint", (Object)multiCard.getDate("mustpoint"));
            entry.add((Object)row);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key = args.getOperateKey();
        if (HRStringUtils.equals((String)"confirm", (String)key)) {
            DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
            String message = this.validRequest(entry);
            if (HRStringUtils.isNotEmpty((String)message)) {
                this.getView().showTipNotification(message);
                return;
            }
            this.reMatchCard(entry);
        }
    }

    private String validRequest(DynamicObjectCollection entry) {
        Long attPersonId = ((DynamicObject)entry.get(0)).getLong("attperson.id");
        Long attFileBoId = ((DynamicObject)entry.get(0)).getLong("attfile.boid");
        Date shiftDate = ((DynamicObject)entry.get(0)).getDate("shiftdate");
        AttFileScheduleQueryParam param = new AttFileScheduleQueryParam();
        param.setBoId(attFileBoId.longValue());
        param.setStartDate(shiftDate);
        param.setEndDate(shiftDate);
        param.setLoad(Boolean.TRUE);
        Map timeZoneMap = AttFileScheduleServiceImpl.getInstance().queryAttFileSchedule(AttFileScheduleEnum.TZ, param);
        List timeZoneList = (List)timeZoneMap.get(attFileBoId);
        if (CollectionUtils.isEmpty((Collection)timeZoneList)) {
            return CardMatchKDString.notTimeZoneTips((String)WTCDateUtils.toLocalDate((Date)shiftDate).toString());
        }
        int timeDiff = ((DynamicObject)timeZoneList.get(0)).getInt("tz.timedif");
        for (DynamicObject row : entry) {
            boolean isFirst;
            String oldPointTag = row.getString("oldpointtag");
            String pointTag = row.getString("pointtag");
            Date signPoint = row.getDate("signpoint");
            Date multiPointUtc = row.getDate("multipointutc");
            boolean bl = isFirst = entry.indexOf((Object)row) == 0;
            if (null == signPoint || HRStringUtils.isEmpty((String)pointTag)) continue;
            String signPointStr = WTCInteDateUtil.formatBySysTzAndUserFmt((Date)signPoint);
            if (HRStringUtils.equals((String)oldPointTag, (String)pointTag)) {
                return CardMatchKDString.signPointChangeTips((String)signPointStr);
            }
            Date currentDate = row.getDate("shiftdate");
            String frozenMsg = CardMatchHelper.isFrozenAttFile((Date)currentDate, (Long)attPersonId);
            if (HRStringUtils.isNotEmpty((String)frozenMsg)) {
                return frozenMsg;
            }
            Date mustPoint = row.getDate("mustpoint");
            String errMsg = null != mustPoint ? this.validNotOffShift(mustPoint, timeDiff, multiPointUtc, isFirst, row, attPersonId, attFileBoId) : this.validOffShift(entry, isFirst, row, attPersonId, attFileBoId);
            if (!HRStringUtils.isNotEmpty((String)errMsg)) continue;
            return errMsg;
        }
        return null;
    }

    private String validNotOffShift(Date mustPoint, int timeDiff, Date multiPointUtc, boolean isFirst, DynamicObject row, Long attPersonId, Long attFileBoId) {
        LocalDateTime mustDateUtc = WTCDateUtils.toLocalDateTime((Date)mustPoint).minusHours(timeDiff);
        Date mustPointUtc = WTCDateUtils.toDate((LocalDateTime)mustDateUtc);
        if (null != multiPointUtc && isFirst && multiPointUtc.after(mustPointUtc)) {
            return CardMatchKDString.pointTagFirstTips();
        }
        if (null != multiPointUtc && !isFirst && multiPointUtc.before(mustPointUtc)) {
            return CardMatchKDString.pointTagLastTips();
        }
        Date currentDate = row.getDate("shiftdate");
        String oldPointTag = row.getString("oldpointtag");
        String pointTag = row.getString("pointtag");
        Date signPoint = row.getDate("signpoint");
        Date manualDate = isFirst ? WTCDateUtils.getCustomDate((Date)currentDate, (Integer)-1) : WTCDateUtils.getCustomDate((Date)currentDate, (Integer)1);
        String tagMsg = CardMatchHelper.isLegalTag((boolean)isFirst, (String)oldPointTag, (String)pointTag, (Date)signPoint);
        if (HRStringUtils.isNotEmpty((String)tagMsg)) {
            return tagMsg;
        }
        String attFileMsg = CardMatchHelper.isLegalAttFile((Date)manualDate, (Long)attPersonId, (Long)attFileBoId);
        if (HRStringUtils.isNotEmpty((String)attFileMsg)) {
            return attFileMsg;
        }
        String shiftMsg = CardMatchHelper.isLegalShift((Date)manualDate, (Long)attPersonId, (Long)attFileBoId);
        if (HRStringUtils.isNotEmpty((String)shiftMsg)) {
            return shiftMsg;
        }
        return null;
    }

    private String validOffShift(DynamicObjectCollection entry, boolean isFirst, DynamicObject row, Long attPersonId, Long attFileBoId) {
        Date currentDate = row.getDate("shiftdate");
        String oldPointTag = row.getString("oldpointtag");
        String pointTag = row.getString("pointtag");
        Date signPoint = row.getDate("signpoint");
        String dateString = WTCInteDateUtil.formatBySysTzAndUserFmt((Date)signPoint);
        boolean onSign = false;
        boolean offSign = false;
        Map<String, Object> tagMap = this.validOffShiftTag(isFirst, entry, oldPointTag, pointTag, onSign, offSign);
        String errMsg = (String)tagMap.get("errMsg");
        if (HRStringUtils.isNotEmpty((String)errMsg)) {
            return errMsg;
        }
        onSign = (Boolean)tagMap.get("onSign");
        errMsg = this.validOffShiftTag(onSign, offSign = ((Boolean)tagMap.get("offSign")).booleanValue(), oldPointTag, pointTag, dateString);
        if (HRStringUtils.isNotEmpty((String)errMsg)) {
            return errMsg;
        }
        Date manualDate = this.getShiftManualDate(currentDate, oldPointTag, pointTag);
        String attFileMsg = CardMatchHelper.isLegalAttFile((Date)manualDate, (Long)attPersonId, (Long)attFileBoId);
        if (HRStringUtils.isNotEmpty((String)attFileMsg)) {
            return attFileMsg;
        }
        String shiftMsg = CardMatchHelper.isLegalShift((Date)manualDate, (Long)attPersonId, (Long)attFileBoId);
        if (HRStringUtils.isNotEmpty((String)shiftMsg)) {
            return shiftMsg;
        }
        return null;
    }

    private String validOffShiftTag(boolean onSign, boolean offSign, String oldPointTag, String pointTag, String dateString) {
        boolean isNext;
        boolean isCurrent = PointTagEnum.AUTO_CURRENT.getCode().equals(oldPointTag) || PointTagEnum.MANUAL_CURRENT.getCode().equals(oldPointTag);
        boolean isPrevious = PointTagEnum.AUTO_PREVIOUS.getCode().equals(oldPointTag) || PointTagEnum.MANUAL_PREVIOUS.getCode().equals(oldPointTag);
        boolean bl = isNext = PointTagEnum.AUTO_NEXT.getCode().equals(oldPointTag) || PointTagEnum.MANUAL_NEXT.getCode().equals(oldPointTag);
        if (onSign && !offSign && isCurrent && !PointTagEnum.MANUAL_PREVIOUS.getCode().equals(pointTag)) {
            String msg = ResManager.loadKDString((String)"\u53ea\u53ef\u6539\u4e3a\u524d\u4e00\u4e2a\u73ed\u6b21\u4e0b\u73ed\u5361\u3002", (String)"MultiCardEditPlugin_0", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]);
            return dateString + msg;
        }
        if (onSign && !offSign && isNext && !PointTagEnum.MANUAL_CURRENT.getCode().equals(pointTag)) {
            String msg = ResManager.loadKDString((String)"\u53ea\u53ef\u6539\u4e3a\u5f53\u5929\u73ed\u6b21\u4e0b\u73ed\u5361\u3002", (String)"MultiCardEditPlugin_1", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]);
            return dateString + msg;
        }
        if (offSign && !onSign && isCurrent && !PointTagEnum.MANUAL_NEXT.getCode().equals(pointTag)) {
            String msg = ResManager.loadKDString((String)"\u53ea\u53ef\u6539\u4e3a\u540e\u4e00\u4e2a\u73ed\u6b21\u4e0a\u73ed\u5361\u3002", (String)"MultiCardEditPlugin_2", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]);
            return dateString + msg;
        }
        if (offSign && !onSign && isPrevious && !PointTagEnum.MANUAL_CURRENT.getCode().equals(pointTag)) {
            String msg = ResManager.loadKDString((String)"\u53ea\u53ef\u6539\u4e3a\u5f53\u5929\u73ed\u6b21\u4e0a\u73ed\u5361\u3002", (String)"MultiCardEditPlugin_3", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]);
            return dateString + msg;
        }
        if (offSign && onSign && isNext && !PointTagEnum.MANUAL_CURRENT.getCode().equals(pointTag)) {
            String msg = ResManager.loadKDString((String)"\u53ea\u53ef\u6539\u4e3a\u5f53\u5929\u73ed\u6b21\u4e0a\u73ed\u5361\u3002", (String)"MultiCardEditPlugin_4", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]);
            return dateString + msg;
        }
        if (offSign && onSign && isPrevious && !PointTagEnum.MANUAL_CURRENT.getCode().equals(pointTag)) {
            String msg = ResManager.loadKDString((String)"\u53ea\u53ef\u6539\u4e3a\u5f53\u5929\u73ed\u6b21\u4e0a\u73ed\u5361\u3002", (String)"MultiCardEditPlugin_5", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]);
            return dateString + msg;
        }
        return null;
    }

    private Map<String, Object> validOffShiftTag(boolean isFirst, DynamicObjectCollection entry, String oldPointTag, String pointTag, boolean onSign, boolean offSign) {
        boolean isPrevious;
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        String errMsg = null;
        boolean isCurrent = PointTagEnum.AUTO_CURRENT.getCode().equals(oldPointTag) || PointTagEnum.MANUAL_CURRENT.getCode().equals(oldPointTag);
        boolean bl = isPrevious = PointTagEnum.AUTO_PREVIOUS.getCode().equals(oldPointTag) || PointTagEnum.MANUAL_PREVIOUS.getCode().equals(oldPointTag);
        if (isFirst) {
            onSign = true;
            Date lastSignPoint = ((DynamicObject)entry.get(entry.size() - 1)).getDate("signpoint");
            if (null != lastSignPoint) {
                if (isCurrent && PointTagEnum.MANUAL_NEXT.getCode().equals(pointTag)) {
                    errMsg = CardMatchKDString.tagOnToNextOnTips();
                }
                if (isPrevious && PointTagEnum.MANUAL_CURRENT.getCode().equals(pointTag)) {
                    errMsg = CardMatchKDString.tagOnToNextOn2Tips();
                }
            } else {
                offSign = true;
            }
        } else {
            offSign = true;
            Date firstSignPoint = ((DynamicObject)entry.get(0)).getDate("signpoint");
            if (null != firstSignPoint) {
                if (isCurrent && PointTagEnum.MANUAL_PREVIOUS.getCode().equals(pointTag)) {
                    errMsg = CardMatchKDString.tagOffToPreOffTips();
                }
            } else {
                onSign = true;
            }
        }
        map.put("errMsg", errMsg);
        map.put("onSign", onSign);
        map.put("offSign", offSign);
        return map;
    }

    private Date getShiftManualDate(Date currentDate, String oldPointTag, String pointTag) {
        if ((PointTagEnum.AUTO_CURRENT.getCode().equals(oldPointTag) || PointTagEnum.MANUAL_CURRENT.getCode().equals(oldPointTag)) && PointTagEnum.MANUAL_PREVIOUS.getCode().equals(pointTag)) {
            return WTCDateUtils.getCustomDate((Date)currentDate, (Integer)-1);
        }
        if ((PointTagEnum.AUTO_CURRENT.getCode().equals(oldPointTag) || PointTagEnum.MANUAL_CURRENT.getCode().equals(oldPointTag)) && PointTagEnum.MANUAL_NEXT.getCode().equals(pointTag)) {
            return WTCDateUtils.getCustomDate((Date)currentDate, (Integer)1);
        }
        if ((PointTagEnum.AUTO_PREVIOUS.getCode().equals(oldPointTag) || PointTagEnum.MANUAL_PREVIOUS.getCode().equals(oldPointTag)) && PointTagEnum.MANUAL_CURRENT.getCode().equals(pointTag)) {
            return WTCDateUtils.getCustomDate((Date)currentDate, (Integer)1);
        }
        if ((PointTagEnum.AUTO_NEXT.getCode().equals(oldPointTag) || PointTagEnum.MANUAL_NEXT.getCode().equals(oldPointTag)) && PointTagEnum.MANUAL_CURRENT.getCode().equals(pointTag)) {
            return WTCDateUtils.getCustomDate((Date)currentDate, (Integer)-1);
        }
        return currentDate;
    }

    private void reMatchCard(DynamicObjectCollection entry) {
        boolean legal = false;
        Date currentDate = ((DynamicObject)entry.get(0)).getDate("shiftdate");
        LocalDate localDate = currentDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        long attPersonId = ((DynamicObject)entry.get(0)).getLong("attperson.id");
        long attFileId = ((DynamicObject)entry.get(0)).getLong("attfile.id");
        Date taskStart = currentDate;
        Date taskEnd = currentDate;
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"wtpm_pointtaglog");
        for (DynamicObject row : entry) {
            String oldPointTag = row.getString("oldpointtag");
            String pointTag = row.getString("pointtag");
            if (HRStringUtils.isEmpty((String)pointTag) || HRStringUtils.equals((String)oldPointTag, (String)pointTag) || null == row.getDate("signpoint")) continue;
            Date manualDate = this.getShiftManualDate(currentDate, oldPointTag, pointTag);
            if (manualDate.before(currentDate)) {
                taskStart = manualDate;
            }
            if (manualDate.after(currentDate)) {
                taskEnd = manualDate;
            }
            LocalDate manualLocal = WTCDateUtils.toLocalDate((Date)manualDate);
            this.savePointTagLog(localDate, manualLocal, attPersonId, row, manualDate.before(currentDate), mainEntityType);
            legal = true;
        }
        if (legal) {
            SignCardService service = new SignCardService();
            ArrayList attPersonIds = Lists.newArrayList((Object[])new Long[]{attPersonId});
            ArrayList attFileIds = Lists.newArrayList((Object[])new Long[]{attFileId});
            service.startMatch(taskStart, taskEnd, (Collection)attPersonIds, (Collection)attFileIds, 1);
        }
        this.getView().close();
    }

    private void savePointTagLog(LocalDate currentDay, LocalDate localDate, long attPersonId, DynamicObject row, boolean isPreDate, MainEntityType mainEntityType) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtpm_pointtaglog");
        DynamicObject result = new DynamicObject((DynamicObjectType)mainEntityType);
        result.set("creator", (Object)RequestContext.get().getCurrUserId());
        result.set("createtime", (Object)new Date());
        result.set("org", (Object)RequestContext.get().getOrgId());
        result.set("vestingdate", (Object)WTCDateUtils.toDate((LocalDateTime)localDate.atStartOfDay()));
        result.set("attperson", (Object)attPersonId);
        result.set("accesstag", (Object)row.getString("accesstag"));
        result.set("multipoint", (Object)row.getDate("signpoint"));
        result.set("multipointutc", (Object)row.getDate("multipointutc"));
        result.set("timezone", (Object)row.getLong("timezone"));
        result.set("source", (Object)row.getDynamicObject("source"));
        result.set("device", (Object)row.getLong("device"));
        result.set("worktag", (Object)(isPreDate ? "1" : "0"));
        result.set("pointtag", (Object)row.getString("pointtag"));
        QFilter attPersonFilter = new QFilter("attperson", "=", (Object)attPersonId);
        QFilter currentDateFilter = new QFilter("vestingdate", "=", (Object)WTCDateUtils.toDate((LocalDateTime)currentDay.atStartOfDay()));
        QFilter signPointFilter = new QFilter("multipoint", "=", (Object)row.getDate("signpoint"));
        serviceHelper.deleteByFilter(new QFilter[]{attPersonFilter, currentDateFilter, signPointFilter});
        QFilter dateFilter = new QFilter("vestingdate", "=", (Object)WTCDateUtils.toDate((LocalDateTime)localDate.atStartOfDay()));
        QFilter workTagFilter = isPreDate ? new QFilter("worktag", "=", (Object)"1") : new QFilter("worktag", "=", (Object)"0");
        serviceHelper.deleteByFilter(new QFilter[]{attPersonFilter, dateFilter, workTagFilter});
        serviceHelper.saveOne(result);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (null != this.getView().getParentView()) {
            this.getView().getParentView().invokeOperation("refresh");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }
}

