/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.formplugin.sign.mobile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.mcontrol.mobtable.IMobTablePackageDataHandler;
import kd.bos.form.mcontrol.mobtable.MobTable;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtpm.business.sign.mobile.MobileAdBatchControlService;
import kd.wtc.wtpm.business.sign.mobile.MobileAdBatchService;
import kd.wtc.wtpm.business.sign.mobile.MobileAdBatchTablePackageHandler;
import kd.wtc.wtpm.business.signcard.supplyapply.helper.SupSignHelper;
import kd.wtc.wtpm.business.signcard.supplyapply.service.SupSignService;
import kd.wtc.wtpm.constants.suppleapply.SupSignKDString;
import kd.wtc.wtpm.vo.mobile.suppleapply.MobileAdBatchOrgPerson;
import kd.wtc.wtpm.vo.mobile.suppleapply.MobileAdBatchOrgPersonItem;

public class MobileAdBatchPlugin
extends AbstractMobFormPlugin {
    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        FormShowParameter formShowParameter = args.getFormShowParameter();
        String caption = formShowParameter.getCaption();
        if (HRStringUtils.isEmpty((String)caption)) {
            formShowParameter.setCaption(SupSignKDString.supSignBatch());
        }
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        Label priDetailLabel = (Label)this.getControl("pridetaillbl");
        if (priDetailLabel != null) {
            priDetailLabel.addClickListener((ClickListener)this);
        }
    }

    public void onGetControl(OnGetControlArgs args) {
        String[] split;
        super.onGetControl(args);
        String key = args.getKey();
        if (key.startsWith("deptflex") && (split = key.split("_")).length == 2) {
            Container container = new Container();
            container.setKey(key);
            container.setId(key);
            container.addClickListener((ClickListener)this);
            container.setView(this.getView());
            args.setControl((Control)container);
        }
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        DynamicObject billDy = this.getModel().getDataEntity();
        long billId = billDy.getLong("id");
        DynamicObject dataEntity = SupSignHelper.queryBatchBillById((Long)billId);
        String adBatchType = dataEntity.getString("batchsuptype");
        long pkId = dataEntity.getLong("id");
        if ("1".equals(adBatchType)) {
            int limit = 10;
            String queryProp = MobileAdBatchService.getAdBatchMobileListQueryProp();
            String listOrderBy = SupSignService.getAdBatchListOrderBy();
            List adBatchDataList = SupSignHelper.queryBatchBillDetailByBillId((Collection)Lists.newArrayList((Object[])new Long[]{pkId}), (Boolean)Boolean.TRUE, (String)queryProp, (String)listOrderBy, null, (int)limit);
            this.handleMobTablePriEntry(adBatchDataList);
            this.getView().setVisible(Boolean.FALSE, new String[]{"adpubinfoflex"});
            int size = SupSignHelper.queryBatchBillDetailCountByBillId((Collection)Lists.newArrayList((Object[])new Long[]{pkId}), (Boolean)Boolean.TRUE, null);
            this.getView().setVisible(Boolean.valueOf(size > 10), new String[]{"pridetaillbl"});
            Label supsignInfoLabel = (Label)this.getControl("adinfoprilbl");
            if (supsignInfoLabel != null) {
                String supSignInfo = SupSignKDString.supSignInfoCount((Object)size);
                supsignInfoLabel.setText(supSignInfo);
            }
            this.getPageCache().put("entryentitymultipri_count", String.valueOf(size));
        } else {
            String queryProp = MobileAdBatchService.getAdBatchMobilePersonQueryProp();
            List adBatchDataList = SupSignHelper.queryBatchBillDetailByBillId((Collection)Lists.newArrayList((Object[])new Long[]{pkId}), (Boolean)Boolean.TRUE, (String)queryProp);
            DynamicObjectCollection adInfoColl = dataEntity.getDynamicObjectCollection("entryentitysupinfo");
            this.handleMobTablePubEntry(adInfoColl);
            int infoSize = adInfoColl.size();
            MobileAdBatchService.showLimitDesc((int)infoSize, (int)200, SupSignKDString::detailLimitDesc, (IFormView)this.getView(), (String)"");
            Label adInfoTitleLabel = (Label)this.getControl("adinfolbl");
            if (adInfoTitleLabel != null) {
                String title = SupSignKDString.supSignInfoCount((Object)infoSize);
                adInfoTitleLabel.setText(title);
            }
            this.handleAdPersonInfo(adBatchDataList);
            this.getView().setVisible(Boolean.FALSE, new String[]{"adpriinfoflex"});
        }
    }

    public void click(EventObject evt) {
        String[] split;
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("pridetaillbl".equals(key)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            long pkId = dataEntity.getLong("id");
            MobileFormShowParameter mobileBillShowParameter = new MobileFormShowParameter();
            mobileBillShowParameter.setFormId("wtpm_adbatchprimore_m");
            mobileBillShowParameter.setCustomParam("billid", (Object)String.valueOf(pkId));
            String dataCount = this.getPageCache().get("entryentitymultipri_count");
            String caption = SupSignKDString.supSignInfoCount((Object)dataCount);
            mobileBillShowParameter.setCaption(caption);
            mobileBillShowParameter.getOpenStyle().setShowType(ShowType.Floating);
            this.getView().showForm((FormShowParameter)mobileBillShowParameter);
        } else if (key.startsWith("deptflex") && (split = key.split("_")).length == 2) {
            String orgIdStr = split[1];
            long billId = this.getModel().getDataEntity().getLong("id");
            MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
            formShowParameter.setFormId("wtpm_adbatchpubdetail_m");
            String personCount = this.getPageCache().get("adBatchPubCount");
            formShowParameter.setCaption(SupSignKDString.supSignPersonCount((Object)personCount));
            formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
            formShowParameter.setStatus(OperationStatus.VIEW);
            formShowParameter.setCustomParam("billid", (Object)String.valueOf(billId));
            formShowParameter.setCustomParam("currentOrgId", (Object)orgIdStr);
            this.getView().showForm((FormShowParameter)formShowParameter);
        }
    }

    private void handleMobTablePriEntry(List<DynamicObject> adBatchDataList) {
        MobTable mobTablePri = (MobTable)this.getControl("entryentitymultipri");
        mobTablePri.addMobTablePackageDataHandlerListener(mobTablePackageDataHandlerEvent -> {
            int showSize = Math.min(adBatchDataList.size(), 10);
            mobTablePackageDataHandlerEvent.setMobTablePackageDataHandler((IMobTablePackageDataHandler)new MobileAdBatchTablePackageHandler(adBatchDataList, showSize));
        });
    }

    private void handleMobTablePubEntry(DynamicObjectCollection adInfoColl) {
        MobTable mobTablePub = (MobTable)this.getControl("entryentitysupinfo");
        mobTablePub.addMobTablePackageDataHandlerListener(mobTablePackageDataHandlerEvent -> {
            int showSize = Math.min(adInfoColl.size(), 200);
            mobTablePackageDataHandlerEvent.setMobTablePackageDataHandler((IMobTablePackageDataHandler)new MobileAdBatchTablePackageHandler(adInfoColl, showSize));
        });
    }

    private void handleAdPersonInfo(List<DynamicObject> adBatchDataList) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        MobileAdBatchOrgPerson orgPerson = MobileAdBatchService.getMobileAdBatchOrgPerson((DynamicObject)dataEntity, adBatchDataList);
        int personCount = orgPerson.getSuccessPerson();
        this.getPageCache().put("adBatchPubCount", String.valueOf(personCount));
        Label attPersonCountLabel = (Label)this.getControl("adpersoninfolbl");
        if (attPersonCountLabel != null) {
            attPersonCountLabel.setText(SupSignKDString.supSignPersonCount((Object)personCount));
        }
        this.createDeptControl(orgPerson.getItems());
        this.getView().setVisible(Boolean.FALSE, new String[]{"maxlimitflexdept"});
        if (orgPerson.isMoreLimit()) {
            int limitSize = 10;
            int totalSize = 11;
            MobileAdBatchService.showLimitDesc((int)totalSize, (int)limitSize, SupSignKDString::deptLimitDesc, (IFormView)this.getView(), (String)"dept");
        }
    }

    private void createDeptControl(List<MobileAdBatchOrgPersonItem> orgPersonItems) {
        Container container = (Container)this.getControl("adpersoncontainer");
        ArrayList<Map> flexList = new ArrayList<Map>(orgPersonItems.size());
        for (MobileAdBatchOrgPersonItem orgPersonItem : orgPersonItems) {
            if (orgPersonItem.getTotalPerson() <= 0L) continue;
            flexList.add(MobileAdBatchControlService.createDeptFlexControl((MobileAdBatchOrgPersonItem)orgPersonItem));
        }
        container.addControls(flexList);
    }
}

