/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.formplugin.suppleapply;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillList;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskEntity;
import kd.wtc.wtbs.business.formtask.WTCTaskForm;
import kd.wtc.wtbs.business.helper.WTCTaskServiceHelper;
import kd.wtc.wtbs.business.task.base.WTCDistributeTaskHelper;
import kd.wtc.wtbs.business.task.repository.WTCTaskRepository;
import kd.wtc.wtbs.common.util.WTCCacheUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtpm.business.signcard.SignCardBatchService;
import kd.wtc.wtpm.business.signcard.supplyapply.helper.SupSignTaskHelper;
import kd.wtc.wtpm.business.signcard.supplyapply.service.SupSignService;
import kd.wtc.wtpm.business.signcard.task.BillApplyTaskService;
import kd.wtc.wtpm.constants.suppleapply.SupSignKDString;
import kd.wtc.wtpm.constants.suppleapply.SuppleApplyConstants;
import kd.wtc.wtpm.vo.suppleapply.ApplyReqVo;

public class BillApplyBatchList
extends HRCoreBaseBillList {
    protected static final Log LOG = LogFactory.getLog(BillApplyBatchList.class);
    protected static Map<String, String> confirmopmap = Maps.newHashMapWithExpectedSize((int)8);
    protected Long billId;
    protected DynamicObject billDataEntity;
    protected String opKey;
    protected String billEntityId;
    protected String taskCategory;
    protected String billNo;
    protected OperationResult operationResult = new OperationResult();
    protected List<DynamicObject> billLists;
    protected Long orgId;
    protected Set<Long> batchBillIds = Sets.newHashSetWithExpectedSize((int)16);

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        setFilterEvent.addCustomQFilter(new QFilter("billid.isvalid", "!=", (Object)Boolean.FALSE));
        setFilterEvent.addCustomQFilter(new QFilter("isvalid", "=", (Object)Boolean.TRUE));
        String listOrderBy = SupSignService.getAdBatchListOrderBy();
        setFilterEvent.setOrderBy(listOrderBy);
        Long userId = BillUnifyService.getUserId((IPageCache)this.getPageCache());
        QFilter excludeAttFileLevelFilter = BillCommonService.getInstance().getExcludeAttFileLevelFilter(this.getView(), userId, "attfile");
        setFilterEvent.addCustomQFilter(excludeAttFileLevelFilter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        List<Long> listSelectIds = this.getListSelectIds();
        if (CollectionUtils.isEmpty(listSelectIds)) {
            this.getView().showTipNotification(SupSignKDString.pleaseSelectData());
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        String operateKey = operate.getOperateKey();
        if (confirmopmap.containsKey(operateKey)) {
            afterDoOperationEventArgs.getOperationResult().setShowMessage(false);
            String opName = operate.getOperateName().getLocaleValue();
            String message = String.format(Locale.ROOT, SupSignKDString.confimMsg(), opName);
            this.getView().showConfirm(message, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(operateKey, (IFormPlugin)this));
        }
    }

    protected boolean tryOperation(DynamicObject[] batchBillArr) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("currbizappid", this.getView().getFormShowParameter().getAppId());
        this.operationResult = OperationServiceHelper.executeOperate((String)this.opKey, (String)this.billEntityId, (DynamicObject[])batchBillArr, (OperateOption)operateOption);
        if (this.operationResult.isSuccess()) {
            return true;
        }
        this.getView().showOperationResult(this.operationResult);
        return false;
    }

    protected void submitDistributeTask() {
        String opType = (String)SuppleApplyConstants.BATCH_SYNC_OP_MAP.get(this.opKey);
        Tuple applyDateRange = SignCardBatchService.getBatchApplyDateRange((DynamicObject)this.billDataEntity);
        if (HRStringUtils.isEmpty((String)opType)) {
            opType = this.opKey;
        }
        ApplyReqVo applyReqVo = new ApplyReqVo();
        applyReqVo.setBillId(this.billId);
        applyReqVo.setStartDate((Date)applyDateRange.item1);
        applyReqVo.setEndDate((Date)applyDateRange.item2);
        applyReqVo.setEntityId(this.getView().getEntityId());
        applyReqVo.setTaskCategory(this.taskCategory);
        applyReqVo.setTargetBillStatus((String)SuppleApplyConstants.BATCH_SYNC_OP_BILL_STATUS_MAP.get(opType));
        applyReqVo.setBillNo(this.billNo);
        applyReqVo.setOpType(opType);
        applyReqVo.setOrgId(this.orgId);
        applyReqVo.setDataChanged("0");
        applyReqVo.setOpSource("1");
        String caption = SupSignKDString.taskSpeedDesc();
        String jsonStr = JSON.toJSONString((Object)applyReqVo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat});
        Map paramsMap = (Map)JSON.parseObject((String)jsonStr, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskfinished");
        WTCTaskForm taskForm = new WTCTaskForm();
        taskForm.setCaption(caption);
        taskForm.setCloseCallBack(closeCallBack);
        taskForm.setCanStop(true);
        taskForm.setCanBackground(true);
        taskForm.setClickClassName("kd.wtc.wtpm.formplugin.suppleapply.task.BillApplyTaskClick");
        taskForm.setCustomParams(paramsMap);
        WTCDistributeTaskHelper.showProgress((IFormView)this.getView(), (CloseCallBack)closeCallBack, (String)caption, (String)this.taskCategory, (Object)taskForm);
        this.getPageCache().put("taskCategory", this.taskCategory);
        String cacheKey = WTCCacheUtils.getKey((String)"wtpm", (String)BillApplyTaskService.getTaskCacheKey((long)this.billId));
        WTCCacheUtils.getCache().remove(cacheKey);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("taskfinished".equals(actionId)) {
            long taskId;
            String errMsg = this.getPageCache().get("errMsg");
            if (HRStringUtils.isNotEmpty((String)errMsg)) {
                this.getView().showTipNotification(errMsg);
                return;
            }
            String taskIdStr = this.getPageCache().get("taskId");
            String taskCat = this.getPageCache().get("taskCategory");
            WTCCalTaskEntity wtcTaskEntity = WTCTaskServiceHelper.loadTaskByTaskId((String)taskCat, (long)(taskId = Long.parseLong(taskIdStr)), (QFilter)WTCTaskRepository.NO_CUSTOM_CONDITION);
            if (wtcTaskEntity.getTaskStatus().isEnd()) {
                SupSignTaskHelper.showTaskResultForm((IFormView)this.getView(), (IFormView)this.getView(), (long)taskId, (String)taskCat);
            } else {
                this.getView().close();
            }
        }
    }

    protected void validateOperationResult() {
        Map operateMap = EntityMetadataCache.getDataEntityOperate((String)((IListView)this.getView()).getBillFormId(), (String)this.opKey);
        String opName = LocaleString.fromMap((Map)((Map)operateMap.get("name"))).getLocaleValue();
        if (!this.operationResult.isSuccess()) {
            this.getView().showOperationResult(this.operationResult);
        } else if (!SuppleApplyConstants.BATCH_SYNC_OP_MAP.containsKey(this.opKey)) {
            this.getView().showSuccessNotification(String.format(Locale.ROOT, SupSignKDString.opSuccess(), opName));
        }
        BillUnifyService.refreshListData((IFormView)this.getView());
        if ("delete".equals(confirmopmap.get(this.opKey)) && this.getView() instanceof ListView) {
            ((IListView)this.getView()).clearSelection();
        }
    }

    protected List<Long> getListSelectIds() {
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        ArrayList<Long> selectIds = new ArrayList<Long>(selectedRows.size());
        for (int index = 0; index < selectedRows.size(); ++index) {
            selectIds.add((Long)selectedRows.get(index).getPrimaryKeyValue());
        }
        return selectIds;
    }

    static {
        confirmopmap.put("saveofsubmit", "submit");
        confirmopmap.put("saveofsubmiteffect", "submiteffect");
        confirmopmap.put("dounsubmit", "unsubmit");
        confirmopmap.put("dodiscard", "discard");
        confirmopmap.put("dodelete", "delete");
        confirmopmap.put("doaudit", "audit");
    }
}

