/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.formplugin.suppleapply;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskEntity;
import kd.wtc.wtbs.business.formtask.WTCTaskForm;
import kd.wtc.wtbs.business.helper.WTCTaskServiceHelper;
import kd.wtc.wtbs.business.task.base.WTCDistributeTaskHelper;
import kd.wtc.wtbs.business.task.repository.WTCTaskRepository;
import kd.wtc.wtbs.business.util.WtbsBusinessUtils;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.model.Page;
import kd.wtc.wtbs.common.model.attfile.AttFileF7QueryParam;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCCacheUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.time.StopWatch;
import kd.wtc.wtpm.business.signcard.SignCardBatchService;
import kd.wtc.wtpm.business.signcard.SignCardCommonService;
import kd.wtc.wtpm.business.signcard.supplyapply.helper.SupSignHelper;
import kd.wtc.wtpm.business.signcard.supplyapply.helper.SupSignTaskHelper;
import kd.wtc.wtpm.business.signcard.task.BillApplyTaskFactoryService;
import kd.wtc.wtpm.business.signcard.task.BillApplyTaskService;
import kd.wtc.wtpm.constants.suppleapply.SupSignKDString;
import kd.wtc.wtpm.constants.suppleapply.SuppleApplyConstants;
import kd.wtc.wtpm.formplugin.suppleapply.helper.SupSignBatchViewHelper;
import kd.wtc.wtpm.formplugin.suppleapply.helper.SupSignCommonViewHelper;
import kd.wtc.wtpm.vo.suppleapply.ApplyReqVo;

public class SignCardBatchBillEdit
extends HRCoreBaseBillEdit
implements BeforeF7SelectListener,
SuppleApplyConstants {
    protected static final Log LOG = LogFactory.getLog(SignCardBatchBillEdit.class);
    private String dataChanged = "0";
    protected Supplier<String> signCardEntryMustOne;

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        FormShowParameter formShowParameter = args.getFormShowParameter();
        this.setOrgPermCustomParam(formShowParameter);
    }

    protected void setOrgPermCustomParam(FormShowParameter formShowParameter) {
    }

    public void registerListener(EventObject args) {
        super.registerListener(args);
        BasedataEdit excPerson = (BasedataEdit)this.getControl("excperson");
        excPerson.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"toobarextraperson", "toolbarsigninfo", "toolbarwithorg"});
        BasedataEdit orgClassEdit = (BasedataEdit)this.getView().getControl("orgclass");
        orgClassEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit timezoneEdit = (BasedataEdit)this.getControl("timezone");
        timezoneEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit equipment = (BasedataEdit)this.getControl("equipment");
        equipment.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit reasonEdit = (BasedataEdit)this.getControl("applyreason");
        if (reasonEdit != null) {
            reasonEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit attFileEdit = (BasedataEdit)this.getControl("attfile");
        attFileEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"labelap1"});
    }

    public void beforePropertyChanged(PropertyChangedArgs args) {
        super.beforePropertyChanged(args);
        String name = args.getProperty().getName();
        if ("orgtype".equals(name)) {
            IDataModel model = this.getModel();
            ChangeData changeData = args.getChangeSet()[0];
            model.setValue("excperson", null, changeData.getRowIndex());
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name;
        switch (name = args.getProperty().getName()) {
            case "orgclass": {
                SupSignBatchViewHelper.orgClassChanged(args, this.getView());
                break;
            }
            case "orgtype": {
                SupSignBatchViewHelper.orgTypeChanged(args, this.getView());
                break;
            }
        }
    }

    public void afterBindData(EventObject args) {
        DateEdit priSignDateEdit;
        super.afterBindData(args);
        SignCardCommonService.setAccessTagMustInput((IFormView)this.getView());
        DateEdit signDateEdit = (DateEdit)this.getView().getControl("signdate");
        if (signDateEdit != null) {
            signDateEdit.setMaxDate(new Date());
        }
        if ((priSignDateEdit = (DateEdit)this.getView().getControl("prisigndate")) != null) {
            priSignDateEdit.setMaxDate(new Date());
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "withorg": {
                SupSignBatchViewHelper.personF7CloseCallback(closedCallBackEvent, this.getView());
                break;
            }
            case "withperson": {
                SupSignBatchViewHelper.extraPersonF7CloseCallback(closedCallBackEvent, this.getView());
                break;
            }
            case "newentry_sign": {
                SupSignBatchViewHelper.addSupSignInfo(this.getView(), closedCallBackEvent);
                break;
            }
            case "newentry_org": {
                Object returnData = closedCallBackEvent.getReturnData();
                if (returnData == null) break;
                ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
                TableValueSetter tableValueSetter = new TableValueSetter(new String[]{"orgtype", "orgclass"});
                for (ListSelectedRow selectedRow : selectedRows) {
                    tableValueSetter.addRow(new Object[]{"haos_adminorghr", selectedRow.getPrimaryKeyValue()});
                }
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                model.beginInit();
                model.batchCreateNewEntryRow("entryentityorg", tableValueSetter);
                model.endInit();
                this.getView().updateView("entryentityorg");
                break;
            }
            case "taskfinished": {
                String errMsg = this.getPageCache().get("errMsg");
                if (HRStringUtils.isNotEmpty((String)errMsg)) {
                    this.getView().showTipNotification(errMsg);
                    return;
                }
                String taskIdStr = this.getPageCache().get("taskId");
                if (HRStringUtils.isEmpty((String)taskIdStr)) {
                    return;
                }
                long taskId = Long.parseLong(taskIdStr);
                String taskCategory = BillApplyTaskFactoryService.getTaskCategory((String)this.getView().getEntityId());
                WTCCalTaskEntity wtcTaskEntity = WTCTaskServiceHelper.loadTaskByTaskId((String)taskCategory, (long)taskId, (QFilter)WTCTaskRepository.NO_CUSTOM_CONDITION);
                if (wtcTaskEntity.getTaskStatus().isEnd()) {
                    SupSignTaskHelper.showTaskResultForm((IFormView)this.getView(), (IFormView)this.getView(), (long)taskId, (String)taskCategory);
                    break;
                }
                this.getView().close();
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propName;
        switch (propName = beforeF7SelectEvent.getProperty().getName()) {
            case "excperson": {
                String sourceMethod = beforeF7SelectEvent.getSourceMethod();
                if (!"click".equals(sourceMethod)) break;
                beforeF7SelectEvent.setCancel(true);
                this.getPageCache().put("attfile_clicktype", "withorg");
                BasedataEdit basedataEdit = (BasedataEdit)this.getControl("attfile");
                basedataEdit.click();
                break;
            }
            case "applyreason": {
                SupSignBatchViewHelper.validateOrgExist(this.getView(), beforeF7SelectEvent);
                break;
            }
            case "orgclass": {
                int index = beforeF7SelectEvent.getRow();
                DynamicObjectCollection orgEntity = this.getView().getModel().getEntryEntity("entryentityorg");
                DynamicObject orgDy = (DynamicObject)orgEntity.get(index);
                String orgType = orgDy.getString("orgtype");
                Set sameOrgIds = orgEntity.stream().filter(entity -> HRStringUtils.equals((String)entity.getString("orgtype"), (String)orgType) && !HRObjectUtils.isEmpty((Object)entity.get("orgclass")) && orgDy.getLong(ORGCLASS_ID) != entity.getLong(ORGCLASS_ID)).map(org -> org.getLong(ORGCLASS_ID)).collect(Collectors.toSet());
                if (CollectionUtils.isEmpty(sameOrgIds)) break;
                QFilter qFilter = new QFilter("id", "not in", sameOrgIds);
                beforeF7SelectEvent.addCustomQFilter(qFilter);
                break;
            }
            case "equipment": 
            case "timezone": 
            case "source": {
                ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                listShowParameter.setMultiSelect(false);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "newentry_org": {
                ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"haos_adminorghr", (boolean)true);
                DynamicObjectCollection orgEntity = this.getView().getModel().getEntryEntity("entryentityorg");
                List sameOrgIds = orgEntity.stream().map(org -> org.getLong("orgclass.id")).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(sameOrgIds)) {
                    showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", sameOrgIds));
                }
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "newentry_org"));
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "newentry_person": {
                this.getPageCache().put("attfile_clicktype", "withperson");
                BasedataEdit basedataEdit = (BasedataEdit)this.getControl("attfile");
                basedataEdit.click();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean isDataChanged;
        LOG.info("SignCardBatchBillEdit.beforeDoOperation.begin");
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (!this.operationCanNext(source)) {
            return;
        }
        FormOperate operate = (FormOperate)args.getSource();
        String opKey = operate.getOperateKey();
        IDataModel dataModel = this.getView().getModel();
        DynamicObject dataEntity = dataModel.getDataEntity();
        if (SuppleApplyConstants.BATCH_SYNC_OP_MAP.containsKey(opKey)) {
            boolean billIsMulPri = SignCardBatchService.billIsMulPri((DynamicObject)dataEntity);
            if (billIsMulPri) {
                this.checkSupSignInfo(args, "entryentitymultipri", SupSignKDString.mustSupSignBatchInfoOne());
                if (args.isCancel()) {
                    return;
                }
            } else {
                this.checkSupSignInfo(args, "entryentitysupinfo", SupSignKDString.mustSupSignBatchInfoOne());
                if (args.isCancel()) {
                    return;
                }
                boolean checkResult = SupSignCommonViewHelper.checkSelectData(this.getView());
                if (!checkResult) {
                    args.setCancel(true);
                    return;
                }
                checkResult = SupSignBatchViewHelper.checkDate(this.getView());
                if (!checkResult) {
                    args.setCancel(true);
                    return;
                }
            }
            long billId = dataModel.getDataEntity().getLong("id");
            String taskCategory = BillApplyTaskFactoryService.getTaskCategory((String)this.getView().getEntityId());
            if (!SupSignCommonViewHelper.checkBillTaskIsFinished(billId, this.getView(), taskCategory)) {
                args.setCancel(true);
                return;
            }
        }
        this.dataChanged = (isDataChanged = this.getModel().getDataChanged()) ? "1" : "0";
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        LOG.info("SignCardBatchBillEdit.afterDoOperation.start");
        super.afterDoOperation(afterDoOperationEventArgs);
        if (!this.operationCanNext(afterDoOperationEventArgs.getSource())) {
            return;
        }
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            long billId = this.getModel().getDataEntity().getLong("id");
            BillApplyTaskService.deleteTaskStatusCache((long)billId);
            return;
        }
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        String operateKey = operate.getOperateKey();
        if (SuppleApplyConstants.BATCH_SYNC_OP_MAP.containsKey(operateKey)) {
            OperationResult saveResult;
            if (("saveofsubmit".equals(operateKey) || "saveofsubmiteffect".equals(operateKey)) && (saveResult = this.doSave()) != null && !saveResult.isSuccess()) {
                this.getView().showOperationResult(saveResult);
                return;
            }
            this.distributeBillApplyTask(afterDoOperationEventArgs);
            this.getView().updateView("selectpersonpanell");
        } else if ("viewattfiledetail".equals(operateKey)) {
            this.showAttFileInfoDetails();
        }
    }

    protected OperationResult doSave() {
        return null;
    }

    private void showAttFileInfoDetails() {
        HashSet adminOrgIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet excludeAttFileBoIds = Sets.newHashSetWithExpectedSize((int)16);
        ArrayList includeAttFileBoIds = new ArrayList(0);
        SignCardBatchService.getSelectAdminOrgAndExcludeAttFile((DynamicObject)this.getModel().getDataEntity(), (Set)adminOrgIds, (Set)excludeAttFileBoIds, includeAttFileBoIds);
        if (CollectionUtils.isEmpty((Collection)adminOrgIds)) {
            this.getView().showTipNotification(SupSignKDString.inputAdminOrg());
            return;
        }
        AttFileF7QueryParam attFileF7QueryParam = new AttFileF7QueryParam();
        attFileF7QueryParam.setProperties("id");
        attFileF7QueryParam.setAffiliateAdminOrgSetIds((Set)adminOrgIds);
        attFileF7QueryParam.setBoDelSetIds((Set)excludeAttFileBoIds);
        attFileF7QueryParam.setOrgAuthCheck(true);
        this.getFormPermInfo(attFileF7QueryParam);
        Long userId = BillUnifyService.getUserId((IPageCache)this.getPageCache());
        QFilter excludeAttFileLevelFilter = BillCommonService.getInstance().getExcludeAttFileLevelFilter(this.getView(), userId, "boid");
        attFileF7QueryParam.setqFilter(excludeAttFileLevelFilter);
        Page dynamicObjectPage = AttFileQueryServiceImpl.getInstance().queryAttFileF7WithPerm(attFileF7QueryParam, 0, 99999999);
        List listRecords = dynamicObjectPage.getListRecords();
        List ids = listRecords.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        ListShowParameter parameter = new ListShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("ids", ids);
        parameter.setBillFormId("wtp_attfileinfoquerylist");
        parameter.setFormId("wtpm_listborderless");
        parameter.setHasRight(true);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("1000");
        styleCss.setHeight("600");
        parameter.getOpenStyle().setInlineStyleCss(styleCss);
        parameter.setCaption(SupSignKDString.captionAttFileInfoDetails());
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected void checkSupSignInfo(BeforeDoOperationEventArgs args, String entryKey, String errorMsg) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryKey);
        DynamicObject[] dataEntities = entryGrid.getEntryData().getDataEntitys();
        if (dataEntities == null || dataEntities.length == 0) {
            this.getView().showTipNotification(errorMsg);
            args.setCancel(true);
        }
    }

    protected void handleLoadData(LoadDataEventArgs args, QFilter qFilter, DynamicObject dataEntity) {
        boolean superUser;
        DynamicObjectCollection attFileEntryColl = dataEntity.getDynamicObjectCollection("entryentityperson");
        if (!CollectionUtils.isEmpty((Collection)attFileEntryColl) && !(superUser = WtbsBusinessUtils.isSuperUser())) {
            Set selectEntryAttFileBoIdSet = attFileEntryColl.stream().map(item -> item.getLong("exteaattfile.boid")).collect(Collectors.toSet());
            AttFileQueryParam attFileQueryParam = new AttFileQueryParam(WTCStringUtils.joinOnComma((String[])new String[]{"id", "boid"}));
            attFileQueryParam.setAuthCheck(Boolean.FALSE);
            attFileQueryParam.setBeCurrent(Boolean.FALSE);
            attFileQueryParam.setAttStatus(null);
            attFileQueryParam.setqFilter(qFilter);
            attFileQueryParam.setSetBoIds(selectEntryAttFileBoIdSet);
            List attFileList = SupSignHelper.queryAttFile((AttFileQueryParam)attFileQueryParam);
            if (CollectionUtils.isEmpty((Collection)attFileList)) {
                attFileEntryColl.clear();
            } else {
                List attFileVIdList = attFileList.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
                Iterator iterator = attFileEntryColl.iterator();
                while (iterator.hasNext()) {
                    DynamicObject attFileEntryDy = (DynamicObject)iterator.next();
                    long attFileVId = attFileEntryDy.getLong("exteaattfile.id");
                    if (attFileVIdList.contains(attFileVId)) continue;
                    iterator.remove();
                }
            }
        }
        args.setDataEntity(dataEntity);
    }

    private void distributeBillApplyTask(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        afterDoOperationEventArgs.getOperationResult().setShowMessage(false);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Tuple applyDateRange = SignCardBatchService.getBatchApplyDateRange((DynamicObject)dataEntity);
        String opKey = afterDoOperationEventArgs.getOperateKey();
        String targetOp = (String)SuppleApplyConstants.BATCH_SYNC_OP_MAP.get(opKey);
        String targetBillStatus = (String)SuppleApplyConstants.BATCH_SYNC_OP_BILL_STATUS_MAP.get(targetOp);
        String billNo = dataEntity.getString("billno");
        String taskCategory = BillApplyTaskFactoryService.getTaskCategory((String)this.getView().getEntityId());
        long billId = dataEntity.getLong("id");
        ApplyReqVo applyReqVo = new ApplyReqVo();
        applyReqVo.setBillId(Long.valueOf(billId));
        applyReqVo.setStartDate((Date)applyDateRange.item1);
        applyReqVo.setEndDate((Date)applyDateRange.item2);
        applyReqVo.setEntityId(this.getView().getEntityId());
        applyReqVo.setTaskCategory(taskCategory);
        applyReqVo.setTargetBillStatus(targetBillStatus);
        applyReqVo.setBillNo(billNo);
        applyReqVo.setOpType(targetOp);
        applyReqVo.setOrgId(Long.valueOf(dataEntity.getLong("org.id")));
        applyReqVo.setDataChanged(this.dataChanged);
        applyReqVo.setOpSource("0");
        String jsonStr = JSON.toJSONString((Object)applyReqVo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat});
        Map paramsMap = (Map)JSON.parseObject((String)jsonStr, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskfinished");
        String caption = SupSignKDString.taskSpeedDesc();
        WTCTaskForm taskForm = new WTCTaskForm();
        taskForm.setType(taskCategory);
        taskForm.setCaption(caption);
        taskForm.setCloseCallBack(closeCallBack);
        taskForm.setCanStop(true);
        taskForm.setCanBackground(true);
        taskForm.setClickClassName("kd.wtc.wtpm.formplugin.suppleapply.task.BillApplyTaskClick");
        taskForm.setCustomParams(paramsMap);
        StopWatch watch = StopWatch.createStarted();
        WTCDistributeTaskHelper.showProgress((IFormView)this.getView(), (CloseCallBack)closeCallBack, (String)caption, (String)taskCategory, (Object)taskForm);
        watch.stop();
        LOG.info("SignCardBatchBillEdit.afterDoOperation.end,dispatchTask Time:{}", (Object)watch.getTime());
        String cacheKey = WTCCacheUtils.getKey((String)"wtpm", (String)BillApplyTaskService.getTaskCacheKey((long)billId));
        WTCCacheUtils.getCache().remove(cacheKey);
    }

    @Deprecated
    protected String getAffiliateAdminOrgQFilter() {
        return null;
    }

    protected QFilter getDataRuleForBdProp() {
        QFilter qFilter = null;
        if (!WtbsBusinessUtils.isSuperUser()) {
            qFilter = this.getPermRuleQFilter();
        }
        return qFilter;
    }

    protected QFilter getPermRuleQFilter() {
        return null;
    }

    protected void getFormPermInfo(AttFileF7QueryParam attFileF7QueryParam) {
    }

    private boolean operationCanNext(Object source) {
        AbstractOperate save;
        OperateOption option;
        return !(source instanceof AbstractOperate) || !Boolean.parseBoolean((option = (save = (AbstractOperate)source).getOption()).getVariableValue("cancelThisOperation", "false"));
    }
}

