/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.formplugin.suppleapply;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.util.WTCOrgUtils;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.enums.AttModeEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileF7QueryParam;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.wtp.enums.supple.SuppleReasonEnum;
import kd.wtc.wtpm.business.signcard.SignCardBatchService;
import kd.wtc.wtpm.business.signcard.SignCardCommonService;
import kd.wtc.wtpm.business.signcard.supplyapply.helper.SupSignHelper;
import kd.wtc.wtpm.constants.suppleapply.SupSignKDString;
import kd.wtc.wtpm.formplugin.suppleapply.SignCardBatchBillEdit;
import kd.wtc.wtpm.formplugin.suppleapply.helper.SupSignBatchViewHelper;

public class SupSignBatchBillEdit
extends SignCardBatchBillEdit {
    @Override
    protected void setOrgPermCustomParam(FormShowParameter formShowParameter) {
        super.setOrgPermCustomParam(formShowParameter);
        String propKey = "attfilev.affiliateadminorg";
        formShowParameter.setCustomParam("customHREntityNumber", (Object)"wtpm_supsignlist");
        formShowParameter.setCustomParam("customHRPermItemId", (Object)"47150e89000000ac");
        formShowParameter.setCustomParam("custom_parent_f7_prop", (Object)propKey);
    }

    @Override
    public void registerListener(EventObject args) {
        BasedataEdit priAttFileEdit;
        BasedataEdit priReasonEdit;
        BasedataEdit priEquipment;
        super.registerListener(args);
        this.addItemClickListeners(new String[]{"toolbarmultipri"});
        BasedataEdit priTimeZoneEdit = (BasedataEdit)this.getControl("pritimezone");
        if (priTimeZoneEdit != null) {
            priTimeZoneEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((priEquipment = (BasedataEdit)this.getControl("priequipment")) != null) {
            priEquipment.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((priReasonEdit = (BasedataEdit)this.getControl("priapplyreason")) != null) {
            priReasonEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((priAttFileEdit = (BasedataEdit)this.getControl("multipriattfile")) != null) {
            priAttFileEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void loadData(LoadDataEventArgs args) {
        super.loadData(args);
        QFilter dataRuleForBdPropFilter = this.getDataRuleForBdProp();
        Object pkId = args.getPkId();
        DynamicObject dataEntity = SupSignHelper.queryBatchBillById((Long)((Long)pkId));
        this.handleLoadData(args, dataRuleForBdPropFilter, dataEntity);
    }

    public void afterLoadData(EventObject evt) {
        boolean billIsMulPri;
        super.afterLoadData(evt);
        BillShowParameter formShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        BillOperationStatus billStatus = formShowParameter.getBillStatus();
        if (BillOperationStatus.EDIT.equals((Object)billStatus) && (billIsMulPri = SignCardBatchService.billIsMulPri((DynamicObject)this.getModel().getDataEntity()))) {
            this.getModel().setValue("entryentitysupinfo", null);
        }
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        super.afterCreateNewData(evt);
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        IFormView parentView = this.getView().getViewNoPlugin(parentPageId);
        if (parentView instanceof ListView) {
            long defaultSelectOrgIds = WTCOrgUtils.getDefaultSelectOrgIds((ListView)((ListView)parentView), (String)"org");
            this.getModel().setValue("org", (Object)defaultSelectOrgIds);
        }
    }

    @Override
    public void afterBindData(EventObject args) {
        super.afterBindData(args);
        this.initLackCardData();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        boolean isMultiPriSup = "1".equals(dataEntity.getString("batchsuptype"));
        this.getView().setVisible(Boolean.valueOf(isMultiPriSup), new String[]{"multiprivatepanel"});
        this.getView().setVisible(Boolean.valueOf(!isMultiPriSup), new String[]{"multipublicpanel"});
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        this.signCardEntryMustOne = SupSignKDString::mustSupSignBatchInfoOne;
        super.beforeDoOperation(args);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("newentry_sign".equals(itemKey)) {
            SupSignBatchViewHelper.openAddSignInfoForm(this.getView(), (AbstractBillPlugIn)this, "wtpm_addsupsigninfo");
        } else if ("newentry_multipri".equals(itemKey)) {
            SupSignBatchViewHelper.openAddMultiPriSupInfoForm(this.getView(), (AbstractBillPlugIn)this, "wtpm_addmultiprisupinfo");
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propName;
        super.beforeF7Select(beforeF7SelectEvent);
        switch (propName = beforeF7SelectEvent.getProperty().getName()) {
            case "attfile": {
                QFilter dataRuleForBdProp = this.getDataRuleForBdProp();
                FormShowParameter formShowParameter = beforeF7SelectEvent.getFormShowParameter();
                formShowParameter.setCustomParam("orgAppId", (Object)this.getView().getFormShowParameter().getAppId());
                formShowParameter.setCustomParam("orgEntityId", (Object)"wtpm_supsignlist");
                formShowParameter.setCustomParam("orgField", (Object)"attfilev.affiliateadminorg");
                AttFileQueryServiceImpl.getInstance().setFileF7OrgPerm(formShowParameter, "wtpm_supsignlist", this.getView().getFormShowParameter().getAppId());
                SupSignBatchViewHelper.attFileBeforeB7(this.getView(), (IFormPlugin)this, beforeF7SelectEvent, dataRuleForBdProp);
                break;
            }
            case "priapplyreason": {
                SupSignBatchViewHelper.validateOrgExist(this.getView(), beforeF7SelectEvent);
                break;
            }
            case "pritimezone": 
            case "priequipment": 
            case "prisource": {
                ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                listShowParameter.setMultiSelect(false);
                break;
            }
            case "multipriattfile": {
                ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                listShowParameter.setMultiSelect(false);
                QFilter dataRuleForBdProp = this.getDataRuleForBdProp();
                if (dataRuleForBdProp == null) break;
                listShowParameter.getListFilterParameter().getQFilters().add(dataRuleForBdProp);
                break;
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String name = args.getProperty().getName();
        if ("batchsuptype".equals(name)) {
            ChangeData changeData = args.getChangeSet()[0];
            String batchSupType = (String)changeData.getNewValue();
            boolean isMultiPriSup = "1".equals(batchSupType);
            this.getView().setVisible(Boolean.valueOf(isMultiPriSup), new String[]{"multiprivatepanel"});
            this.getView().setVisible(Boolean.valueOf(!isMultiPriSup), new String[]{"multipublicpanel"});
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("newentry_multipri".equals(actionId)) {
            SupSignBatchViewHelper.addMultiPriAddPerson(this.getView(), closedCallBackEvent);
        }
    }

    private void initLackCardData() {
        String source = (String)this.getView().getFormShowParameter().getCustomParam("from");
        String isInitLackCardData = this.getPageCache().get("isInitLackCardData");
        if ("1".equals(isInitLackCardData)) {
            return;
        }
        if (HRStringUtils.isNotEmpty((String)source) && HRStringUtils.equalsIgnoreCase((String)source, (String)"lackcardlist")) {
            this.getModel().setValue("batchsuptype", (Object)"1");
            JSONArray ids = (JSONArray)this.getView().getFormShowParameter().getCustomParam("ids");
            List idSet = JSON.parseArray((String)JSON.toJSONString((Object)ids), Long.class);
            HRBaseServiceHelper lackCardHelper = new HRBaseServiceHelper("wtpm_lackcard");
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", (Object)idSet)};
            String orderByStr = "shiftdate desc,attperson.id asc,lackpoint asc";
            DynamicObject[] lackDys = lackCardHelper.query("attfile.id,attperson.id,shiftdate,lackpoint,timezone.id,attmode", qFilters, orderByStr);
            TableValueSetter tableValueSetter = new TableValueSetter(new String[]{"multipriattfile", "prisigndate", "prisuppleworktime", "priapplyreason", "pritimezone", "pripointtag"});
            HRBaseServiceHelper reasonHelper = new HRBaseServiceHelper("wtbd_reason");
            QFilter[] reasonFilters = new QFilter[]{new QFilter("id", "=", (Object)SuppleReasonEnum.forgot_sign.getId()), new QFilter("enable", "=", (Object)"1")};
            DynamicObject reasonDy = reasonHelper.queryOne("id", reasonFilters);
            boolean isEnable = !HRObjectUtils.isEmpty((Object)reasonDy);
            for (DynamicObject lackCard : lackDys) {
                Long attFileId = lackCard.getLong("attfile.id");
                Date shiftDate = lackCard.getDate("shiftdate");
                String attMode = lackCard.getString("attmode");
                boolean isOnceCard = HRStringUtils.equalsIgnoreCase((String)attMode, (String)AttModeEnum.ONES_CARD.getCode());
                Long timeZoneId = lackCard.getLong("timezone.id");
                if (isOnceCard) {
                    shiftDate = WTCDateUtils.getZeroDate((Date)shiftDate);
                    tableValueSetter.addRow(new Object[]{attFileId, shiftDate, -1, isEnable ? SuppleReasonEnum.forgot_sign.getId() : null, timeZoneId, null});
                    continue;
                }
                LocalDate shiftLocalDate = shiftDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                Date lackPoint = lackCard.getDate("lackpoint");
                LocalDate lackLocalDate = lackPoint.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                LocalTime lackLocalTime = lackPoint.toInstant().atZone(ZoneId.systemDefault()).toLocalTime();
                int time = lackLocalTime.get(ChronoField.SECOND_OF_DAY);
                String beforeAfter = shiftLocalDate.isAfter(lackLocalDate) ? "F" : "E";
                String pointTag = shiftLocalDate.isEqual(lackLocalDate) ? "D" : beforeAfter;
                lackPoint = WTCDateUtils.getZeroDate((Date)lackPoint);
                tableValueSetter.addRow(new Object[]{attFileId, lackPoint, time, isEnable ? SuppleReasonEnum.forgot_sign.getId() : null, timeZoneId, pointTag});
            }
            AbstractFormDataModel abstractFormDataModel = (AbstractFormDataModel)this.getView().getModel();
            abstractFormDataModel.beginInit();
            abstractFormDataModel.batchCreateNewEntryRow("entryentitymultipri", tableValueSetter);
            abstractFormDataModel.endInit();
            this.getView().updateView("entryentitymultipri");
            this.getView().updateView("flexpanelap");
            this.getPageCache().put("isInitLackCardData", "1");
        }
    }

    @Override
    @Deprecated
    protected String getAffiliateAdminOrgQFilter() {
        String appId = this.getView().getFormShowParameter().getAppId();
        String entityNumber = "wtpm_supsignlist";
        String permItemId = "47150e89000000ac";
        String propKey = "attfilev.affiliateadminorg";
        List permAdminOrgIds = SignCardCommonService.getAuthorizedAdminOrgResult((String)appId, (String)entityNumber, (String)propKey, (String)permItemId);
        return SerializationUtils.toJsonString((Object)permAdminOrgIds);
    }

    @Override
    protected QFilter getPermRuleQFilter() {
        return SignCardBatchService.getDataRuleForBdProp((String)"attfilev", (String)"wtpm_supsignlist", (String)this.getView().getFormShowParameter().getAppId());
    }

    @Override
    protected void getFormPermInfo(AttFileF7QueryParam attFileF7QueryParam) {
        attFileF7QueryParam.setFormId("wtpm_supsignlist");
        attFileF7QueryParam.setPermField("attfilev");
        attFileF7QueryParam.setAppId(this.getView().getFormShowParameter().getAppId());
    }

    @Override
    protected OperationResult doSave() {
        super.doSave();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("currbizappid", this.getView().getFormShowParameter().getAppId());
        operateOption.setVariableValue("ignoreValidation", "true");
        operateOption.setVariableValue("ishasright", "true");
        operateOption.setVariableValue("isshowmessage", "false");
        operateOption.setVariableValue("cancelThisOperation", "true");
        OperationResult operationResult = this.getView().invokeOperation("saveofsave", operateOption);
        return operationResult;
    }
}

