/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.formplugin.suppleapply;

import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.enums.BillSystemParamConfigEnum;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtpm.business.signcard.supplyapply.helper.SupSignHelper;
import kd.wtc.wtpm.constants.suppleapply.SupSignKDString;
import kd.wtc.wtpm.constants.suppleapply.SuppleApplyConstants;
import kd.wtc.wtpm.formplugin.suppleapply.BillApplyBatchList;
import kd.wtc.wtpm.formplugin.suppleapply.helper.SupSignCommonViewHelper;
import kd.wtc.wtpm.formplugin.suppleapply.helper.SupSignListViewHelper;

public class SupSignBatchList
extends BillApplyBatchList {
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        args.getListColumns().removeIf(iListColumn -> HRStringUtils.equals((String)iListColumn.getListFieldKey(), (String)"supsigninfo.suppleworktime"));
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        ListSelectedRow selectedRow = ((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow();
        Long detailBillId = (Long)selectedRow.getPrimaryKeyValue();
        DynamicObject detailBillDy = SupSignHelper.queryBatchBillDetailByDetailId((Long)detailBillId);
        if (detailBillDy == null) {
            this.getView().showTipNotification(SupSignKDString.dataHaveChange());
            args.setCancel(true);
        } else {
            long billId = detailBillDy.getLong("billid.id");
            SupSignListViewHelper.openSignForm(billId, this.getView(), (IFormPlugin)this);
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String opKey = operate.getOperateKey();
        LOG.info("SupSignInfoDetailBillList.beforeDoOperation.opKey={}", (Object)opKey);
        if (confirmopmap.containsKey(opKey)) {
            super.beforeDoOperation(args);
            if (args.isCancel()) {
                return;
            }
            this.getSelectBillId();
            if (CollectionUtils.isEmpty((Collection)this.batchBillIds)) {
                this.getView().showTipNotification(SupSignKDString.dataHaveChange());
                args.setCancel(true);
                return;
            }
            if (SuppleApplyConstants.BATCH_SYNC_OP_MAP.containsKey(opKey) && this.batchBillIds.size() > 1) {
                LOG.info("SupSignInfoDetailBillList.beforeDoOperation.onlyOneSupSignBatchBill");
                this.getView().showTipNotification(SupSignKDString.onlyOneSupSignBill());
                args.setCancel(true);
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        if ("batchnew".equals(operateKey)) {
            SupSignListViewHelper.openSignForm(this.getView(), (IFormPlugin)this);
        } else if ("viewlog".equals(operateKey)) {
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"wtpm_supsigntasklog", (boolean)true, (int)0, (boolean)false);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("taskCategory", (Object)"wtpm_supsign");
            this.getView().showForm((FormShowParameter)showParameter);
        } else if ("viewflowchart".equals(operateKey)) {
            this.viewFlowChart();
        }
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes && confirmopmap.containsKey(callBackId)) {
            this.getSelectBillId();
            this.opKey = callBackId;
            this.confirmDoListOp();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void confirmDoListOp() {
        if (!CollectionUtils.isEmpty((Collection)this.batchBillIds)) {
            DynamicObject[] batchBillArr = SupSignHelper.queryBatchBillById((Collection)this.batchBillIds);
            if (SuppleApplyConstants.BATCH_SYNC_OP_MAP.containsKey(this.opKey)) {
                DynamicObject listDataDy = (DynamicObject)this.billLists.get(0);
                this.billId = (Long)this.batchBillIds.iterator().next();
                this.billNo = listDataDy.getString("billno");
                this.orgId = listDataDy.getLong("org.id");
                this.billEntityId = "wtpm_supsignbatch";
                this.taskCategory = "wtpm_supsign";
                boolean tryOperation = this.tryOperation(batchBillArr);
                boolean checkTaskStatus = false;
                if (tryOperation) {
                    checkTaskStatus = SupSignCommonViewHelper.checkBillTaskIsFinished(this.billId, this.getView(), this.taskCategory);
                }
                if (!tryOperation || !checkTaskStatus) return;
                this.billDataEntity = SupSignHelper.queryBatchBillById((Long)this.billId);
                this.submitDistributeTask();
            } else {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("currbizappid", this.getView().getFormShowParameter().getAppId());
                OperationResult result = OperationServiceHelper.executeOperate((String)((String)confirmopmap.get(this.opKey)), (String)"wtpm_supsignbatch", (DynamicObject[])batchBillArr, (OperateOption)operateOption);
                this.operationResult.mergeOperateResult(result);
            }
        }
        LOG.info("SupSignInfoDetailBillList.confirmDoListOp.operationResult:{}", (Object)this.operationResult);
        this.validateOperationResult();
    }

    public void packageData(PackageDataEvent args) {
        SupSignCommonViewHelper.packageSuppleWorkTime(args);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("bill_list_closeactionid".equals(actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        SupSignCommonViewHelper.handleSupSignDateFilterRange(this.getView(), args, BillSystemParamConfigEnum.SUPPLE, "supsigninfo.signdate");
    }

    private void getSelectBillId() {
        List<Long> selectIds = this.getListSelectIds();
        this.billLists = SupSignHelper.queryBatchBillDetailByDetailId(selectIds);
        this.batchBillIds = Sets.newHashSetWithExpectedSize((int)4);
        for (DynamicObject listDy : this.billLists) {
            this.batchBillIds.add(listDy.getLong("billid.id"));
        }
    }

    private void viewFlowChart() {
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        if (!CollectionUtils.isEmpty((Collection)selectedRows)) {
            if (selectedRows.size() > 1) {
                listView.showTipNotification(SupSignKDString.limitSelectOne());
                return;
            }
            long primaryKeyValue = (Long)selectedRows.get(0).getPrimaryKeyValue();
            DynamicObject dynamicObject = SupSignHelper.queryBatchBillDetailByDetailId((Long)primaryKeyValue);
            long billId = dynamicObject.getLong("billid.id");
            String entityNumber = "wtpm_supsignbatch";
            WorkflowServiceHelper.viewFlowchartWithEntityNumber((String)listView.getPageId(), (String)entityNumber, (Object)String.valueOf(billId));
        }
    }
}

