/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.formplugin.suppleapply;

import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.wtc.wtbs.business.util.WTCOrgUtils;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtpm.business.signcard.SignCardCommonService;
import kd.wtc.wtpm.business.signcard.SupSignChangeService;
import kd.wtc.wtpm.business.signcard.supplyapply.helper.SupSignHisHelper;
import kd.wtc.wtpm.constants.suppleapply.SupSignKDString;
import kd.wtc.wtpm.formplugin.suppleapply.helper.SupSignViewHelper;

public class SupSignBillEdit
extends HRCoreBaseBillEdit
implements BeforeF7SelectListener {
    private static final long DEFAULT_TZ = 320881823238577152L;
    protected static final Log LOG = LogFactory.getLog(SupSignBillEdit.class);

    public void registerListener(EventObject args) {
        super.registerListener(args);
        BasedataEdit reasonEdit = (BasedataEdit)this.getControl("applyreason");
        reasonEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit timezoneEdit = (BasedataEdit)this.getControl("timezone");
        timezoneEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit equipment = (BasedataEdit)this.getControl("equipment");
        equipment.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String parentPageId = formShowParameter.getParentPageId();
        IFormView parentView = this.getView().getViewNoPlugin(parentPageId);
        Object org = this.getModel().getValue("org");
        if (org == null && parentView instanceof ListView) {
            long defaultSelectOrgIds = WTCOrgUtils.getDefaultSelectOrgIds((ListView)((ListView)parentView), (String)"org");
            this.getModel().setValue("org", (Object)defaultSelectOrgIds);
        }
    }

    public void afterBindData(EventObject eventObject) {
        int attachmentCount;
        LOG.info("SupSignBillEdit.afterBindData.start");
        super.afterBindData(eventObject);
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        if (billShowParameter.getBillStatus() != BillOperationStatus.ADDNEW) {
            SupSignViewHelper.setAttPolicy(this.getView());
            String billStatus = this.getModel().getDataEntity().getString("billstatus");
            if (Lists.newArrayList((Object[])new String[]{"A", "G"}).contains(billStatus)) {
                SupSignViewHelper.showMultipleCountLimit(this.getView());
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"supsigncountpanel"});
            }
            this.getPageCache().put("billid", String.valueOf(this.getModel().getDataEntity().getLong("id")));
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"supsigncountpanel"});
        }
        AttachmentPanel attachmentpanel = (AttachmentPanel)this.getView().getControl("attachmentpanel");
        int n = attachmentCount = CollectionUtils.isEmpty((Collection)attachmentpanel.getAttachmentData()) ? 0 : attachmentpanel.getAttachmentData().size();
        if (attachmentCount == 0) {
            Container attachFlex = (Container)this.getView().getControl("attchmentcontentpanel");
            attachFlex.setCollapse(true);
        }
        SignCardCommonService.setAccessTagMustInput((IFormView)this.getView());
        DateEdit signDateEdit = (DateEdit)this.getView().getControl("signdate");
        signDateEdit.setMaxDate(new Date());
        LOG.info("SupSignBillEdit.afterBindData.end");
    }

    protected void handleExOp() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object opTypeFrom = formShowParameter.getCustomParam("optype");
        if (!"from_ex".equals(opTypeFrom)) {
            return;
        }
        String punchCardPoint = (String)formShowParameter.getCustomParam("punchcardpoint");
        String shiftDateStr = (String)formShowParameter.getCustomParam("shiftdate");
        Date shiftDate = null;
        try {
            if (HRStringUtils.isNotEmpty((String)shiftDateStr)) {
                shiftDate = WTCDateUtils.parseDate((String)shiftDateStr, (String)"yyyy-MM-dd");
            }
        }
        catch (ParseException ex) {
            LOG.info("SupSignBillEdit handleExOp parseDate exception:{}", (Object)ex.getMessage());
        }
        long tzId = this.getTimeZone(shiftDate);
        TableValueSetter tableValueSetter = new TableValueSetter(new String[]{"signdate", "suppleworktime", "timezone"});
        if (HRStringUtils.isNotEmpty((String)punchCardPoint)) {
            String[] punchCardPointSplit = punchCardPoint.split(",");
            try {
                for (String cardPoint : punchCardPointSplit) {
                    this.fillSupSignInfoEntry(tableValueSetter, cardPoint, tzId);
                }
            }
            catch (Exception exception) {
                LOG.info("SupSignBillEdit handleExOp parseDate exception:{}", (Object)exception.getMessage());
            }
        }
        if (tableValueSetter.getCount() > 0) {
            this.getModel().deleteEntryData("entryentity");
            AbstractFormDataModel abstractFormDataModel = (AbstractFormDataModel)this.getView().getModel();
            for (int index = 0; index < tableValueSetter.getCount(); ++index) {
                abstractFormDataModel.createNewEntryRow("entryentity");
                List fields = tableValueSetter.getFields();
                for (String field : fields) {
                    abstractFormDataModel.setValue(field, tableValueSetter.get(field, index), index);
                }
            }
            this.getView().updateView("entryentity");
            this.getModel().setDataChanged(false);
        }
    }

    private void fillSupSignInfoEntry(TableValueSetter tableValueSetter, String cardPoint, long tzId) {
        if (HRStringUtils.isNotEmpty((String)cardPoint)) {
            if (cardPoint.length() > 8) {
                LocalDateTime localDateTime = LocalDateTime.parse(cardPoint, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));
                LocalDate localDate = localDateTime.toLocalDate();
                LocalTime localTime = localDateTime.toLocalTime();
                tableValueSetter.addRow(new Object[]{WTCDateUtils.toDate((LocalDate)localDate), localTime.toSecondOfDay(), tzId});
            } else {
                int suppleWorkTime = LocalTime.parse(cardPoint).toSecondOfDay();
                tableValueSetter.addRow(new Object[]{null, suppleWorkTime, tzId});
            }
        }
    }

    private long getTimeZone(Date shiftDate) {
        long tzId = 0L;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject attFile = dataEntity.getDynamicObject("attfile");
        if (shiftDate != null && attFile != null) {
            long attFileBoId = attFile.getLong("id");
            DynamicObject timeZoneDy = SupSignHisHelper.getTimeZoneHis((long)attFileBoId, (Date)shiftDate);
            tzId = 320881823238577152L;
            if (timeZoneDy != null) {
                DynamicObject tz = timeZoneDy.getDynamicObject("tz");
                tzId = tz.getLong("id");
            }
        }
        return tzId;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propName = beforeF7SelectEvent.getProperty().getName();
        if ("applyreason".equals(propName)) {
            SupSignViewHelper.reasonBeforeF7Select(beforeF7SelectEvent, this.getView());
        } else if ("timezone".equals(propName) || "equipment".equals(propName)) {
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowParameter.setMultiSelect(false);
        }
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String propKey = propertyChangedArgs.getProperty().getName();
        if (propertyChangedArgs.getChangeSet() == null || propertyChangedArgs.getChangeSet().length <= 0) {
            return;
        }
        switch (propKey) {
            case "personid": {
                SupSignViewHelper.switchPerson(this.getView());
                break;
            }
            case "attfilebasef7": {
                if (propertyChangedArgs.getChangeSet()[0].getNewValue() == null) break;
                this.attFilePropertyChanged();
                break;
            }
            case "applyreason": {
                SupSignViewHelper.reasonPropertyChanged(propertyChangedArgs, this.getView());
                break;
            }
            case "signdate": {
                SupSignViewHelper.signDatePropertyChanged(propertyChangedArgs, this.getView());
                break;
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs args) {
        EntryGrid entryGrid;
        DynamicObject[] dataEntities;
        int length;
        String name;
        EntryProp entryProp = args.getEntryProp();
        if (entryProp != null && "entryentity".equals(name = entryProp.getName()) && (length = args.getRowIndexs().length) == (dataEntities = (entryGrid = (EntryGrid)this.getControl("entryentity")).getEntryData().getDataEntitys()).length) {
            this.getView().showTipNotification(SupSignKDString.mustOne());
            args.setCancel(true);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs args) {
        String name;
        EntryProp entryProp = args.getEntryProp();
        if (entryProp != null && "entryentity".equals(name = entryProp.getName())) {
            SupSignViewHelper.setAttPolicy(this.getView());
            SupSignViewHelper.showMultipleCountLimit(this.getView());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (!Lists.newArrayList((Object[])new String[]{"A", "G"}).contains(billStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"supsigncountpanel"});
        } else {
            SupSignViewHelper.showMultipleCountLimit(this.getView());
        }
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && operationResult.isSuccess() && "change".equals(operateKey)) {
            DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
            long id = dataEntity.getLong("id");
            SupSignChangeService.getInstance().openNewChange(Long.valueOf(id), this.getView(), (AbstractFormPlugin)this);
        }
    }

    protected boolean attFilePropertyChanged() {
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        long attFileBoId = SignCardCommonService.getObjectId((DynamicObject)model.getDataEntity(), (String)"attfile");
        if (attFileBoId == 0L) {
            return true;
        }
        LOG.info("SupSignViewHelper.attFilePropertyChanged.attFileBoId={}", (Object)attFileBoId);
        Map planIdListMap = SupSignHisHelper.getAttFilePlanHis((Collection)Lists.newArrayList((Object[])new Long[]{attFileBoId}));
        LOG.info("SupSignViewHelper.attFilePropertyChanged.planIdListMap.size={}", (Object)planIdListMap.size());
        view.setVisible(Boolean.FALSE, new String[]{"supsigncountpanel"});
        if (CollectionUtils.isEmpty((Map)planIdListMap)) {
            this.setNoPersonStyle(false);
            view.showTipNotification(SupSignKDString.noPlan());
            return false;
        }
        this.setNoPersonStyle(true);
        return true;
    }

    protected void setNoPersonStyle(boolean havePerson) {
    }
}

