/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.formplugin.suppleapply;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeQueryOfExportEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillList;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.common.enums.WTCBillChangeEnum;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtpm.business.signcard.SignCardHelperFactory;
import kd.wtc.wtpm.business.signcard.SupSignChangeService;
import kd.wtc.wtpm.constants.suppleapply.BillOperationConstants;
import kd.wtc.wtpm.constants.suppleapply.SupSignKDString;

public class SupSignList
extends HRCoreBaseBillList {
    protected String originalFormId;
    private String exportSelectFields;
    private static final Map<String, String> BILLSTATUS_COLOR_MAP = new HashMap<String, String>(16);

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        setFilterEvent.addCustomQFilter(new QFilter("isnewbill", "=", (Object)"1"));
        setFilterEvent.setOrderBy("id desc");
    }

    public void handleFilter(SetFilterEvent setFilterEvent, String key, String replaceKey) {
        List qFilters = setFilterEvent.getQFilters();
        for (QFilter qFilter : qFilters) {
            String property = qFilter.getProperty();
            if (key.equals(property)) {
                qFilter.__setProperty(replaceKey);
            }
            List nests = qFilter.getNests(true);
            for (QFilter.QFilterNest qFilterNest : nests) {
                QFilter nestFilter = qFilterNest.getFilter();
                property = nestFilter.getProperty();
                if (!key.equals(property)) continue;
                nestFilter.__setProperty(replaceKey);
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String opKey = operate.getOperateKey();
        OperateOption option = operate.getOption();
        option.setVariableValue("BILL_LIST_OP", "BILL_LIST_OP_TRUE");
        Map variables = option.getVariables();
        if (WTCCollections.isNotEmpty((Map)variables)) {
            this.getPageCache().put("optionvariablescache", JSON.toJSONString((Object)variables));
        }
        if ("viewflowchart".equals(opKey)) {
            this.handleOp(opKey, args);
        } else if (BillOperationConstants.SUPSIGN_OP_LIST.contains(opKey)) {
            args.setCancel(true);
            String opName = operate.getOperateName().getLocaleValue();
            String message = String.format(Locale.ROOT, SupSignKDString.confimMsg(), opName);
            operate.setConfirmMessage(message);
            this.getView().showConfirm(message, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(opKey, (IFormPlugin)this));
        } else if ("exportlist_expt".equals(opKey)) {
            Map parameter = operate.getParameter();
            parameter.put("byList", false);
            operate.setParameter(parameter);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (!BillOperationConstants.SUPSIGN_OP_LIST.contains(callBackId) || messageBoxClosedEvent.getResult().getValue() != MessageBoxResult.Yes.getValue()) {
            return;
        }
        String targetOp = this.getTargetOp(callBackId);
        this.handleOp(targetOp, null);
    }

    public void beforePackageData(BeforePackageDataEvent args) {
        super.beforePackageData(args);
        DynamicObjectCollection pageData = args.getPageData();
        BillList control = (BillList)this.getControl("billlistap");
        int startIndex = (control.getEntryState().getCurrentPageIndex() - 1) * control.getEntryState().getPageRows();
        ArrayList<CellStyle> csList = new ArrayList<CellStyle>(pageData.size());
        for (int index = 0; index < pageData.size(); ++index) {
            DynamicObject dynamicObject = (DynamicObject)pageData.get(index);
            String billStatus = dynamicObject.getString("billstatus");
            CellStyle cs = new CellStyle();
            cs.setFieldKey("billstatus");
            cs.setForeColor(BILLSTATUS_COLOR_MAP.get(billStatus));
            cs.setRow(startIndex + index);
            csList.add(cs);
        }
        control.setCellStyle(csList);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        boolean success = false;
        if (operationResult != null) {
            success = operationResult.isSuccess();
        }
        if (success && "change".equals(operateKey)) {
            this.showChangeView(afterDoOperationEventArgs);
        }
    }

    private void showChangeView(AfterDoOperationEventArgs args) {
        Donothing operator = (Donothing)args.getSource();
        ListSelectedRowCollection listSelectedDatas = operator.getListSelectedData();
        if (listSelectedDatas == null) {
            return;
        }
        HashSet ps = new HashSet(listSelectedDatas);
        ListSelectedRow row = (ListSelectedRow)ps.iterator().next();
        long id = (Long)row.getPrimaryKeyValue();
        SupSignChangeService.getInstance().openNewChange(Long.valueOf(id), this.getView(), null);
    }

    private void handleOp(String targetOp, BeforeDoOperationEventArgs args) {
        JSONObject jsonObject;
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        Set billIdSet = selectedRows.stream().map(item -> (Long)item.getPrimaryKeyValue()).collect(Collectors.toSet());
        HRBaseServiceHelper serviceHelper = SignCardHelperFactory.getHelper((String)this.originalFormId);
        QFilter qFilter = new QFilter("id", "in", billIdSet);
        DynamicObject[] dataEntities = serviceHelper.loadDynamicObjectArray(qFilter.toArray());
        OperateOption operateOption = OperateOption.create();
        String variables = this.getPageCache().get("optionvariablescache");
        if (HRStringUtils.isNotEmpty((String)variables) && (jsonObject = JSON.parseObject((String)variables)) != null) {
            Set entries = jsonObject.entrySet();
            Set<Map.Entry> collect = entries.stream().filter(item -> item.getValue() != null).collect(Collectors.toSet());
            collect.forEach(entry -> operateOption.setVariableValue((String)entry.getKey(), String.valueOf(entry.getValue())));
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        operateOption.setVariableValue("currbizappid", appId);
        operateOption.setVariableValue("appnumber", appId);
        operateOption.setVariableValue("listOp", "1");
        Tuple resultTuple = BillUnifyService.opTargetBillForm((String)this.originalFormId, (String)targetOp, (OperateOption)operateOption, (IListView)listView, (DynamicObject[])dataEntities);
        if (((Boolean)resultTuple.getKey()).booleanValue()) {
            if (((OperationResult)resultTuple.getValue()).isSuccess()) {
                String msg = BillUnifyService.getOpSuccessTip((String)this.originalFormId, (String)targetOp);
                if (HRStringUtils.isNotEmpty((String)msg)) {
                    this.getView().showSuccessNotification(msg);
                    this.refreshListData();
                }
            } else {
                BillUnifyService.refreshListData((IFormView)listView, (OperationResult)((OperationResult)resultTuple.getValue()));
                this.getView().showOperationResult((OperationResult)resultTuple.getValue());
            }
            if (args != null) {
                args.setCancel(true);
            }
        } else {
            this.handleOp(targetOp, dataEntities, operateOption);
        }
    }

    private void handleOp(String targetOp, DynamicObject[] dataEntities, OperateOption operateOption) {
        if (!"viewflowchart".equals(targetOp)) {
            OperationResult result = OperationServiceHelper.executeOperate((String)targetOp, (String)this.originalFormId, (DynamicObject[])dataEntities, (OperateOption)operateOption);
            if (result.isSuccess()) {
                String msg = BillUnifyService.getOpSuccessTip((String)this.originalFormId, (String)targetOp);
                if (HRStringUtils.isNotEmpty((String)msg)) {
                    this.getView().showSuccessNotification(msg);
                    if ("delete".equals(targetOp) || "discard".equals(targetOp)) {
                        this.refreshAndCleanSelectList();
                    } else {
                        this.refreshListData();
                    }
                }
            } else {
                BillUnifyService.refreshListData((IFormView)this.getView(), (OperationResult)result);
                this.getView().showOperationResult(result);
            }
        }
    }

    private void refreshAndCleanSelectList() {
        BillUnifyService.refreshAndCleanSelectListData((IFormView)this.getView());
    }

    private void refreshListData() {
        BillUnifyService.refreshListData((IFormView)this.getView());
    }

    private String getTargetOp(String opKey) {
        if (opKey.startsWith("cus_")) {
            return StringUtils.removeStart((String)opKey, (String)"cus_");
        }
        return opKey;
    }

    private void updateList() {
        BillList billlistap = (BillList)this.getView().getControl("billlistap");
        if (billlistap != null) {
            billlistap.clearSelection();
            billlistap.refresh();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)"sup_change_close_callback", (String)actionId)) {
            this.updateList();
        }
    }

    public void beforeQueryOfExport(BeforeQueryOfExportEvent event) {
        super.beforeQueryOfExport(event);
        String selectFields = event.getSelectFields();
        String fields = String.join((CharSequence)",", selectFields, "tripresontex", "originalid", "ischange", "parent");
        event.setSelectFields(fields);
        this.exportSelectFields = event.getSelectFields();
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent ee) {
        super.afterQueryOfExport(ee);
        DynamicObject[] dataArr = ee.getQueryValues();
        if (dataArr != null && dataArr.length > 0) {
            LinkedHashMap<Long, Long> leafBillIdMap = new LinkedHashMap<Long, Long>(dataArr.length);
            Arrays.stream(dataArr).forEach(dy -> leafBillIdMap.put(dy.getLong("id"), dy.getLong("originalid")));
            DynamicObject[] resultDys = HRBaseServiceHelper.create((String)"wtpm_supsignpc").query(this.exportSelectFields, new QFilter("originalid", "in", leafBillIdMap.values()).toArray(), "id desc");
            ArrayList result = new ArrayList(resultDys.length);
            Map<Long, List<DynamicObject>> dyMapByOriginalId = Arrays.stream(resultDys).collect(Collectors.groupingBy(dy -> dy.getLong("originalid")));
            leafBillIdMap.forEach((leafId, originalId) -> {
                List dys = (List)dyMapByOriginalId.get(originalId);
                if (WTCCollections.isNotEmpty((Collection)dys)) {
                    if (dys.size() > 1) {
                        dys = BillCommonService.getInstance().leafFilter(leafId, dys, WTCBillChangeEnum.SUP);
                    }
                    int changeNum = dys.size() - 1;
                    for (DynamicObject dy : dys) {
                        if (!dy.containsProperty("changenum")) continue;
                        String changeNumStr = changeNum > 0 ? ResManager.loadKDString((String)"\u7b2c{0}\u6b21\u53d8\u66f4", (String)"SupSignList_0", (String)"wtc-wtpm-formplugin", (Object[])new Object[]{changeNum--}) : ResManager.loadKDString((String)"\u539f\u5355", (String)"SupSignList_1", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]);
                        dy.set("changenum", (Object)changeNumStr);
                    }
                    result.addAll(dys);
                }
            });
            ee.setCustomOrder(true);
            ee.setQueryValues(result.toArray(new DynamicObject[result.size()]));
        }
    }

    static {
        BILLSTATUS_COLOR_MAP.put("A", "rgb(102, 102, 102)");
        BILLSTATUS_COLOR_MAP.put("B", "rgb(24, 188, 113)");
        BILLSTATUS_COLOR_MAP.put("C", "rgb(24, 188, 113)");
        BILLSTATUS_COLOR_MAP.put("D", "rgb(94, 128, 235)");
        BILLSTATUS_COLOR_MAP.put("F", "rgb(204, 204, 204)");
        BILLSTATUS_COLOR_MAP.put("E", "rgb(253, 108, 106)");
        BILLSTATUS_COLOR_MAP.put("G", "rgb(253, 194, 0)");
    }
}

