/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.formplugin.suppleapply;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.ReflectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.util.third.time.StopWatch;

public class SupSignOtherImportPlugin
extends BatchImportPlugin {
    private static final Log LOG = LogFactory.getLog(SupSignOtherImportPlugin.class);

    public BatchImportPlugin setContext(RequestContext rc, ImportContext ctx, List<String> startArgs) {
        try {
            Field view = ctx.getClass().getDeclaredField("view");
            ReflectionUtils.makeAccessible((Field)view);
            IFormView formView = (IFormView)view.get(ctx);
            formView.setEnable(Boolean.FALSE, new String[]{"radiofield1", "radiofield2"});
            ctx.addOption("appid", (Object)ctx.getCheckRightAppId());
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOG.error("SupSignOtherImportPlugin setContext error={}", (Object)e.getMessage());
        }
        return super.setContext(rc, ctx, startArgs);
    }

    public String getBillFormId() {
        return "wtpm_supsignpc";
    }

    protected boolean isForceBatch() {
        return true;
    }

    protected int getBatchImportSize() {
        return super.getBatchImportSize();
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        StopWatch watch = StopWatch.createStarted();
        for (ImportBillData importBillData : billdatas) {
            JSONObject data = importBillData.getData();
            JSONArray jsonArray = data.getJSONArray("entryentity");
            for (int index = 0; index < jsonArray.size(); ++index) {
                JSONObject entryData = jsonArray.getJSONObject(index);
                String signDate = entryData.getString("signdate");
                if (!HRStringUtils.isNotEmpty((String)signDate)) continue;
                if ((signDate = signDate.trim()).length() > 10) {
                    signDate = signDate.substring(0, 10);
                }
                signDate = signDate.replace('/', '-');
                entryData.put("signdate", (Object)signDate);
            }
        }
        watch.stop();
        LOG.info("SupSignOtherImportPlugin.beforeSave use times:{}ms", (Object)watch.getTime());
        super.beforeSave(billdatas, logger);
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        return super.save(rowdatas, logger);
    }
}

