/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.formplugin.suppleapply;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.model.mobile.AbnormalDealModel;
import kd.wtc.wtbs.common.predata.wtbd.PreDataReason;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtpm.business.sign.mobile.MobSupSignBusiness;
import kd.wtc.wtpm.formplugin.suppleapply.SupSignBillEdit;
import kd.wtc.wtpm.formplugin.suppleapply.helper.SupSignViewHelper;

public class SupSignSelfEdit
extends SupSignBillEdit {
    public void preOpenForm(PreOpenFormEventArgs ee) {
        Object pkId;
        super.preOpenForm(ee);
        FormShowParameter formShowParameter = ee.getFormShowParameter();
        if (formShowParameter instanceof BillShowParameter && (pkId = ((BillShowParameter)formShowParameter).getPkId()) != null) {
            String caption = ResManager.loadKDString((String)"\u8865\u7b7e\u7533\u8bf7", (String)"SupSignSelfEdit_0", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]);
            HRBaseServiceHelper helper = new HRBaseServiceHelper("wtpm_supsignself");
            DynamicObject dy = helper.queryOne(pkId);
            DynamicObject attFile = dy.getDynamicObject("attfile");
            if (attFile != null) {
                caption = caption + "-" + attFile.getLocaleString("name");
            }
            formShowParameter.setCaption(caption);
        }
    }

    @Override
    public void afterBindData(EventObject eventObject) {
        boolean checkPass;
        super.afterBindData(eventObject);
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        if (billShowParameter.getBillStatus().equals((Object)BillOperationStatus.ADDNEW) && (checkPass = this.attFilePropertyChanged())) {
            this.handleExSupple();
            this.handleExOp();
        }
    }

    private void handleExSupple() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object customParam = formShowParameter.getCustomParam("isAbnormal");
        if (Objects.equals(customParam, Boolean.TRUE)) {
            Long attFileBo;
            AbnormalDealModel.AbnormalDetail abnormalDetail;
            String exDetailStr = (String)formShowParameter.getCustomParam("abnormalDetail");
            if (HRStringUtils.isEmpty((String)exDetailStr)) {
                return;
            }
            AbnormalDealModel abnormalDealModel = (AbnormalDealModel)SerializationUtils.deSerializeFromBase64((String)exDetailStr);
            if (abnormalDealModel == null) {
                return;
            }
            Date signDate = null;
            String accessTag = null;
            int suppleWorkTime = -1;
            String abnormalDateStr = abnormalDealModel.getAbnormalDate();
            String shouldCardTime = null;
            if (!HRStringUtils.isEmpty((String)abnormalDateStr)) {
                signDate = WTCDateUtils.str2Date((String)abnormalDateStr, (String)"yyyy-MM-dd");
            }
            if ((abnormalDetail = abnormalDealModel.getSelectedAbnormal()) != null) {
                shouldCardTime = abnormalDetail.getShouldCardTime();
                if (HRStringUtils.isNotEmpty((String)shouldCardTime)) {
                    LocalDateTime localDateTime = LocalDateTime.parse(shouldCardTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                    signDate = WTCDateUtils.toDate((LocalDate)localDateTime.toLocalDate());
                    suppleWorkTime = localDateTime.toLocalTime().toSecondOfDay();
                } else {
                    String abnormalTime = abnormalDetail.getAbnormalTime();
                    if (!HRStringUtils.isEmpty((String)abnormalTime)) {
                        LocalTime localTime = LocalTime.parse(abnormalTime);
                        suppleWorkTime = localTime.toSecondOfDay();
                    }
                }
                accessTag = abnormalDetail.getCardType();
            }
            if ((attFileBo = (Long)this.getView().getFormShowParameter().getCustomParam("attfile")) != null) {
                SupSignViewHelper.setTimeZoneDefaultValue(this.getView(), 0, signDate, attFileBo);
            }
            long reasonId = PreDataReason.PD_1010_S;
            String pointTag = MobSupSignBusiness.getInstance().getPointTag(abnormalDateStr, shouldCardTime);
            int index = 0;
            IDataModel model = this.getModel();
            model.beginInit();
            model.setValue("suppleworktime", (Object)suppleWorkTime, index);
            model.setValue("accesstag", (Object)accessTag, index);
            model.setValue("pointtag", (Object)pointTag, index);
            model.endInit();
            model.setValue("signdate", (Object)signDate, index);
            model.setValue("applyreason", (Object)reasonId, index);
            model.setDataChanged(false);
            this.getView().updateView("entryentity");
        }
    }

    @Override
    protected void setNoPersonStyle(boolean havePerson) {
        super.setNoPersonStyle(havePerson);
        IFormView view = this.getView();
    }
}

