/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.formplugin.suppleapply.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtpm.business.signcard.SignCardBatchService;
import kd.wtc.wtpm.business.signcard.SignCardCommonService;
import kd.wtc.wtpm.constants.suppleapply.SupSignKDString;
import kd.wtc.wtpm.constants.suppleapply.SuppleApplyConstants;
import kd.wtc.wtpm.vo.suppleapply.SignCardInfo;

public class SupSignBatchViewHelper
implements SuppleApplyConstants {
    private SupSignBatchViewHelper() {
    }

    public static void orgClassChanged(PropertyChangedArgs args, IFormView view) {
        ChangeData changeData = args.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        IDataModel dataModel = view.getModel();
        dataModel.setValue("excperson", null, rowIndex);
    }

    public static void orgTypeChanged(PropertyChangedArgs args, IFormView view) {
        SupSignBatchViewHelper.orgClassChanged(args, view);
    }

    public static void attFileBeforeB7(IFormView view, IFormPlugin plugin, BeforeF7SelectEvent beforeF7SelectEvent, QFilter qFilter) {
        String attFileClickType = view.getPageCache().get("attfile_clicktype");
        if ("withorg".equals(attFileClickType)) {
            EntryGrid orgEntry = (EntryGrid)view.getControl("entryentityorg");
            int currentIndex = orgEntry.getSelectRows()[0];
            view.getModel().clearNoDataRow();
            EntryData entryData = orgEntry.getEntryData();
            DynamicObject[] dataEntities = entryData.getDataEntitys();
            DynamicObject dataEntity = dataEntities[currentIndex];
            DynamicObject orgClassDy = dataEntity.getDynamicObject("orgclass");
            if (orgClassDy == null) {
                view.showTipNotification(SupSignKDString.pleaseSelectOrg());
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            String orgType = dataEntity.getString("orgtype");
            if ("haos_adminorghr".equals(orgType)) {
                long orgClassId = orgClassDy.getLong("id");
                ArrayList orgClassIdList = Lists.newArrayList((Object[])new Long[]{orgClassId});
                List subAdminOrgIdList = SignCardBatchService.getSubAdminOrg((List)orgClassIdList);
                QFilter orgFilter = new QFilter("affiliateadminorg", "in", (Object)subAdminOrgIdList);
                beforeF7SelectEvent.addCustomQFilter(orgFilter);
            }
            if (qFilter != null) {
                beforeF7SelectEvent.addCustomQFilter(qFilter);
            }
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setMultiSelect(true);
            formShowParameter.setCloseCallBack(new CloseCallBack(plugin, "withorg"));
        } else if ("withperson".equals(attFileClickType)) {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setMultiSelect(true);
            if (qFilter != null) {
                beforeF7SelectEvent.addCustomQFilter(qFilter);
            }
            formShowParameter.setCloseCallBack(new CloseCallBack(plugin, "withperson"));
        }
        Long currAttPersonId = BillUnifyService.getUserId((IPageCache)view.getPageCache());
        QFilter excludeAttFileLevelFilter = BillCommonService.getInstance().getExcludeAttFileLevelFilter(view, currAttPersonId, "boid");
        beforeF7SelectEvent.addCustomQFilter(excludeAttFileLevelFilter);
    }

    public static void extraPersonF7CloseCallback(ClosedCallBackEvent closedCallBackEvent, IFormView view) {
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        List selectedRows = (List)closedCallBackEvent.getReturnData();
        Set<Object> selectIdList = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        Set<Long> attFileIds = SupSignBatchViewHelper.getEntrySelectedBaseDataIds(view, "entryentityperson", "exteaattfile");
        Set<Object> repeatedVids = SupSignBatchViewHelper.removeDuplicateAttFile(selectIdList, attFileIds);
        TableValueSetter tableValueSetter = new TableValueSetter(new String[]{"exteaattfile"});
        IDataModel model = view.getModel();
        AbstractFormDataModel dataModel = (AbstractFormDataModel)model;
        dataModel.beginInit();
        tableValueSetter.addField("exteaattfile", repeatedVids.toArray());
        dataModel.deleteEntryData("entryentityperson");
        dataModel.batchCreateNewEntryRow("entryentityperson", tableValueSetter);
        dataModel.endInit();
        view.updateView("entryentityperson");
    }

    public static void personF7CloseCallback(ClosedCallBackEvent closedCallBackEvent, IFormView view) {
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        List selectedRows = (List)closedCallBackEvent.getReturnData();
        Set<Object> primaryIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        EntryGrid orgEntry = (EntryGrid)view.getControl("entryentityorg");
        int currentIndex = orgEntry.getSelectRows()[0];
        DynamicObject dataEntity = orgEntry.getEntryData().getDataEntitys()[currentIndex];
        DynamicObjectCollection excPersonColl = dataEntity.getDynamicObjectCollection("excperson");
        Set<Object> selectAttFileVids = Sets.newHashSetWithExpectedSize((int)excPersonColl.size());
        if (!CollectionUtils.isEmpty((Collection)excPersonColl)) {
            selectAttFileVids = excPersonColl.stream().map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toSet());
        }
        Set<Object> repeatedVids = SupSignBatchViewHelper.removeDuplicateAttFile(primaryIds, selectAttFileVids);
        view.getModel().setValue("excperson", (Object)repeatedVids.toArray(), currentIndex);
    }

    private static Set<Object> removeDuplicateAttFile(Set<Object> attFileVIds, Set<Long> selectAttFileVids) {
        HashSet allAttFileVid = Sets.newHashSet(attFileVIds);
        if (!CollectionUtils.isEmpty(selectAttFileVids) && !CollectionUtils.isEmpty(attFileVIds)) {
            allAttFileVid.addAll(selectAttFileVids);
            AttFileQueryServiceImpl attFileQueryService = AttFileQueryServiceImpl.getInstance();
            List dynamicObjects = attFileQueryService.queryAttFileByIds(WTCStringUtils.joinOnComma((String[])new String[]{"id", "boid"}), (List)Lists.newArrayList((Iterable)allAttFileVid));
            Map<Object, Object> vidBoIdMap = dynamicObjects.stream().collect(Collectors.toMap(item -> item.get("id"), item -> item.get("boid"), (key1, key2) -> key2));
            HashSet attFileBoIds = Sets.newHashSetWithExpectedSize((int)vidBoIdMap.size());
            HashSet repeatedVIds = Sets.newHashSetWithExpectedSize((int)vidBoIdMap.size());
            attFileVIds.forEach(vid -> {
                if (attFileBoIds.add(vidBoIdMap.get(vid))) {
                    repeatedVIds.add(vid);
                }
            });
            selectAttFileVids.forEach(vid -> {
                if (attFileBoIds.add(vidBoIdMap.get(vid))) {
                    repeatedVIds.add(vid);
                }
            });
            return repeatedVIds;
        }
        return attFileVIds;
    }

    public static Set<Long> getEntrySelectedBaseDataIds(IFormView view, String entryKey, String fieldKey) {
        EntryGrid entryGrid = (EntryGrid)view.getControl(entryKey);
        DynamicObject[] extraPersonArr = entryGrid.getEntryData().getDataEntitys();
        HashSet selectAttFileVids = Sets.newHashSetWithExpectedSize((int)extraPersonArr.length);
        for (DynamicObject extraPerson : extraPersonArr) {
            selectAttFileVids.add(SignCardCommonService.getObjectId((DynamicObject)extraPerson, (String)fieldKey));
        }
        return selectAttFileVids;
    }

    public static void validateOrgExist(IFormView view, BeforeF7SelectEvent evt) {
        IDataModel model = view.getModel();
        Object org = model.getValue("org");
        if (org == null) {
            view.showTipNotification(SupSignKDString.emptyOrg());
            evt.setCancel(true);
        }
    }

    public static boolean checkDate(IFormView view) {
        DynamicObjectCollection entryColl = view.getModel().getEntryEntity("entryentitysupinfo");
        String msg = SupSignKDString.cardInfoRepeat();
        ArrayList<SignCardInfo> signCardInfoList = new ArrayList<SignCardInfo>(entryColl.size());
        for (DynamicObject entryRow : entryColl) {
            SignCardInfo signCardInfo = new SignCardInfo();
            signCardInfo.setSignDate(entryRow.getDate("signdate"));
            signCardInfo.setSuppleWorkTime(Integer.valueOf(entryRow.getInt("suppleworktime")));
            signCardInfo.setTimeZone(Long.valueOf(entryRow.getLong("timezone.id")));
            signCardInfo.setAccessTag(entryRow.getString("accesstag"));
            signCardInfoList.add(signCardInfo);
        }
        Map<SignCardInfo, Long> signCardInfoCountMap = signCardInfoList.stream().collect(Collectors.groupingBy(item -> item, Collectors.counting()));
        List repeatSignCardInfos = signCardInfoCountMap.entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(repeatSignCardInfos)) {
            return true;
        }
        repeatSignCardInfos.sort(Comparator.comparing(SignCardInfo::getDetailTime));
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (SignCardInfo info : repeatSignCardInfos) {
            if (count >= 10) break;
            sb.append(WTCInteDateUtil.formatBySysTzAndUserFmt((Date)info.getDetailTime())).append('\uff0c');
            ++count;
        }
        msg = String.format(Locale.ROOT, msg, sb);
        view.showTipNotification(msg);
        return false;
    }

    public static void openAddSignInfoForm(IFormView view, AbstractBillPlugIn plugin, String formId) {
        IDataModel model = view.getModel();
        Object org = model.getValue("org");
        if (org == null) {
            view.showTipNotification(SupSignKDString.emptyOrg());
            return;
        }
        DynamicObject orgDy = (DynamicObject)org;
        long orgId = orgDy.getLong("id");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.setCustomParam("orgId", (Object)orgId);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "newentry_sign"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    public static void openAddMultiPriSupInfoForm(IFormView view, AbstractBillPlugIn plugin, String formId) {
        IDataModel model = view.getModel();
        Object org = model.getValue("org");
        if (org != null) {
            DynamicObject orgDy = (DynamicObject)org;
            long orgId = orgDy.getLong("id");
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(formId);
            showParameter.setCustomParam("orgId", (Object)orgId);
            Set<Long> selectedAttFileIds = SupSignBatchViewHelper.getEntrySelectedBaseDataIds(view, "entryentitymultipri", "multipriattfile");
            showParameter.setCustomParam("multipriattfile", selectedAttFileIds);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "newentry_multipri"));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCaption(SupSignKDString.supSignInfoTag() + "-" + model.getValue("billno"));
            view.showForm(showParameter);
        } else {
            view.showTipNotification(SupSignKDString.emptyOrg());
        }
    }

    public static void addSupSignInfo(IFormView view, ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        DynamicObject signInfoDy = (DynamicObject)returnData;
        DataEntityPropertyCollection properties = signInfoDy.getDynamicObjectType().getProperties();
        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("entryentitysupinfo");
        Map allFields = ((EntryType)entryEntity.getDynamicObjectType()).getFields();
        TableValueSetter tableValueSetter = new TableValueSetter(allFields.keySet().toArray(new String[0]));
        List fields = tableValueSetter.getFields();
        Date startDate = signInfoDy.getDate("startdate");
        Date endDate = signInfoDy.getDate("enddate");
        if (endDate == null) {
            endDate = startDate;
        }
        int rangeDate = WTCDateUtils.daysBetween((Date)startDate, (Date)endDate) + 1;
        ArrayList<Date> allDates = new ArrayList<Date>(rangeDate);
        while (startDate.compareTo(endDate) <= 0) {
            allDates.add(startDate);
            startDate = WTCDateUtils.getCustomDate((Date)startDate, (Integer)1);
        }
        IDataModel model = view.getModel();
        Object[] values = new Object[fields.size()];
        int dateFieldIndex = 0;
        for (int index = 0; index < fields.size(); ++index) {
            String field = (String)fields.get(index);
            if ("signdate".equals(field)) {
                dateFieldIndex = index;
                continue;
            }
            if (!properties.containsKey((Object)field)) continue;
            Object value = signInfoDy.get(field);
            values[index] = value instanceof DynamicObject ? ((DynamicObject)value).getPkValue() : value;
        }
        AbstractFormDataModel dataModel = (AbstractFormDataModel)model;
        dataModel.beginInit();
        for (Date date : allDates) {
            values[dateFieldIndex] = date;
            tableValueSetter.addRow(values);
        }
        dataModel.batchCreateNewEntryRow("entryentitysupinfo", tableValueSetter);
        dataModel.endInit();
        view.updateView("entryentitysupinfo");
    }

    public static void addMultiPriAddPerson(IFormView view, ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        DynamicObject multiPriSignInfo = (DynamicObject)closedCallBackEvent.getReturnData();
        DynamicObjectCollection attFileColl = multiPriSignInfo.getDynamicObjectCollection("attfile");
        Date startDate = multiPriSignInfo.getDate("startdate");
        Date endDate = multiPriSignInfo.getDate("enddate");
        if (endDate == null) {
            endDate = startDate;
        }
        int suppleWorkTime = multiPriSignInfo.getInt("suppleworktime");
        DynamicObject applyReason = multiPriSignInfo.getDynamicObject("applyreason");
        Object applyReasonId = applyReason == null ? null : applyReason.get("id");
        DynamicObject timeZone = multiPriSignInfo.getDynamicObject("timezone");
        Object timeZoneId = timeZone == null ? null : timeZone.get("id");
        String accessTag = multiPriSignInfo.getString("accesstag");
        DynamicObject source = multiPriSignInfo.getDynamicObject("source");
        Object sourceId = source == null ? null : source.get("id");
        String pointTag = multiPriSignInfo.getString("pointtag");
        DynamicObject equipment = multiPriSignInfo.getDynamicObject("equipment");
        Object equipmentId = equipment == null ? null : equipment.get("id");
        String remark = multiPriSignInfo.getString("remark");
        TableValueSetter tableValueSetter = new TableValueSetter(new String[]{"multipriattfile", "prisigndate", "prisuppleworktime", "priapplyreason", "pritimezone", "priaccesstag", "pripointtag", "prisource", "priequipment", "priremark"});
        for (DynamicObject attFile : attFileColl) {
            Date dateIndex = startDate;
            while (dateIndex.compareTo(endDate) <= 0) {
                tableValueSetter.addRow(new Object[]{attFile.getDynamicObject("fbasedataid").getPkValue(), dateIndex, suppleWorkTime, applyReasonId, timeZoneId, accessTag, pointTag, sourceId, equipmentId, remark});
                dateIndex = WTCDateUtils.getNextDate((Date)dateIndex);
            }
        }
        AbstractFormDataModel abstractFormDataModel = (AbstractFormDataModel)view.getModel();
        abstractFormDataModel.beginInit();
        abstractFormDataModel.batchCreateNewEntryRow("entryentitymultipri", tableValueSetter);
        abstractFormDataModel.endInit();
        view.updateView("entryentitymultipri");
    }
}

