/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.formplugin.suppleapply.helper;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.enums.BillSystemParamConfigEnum;
import kd.wtc.wtbs.common.model.bill.BillSystemParamRange;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtpm.business.signcard.supplyapply.helper.SupSignTaskHelper;
import kd.wtc.wtpm.business.signcard.task.BillApplyTaskFactoryService;
import kd.wtc.wtpm.business.signcard.task.BillApplyTaskService;
import kd.wtc.wtpm.constants.suppleapply.SupSignKDString;

public class SupSignCommonViewHelper {
    private static final String FIELD_SUPPLEWORKTIMESHOW = "suppleworktimeshow";

    private SupSignCommonViewHelper() {
    }

    public static boolean checkSelectData(IFormView view) {
        IDataModel dataModel = view.getModel();
        DynamicObject dataEntity = dataModel.getDataEntity();
        boolean withOrg = dataEntity.getBoolean("withorg");
        boolean withPerson = dataEntity.getBoolean("withperson");
        if (!withPerson && !withOrg) {
            view.showTipNotification(SupSignKDString.inputAttPerson());
            return false;
        }
        boolean isSuccess = true;
        DynamicObjectCollection orgEntryColl = dataModel.getEntryEntity("entryentityorg");
        if (withOrg) {
            for (int index = 0; index < orgEntryColl.size(); ++index) {
                DynamicObject orgEntryDy = (DynamicObject)orgEntryColl.get(index);
                String orgType = orgEntryDy.getString("orgtype");
                DynamicObject orgClass = orgEntryDy.getDynamicObject("orgclass");
                if (!HRStringUtils.isEmpty((String)orgType) && !Objects.isNull(orgClass)) continue;
                view.showTipNotification(SupSignKDString.inputAdminOrg());
                isSuccess = false;
                break;
            }
        }
        DynamicObjectCollection personEntryColl = dataModel.getEntryEntity("entryentityperson");
        if (withPerson && isSuccess && CollectionUtils.isEmpty((Collection)personEntryColl)) {
            view.showTipNotification(SupSignKDString.inputAttPerson());
            isSuccess = false;
        }
        if (isSuccess && orgEntryColl.size() <= 0 && personEntryColl.size() <= 0) {
            view.showTipNotification(SupSignKDString.noAttFile());
            isSuccess = false;
        }
        return isSuccess;
    }

    public static void packageSuppleWorkTime(PackageDataEvent args) {
        DynamicObject rowData = args.getRowData();
        AbstractColumnDesc source = (AbstractColumnDesc)args.getSource();
        String fieldKey = source.getFieldKey();
        if (HRStringUtils.equals((String)FIELD_SUPPLEWORKTIMESHOW, (String)fieldKey)) {
            int suppleWorkTime = rowData.getInt("supsigninfo.suppleworktime");
            args.setFormatValue((Object)LocalTime.ofSecondOfDay(suppleWorkTime).format(DateTimeFormatter.ofPattern("HH:mm:ss")));
        }
    }

    public static FormShowParameter showFrom(String formId, String caption, long pkId) {
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.setShowTitle(true);
        formShowParameter.setCaption(caption);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if (pkId != 0L) {
            formShowParameter.setPkId((Object)pkId);
        }
        return formShowParameter;
    }

    public static boolean checkBillTaskIsFinished(long billId, IFormView view, String taskCategory) {
        boolean taskCanNotRun;
        if (billId == 0L) {
            return true;
        }
        boolean taskIsRun = BillApplyTaskService.taskStatusIsRun((long)billId);
        String taskLogEntityId = BillApplyTaskFactoryService.getTaskLogEntityId((String)taskCategory);
        DynamicObject taskLog = SupSignTaskHelper.getTaskLogByBillIdInProcess((long)billId, (String)taskLogEntityId);
        boolean bl = taskCanNotRun = taskLog != null || taskIsRun;
        if (taskCanNotRun) {
            String billNo = "";
            if (view instanceof IListView) {
                IListView listView = (IListView)view;
                ListSelectedRowCollection selectedRows = listView.getSelectedRows();
                if (!CollectionUtils.isEmpty((Collection)selectedRows)) {
                    billNo = selectedRows.get(0).getBillNo();
                }
            } else {
                billNo = view.getModel().getDataEntity().getString("billno");
            }
            String msg = String.format(Locale.ROOT, SupSignKDString.billIsInTask(), billNo);
            view.showTipNotification(msg);
            return false;
        }
        BillApplyTaskService.cacheTaskStatus((long)billId);
        return true;
    }

    public static void handleSupSignDateFilterRange(IFormView view, FilterContainerSearchClickArgs args, BillSystemParamConfigEnum configEnum, String filterKey) {
        Map currentCommonFilter = args.getCurrentCommonFilter();
        if (currentCommonFilter == null) {
            return;
        }
        for (Object fieldName : (List)currentCommonFilter.get("FieldName")) {
            if (!filterKey.equals(fieldName)) continue;
            SupSignCommonViewHelper.handleSignDateFilter(view, args, currentCommonFilter, configEnum, filterKey);
        }
    }

    private static void handleSignDateFilter(IFormView view, FilterContainerSearchClickArgs args, Map<String, List<Object>> currentCommonFilter, BillSystemParamConfigEnum configEnum, String filterKey) {
        BillSystemParamRange range;
        Tuple<Boolean, String> result;
        boolean checkResult;
        List<Object> values;
        Date startDate = null;
        Date endDate = null;
        List qFilters = args.getFilterModel().getFilterObject().getFilterResult().getQFilters();
        ArrayList<QFilter> allFilter = new ArrayList<QFilter>(qFilters.size());
        for (QFilter qFilter : qFilters) {
            allFilter.add(qFilter);
            SupSignCommonViewHelper.getAllNestFilter(qFilter, allFilter);
        }
        for (QFilter qFilter : allFilter) {
            if (StringUtils.equals((CharSequence)filterKey, (CharSequence)qFilter.getProperty())) {
                if (">=".equals(qFilter.getCP()) || ">".equals(qFilter.getCP())) {
                    startDate = (Date)qFilter.getValue();
                }
                if ("<=".equals(qFilter.getCP()) || "<".equals(qFilter.getCP())) {
                    endDate = (Date)qFilter.getValue();
                }
            }
            if (startDate == null || endDate == null) continue;
            break;
        }
        if ((values = currentCommonFilter.get("Value")) != null && values.size() > 1 && !(checkResult = ((Boolean)(result = SupSignCommonViewHelper.dateCheckSuccess(range = SystemParamQueryUtil.getBillSystemParamRange((BillSystemParamConfigEnum)configEnum), startDate, endDate)).getKey()).booleanValue())) {
            view.showTipNotification((String)result.getValue());
            values.clear();
            values.add("63");
        }
    }

    private static void getAllNestFilter(QFilter qFilter, List<QFilter> allFilter) {
        List nests = qFilter.getNests(true);
        if (CollectionUtils.isEmpty((Collection)nests)) {
            return;
        }
        for (QFilter.QFilterNest nestFilter : nests) {
            QFilter filter = nestFilter.getFilter();
            allFilter.add(filter);
            SupSignCommonViewHelper.getAllNestFilter(filter, allFilter);
        }
    }

    public static Tuple<Boolean, String> dateCheckSuccess(BillSystemParamRange range, Date startDate, Date endDate) {
        if (range == null || startDate == null || endDate == null) {
            return new Tuple((Object)Boolean.TRUE, (Object)"");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        switch (range.getUnit()) {
            case "year": {
                calendar.add(1, range.getRange());
                break;
            }
            case "month": {
                calendar.add(2, range.getRange());
                break;
            }
            case "day": {
                calendar.add(6, range.getRange());
                break;
            }
        }
        boolean success = !WTCDateUtils.addDays((Date)endDate, (int)0).after(calendar.getTime());
        String unit = null;
        if (!success) {
            switch (range.getUnit()) {
                case "year": {
                    unit = ResManager.loadKDString((String)"\u5e74", (String)"WTCBillViewUtils_0", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "month": {
                    unit = ResManager.loadKDString((String)"\u4e2a\u6708", (String)"WTCBillViewUtils_1", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "day": {
                    unit = ResManager.loadKDString((String)"\u65e5", (String)"WTCBillViewUtils_2", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]);
                    break;
                }
                default: {
                    unit = "";
                }
            }
        }
        return new Tuple((Object)success, (Object)(success ? "" : String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6700\u5927\u53ef\u67e5\u8be2\u65e5\u671f\u8303\u56f4\u4e3a%1$s\u3002", (String)"WTCBillViewUtils_3", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]), range.getRange() + unit)));
    }
}

