/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.formplugin.suppleapply.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.common.model.bill.BillSystemParam;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtpm.business.signcard.AdCheckService;
import kd.wtc.wtpm.business.signcard.supplyapply.helper.SupSignHisHelper;
import kd.wtc.wtpm.business.signcard.supplyapply.service.SupSignService;
import kd.wtc.wtpm.business.signcard.validator.SupSignCheckServiceHandler;
import kd.wtc.wtpm.constants.suppleapply.SupSignKDString;
import kd.wtc.wtpm.enums.SignCardBillTypeEnum;
import kd.wtc.wtpm.vo.suppleapply.AdCheckVo;

public class SupSignViewHelper {
    private static final Log LOG = LogFactory.getLog(SupSignViewHelper.class);

    private SupSignViewHelper() {
    }

    public static void reasonBeforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent, IFormView view) {
        Date signDate;
        IDataModel model = view.getModel();
        EntryGrid supSignEntry = (EntryGrid)view.getControl("entryentity");
        int[] selectRows = supSignEntry.getSelectRows();
        int selectIndex = 0;
        if (selectRows != null && selectRows.length > 0) {
            selectIndex = selectRows[0];
        }
        if ((signDate = (Date)model.getValue("signdate", selectIndex)) == null) {
            beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "=", (Object)0L));
            return;
        }
        long attFileBoId = model.getDataEntity().getLong("attfile.id");
        Optional optional = SupSignService.getSupSignReason((long)attFileBoId, (Date)signDate);
        if (!optional.isPresent()) {
            beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "=", (Object)0L));
        } else {
            List reasonIdList = ((List)optional.get()).stream().mapToLong(reasonDy -> reasonDy.getLong("id")).boxed().collect(Collectors.toList());
            beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", reasonIdList));
        }
    }

    public static void switchPerson(IFormView view) {
        RichTextEditor richTextEditor = (RichTextEditor)view.getControl("richtexteditorap");
        richTextEditor.setText("");
        view.getModel().deleteEntryData("entryentity");
        view.getModel().createNewEntryRow("entryentity");
        view.updateView("entryentity");
        Container policyContainer = (Container)view.getControl("supplypolicypanel");
        policyContainer.setCollapse(true);
        Container attachmentContainer = (Container)view.getControl("attchmentcontentpanel");
        attachmentContainer.setCollapse(true);
    }

    public static void reasonPropertyChanged(PropertyChangedArgs propertyChangedArgs, IFormView view) {
        IDataModel model = view.getModel();
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        int index = changeData.getRowIndex();
        if (changeData.getNewValue() == null) {
            model.setValue("attpolicy", null, index);
            SupSignViewHelper.setAttPolicy(view);
            return;
        }
        DynamicObject attFileDy = model.getDataEntity().getDynamicObject("attfile");
        if (attFileDy != null) {
            DynamicObject reasonDy = (DynamicObject)changeData.getNewValue();
            long reasonId = reasonDy.getLong("id");
            SupSignViewHelper.showMultipleCountLimit(view);
            SupSignViewHelper.setAttPolicy(view);
        }
    }

    public static void setAttPolicy(IFormView view) {
        HashMap reasonPolicyMap;
        LOG.info("SupSignViewHelper.setAttPolicy.start");
        EntryGrid entryGrid = (EntryGrid)view.getControl("entryentity");
        DynamicObject[] supSignInfoArr = entryGrid.getEntryData().getDataEntitys();
        if (supSignInfoArr == null || supSignInfoArr.length == 0) {
            return;
        }
        BillSystemParam billSystemParam = SystemParamQueryUtil.getBillSystemParam();
        String systemDes = billSystemParam.getSystemdes();
        if ("2".equals(systemDes)) {
            DynamicObject entryEntityData = supSignInfoArr[supSignInfoArr.length - 1];
            reasonPolicyMap = Maps.newHashMapWithExpectedSize((int)1);
            reasonPolicyMap.put(entryEntityData.getString("applyreason.name"), entryEntityData.getLong("attpolicy"));
        } else {
            reasonPolicyMap = Stream.of(supSignInfoArr).collect(Collectors.toMap(item -> item.getString("applyreason.name"), item -> item.getLong("attpolicy"), (item1, item2) -> item1));
        }
        LOG.info("SupSignViewHelper.setAttPolicy.getPolicyContent.start");
        Optional optional = SupSignService.getPolicyContent((Map)reasonPolicyMap);
        LOG.info("SupSignViewHelper.setAttPolicy.getPolicyContent.end");
        if (optional.isPresent()) {
            RichTextEditor richTextEditor = (RichTextEditor)view.getControl("richtexteditorap");
            richTextEditor.setText((String)optional.get());
            view.setVisible(Boolean.TRUE, new String[]{"richtexteditorap"});
            view.setVisible(Boolean.FALSE, new String[]{"lackpageflex"});
            Container policyContainer = (Container)view.getControl("supplypolicypanel");
            policyContainer.setCollapse(false);
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"richtexteditorap"});
            view.setVisible(Boolean.TRUE, new String[]{"lackpageflex"});
            Container policyContainer = (Container)view.getControl("supplypolicypanel");
            policyContainer.setCollapse(true);
        }
        LOG.info("SupSignViewHelper.setAttPolicy.end");
    }

    public static void signDatePropertyChanged(PropertyChangedArgs propertyChangedArgs, IFormView view) {
        LOG.info("SupSignViewHelper.signDatePropertyChanged.begin");
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        int index = changeData.getRowIndex();
        IDataModel model = view.getModel();
        Date signDate = (Date)changeData.getNewValue();
        LOG.info("SupSignViewHelper.signDatePropertyChanged.signDate={}", (Object)signDate);
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObject attFile = dataEntity.getDynamicObject("attfile");
        model.setValue("applyreason", null, index);
        if (signDate != null && attFile != null) {
            try {
                SupSignViewHelper.checkCurrentIndex(view, index, Lists.newArrayList((Object[])new DynamicObject[]{attFile}));
            }
            catch (Exception ex) {
                LOG.warn("SupSignViewHelper.signDatePropertyChanged.checkCurrentIndex error", (Throwable)ex);
                throw new KDBizException(SupSignKDString.checkFail());
            }
        }
        if (attFile != null) {
            long attFileBoId = attFile.getLong("id");
            LOG.info("SupSignViewHelper.signDatePropertyChanged.attFileBoId={}", (Object)attFileBoId);
            SupSignViewHelper.showMultipleCountLimit(view);
            SupSignViewHelper.setTimeZoneDefaultValue(view, index, signDate, attFileBoId);
        }
    }

    public static void setTimeZoneDefaultValue(IFormView view, int index, Date signDate, long attFileBoId) {
        EntryGrid entryGrid = (EntryGrid)view.getControl("entryentity");
        DynamicObject[] dataEntities = entryGrid.getEntryData().getDataEntitys();
        DynamicObject dataEntity = dataEntities[index];
        if (dataEntity.get("timezone") != null) {
            return;
        }
        DynamicObject timeZoneDy = SupSignHisHelper.getTimeZoneHis((long)attFileBoId, (Date)signDate);
        if (timeZoneDy == null) {
            view.getModel().setItemValueByNumber("timezone", "Asia/Shanghai", index);
            return;
        }
        DynamicObject tz = timeZoneDy.getDynamicObject("tz");
        view.getModel().setValue("timezone", (Object)tz, index);
    }

    public static boolean checkCurrentIndex(IFormView view, int index, List<DynamicObject> attFileList) {
        LOG.info("SupSignViewHelper.checkCurrentIndex.begin");
        IDataModel model = view.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        LOG.info("SupSignViewHelper.checkCurrentIndex.attFileList.size:{}", (Object)attFileList.size());
        ArrayList currentAttFileList = Lists.newArrayList((Object[])new DynamicObject[]{attFileList.get(0)});
        DynamicObjectCollection supSignInfoColl = dataEntity.getDynamicObjectCollection("entryentity");
        DynamicObject supSignInfo = (DynamicObject)supSignInfoColl.get(index);
        ArrayList supSignInfoList = Lists.newArrayList((Object[])new DynamicObject[]{supSignInfo});
        List adCheckVoList = AdCheckService.genAdCheckVoList((List)currentAttFileList, (List)supSignInfoList);
        LOG.info("SupSignViewHelper.checkCurrentIndex.adCheckVoList.size:{}", (Object)adCheckVoList.size());
        String applyType = dataEntity.getString("applytyperadio");
        SignCardBillTypeEnum billTypeEnum = "1".equals(applyType) ? SignCardBillTypeEnum.OTHER_BILL : SignCardBillTypeEnum.SELF_BILL;
        String appId = BillCommonService.getInstance().getAuthAppIdForFormPlugin(view);
        SupSignCheckServiceHandler serviceHandler = new SupSignCheckServiceHandler(adCheckVoList, billTypeEnum, appId);
        boolean checkResult = serviceHandler.singleBillEditCheck();
        if (!checkResult && !CollectionUtils.isEmpty((Collection)adCheckVoList)) {
            view.showTipNotification(((AdCheckVo)adCheckVoList.get(0)).getErrorMsg());
        }
        SupSignViewHelper.cachePolicyAndReason(adCheckVoList, view, index);
        return checkResult;
    }

    private static void cachePolicyAndReason(List<AdCheckVo> adCheckVoList, IFormView view, int index) {
        if (WTCCollections.isNotEmpty(adCheckVoList)) {
            HashMap<String, Long> allReasonPolicyMap = new HashMap<String, Long>(adCheckVoList.size());
            for (AdCheckVo adCheckVo : adCheckVoList) {
                DynamicObject adRuleDy = adCheckVo.getAdRuleDy();
                Date signDate = adCheckVo.getSignDate();
                long signDateTime = 0L;
                if (signDate != null) {
                    signDateTime = signDate.getTime();
                }
                Map<String, Long> reasonPolicyMap = null;
                if (adRuleDy != null) {
                    DynamicObjectCollection reasonPolicyColl = adRuleDy.getDynamicObjectCollection("entryentity");
                    long finalSignDateTime = signDateTime;
                    reasonPolicyMap = reasonPolicyColl.stream().filter(item -> item.get("attpolicy") != null).collect(Collectors.toMap(item -> item.getLong("reason.id") + "_" + finalSignDateTime, item -> item.getLong("attpolicy.id"), (o1, o2) -> o1));
                }
                if (!WTCCollections.isNotEmpty(reasonPolicyMap)) continue;
                allReasonPolicyMap.putAll(reasonPolicyMap);
            }
            IDataModel model = view.getModel();
            DynamicObject dataEntity = view.getModel().getDataEntity(true);
            DynamicObjectCollection supSignInfoColl = dataEntity.getDynamicObjectCollection("entryentity");
            int entryRowCount = supSignInfoColl.size();
            if (index == -1) {
                for (int ii = 0; ii < entryRowCount; ++ii) {
                    SupSignViewHelper.setEntryPolicyId(model, supSignInfoColl, ii, allReasonPolicyMap);
                }
            } else {
                SupSignViewHelper.setEntryPolicyId(model, supSignInfoColl, index, allReasonPolicyMap);
            }
        }
    }

    private static void setEntryPolicyId(IDataModel model, DynamicObjectCollection supSignInfoColl, int index, Map<String, Long> allReasonPolicyMap) {
        DynamicObject supSignInfoDy = (DynamicObject)supSignInfoColl.get(index);
        long applyReasonId = supSignInfoDy.getLong("applyreason.id");
        Date signDate = supSignInfoDy.getDate("signdate");
        long signDateTime = 0L;
        if (signDate != null) {
            signDateTime = signDate.getTime();
        }
        Long policyId = allReasonPolicyMap.get(applyReasonId + "_" + signDateTime);
        model.setValue("attpolicy", (Object)policyId, index);
    }

    public static void showMultipleCountLimit(IFormView view) {
        LOG.info("SupSignViewHelper.showMultipleCountLimit.start");
        IDataModel model = view.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObject attFile = dataEntity.getDynamicObject("attfile");
        ArrayList attFileList = Lists.newArrayList((Object[])new DynamicObject[]{attFile});
        DynamicObjectCollection supSignInfoColl = dataEntity.getDynamicObjectCollection("entryentity");
        ArrayList supSignInfoList = Lists.newArrayList((Iterable)supSignInfoColl);
        List adCheckVoList = AdCheckService.genAdCheckVoList((List)attFileList, (List)supSignInfoList);
        List countLimitList = SupSignService.getMultipleCountLimitList((List)adCheckVoList);
        SupSignViewHelper.cachePolicyAndReason(adCheckVoList, view, -1);
        if (!CollectionUtils.isEmpty((Collection)countLimitList)) {
            String countDesc = SupSignViewHelper.joinStrList(countLimitList, "\r\n");
            Label label = (Label)view.getControl("countexplain");
            label.setText(countDesc);
            view.setVisible(Boolean.TRUE, new String[]{"supsigncountpanel"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"supsigncountpanel"});
        }
        LOG.info("SupSignViewHelper.showMultipleCountLimit.end");
    }

    private static String joinStrList(List<String> strList, String separator) {
        if (CollectionUtils.isEmpty(strList)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int index = 1;
        for (String str : strList) {
            sb.append(str);
            if (index < strList.size()) {
                sb.append(separator);
            }
            ++index;
        }
        return sb.toString();
    }

    private static Optional<Long> getPolicyByReason(IFormView view, long reasonId, Date signDate) {
        IPageCache pageCache = view.getPageCache();
        String reasonPolicyCache = null;
        if (signDate != null) {
            reasonPolicyCache = pageCache.get("reason_policy_cachekey" + signDate.getTime());
        }
        Optional<Long> result = Optional.empty();
        if (HRStringUtils.isNotEmpty(reasonPolicyCache)) {
            try {
                Long policyId;
                Map reasonPolicyMap = (Map)SerializationUtils.fromJsonString(reasonPolicyCache, Map.class);
                if (reasonPolicyMap != null && (policyId = (Long)reasonPolicyMap.get(String.valueOf(reasonId))) != null) {
                    result = Optional.of(policyId);
                }
            }
            catch (RuntimeException exception) {
                LOG.warn("SupSignViewHelper.getPolicyByReason json parse error", (Throwable)exception);
            }
        }
        return result;
    }
}

