/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.formplugin.suppleapply.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.IListView;
import kd.bos.list.ListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.EnableCustomSumEvent;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseList;
import kd.wtc.wtbs.business.caltask.common.billapply.BillApplyTaskDetailStatus;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtpm.business.signcard.task.BillApplyTaskFactoryService;
import kd.wtc.wtpm.constants.suppleapply.SupSignKDString;

public class BillApplyTaskDetailList
extends HRCoreBaseList {
    private static final Map<String, QFilter> TABKEYFILTERMAP = new HashMap<String, QFilter>(4);

    public void setEnableCustomSum(EnableCustomSumEvent args) {
        super.setEnableCustomSum(args);
        args.setEnableCustomSum(false);
    }

    public void setFilter(SetFilterEvent args) {
        super.setFilter(args);
        String tabKey = this.getPageCache().get("tabkey");
        if (HRStringUtils.isEmpty((String)tabKey)) {
            args.getQFilters().add(new QFilter("id", "=", (Object)0L));
        } else {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            long taskId = (Long)customParams.get("taskid");
            QFilter qFilter = new QFilter("taskid", "=", (Object)taskId);
            QFilter statusFilter = TABKEYFILTERMAP.get(tabKey);
            if (statusFilter != null) {
                qFilter.and(statusFilter);
            }
            args.getQFilters().add(qFilter);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        String tabKey = (String)this.getView().getFormShowParameter().getCustomParam("tabkey");
        HashSet failStatus = Sets.newHashSet((Object[])new String[]{BillApplyTaskDetailStatus.FAIL.code, BillApplyTaskDetailStatus.NOTRUN.code});
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (CollectionUtils.isEmpty((Collection)rows)) {
                    return rows;
                }
                Set haveTipMsgAttFileIds = BillApplyTaskDetailList.this.getHaveTipMsgAttFileIds(rows);
                rows.forEach(row -> {
                    if (haveTipMsgAttFileIds.contains(row.getLong("attfile.boid"))) {
                        row.set("desc", (Object)ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"BillApplyTaskDetailList_0", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]));
                    }
                });
                return rows;
            }
        });
    }

    private Set<Long> getHaveTipMsgAttFileIds(DynamicObjectCollection rows) {
        if (WTCCollections.isEmpty((Collection)rows)) {
            return Sets.newHashSet();
        }
        Set<Long> ids = rows.stream().map(item -> item.getLong("id")).collect(Collectors.toSet());
        QFilter exDetailFilter = this.getExDetailFilter(ids);
        IListView view = (IListView)this.getView();
        String billFormId = view.getBillFormId();
        String exEntityId = "wtpm_supsigntaskdetail".equals(billFormId) ? "wtpm_supsignexdetail" : "wtpm_signcardexdetail";
        HRBaseServiceHelper serviceHelper = HRBaseServiceHelper.create((String)exEntityId);
        DynamicObject[] dynamicObjects = serviceHelper.queryOriginalArray("attfileid", exDetailFilter.toArray());
        return Arrays.stream(dynamicObjects).map(item -> item.getLong("attfileid")).collect(Collectors.toSet());
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        String tabKey = (String)this.getView().getFormShowParameter().getCustomParam("tabkey");
        if ("successtab".equals(tabKey)) {
            return;
        }
        List columnList = args.getListColumns();
        ListColumn col = new ListColumn();
        col.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5f02\u5e38\u539f\u56e0", (String)"BillApplyTaskDetailList_1", (String)"wtc-wtpm-formplugin", (Object[])new Object[0])));
        col.setKey("desc");
        col.setListFieldKey("desc");
        col.setFieldName("desc");
        col.setFixed(false);
        col.setHyperlink(true);
        col.setColumnFilter(false);
        col.setColumnOrder(false);
        columnList.add(col);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String taskCategory;
        boolean hasRight;
        super.billListHyperLinkClick(args);
        args.setCancel(true);
        BillListHyperLinkClickEvent clickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        String fieldName = args.getFieldName();
        if (HRStringUtils.equalsIgnoreCase((String)fieldName, (String)"desc") && (hasRight = this.checkHasViewDetailRight(taskCategory = (String)this.getView().getFormShowParameter().getCustomParam("taskCategory")))) {
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.getOpenStyle().setInlineStyleCss(this.getStyle());
            listShowParameter.setCaption(SupSignKDString.exceptionReason());
            listShowParameter.setFormId("wtpm_listborderless");
            listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            listShowParameter.setBillFormId(BillApplyTaskFactoryService.getExDetailEntityId((String)taskCategory));
            Long detailId = (Long)clickEvent.getCurrentRow().getPrimaryKeyValue();
            listShowParameter.getListFilterParameter().getQFilters().add(this.getExDetailFilter(Sets.newHashSet((Object[])new Long[]{detailId})));
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    private boolean checkHasViewDetailRight(String taskCategory) {
        boolean hasRight;
        RequestContext ctx = RequestContext.get();
        long currUserId = ctx.getCurrUserId();
        String appNumber = "wtpm";
        String entityId = "wtpm_signcardtasklog";
        if ("wtpm_supsign".equals(taskCategory)) {
            appNumber = "wtam";
            entityId = "wtpm_supsigntasklog";
        }
        if (!(hasRight = PermissionServiceHelper.hasViewPermission((long)currUserId, (String)appNumber, (String)entityId))) {
            this.getView().showErrorNotification(SupSignKDString.noViewLogDetailRight());
        }
        return hasRight;
    }

    private QFilter getExDetailFilter(Set<Long> detailIds) {
        String taskCategory = (String)this.getView().getFormShowParameter().getCustomParam("taskCategory");
        HRBaseServiceHelper helper = new HRBaseServiceHelper(BillApplyTaskFactoryService.getTaskDetailEntityId((String)taskCategory));
        String queryFiled = "attfileboid,taskid,subtaskid";
        DynamicObject[] datas = helper.queryOriginalArray(queryFiled, new QFilter[]{new QFilter("id", "in", detailIds)});
        ArrayList<Long> attFileBoIds = new ArrayList<Long>(detailIds.size());
        ArrayList<Long> taskIds = new ArrayList<Long>(detailIds.size());
        ArrayList<Long> subTaskIds = new ArrayList<Long>(detailIds.size());
        for (DynamicObject data : datas) {
            long attFileId = data.getLong("attfileboid");
            long taskId = data.getLong("taskid");
            long subTaskId = data.getLong("subtaskid");
            attFileBoIds.add(attFileId);
            taskIds.add(taskId);
            subTaskIds.add(subTaskId);
        }
        QFilter qFilter = new QFilter("attfileid", "in", attFileBoIds);
        qFilter.and("taskid", "in", taskIds);
        qFilter.and("subtaskid", "in", subTaskIds);
        return qFilter;
    }

    private StyleCss getStyle() {
        StyleCss style = new StyleCss();
        style.setWidth("1000");
        style.setHeight("600");
        return style;
    }

    static {
        TABKEYFILTERMAP.put("totaltab", new QFilter("matchstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{BillApplyTaskDetailStatus.SUCCESS.code, BillApplyTaskDetailStatus.FAIL.code})));
        TABKEYFILTERMAP.put("successtab", new QFilter("matchstatus", "=", (Object)BillApplyTaskDetailStatus.SUCCESS.code));
        TABKEYFILTERMAP.put("failtab", new QFilter("matchstatus", "=", (Object)BillApplyTaskDetailStatus.FAIL.code));
        TABKEYFILTERMAP.put("notruntab", new QFilter("matchstatus", "=", (Object)BillApplyTaskDetailStatus.NOTRUN.code));
    }
}

