/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.formplugin.suppleapply.task;

import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.wtc.wtbs.business.task.common.WTCTaskStatus;
import kd.wtc.wtbs.business.task.view.TaskDetailShowUtils;
import kd.wtc.wtpm.business.signcard.task.BillApplyTaskFactoryService;
import kd.wtc.wtpm.common.ad.AdCommonUtils;

public class BillApplyTaskLogList
extends HRDataBaseList {
    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        FormShowParameter formShowParameter = args.getFormShowParameter();
        Object taskCategory = formShowParameter.getCustomParam("taskCategory");
        if (taskCategory == null) {
            formShowParameter.setCustomParam("taskCategory", (Object)"wtpm_supsign");
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getFieldName();
        this.getPageCache().put("selectFieldName", fieldName);
    }

    public void beforeShowBill(BeforeShowBillFormEvent evt) {
        super.beforeShowBill(evt);
        BillShowParameter parameter = evt.getParameter();
        Object pkId = parameter.getPkId();
        String taskCategory = (String)this.getView().getFormShowParameter().getCustomParam("taskCategory");
        HRBaseServiceHelper helper = new HRBaseServiceHelper(BillApplyTaskFactoryService.getTaskLogEntityId((String)taskCategory));
        DynamicObject logDy = helper.loadDynamicObject(new QFilter[]{new QFilter("id", "=", pkId)});
        boolean checkTaskStatus = this.checkTaskStatus(logDy);
        if (checkTaskStatus) {
            String version = logDy.getString("billno");
            String caption = ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5-", (String)"BillApplyTaskLogList_2", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]);
            caption = caption + version;
            parameter.setCaption(caption);
            String fieldName = this.getPageCache().get("selectFieldName");
            parameter.setCustomParam("tabkey", (Object)fieldName);
            parameter.setCustomParam("taskCategory", (Object)taskCategory);
            parameter.setBillStatus(BillOperationStatus.VIEW);
        }
        evt.setCancel(!checkTaskStatus);
    }

    public void packageData(PackageDataEvent args) {
        super.packageData(args);
        DynamicObject rowData = args.getRowData();
        AbstractColumnDesc source = (AbstractColumnDesc)args.getSource();
        String fieldKey = source.getFieldKey();
        if (HRStringUtils.equals((String)"task.timecost", (String)fieldKey)) {
            int timeCost = rowData.getInt("task.timecost");
            args.setFormatValue((Object)AdCommonUtils.msFormat((long)timeCost));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("taskdetailview".equals(operateKey)) {
            long pkId = (Long)this.getFocusRowPkId();
            String taskCategory = (String)this.getView().getFormShowParameter().getCustomParam("taskCategory");
            HRBaseServiceHelper helper = new HRBaseServiceHelper(BillApplyTaskFactoryService.getTaskLogEntityId((String)taskCategory));
            DynamicObject logDy = helper.loadDynamicObject(new QFilter[]{new QFilter("id", "=", (Object)pkId)});
            if (logDy == null) {
                return;
            }
            boolean checkTaskStatus = this.checkTaskStatus(logDy);
            if (checkTaskStatus) {
                String billNo = logDy.getString("billno");
                String caption = TaskDetailShowUtils.genCaption((String)billNo);
                DynamicObject taskDy = logDy.getDynamicObject("task");
                if (taskDy == null) {
                    return;
                }
                long taskId = taskDy.getLong("id");
                TaskDetailShowUtils.showTaskDetail((IFormView)this.getView(), (String)"wtpm_supsigntaskview", (long)taskId, (String)taskCategory, (String)caption);
            }
        }
    }

    private boolean checkTaskStatus(DynamicObject logDy) {
        boolean checkTaskStatus;
        DynamicObject taskDy = logDy.getDynamicObject("task");
        if (taskDy != null) {
            long taskId = taskDy.getLong("id");
            String status = taskDy.getString("taskstatus");
            if (HRObjectUtils.isEmpty((Object)taskId) || taskId == 0L || WTCTaskStatus.RUNNING.getCode().equals(status)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u8fdb\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"BillApplyTaskLogList_0", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                checkTaskStatus = false;
            } else if (WTCTaskStatus.TERMINATING.getCode().equals(status)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u6b63\u5728\u7ec8\u6b62\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"BillApplyTaskLogList_3", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                checkTaskStatus = false;
            } else {
                checkTaskStatus = true;
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u672a\u521b\u5efa\u3002", (String)"BillApplyTaskLogList_4", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            checkTaskStatus = false;
        }
        return checkTaskStatus;
    }
}

