/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.formplugin.suppleapply.task;

import java.util.EventObject;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtpm.business.signcard.supplyapply.helper.SupSignTaskHelper;
import kd.wtc.wtpm.business.signcard.task.BillApplyTaskFactoryService;
import kd.wtc.wtpm.vo.suppleapply.BillTaskResultVo;

public class BillApplyTaskResultPlugin
extends HRDynamicFormBasePlugin {
    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        Label label = (Label)this.getControl("viewdetail");
        label.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskid");
        String taskCategory = (String)this.getView().getFormShowParameter().getCustomParam("taskCategory");
        String taskDetailEntityId = BillApplyTaskFactoryService.getTaskDetailEntityId((String)taskCategory);
        BillTaskResultVo billTaskResultVo = SupSignTaskHelper.getBillTaskResult((long)taskId, (String)taskDetailEntityId);
        this.setLabelText("total", billTaskResultVo.getTotalAttFile());
        this.setLabelText("totalcard", billTaskResultVo.getTotalCard());
        this.setLabelText("successtotal", billTaskResultVo.getSuccessAttFile());
        this.setLabelText("successcard", billTaskResultVo.getSuccessCard());
        this.setLabelText("parttotal", billTaskResultVo.getPartSuccessAttFile());
        this.setLabelText("partsuccesscard", billTaskResultVo.getPartSuccessCard());
        this.setLabelText("partfailcard", billTaskResultVo.getPartFailCard());
        this.setLabelText("failtotal", billTaskResultVo.getAllFailAttFile());
        this.setLabelText("failcard", billTaskResultVo.getAllFailCard());
        this.setLabelText("notrun", billTaskResultVo.getNotRunAttFile());
        this.setLabelText("notruncard", billTaskResultVo.getNotRunCard());
    }

    private void setLabelText(String labelKey, int value) {
        Label label = (Label)this.getControl(labelKey);
        if (label != null) {
            label.setText(String.valueOf(value));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (operateKey.equals("close")) {
            this.getView().close();
        } else if ("viewdetail".equals(operateKey)) {
            this.showTaskDetail();
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        String parentViewPageId = (String)this.getView().getFormShowParameter().getCustomParam("parentViewPageId");
        if (HRStringUtils.isEmpty((String)parentViewPageId)) {
            return;
        }
        IFormView parentView = this.getView().getView(parentViewPageId);
        if (parentView == null) {
            return;
        }
        parentView.invokeOperation("refresh");
        this.getView().sendFormAction(parentView);
    }

    public void showTaskDetail() {
        String taskCategory;
        String entityId;
        long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskid");
        DynamicObject taskLog = SupSignTaskHelper.getTaskLogByTaskId((long)taskId, (String)(entityId = BillApplyTaskFactoryService.getTaskLogEntityId((String)(taskCategory = (String)this.getView().getFormShowParameter().getCustomParam("taskCategory")))));
        if (taskLog == null) {
            return;
        }
        String billNo = taskLog.getString("billno");
        String caption = ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5-", (String)"BillApplyTaskResultPlugin_0", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]);
        caption = caption + billNo;
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setCaption(caption);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId(BillApplyTaskFactoryService.getTaskLogEntityId((String)taskCategory));
        parameter.setCustomParam("taskCategory", (Object)taskCategory);
        parameter.setCustomParam("tabkey", (Object)"billno");
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setPkId(taskLog.get("id"));
        parameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)parameter);
    }
}

