/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.macc.opplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bd.macc.common.helper.MaterialHelper;
import kd.bd.macc.common.utils.DynamicObjDataUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class CadBomSubmitValidate
extends AbstractValidator {
    private static final String MATERIAL = "material";
    private static final String MASTERID = "masterid";
    private static final String NUMBER = "number";
    private static final String NAME = "name";

    public void validate() {
        String operate = this.getOperateKey();
        ExtendedDataEntity[] objs = this.getDataEntities();
        if (objs == null || objs.length <= 0) {
            return;
        }
        if ("submit".equalsIgnoreCase(operate)) {
            for (ExtendedDataEntity obj : objs) {
                DynamicObject entryversionMaterial;
                DynamicObject bom = obj.getDataEntity();
                if (bom == null) continue;
                String number = DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)bom, (String)NUMBER);
                if (StringUtils.isBlank((CharSequence)number)) {
                    this.addErrorMessage(obj, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201cBOM\u7f16\u53f7\u201d\u3002", (String)"CadBomSubmitValidate_0", (String)"bd-macc-opplugin", (Object[])new Object[0]));
                    continue;
                }
                DynamicObject material = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)bom, (String)MATERIAL);
                if (material == null) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4ea7\u54c1\u7f16\u53f7\u201d\u3002", (String)"CadBomSubmitValidate_1", (String)"bd-macc-opplugin", (Object[])new Object[0]), new Object[0]));
                    continue;
                }
                DynamicObject version = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)bom, (String)"version");
                DynamicObject type = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)bom, (String)"type");
                if (type == null) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201cBOM\u7c7b\u578b\u201d\u3002", (String)"CadBomSubmitValidate_2", (String)"bd-macc-opplugin", (Object[])new Object[0]), new Object[0]));
                    continue;
                }
                Boolean isenablematerialversion = MaterialHelper.isEnableMaterialVersion((DynamicObject)material);
                Boolean isVersion = DynamicObjDataUtil.getDynamicObjectBooleanData((DynamicObject)type, (String)"isversion");
                if ((isenablematerialversion.booleanValue() || isVersion.booleanValue()) && version == null) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7248\u672c\u53f7\u201d\u3002", (String)"CadBomSubmitValidate_3", (String)"bd-macc-opplugin", (Object[])new Object[0]), new Object[0]));
                    continue;
                }
                DynamicObject versionMaterial = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)version, (String)MATERIAL);
                Object materialMaster = DynamicObjDataUtil.getDynamicObjectData((DynamicObject)material, (String)MASTERID);
                materialMaster = materialMaster instanceof DynamicObject ? ((DynamicObject)materialMaster).getPkValue() : material.getPkValue();
                if (!(versionMaterial == null || materialMaster != null && materialMaster.equals(versionMaterial.getPkValue()))) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u4ea7\u54c1\u7f16\u53f7[%1$s]\u4e0d\u5b58\u5728\u7248\u672c\u53f7[%2$s]\u3002", (String)"CadBomSubmitValidate_4", (String)"bd-macc-opplugin", (Object[])new Object[0]), DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)material, (String)NUMBER), DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)version, (String)NAME)));
                    continue;
                }
                DynamicObject auxpty = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)bom, (String)"auxproperty");
                Boolean isUseAuxpty = MaterialHelper.isUseAuxpty((DynamicObject)material);
                Boolean isAffectPricesForAuxpty = this.isAffectPricesForAuxpty(material);
                if (isUseAuxpty.booleanValue() && isAffectPricesForAuxpty.booleanValue() && auxpty == null) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u4ea7\u54c1\u7f16\u53f7[%s]\u542f\u7528\u4e86\u8f85\u52a9\u5c5e\u6027\uff0c\u5f71\u54cd\u4ef7\u683c\u7684\u8f85\u52a9\u5c5e\u6027\u5fc5\u5f55\u3002", (String)"CadBomSubmitValidate_6", (String)"bd-macc-opplugin", (Object[])new Object[0]), DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)material, (String)NUMBER)));
                    continue;
                }
                boolean iscoproduct = DynamicObjDataUtil.getDynamicObjectBooleanData((DynamicObject)bom, (String)"iscoproduct");
                Object copentryObj = DynamicObjDataUtil.getDynamicObjectData((DynamicObject)bom, (String)"copentry");
                DynamicObjectCollection copentrys = null;
                if (copentryObj instanceof DynamicObjectCollection) {
                    copentrys = (DynamicObjectCollection)copentryObj;
                }
                if ((copentrys == null || copentrys.isEmpty()) && iscoproduct) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u5df2\u52fe\u9009\u8054\u526f\u4ea7\u54c1,\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CadBomSubmitValidate_7", (String)"bd-macc-opplugin", (Object[])new Object[0]), new Object[0]));
                    continue;
                }
                if (copentrys != null) {
                    for (int i = 0; iscoproduct && i < copentrys.size(); ++i) {
                        DynamicObject copentry = (DynamicObject)copentrys.get(i);
                        Date copentryvaliddate = DynamicObjDataUtil.getDynamicObjectDateData((DynamicObject)copentry, (String)"copentryvaliddate");
                        Date copentryinvaliddate = DynamicObjDataUtil.getDynamicObjectDateData((DynamicObject)copentry, (String)"copentryinvaliddate");
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");
                        if (copentryvaliddate != null && copentryinvaliddate != null && copentryvaliddate.after(copentryinvaliddate)) {
                            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u7b2c%1$s\u884c,\u5931\u6548\u65e5\u671f[%2$s]<\u751f\u6548\u65e5\u671f[%3$s]\u3002", (String)"CadBomSubmitValidate_8", (String)"bd-macc-opplugin", (Object[])new Object[0]), i + 1, sdf.format(copentryinvaliddate), sdf.format(copentryvaliddate)));
                            continue;
                        }
                        String copentrytype = DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)copentry, (String)"copentrytype");
                        if (copentrytype == null) {
                            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u7b2c%s\u884c,\u8bf7\u586b\u5199\u201c\u4ea7\u54c1\u7c7b\u578b\u201d\u3002", (String)"CadBomSubmitValidate_9", (String)"bd-macc-opplugin", (Object[])new Object[0]), i + 1));
                            continue;
                        }
                        DynamicObject copentrymaterial = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)copentry, (String)"copentrymaterial");
                        if (copentrymaterial == null) {
                            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u7b2c%s\u884c,\u8bf7\u586b\u5199\u201c\u7269\u6599\u7f16\u53f7\u201d\u3002", (String)"CadBomSubmitValidate_10", (String)"bd-macc-opplugin", (Object[])new Object[0]), i + 1));
                            continue;
                        }
                        if (copentrymaterial.getPkValue().equals(material.getPkValue())) {
                            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u7b2c%1$s\u884c,\u7269\u6599\u7f16\u53f7[%2$s]\u4e0e[\u4ea7\u54c1\u7f16\u53f7]\u91cd\u590d\u3002", (String)"CadBomSubmitValidate_11", (String)"bd-macc-opplugin", (Object[])new Object[0]), i + 1, DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)copentrymaterial, (String)NUMBER)));
                            continue;
                        }
                        Object copentrymaterialMaster = DynamicObjDataUtil.getDynamicObjectData((DynamicObject)copentrymaterial, (String)MASTERID);
                        DynamicObject copentrymaterialObj = copentrymaterial;
                        if (copentrymaterialMaster instanceof DynamicObject) {
                            copentrymaterialObj = (DynamicObject)copentrymaterialMaster;
                        }
                        DynamicObject copunit = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)copentry, (String)"copentryunit");
                        DynamicObject baseunit = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)copentrymaterialObj, (String)"baseunit");
                        if (copunit == null) {
                            copunit = baseunit;
                            copentry.set("copentryunit", (Object)copunit);
                        }
                        if (!copunit.getPkValue().equals(baseunit.getPkValue())) {
                            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u7b2c%1$s\u884c,\u7269\u6599\u7f16\u53f7[%2$s]\u4e0d\u5b58\u5728\u8ba1\u91cf\u5355\u4f4d[%3$s]\u3002", (String)"CadBomSubmitValidate_12", (String)"bd-macc-opplugin", (Object[])new Object[0]), i + 1, DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)copentrymaterial, (String)NUMBER), DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)copunit, (String)NAME)));
                            continue;
                        }
                        Boolean isuseauxpty = DynamicObjDataUtil.getDynamicObjectBooleanData((DynamicObject)copentrymaterialObj, (String)"isuseauxpty");
                        Boolean isAffectPricesForEntryAuxpty = this.isAffectPricesForAuxpty(copentrymaterialObj);
                        DynamicObject copentryversion = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)copentry, (String)"copentryversion");
                        if (!(copentryversion == null || (entryversionMaterial = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)copentryversion, (String)MATERIAL)) == null || (copentrymaterialMaster = copentrymaterialMaster instanceof DynamicObject ? ((DynamicObject)copentrymaterialMaster).getPkValue() : copentrymaterial.getPkValue()) != null && copentrymaterialMaster.equals(entryversionMaterial.getPkValue()))) {
                            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u7b2c%1$s\u884c,\u7269\u6599\u7f16\u53f7[%2$s]\u4e0d\u5b58\u5728\u7248\u672c\u53f7[%3$s]\u3002", (String)"CadBomSubmitValidate_13", (String)"bd-macc-opplugin", (Object[])new Object[0]), i + 1, DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)copentrymaterial, (String)NUMBER), DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)copentryversion, (String)NAME)));
                            continue;
                        }
                        DynamicObject copentryauxproperty = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)copentry, (String)"copentryauxproperty");
                        if (!isAffectPricesForEntryAuxpty.booleanValue() || !isuseauxpty.booleanValue() || copentryauxproperty != null) continue;
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u7b2c%1$s\u884c,\u7269\u6599\u7f16\u53f7[%2$s]\u542f\u7528\u4e86\u8f85\u52a9\u5c5e\u6027\uff0c\u8bf7\u586b\u5199\u201c\u8f85\u52a9\u5c5e\u6027\u201d\u3002", (String)"CadBomSubmitValidate_14", (String)"bd-macc-opplugin", (Object[])new Object[0]), i + 1, DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)copentrymaterial, (String)NUMBER)));
                    }
                }
                Object entryObj = DynamicObjDataUtil.getDynamicObjectData((DynamicObject)bom, (String)"entry");
                DynamicObjectCollection entrys = null;
                if (entryObj instanceof DynamicObjectCollection) {
                    entrys = (DynamicObjectCollection)entryObj;
                }
                if (entrys == null || entrys.isEmpty()) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CadBomSubmitValidate_15", (String)"bd-macc-opplugin", (Object[])new Object[0]), new Object[0]));
                    continue;
                }
                for (int i = 0; i < entrys.size(); ++i) {
                    DynamicObject entryversion;
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    Date entryvaliddate = DynamicObjDataUtil.getDynamicObjectDateData((DynamicObject)entry, (String)"entryvaliddate");
                    Date entryinvaliddate = DynamicObjDataUtil.getDynamicObjectDateData((DynamicObject)entry, (String)"entryinvaliddate");
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");
                    if (entryvaliddate != null && entryinvaliddate != null && entryvaliddate.after(entryinvaliddate)) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c%1$s\u884c,\u5931\u6548\u65e5\u671f[%2$s]<\u751f\u6548\u65e5\u671f[%3$s]\u3002", (String)"CadBomSubmitValidate_16", (String)"bd-macc-opplugin", (Object[])new Object[0]), i + 1, sdf.format(entryinvaliddate), sdf.format(entryvaliddate)));
                        continue;
                    }
                    DynamicObject entrymaterial = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"entrymaterial");
                    if (entrymaterial == null) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c%s\u884c,\u8bf7\u586b\u5199\u201c\u7ec4\u4ef6\u7f16\u53f7\u201d\u3002", (String)"CadBomSubmitValidate_17", (String)"bd-macc-opplugin", (Object[])new Object[0]), i + 1));
                        continue;
                    }
                    Object entrymaterialMaster = DynamicObjDataUtil.getDynamicObjectData((DynamicObject)entrymaterial, (String)MASTERID);
                    DynamicObject entrymaterialObj = entrymaterial;
                    if (entrymaterialMaster instanceof DynamicObject) {
                        entrymaterialObj = (DynamicObject)entrymaterialMaster;
                    }
                    Boolean isuseauxpty = DynamicObjDataUtil.getDynamicObjectBooleanData((DynamicObject)entrymaterialObj, (String)"isuseauxpty");
                    if (entrymaterial.getPkValue().equals(material.getPkValue())) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c%1$s\u884c,\u7ec4\u4ef6\u7f16\u53f7[%2$s]\u4e0e[\u4ea7\u54c1\u7f16\u53f7]\u91cd\u590d\u3002", (String)"CadBomSubmitValidate_25", (String)"bd-macc-opplugin", (Object[])new Object[0]), i + 1, DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)entrymaterial, (String)NUMBER)));
                        continue;
                    }
                    DynamicObject entryunit = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"entryunit");
                    DynamicObject baseunit = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entrymaterialObj, (String)"baseunit");
                    if (entryunit == null) {
                        entryunit = baseunit;
                        entry.set("entryunit", (Object)entryunit);
                    }
                    if (!((entryversion = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"entryversion")) == null || (entryversionMaterial = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entryversion, (String)MATERIAL)) == null || (entrymaterialMaster = entrymaterialMaster instanceof DynamicObject ? ((DynamicObject)entrymaterialMaster).getPkValue() : entrymaterial.getPkValue()) != null && entrymaterialMaster.equals(entryversionMaterial.getPkValue()))) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c%1$s\u884c,\u7ec4\u4ef6\u7f16\u53f7[%2$s]\u4e0d\u5b58\u5728\u7248\u672c\u53f7[%3$s]\u3002", (String)"CadBomSubmitValidate_19", (String)"bd-macc-opplugin", (Object[])new Object[0]), i + 1, DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)entrymaterial, (String)NUMBER), DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)entryversion, (String)NAME)));
                        continue;
                    }
                    DynamicObjectCollection qtyentry = entry.getDynamicObjectCollection("qtyentry");
                    DynamicObjectCollection setupentry = entry.getDynamicObjectCollection("setupentry");
                    String entryqtytype = DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)entry, (String)"entryqtytype");
                    BigDecimal entryqtydenominator = DynamicObjDataUtil.getDynamicObjectBigDecimalData((DynamicObject)entry, (String)"entryqtydenominator");
                    BigDecimal entryqtynumerator = DynamicObjDataUtil.getDynamicObjectBigDecimalData((DynamicObject)entry, (String)"entryqtynumerator");
                    BigDecimal entryscraprate = DynamicObjDataUtil.getDynamicObjectBigDecimalData((DynamicObject)entry, (String)"entryscraprate");
                    if (entryqtydenominator == null) {
                        entryqtydenominator = new BigDecimal("1");
                        entry.set("entryqtydenominator", (Object)entryqtydenominator);
                    }
                    if (entryqtynumerator == null) {
                        entryqtynumerator = new BigDecimal("1");
                        entry.set("entryqtynumerator", (Object)entryqtynumerator);
                    }
                    BigDecimal entryqty = entryqtynumerator.divide(entryqtydenominator, RoundingMode.UP);
                    entry.set("entryqty", (Object)entryqty);
                    if (StringUtils.isNotBlank((CharSequence)entryqtytype)) {
                        if ("B".equalsIgnoreCase(entryqtytype)) {
                            if (entryqtydenominator.compareTo(new BigDecimal("1.0")) != 0 || entryscraprate.compareTo(BigDecimal.ZERO) > 0) {
                                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c%s\u884c,\u7528\u91cf\u7c7b\u578b\u4e3a\u56fa\u5b9a\u65f6,\u7528\u91cf:\u5206\u6bcd\u56fa\u5b9a\u4e3a1,\u53d8\u52a8\u635f\u8017\u7387\u56fa\u5b9a\u4e3a0\u3002", (String)"CadBomSubmitValidate_20", (String)"bd-macc-opplugin", (Object[])new Object[0]), i + 1));
                                continue;
                            }
                        } else if ("C".equalsIgnoreCase(entryqtytype) && setupentry != null && setupentry.size() > 0) {
                            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c%s\u884c,\u7528\u91cf\u7c7b\u578b\u4e3a\u9636\u68af\u65f6,\u5b89\u88c5\u4f4d\u7f6e\u5206\u5f55\u4e0d\u80fd\u5f55\u5165\u3002", (String)"CadBomSubmitValidate_22", (String)"bd-macc-opplugin", (Object[])new Object[0]), i + 1));
                            continue;
                        }
                    }
                    Boolean isAffectPricesForEntryAuxpty = this.isAffectPricesForAuxpty(entrymaterialObj);
                    DynamicObject entryauxproperty = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"entryauxproperty");
                    if (isAffectPricesForEntryAuxpty.booleanValue() && isuseauxpty.booleanValue() && entryauxproperty == null) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c%1$s\u884c,\u7ec4\u4ef6\u7f16\u53f7[%2$s]\u542f\u7528\u4e86\u8f85\u52a9\u5c5e\u6027\uff0c\u8bf7\u586b\u5199\u201c\u8f85\u52a9\u5c5e\u6027\u201d\u3002", (String)"CadBomSubmitValidate_23", (String)"bd-macc-opplugin", (Object[])new Object[0]), i + 1, DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)entrymaterial, (String)NUMBER)));
                        continue;
                    }
                    if (setupentry == null || setupentry.isEmpty()) continue;
                    BigDecimal entrySumQty = new BigDecimal("0");
                    for (DynamicObject setup : setupentry) {
                        BigDecimal qty = DynamicObjDataUtil.getDynamicObjectBigDecimalData((DynamicObject)setup, (String)"setupentryqty");
                        entrySumQty = entrySumQty.add(qty);
                    }
                    if (entrySumQty.compareTo(entryqty) <= 0) continue;
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c%s\u884c,\u5b89\u88c5\u4f4d\u7f6e\u6570\u91cf\u4e4b\u548c\u5927\u4e8e\u603b\u6570\u91cf\u3002", (String)"CadBomSubmitValidate_24", (String)"bd-macc-opplugin", (Object[])new Object[0]), i + 1));
                }
            }
        }
    }

    private Boolean isAffectPricesForAuxpty(DynamicObject material) {
        DynamicObjectCollection isaffectprices = material.getDynamicObjectCollection("auxptyentry");
        for (DynamicObject price : isaffectprices) {
            if (!price.getBoolean("isaffectprice")) continue;
            return true;
        }
        return false;
    }
}

