/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.HZPinyin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class DataUpgradeFormPlugin
extends AbstractFormPlugin {
    private static final String BAR_BD_CUSTOMER = "bar_bd_customer";
    private static final String BAR_BD_SUPPLIER = "bar_bd_supplier";
    private static final String BAR_BD_MATERIAL = "bar_bd_material";
    public static final String PROP_NAME = "name";
    public static final String PROP_ID = "id";
    public static final String SIMPLE_PINYIN = "simplepinyin";

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemkey = evt.getItemKey();
        switch (itemkey.toLowerCase(Locale.ENGLISH)) {
            case "bar_bd_customer": {
                this.upgradeDataSimplePinYin("bd_customer");
                break;
            }
            case "bar_bd_supplier": {
                this.upgradeDataSimplePinYin("bd_supplier");
                break;
            }
            case "bar_bd_material": {
                this.upgradeDataSimplePinYin("bd_material");
                break;
            }
        }
    }

    private void upgradeDataSimplePinYin(String entityNumber) {
        DynamicObject[] loads = BusinessDataServiceHelper.load((String)entityNumber, (String)"id,name,simplepinyin", (QFilter[])new QFilter[]{new QFilter(SIMPLE_PINYIN, "=", (Object)" ")});
        if (loads == null || loads.length <= 0) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"DataUpgradeFormPlugin_0", (String)"bd-master-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<SqlParameter[]> sqlparams = new ArrayList<SqlParameter[]>();
        String dataTableUseName = "";
        SqlParameter[] sqlParams = null;
        for (DynamicObject dynamicObject : loads) {
            String name;
            if (StringUtils.isBlank((CharSequence)dataTableUseName)) {
                dataTableUseName = dynamicObject.getDataEntityType().getAlias();
            }
            if (!StringUtils.isNotBlank((CharSequence)(name = dynamicObject.getString(PROP_NAME)))) continue;
            try {
                String simplePinyin = HZPinyin.getFirstSpell((String)name);
                sqlParams = new SqlParameter[]{new SqlParameter(":fsimplepinyin", 12, (Object)simplePinyin), new SqlParameter(":fid", -5, dynamicObject.get(PROP_ID))};
                sqlparams.add(sqlParams);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        String sql = "update " + dataTableUseName + " set fsimplepinyin = ? where fid = ? ;";
        if (sqlparams != null && sqlparams.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql, sqlparams);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"DataUpgradeFormPlugin_0", (String)"bd-master-formplugin", (Object[])new Object[0]));
    }
}

