/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bd.master.util.GroupStandardUtils;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class GroupEditPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public static final String ENTITY_CUSTOMER = "bd_customer";
    public static final String ENTITY_SUPPLIER = "bd_supplier";
    public static final String ENTITY_MATERIAL = "bd_material";
    public static final String ENTITY_MATERIALGROUPSTANDARD = "bd_materialgroupstandard";
    public static final String ENTITY_SUPPLIERGROUPSTANDARD = "bd_suppliergroupstandard";
    public static final String ENTITY_CUSTOMERGROUPSTANDARD = "bd_customergroupstandard";
    private static final String FULLNAME = "fullname";
    private static final String NAME = "name";
    public static final String PROP_STANDARD = "standard";
    public static final String PROP_PARENT = "parent";
    public static final String OP_SAVE = "save";
    public static final String OP_SAVEANDNEW = "saveandnew";
    public static final String PGCACHE_CREATEORG = "createOrg";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tabap"});
        BasedataEdit parent = (BasedataEdit)this.getControl(PROP_PARENT);
        parent.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView != null) {
            Long groupStandardPk = 0L;
            String entity = this.getModel().getDataEntityType().getName();
            if (entity.contains(ENTITY_SUPPLIER)) {
                groupStandardPk = Long.valueOf("716529547008326656");
            } else if (entity.contains(ENTITY_CUSTOMER)) {
                groupStandardPk = Long.valueOf("712984405228187648");
            } else if (entity.contains(ENTITY_MATERIAL)) {
                groupStandardPk = Long.valueOf("730148448254487552");
            }
            IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
            String standard = pageCache.get(PROP_STANDARD);
            if (StringUtils.isNotBlank((CharSequence)standard)) {
                groupStandardPk = Long.valueOf(standard);
                this.getPageCache().put(PROP_STANDARD, standard);
            }
            this.getModel().setValue(PROP_STANDARD, (Object)groupStandardPk);
            Long createOrgId = 0L;
            String createOrg = pageCache.get(PGCACHE_CREATEORG);
            if (StringUtils.isNotBlank((CharSequence)createOrg)) {
                createOrgId = Long.valueOf(createOrg);
                this.getPageCache().put(PGCACHE_CREATEORG, createOrg);
            }
            this.getModel().setValue("createorg", (Object)createOrgId);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean isPerm;
        super.beforeDoOperation(args);
        FormOperate oper = (FormOperate)args.getSource();
        if (OP_SAVE.equals(oper.getOperateKey()) || OP_SAVEANDNEW.equals(oper.getOperateKey())) {
            DynamicObject thisParent;
            String longNumberDlm = ".";
            MainEntityType dataEntityType = this.getModel().getDataEntityType();
            DynamicProperty property = dataEntityType.getProperty(PROP_PARENT);
            GroupProp grop = (GroupProp)property;
            if (grop instanceof ParentBasedataProp) {
                longNumberDlm = ((ParentBasedataProp)grop).getLongNumberDLM();
            }
            if ((thisParent = this.getModel().getDataEntity().getDynamicObject(PROP_PARENT)) == null) {
                this.getModel().setValue(FULLNAME, this.getModel().getValue(NAME));
                return;
            }
            String parentFullName = thisParent.getString(FULLNAME);
            this.getModel().setValue(FULLNAME, (Object)(parentFullName + longNumberDlm + this.getModel().getValue(NAME)));
        } else if ("new".equals(oper.getOperateKey()) && (isPerm = this.checkNewPermission())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u5728\u5f53\u524d\u4e1a\u52a1\u7ec4\u7ec7\u4e0b\u6ca1\u6709\u65b0\u589e\u6743\u9650", (String)"GroupEditPlugin_0", (String)"bd-master-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView != null) {
            Long groupStandardPk = 0L;
            String entity = this.getModel().getDataEntityType().getName();
            if (entity.contains(ENTITY_SUPPLIER)) {
                groupStandardPk = Long.valueOf("716529547008326656");
            } else if (entity.contains(ENTITY_CUSTOMER)) {
                groupStandardPk = Long.valueOf("712984405228187648");
            } else if (entity.contains(ENTITY_MATERIAL)) {
                groupStandardPk = Long.valueOf("730148448254487552");
            }
            IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
            String standard = pageCache.get(PROP_STANDARD);
            if (StringUtils.isNotBlank((CharSequence)standard)) {
                groupStandardPk = Long.valueOf(standard);
                this.getPageCache().put(PROP_STANDARD, standard);
            }
            this.getModel().setValue(PROP_STANDARD, (Object)groupStandardPk);
            Long createOrgId = 0L;
            String createOrg = pageCache.get(PGCACHE_CREATEORG);
            if (StringUtils.isNotBlank((CharSequence)createOrg)) {
                createOrgId = Long.valueOf(createOrg);
                this.getPageCache().put(PGCACHE_CREATEORG, createOrg);
            }
            this.getModel().setValue("createorg", (Object)createOrgId);
        }
        this.getModel().setDataChanged(false);
    }

    private boolean checkNewPermission() {
        String permItem = "47156aff000000ac";
        String useOrg = null;
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView != null) {
            IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
            useOrg = pageCache.get(PGCACHE_CREATEORG);
        }
        String appNumber = this.getView().getFormShowParameter().getAppId();
        String entityName = this.getModel().getDataEntity().getDataEntityType().toString();
        return PermissionServiceHelper.checkPermission((long)Long.parseLong(RequestContext.get().getUserId()), (String)"DIM_ORG", (long)Long.parseLong(useOrg), (String)appNumber, (String)entityName, (String)permItem) == 0;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        FormOperate oper = (FormOperate)args.getSource();
        if (OP_SAVE.equals(oper.getOperateKey()) || OP_SAVEANDNEW.equals(oper.getOperateKey())) {
            IFormView parentView;
            DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)this.getModel().getDataEntityType());
            Object parent = this.getModel().getDataEntity().get(PROP_PARENT);
            Long parentId = GroupStandardUtils.getDataByType((Object)parent);
            if (parentId != 0L) {
                cacheManager.removeByPrimaryKey(new Object[]{parentId});
            }
            if ((parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId())) != null) {
                IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
                pageCache.put("listdatachanged", "1");
            }
        }
    }

    public void afterLoadData(EventObject e) {
        String useOrg = null;
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView != null) {
            IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
            useOrg = pageCache.get(PGCACHE_CREATEORG);
            pageCache.put("listdatachanged", "0");
        }
        if (StringUtils.isBlank(useOrg) || null == useOrg) {
            return;
        }
        Object createOrg = this.getModel().getValue("createorg");
        Object standard = this.getModel().getValue(PROP_STANDARD);
        Long standardId = GroupStandardUtils.getDataByType((Object)standard);
        if (StringUtils.isBlank((Object)standardId)) {
            return;
        }
        Long createOrgId = GroupStandardUtils.getDataByType((Object)createOrg);
        if (StringUtils.isBlank((Object)createOrgId)) {
            return;
        }
        boolean isPreset = this.getModel().getDataEntity().getBoolean("ispreset");
        if (isPreset || !useOrg.equals(createOrgId.toString())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"btnsave", "btnsaveandnew", "number", NAME, "description", PROP_PARENT});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        IPageCache pageCache;
        String standard;
        String entity = this.getModel().getDataEntityType().getName();
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        Long groupStandardPk = 0L;
        String entityNumber = "";
        if (entity.contains(ENTITY_SUPPLIER)) {
            groupStandardPk = Long.valueOf("716529547008326656");
            entityNumber = ENTITY_SUPPLIER;
        } else if (entity.contains(ENTITY_CUSTOMER)) {
            groupStandardPk = Long.valueOf("712984405228187648");
            entityNumber = ENTITY_CUSTOMER;
        } else if (entity.contains(ENTITY_MATERIAL)) {
            groupStandardPk = Long.valueOf("730148448254487552");
            entityNumber = ENTITY_MATERIAL;
        }
        if (parentView != null && StringUtils.isNotBlank((CharSequence)(standard = (pageCache = (IPageCache)parentView.getService(IPageCache.class)).get(PROP_STANDARD)))) {
            groupStandardPk = Long.valueOf(standard);
            this.getPageCache().put(PROP_STANDARD, standard);
        }
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        listShowParameter.setCustomParam("groupStandard", (Object)groupStandardPk);
        Object value = this.getModel().getValue("createorg");
        List qFilters = listShowParameter.getListFilterParameter().getQFilters();
        qFilters.add(new QFilter(PROP_STANDARD, "=", (Object)groupStandardPk));
        if (value != null) {
            HashSet<Long> useorgs = new HashSet<Long>(1);
            Long groupOrgId = GroupStandardUtils.getDataByType((Object)value);
            useorgs.add(groupOrgId);
            Set groupOrgIds = GroupStandardUtils.getGroupOrgId((String)entityNumber, useorgs);
            qFilters.add(new QFilter("createorg", "in", (Object)groupOrgIds));
            listShowParameter.setCustomParam("useOrg", (Object)groupOrgId.toString());
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(true);
    }
}

