/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master;

import java.util.EventObject;
import kd.bd.master.helper.GroupStandardHelper;
import kd.bd.master.helper.MasterDataHelper;
import kd.bd.master.util.GroupStandardUtils;
import kd.bd.master.vo.GroupStandMap;
import kd.bd.master.vo.GroupStandVo;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public abstract class MasterDataFormPlugin
extends AbstractBasePlugIn {
    public String getType() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        return formShowParameter.getFormId();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tabap"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        GroupStandardHelper.setGrouptandard((IDataModel)this.getModel(), (IFormView)this.getView(), (IPageCache)this.getPageCache(), (String)this.getType());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if ("createorg".equalsIgnoreCase(propName)) {
            DynamicObject createOrg = (DynamicObject)this.getModel().getValue("createorg");
            if (createOrg != null) {
                return;
            }
            this.getModel().setValue("org", (Object)createOrg);
        } else if ("name".equals(propName)) {
            MasterDataHelper.setSimpleDefaultImediate((IDataModel)this.getModel());
        } else if ("groupid".equals(propName)) {
            GroupStandardHelper.changeGroupValue((IDataModel)this.getModel(), (String)this.getType());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("submit".equals(operateKey) || "save".equals(operateKey)) {
            try (TraceSpan span = Tracer.create((String)"MasterDataFormPlugin", (String)"setGroupStandard");){
                if (afterDoOperationEventArgs.getOperationResult() == null || afterDoOperationEventArgs.getOperationResult().getSuccessPkIds() == null || afterDoOperationEventArgs.getOperationResult().getSuccessPkIds().size() <= 0) {
                    return;
                }
                GroupStandardHelper.setGroupStandard((Object)this.getModel().getDataEntity().getPkValue(), (String)MasterDataHelper.getUseOrg((IFormView)this.getView()).toString(), null, (IDataModel)this.getModel(), (IFormView)this.getView(), (String)this.getType());
                this.getModel().setDataChanged(false);
                this.getPageCache().remove("change");
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        GroupStandardHelper.pageCacheSetValue((IDataModel)this.getModel(), (IPageCache)this.getPageCache(), (FormOperate)operate);
        if ("change".equals(operateKey)) {
            MasterDataHelper.doChange((BeforeDoOperationEventArgs)args, (IDataModel)this.getModel(), (IFormView)this.getView(), (IPageCache)this.getPageCache());
        } else if (operateKey.equals("submit") || "save".equals(operateKey)) {
            String param = this.getPageCache().get("change");
            if (kd.bos.util.StringUtils.isNotEmpty((String)param) && Boolean.parseBoolean(param)) {
                operate.getOption().setVariableValue("change", "true");
            } else {
                operate.getOption().setVariableValue("change", "false");
            }
            DynamicObjectCollection standards = this.getModel().getEntryEntity("entry_groupstandard");
            for (DynamicObject dynamicObject : standards) {
                Long standard = GroupStandardUtils.getDataByType((Object)dynamicObject.get("standardid"));
                if (!((GroupStandVo)GroupStandMap.getGroupstandmap().get(this.getType())).getJbflbz().equals(standard)) continue;
                Long groupid = GroupStandardUtils.getDataByType((Object)dynamicObject.get("groupid"));
                if (groupid == 0L) {
                    groupid = 1L;
                }
                this.getModel().setValue("group", (Object)groupid);
                this.getModel().setValue("group_id", (Object)groupid);
            }
        } else if (operateKey.equals("unaudit")) {
            MasterDataHelper.recoverVisible((IFormView)this.getView());
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        try (TraceSpan span = Tracer.create((String)"MasterDataFormPlugin", (String)"afterCopySetGroupStandard:afterCopySetGroupStandard");){
            GroupStandardHelper.afterCopySetGroupStandard((IDataModel)this.getModel(), (IFormView)this.getView(), (IPageCache)this.getPageCache(), (String)this.getType());
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        try (TraceSpan span = Tracer.create((String)"MasterDataFormPlugin", (String)"afterLoadData:setGroupStandard");){
            GroupStandardHelper.setGroupStandard((Object)this.getModel().getDataEntity().getPkValue(), (String)MasterDataHelper.getUseOrg((IFormView)this.getView()).toString(), null, (IDataModel)this.getModel(), (IFormView)this.getView(), (String)this.getType());
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setEnable(Boolean.FALSE, new String[]{"group"});
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView != null) {
            String dataid = this.getPageCache().get("dataid");
            if (StringUtils.isBlank((CharSequence)dataid)) {
                dataid = this.getModel().getDataEntity().getPkValue().toString();
            }
            try (TraceSpan span = Tracer.create((String)"MasterDataFormPlugin", (String)"afterCreateNewData:setGroupStandard");){
                GroupStandardHelper.setGroupStandard((Object)dataid, (String)MasterDataHelper.getUseOrg((IFormView)this.getView()).toString(), (IFormView)parentView, (IDataModel)this.getModel(), (IFormView)this.getView(), (String)this.getType());
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        String param = this.getPageCache().get("change");
        if ("bar_close".equals(key) && kd.bos.util.StringUtils.isNotEmpty((String)param) && Boolean.parseBoolean(param)) {
            MasterDataHelper.restoreData((IDataModel)this.getModel(), (IPageCache)this.getPageCache());
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String param = this.getPageCache().get("change");
        if (kd.bos.util.StringUtils.isNotEmpty((String)param) && Boolean.parseBoolean(param)) {
            MasterDataHelper.restoreData((IDataModel)this.getModel(), (IPageCache)this.getPageCache());
        }
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        String param = this.getPageCache().get("change");
        if (kd.bos.util.StringUtils.isNotEmpty((String)param) && Boolean.parseBoolean(param)) {
            MasterDataHelper.restoreData((IDataModel)this.getModel(), (IPageCache)this.getPageCache());
        }
    }
}

