/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.errorcode;

import kd.bd.sbd.errorcode.ScmErrorCode;
import kd.bd.sbd.errorcode.ScmErrorLevel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;

public class ScmErrorCodeUtils {
    private static final String PREFIX = "kd.bd.sbd.";

    public ScmErrorCode create(String code, String message) {
        return this.create(PREFIX, code, message, ScmErrorLevel.Error.getValue());
    }

    public ScmErrorCode create(String code, String message, int scmErrorLevel) {
        return this.create(PREFIX, code, message, scmErrorLevel);
    }

    public ScmErrorCode create(String prefix, String code, String message) {
        return this.create(prefix, code, message, ScmErrorLevel.Error.getValue());
    }

    public ScmErrorCode create(String prefix, String code, String message, int scmErrorLevel) {
        return new ScmErrorCode(new ErrorCode(prefix + code, message), ScmErrorLevel.Error.getValue());
    }

    public String getCodeErrorMessage(ErrorCode errorCode) {
        KDException kde = new KDException(errorCode, new Object[0]);
        return kde.getMessage();
    }

    public String getCodeErrorMessage(ErrorCode errorCode, Object ... args) {
        KDException kde = new KDException(errorCode, args);
        return kde.getMessage();
    }

    public void showMessge(IFormView formView, ScmErrorCode scmErrorCode) {
        if (scmErrorCode == null) {
            return;
        }
        switch (scmErrorCode.getErrorLevel()) {
            case 0: {
                formView.showErrorNotification(scmErrorCode.getErrorCode().getMessage());
                break;
            }
            case 1: {
                formView.showErrorNotification(scmErrorCode.getErrorCode().getMessage());
                break;
            }
            case 2: {
                formView.showErrorNotification(scmErrorCode.getErrorCode().getMessage());
                break;
            }
            case 3: {
                formView.showTipNotification(scmErrorCode.getErrorCode().getMessage(), Integer.valueOf(5000));
                break;
            }
            case 4: {
                formView.showSuccessNotification(scmErrorCode.getErrorCode().getMessage(), Integer.valueOf(3000));
                break;
            }
        }
    }
}

