/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import java.util.EventObject;
import kd.bd.assistant.plugin.helper.CountryHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;

public class FinOrgAdminDivisionPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public static final String KEY_IS_CHINA_MAINLAND = "KEY_IS_CHINA_MAINLAND";
    public static final String COUNTRY = "country";
    public static final String PROVINCE = "province";
    public static final String CITY = "city";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.refreshCountry(false);
        this.refreshProvince(false);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit province = (BasedataEdit)this.getControl(PROVINCE);
        province.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit city = (BasedataEdit)this.getControl(CITY);
        city.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if (COUNTRY.equals(propName)) {
            this.refreshCountry(true);
        } else if (PROVINCE.equals(propName)) {
            this.refreshProvince(true);
        }
    }

    private void refreshCountry(boolean clearData) {
        DynamicObject country = (DynamicObject)this.getModel().getValue(COUNTRY);
        boolean isChinaMainland = CountryHelper.isChina((DynamicObject)country);
        if (clearData) {
            this.getModel().setValue(PROVINCE, null);
            this.getModel().setValue(CITY, null);
        }
        this.getView().setEnable(Boolean.valueOf(isChinaMainland), new String[]{PROVINCE});
        this.getView().setVisible(Boolean.valueOf(isChinaMainland), new String[]{PROVINCE});
        this.getView().setEnable(Boolean.valueOf(!isChinaMainland), new String[]{CITY});
        this.getPageCache().put(KEY_IS_CHINA_MAINLAND, String.valueOf(isChinaMainland));
    }

    private void refreshProvince(boolean clearData) {
        if (clearData) {
            this.getModel().setValue(CITY, null);
        }
        Object province = this.getModel().getValue(PROVINCE);
        boolean isChinaMainland = Boolean.parseBoolean(this.getPageCache().get(KEY_IS_CHINA_MAINLAND));
        if (isChinaMainland) {
            this.getView().setEnable(Boolean.valueOf(province != null), new String[]{CITY});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propName = beforeF7SelectEvent.getProperty().getName();
        if (PROVINCE.equals(propName)) {
            DynamicObject country = (DynamicObject)this.getModel().getValue(COUNTRY);
            if (country != null) {
                Object countryId = country.getPkValue();
                QFilter levelFilter = new QFilter(COUNTRY, "=", countryId).and(new QFilter("level", "=", (Object)1));
                ListShowParameter listShowPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                listShowPara.getListFilterParameter().setFilter(levelFilter);
            }
        } else if (CITY.equals(propName)) {
            boolean isChinaMainland = Boolean.parseBoolean(this.getPageCache().get(KEY_IS_CHINA_MAINLAND));
            QFilter qFilter = null;
            if (isChinaMainland) {
                DynamicObject provinceModel = (DynamicObject)this.getModel().getValue(PROVINCE);
                if (provinceModel != null) {
                    qFilter = new QFilter("parent.number", "=", provinceModel.get("number"));
                }
            } else {
                DynamicObject country = (DynamicObject)this.getModel().getValue(COUNTRY);
                if (country != null) {
                    Object countryId = country.getPkValue();
                    qFilter = new QFilter(COUNTRY, "=", countryId).and(new QFilter("iscity", "=", (Object)Boolean.TRUE));
                }
            }
            ListShowParameter listShowPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowPara.getListFilterParameter().setFilter(qFilter);
        }
    }
}

