/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.er.web;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bd.assistant.plugin.util.ExpenseItemUtils;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class ExpenseItemEdit
extends AbstractBasePlugIn {
    private static final Log log = LogFactory.getLog(ExpenseItemEdit.class);

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"tbmain"});
        this.addClickListeners(new String[]{"expenseitemicon"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"editbilltype"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        switch (key) {
            case "expenseitemicon": {
                paramMap.put("formId", "er_expenseitempic");
                paramMap.put("formName", ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee\u56fe\u6807", (String)"ExpenseItemEdit_0", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                paramMap.put("showType", ShowType.Modal);
                paramMap.put("needCallBack", Boolean.TRUE);
                paramMap.put("formType", "7");
                ExpenseItemUtils.showPage(paramMap, (AbstractFormPlugin)this);
                break;
            }
            case "editbilltype": {
                this.openEditBillType();
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        Boolean isPersonalizeData;
        Map customParams;
        DynamicObject parent = (DynamicObject)this.getModel().getValue("parent");
        String number = (String)this.getModel().getValue("number");
        if (parent != null && StringUtils.isBlank((CharSequence)number)) {
            this.getModel().setValue("number", (Object)(parent.get("number") + "."));
        }
        if ((customParams = this.getView().getFormShowParameter().getCustomParams()) != null && (isPersonalizeData = (Boolean)customParams.get("isPersonalizeData")) != null && isPersonalizeData.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"billtypeentry"});
        }
        this.initBillTypes();
        this.initBillTypeRelate();
    }

    private void initBillTypes() {
        DynamicObject[] billTypes = BusinessDataServiceHelper.load((String)"er_billtype", (String)"id,bizappid.id", (QFilter[])new QFilter("enable", "=", (Object)Boolean.TRUE).toArray());
        this.getModel().deleteEntryData("billtypeentry");
        for (DynamicObject billType : billTypes) {
            int rowIndex = this.getModel().createNewEntryRow("billtypeentry");
            this.getModel().setValue("billtype", billType.getPkValue(), rowIndex);
            this.getModel().setValue("bizappid", billType.get("bizappid.id"), rowIndex);
        }
        EntryGrid entry = (EntryGrid)this.getControl("billtypeentry");
        entry.setPageIndex(1);
    }

    private void initBillTypeRelate() {
        DynamicObject parent = (DynamicObject)this.getModel().getValue("parent");
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        if (Long.valueOf(0L).equals(pkValue)) {
            if (this.copyData(this.getView())) {
                BaseShowParameter formShowParameter = (BaseShowParameter)this.getView().getFormShowParameter();
                pkValue = formShowParameter.getPkId();
            } else if (parent != null) {
                pkValue = parent.getPkValue();
            } else {
                return;
            }
        }
        if (Long.valueOf(0L).equals(pkValue)) {
            return;
        }
        DynamicObject[] relation = BusinessDataServiceHelper.load((String)"er_expenseitembill", (String)"billtype.id", (QFilter[])new QFilter[]{new QFilter("expenseitem.id", "in", pkValue)});
        if (relation.length == 0) {
            return;
        }
        Set billTypeSet = Stream.of(relation).filter(e -> e != null && e.getDynamicObject("billtype") != null).map(v -> v.getDynamicObject("billtype").getPkValue()).collect(Collectors.toSet());
        OperationStatus billStatus = this.getView().getFormShowParameter().getStatus();
        if (billStatus != null && OperationStatus.ADDNEW.equals((Object)billStatus) && billTypeSet.isEmpty()) {
            billTypeSet = ExpenseItemUtils.getParentExpenseItemType((Object)pkValue);
        }
        int entryRowCount = this.getModel().getEntryRowCount("billtypeentry");
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype", i);
            if (!billTypeSet.contains(billType.getPkValue())) continue;
            this.getModel().setValue("setrelate", (Object)Boolean.TRUE, i);
        }
        this.getView().updateView("billtypeentry");
    }

    private boolean copyData(IFormView view) {
        BaseShowParameter formShowParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        Object iscopy = formShowParameter.getCustomParam("iscopy");
        return Boolean.TRUE.equals(iscopy);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String propName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object oldValue = changeData.getOldValue();
        Object newValue = changeData.getNewValue();
        if ("number".equalsIgnoreCase(propName)) {
            this.whenNumberChanged(model, oldValue);
        } else if (StringUtils.equals((CharSequence)"parent", (CharSequence)propName) && newValue != null) {
            DynamicObject parentExpenseItemDO = (DynamicObject)newValue;
            model.beginInit();
            this.getModel().setValue("number", (Object)(parentExpenseItemDO.get("number") + "."));
            model.endInit();
            this.getView().updateView("number");
        }
    }

    private void whenNumberChanged(IDataModel model, Object oldValue) {
        String number = model.getValue("number").toString();
        if (StringUtils.isBlank((CharSequence)number)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"ExpenseItemEdit_1", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
            return;
        }
        Long parentId = -1L;
        if (!number.contains(".")) {
            parentId = null;
        } else {
            String parentNumber = number.substring(0, number.lastIndexOf(46));
            DynamicObject[] expenseItemDOs = BusinessDataServiceHelper.load((String)"er_expenseitemedit", (String)"id", (QFilter[])new QFilter[]{QFilter.of((String)"number=?", (Object[])new Object[]{parentNumber})});
            if (expenseItemDOs == null || expenseItemDOs.length < 1) {
                String oldParentNumber;
                boolean exists;
                String oldNumber = (String)oldValue;
                if (oldNumber != null && oldNumber.contains(".") && !(exists = QueryServiceHelper.exists((String)"er_expenseitemedit", (QFilter[])new QFilter[]{QFilter.of((String)"number=?", (Object[])new Object[]{oldParentNumber = oldNumber.substring(0, oldNumber.lastIndexOf(46))})}))) {
                    oldNumber = null;
                }
                model.beginInit();
                model.setValue("number", (Object)oldNumber);
                model.endInit();
                this.getView().updateView("number");
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7236\u8282\u70b9\u4e0d\u5b58\u5728, \u8bf7\u91cd\u65b0\u8bbe\u7f6e", (String)"ExpenseItemEdit_2", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
            } else if (expenseItemDOs.length == 1) {
                log.info("\u6709\u4e00\u4e2a\u7236\u8282\u70b9\u4e3a:" + SerializationUtils.toJsonString((Object)expenseItemDOs[0]));
                parentId = (Long)expenseItemDOs[0].getPkValue();
            } else {
                log.error("\u6709\u591a\u4e2a\u7236\u8282\u70b9:" + SerializationUtils.toJsonString((Object)expenseItemDOs));
            }
        }
        if (!Long.valueOf(-1L).equals(parentId)) {
            model.beginInit();
            model.setValue("parent", (Object)parentId);
            model.endInit();
            this.getView().updateView("parent");
            if (parentId != null) {
                DynamicObject expenseItem = QueryServiceHelper.queryOne((String)"er_expenseitemedit", (String)"ctrlstrategy", (QFilter[])new QFilter[]{QFilter.of((String)"id=?", (Object[])new Object[]{parentId})});
                model.beginInit();
                model.setValue("ctrlstrategy", expenseItem.get("ctrlstrategy"));
                model.endInit();
                this.getView().updateView("ctrlstrategy");
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("er_expenseitempic".equalsIgnoreCase(closedCallBackEvent.getActionId())) {
            IDataModel model = this.getModel();
            String iconField = (String)closedCallBackEvent.getReturnData();
            if (iconField != null) {
                model.setValue("expenseitemicon", (Object)iconField);
            }
        }
        if ("er_billtype".equalsIgnoreCase(closedCallBackEvent.getActionId())) {
            this.initBillTypes();
            this.initBillTypeRelate();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        IDataModel model = this.getModel();
        String iconUrl = (String)model.getValue("expenseitemicon");
        super.beforeDoOperation(beforeDoOperationEventArgs);
        if (beforeDoOperationEventArgs.getSource() instanceof Save) {
            DynamicObject value;
            String operationKey = ((Save)beforeDoOperationEventArgs.getSource()).getOperateKey();
            if ((operationKey.equals("submitandnew") || operationKey.equals("save")) && (iconUrl == null || iconUrl.equals(" "))) {
                model.setValue("expenseitemicon", (Object)"/icons/mobile/shortcut_entrance/icon_more_80_80.png,#fffff");
            }
            if ((value = (DynamicObject)this.getModel().getValue("parent")) != null) {
                this.getModel().setValue("level", (Object)(value.getInt("level") + 1));
            } else {
                this.getModel().setValue("level", (Object)"1");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("save".equals(operateKey)) {
            List successPkIds = afterDoOperationEventArgs.getOperationResult().getSuccessPkIds();
            ArrayList billTypePks = new ArrayList();
            DynamicObjectCollection billTypes = this.getModel().getEntryEntity("billtypeentry");
            billTypes.forEach(billtype -> {
                if (billtype.getBoolean("setrelate")) {
                    billTypePks.add(billtype.getDynamicObject("billtype").getPkValue());
                }
            });
            ExpenseItemUtils.deleteRelation4ExpenseItem((Object[])successPkIds.toArray());
            ExpenseItemUtils.saveRelation((Object[])successPkIds.toArray(), (Object[])billTypePks.toArray());
            this.getView().updateView();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
    }

    private void openEditBillType() {
        ListShowParameter formShowParameter;
        ListShowParameter listShowParameter = formShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("er_billtype");
        listShowParameter.setFormId("bos_list");
        listShowParameter.setLookUp(false);
        listShowParameter.setListFilterParameter(null);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u8d39\u7528\u5355\u636e\u7c7b\u578b", (String)"ExpenseItemEdit_3", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "er_billtype"));
        formShowParameter.setShowTitle(true);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }
}

