/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.schedule;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.assistant.plugin.helper.ScheduleConfigHelper;
import kd.bos.algo.util.io.IOUtils;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;

public class ScheduleConfigListPlugin
extends StandardTreeListPlugin {
    private static final String CONFIG_IDS = "configIds";
    private static final Integer INITIAL_CAPACITY = 10;
    private static final String BD_SCH_CONFIG = "bd_scheduleconfig";
    private static final String SCHSCHEDULE_ID = "schschedule.id";
    private String[] BIZ_CLOUD_IDS = null;

    public void refreshNode(RefreshNodeEvent e) {
        TreeNode currentNode = this.getTreeModel().getRoot().getTreeNode(e.getNodeId().toString(), 3);
        e.setChildNodes(currentNode.getChildren());
    }

    public void initializeTree(EventObject e) {
        this.initTree();
        this.getTreeListView().getTreeModel().setRoot(this.loadAllAppNodes());
    }

    public void treeToolbarClick(EventObject e) {
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        String bizCloudIds;
        ListShowParameter parameter = (ListShowParameter)e.getFormShowParameter();
        if (parameter != null && StringUtils.isNotEmpty((String)(bizCloudIds = (String)parameter.getCustomParam("bizCloudIds")))) {
            this.BIZ_CLOUD_IDS = bizCloudIds.split(",");
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        String nodeId = e.getNodeId().toString();
        if (nodeId.equalsIgnoreCase("-1")) {
            return;
        }
        TreeNode root = this.getTreeListView().getTreeModel().getRoot();
        TreeNode current = root.getTreeNode(nodeId, 2);
        Map nodeData = (Map)current.getData();
        String nodeType = (String)nodeData.get("type");
        QFilter qFilter = null;
        if ("cloud".equals(nodeType)) {
            if (current.getChildren() != null && !current.getChildren().isEmpty()) {
                ArrayList configIdList = new ArrayList();
                for (TreeNode node : current.getChildren()) {
                    Map data = (Map)node.getData();
                    List configIds = (List)data.get(CONFIG_IDS);
                    if (configIds == null) continue;
                    configIdList.addAll(configIds);
                }
                qFilter = new QFilter("id", "in", configIdList);
            } else {
                qFilter = new QFilter("id", "=", (Object)-1);
            }
        } else if (nodeType.equals("app")) {
            Map data = (Map)current.getData();
            qFilter = new QFilter("id", "in", data.get(CONFIG_IDS));
        }
        e.addQFilter(qFilter);
        e.setCancel(true);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        switch (args.getOperateKey()) {
            case "batchnew": {
                if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) {
                    return;
                }
                ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"sch_schedule", (boolean)true);
                showParameter.setShowTitle(true);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "batchnew"));
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "refresh": {
                this.getTreeListView().getTreeModel().setRoot(this.loadAllAppNodes());
                break;
            }
            case "exportksql": {
                ListSelectedRowCollection selectedRows = this.getSelectedRows();
                if (selectedRows == null || selectedRows.isEmpty()) break;
                String ksql = ScheduleConfigHelper.exportKsql((Object[])selectedRows.getPrimaryKeyValues());
                this.exportFile(ksql);
                break;
            }
            case "verifyconfig": {
                ListSelectedRowCollection selectedRows = this.getSelectedRows();
                if (selectedRows == null || selectedRows.isEmpty()) {
                    return;
                }
                QFilter qFilter = new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues());
                if (!ScheduleConfigHelper.doExecute((QFilter)qFilter, (boolean)Boolean.TRUE)) break;
                this.getView().invokeOperation("refresh");
                break;
            }
            case "queryschedule": {
                ListSelectedRowCollection selectedRows = this.getSelectedRows();
                if (selectedRows == null || selectedRows.isEmpty()) {
                    return;
                }
                BillShowParameter param = new BillShowParameter();
                DynamicObject config = QueryServiceHelper.queryOne((String)BD_SCH_CONFIG, (String)SCHSCHEDULE_ID, (QFilter[])new QFilter("id", "=", selectedRows.get(0).getPrimaryKeyValue()).toArray());
                if (config == null) break;
                param.setPkId(config.get(SCHSCHEDULE_ID));
                param.setFormId("sch_schedule");
                param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                param.setBillStatus(BillOperationStatus.VIEW);
                param.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)param);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        Object returnData = event.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (event.getActionId()) {
            case "batchnew": {
                this.batchAddConfig((ListSelectedRowCollection)returnData);
                break;
            }
        }
    }

    private void batchAddConfig(ListSelectedRowCollection selectedRows) {
        Map<String, ListSelectedRow> scheduleMap = selectedRows.stream().collect(Collectors.toMap(s -> (String)s.getPrimaryKeyValue(), s -> s));
        QFilter qFilter = new QFilter(SCHSCHEDULE_ID, "in", scheduleMap.keySet());
        DynamicObjectCollection configs = QueryServiceHelper.query((String)BD_SCH_CONFIG, (String)SCHSCHEDULE_ID, (QFilter[])qFilter.toArray());
        for (DynamicObject config : configs) {
            scheduleMap.remove(config.getString(SCHSCHEDULE_ID));
        }
        if (scheduleMap.isEmpty()) {
            return;
        }
        ArrayList<DynamicObject> addConfigs = new ArrayList<DynamicObject>(scheduleMap.size());
        Date curTime = new Date();
        for (Map.Entry<String, ListSelectedRow> entry : scheduleMap.entrySet()) {
            ListSelectedRow selectedRow = entry.getValue();
            DynamicObject config = BusinessDataServiceHelper.newDynamicObject((String)BD_SCH_CONFIG);
            config.set("schschedule", selectedRow.getPrimaryKeyValue());
            config.set("number", (Object)selectedRow.getNumber());
            config.set("name", (Object)selectedRow.getName());
            config.set("status", (Object)"A");
            config.set("enable", (Object)"1");
            config.set("exetype", (Object)"bill");
            config.set("creator", (Object)UserServiceHelper.getCurrentUserId());
            config.set("createtime", (Object)curTime);
            addConfigs.add(config);
        }
        SaveServiceHelper.save((DynamicObject[])addConfigs.toArray(new DynamicObject[0]));
        this.getTreeListView().getTreeModel().setRoot(this.loadAllAppNodes());
        this.getTreeListView().refreshTreeView();
    }

    private void initTree() {
        TreeView treeView = (TreeView)this.getControl("treeView");
        TreeView.TreeState treeState = treeView.getTreeState();
        Map focusNode = treeState.getFocusNode();
        if (focusNode == null) {
            return;
        }
        this.getView().getFormShowParameter().setCustomParam("id", focusNode.get("id"));
        ((ListView)this.getView()).setNeedRefreshTree(false);
    }

    private TreeNode loadAllAppNodes() {
        TreeNode root = new TreeNode();
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("type", "root");
        root.setId("-1");
        root.setData(map);
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"ScheduleConfigListPlugin_01", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
        root.setParentid("");
        root.setIsOpened(true);
        List<TreeNode> cloudNodes = this.getCloudNodes();
        if (!cloudNodes.isEmpty()) {
            root.setChildren(cloudNodes);
        }
        return root;
    }

    private List<TreeNode> getCloudNodes() {
        TreeNode root = (TreeNode)BizAppServiceHelp.getRuntimeSubsysTree((String[])this.BIZ_CLOUD_IDS, null, null, (String)"");
        List clouds = root.getChildren();
        if (clouds == null) {
            return Collections.emptyList();
        }
        Map<String, String> appInfoMap = this.getAppInfoMap();
        Map<String, List<Long>> taskIndexMap = this.getConfigIdMap(appInfoMap);
        for (TreeNode cloud : clouds) {
            HashMap<String, String> cloudData = new HashMap<String, String>(1);
            cloudData.put("type", "cloud");
            String cloudNodeId = "cloud_" + cloud.getId();
            cloud.setId(cloudNodeId);
            cloud.setData(cloudData);
            List apps = cloud.getChildren();
            if (apps == null) continue;
            for (TreeNode app : apps) {
                HashMap<String, Object> appData = new HashMap<String, Object>(1);
                String appNodeId = app.getId();
                List<Long> configIds = taskIndexMap.get(appNodeId);
                appData.put("type", "app");
                appData.put(CONFIG_IDS, configIds);
                app.setId(appNodeId);
                app.setParentid(cloudNodeId);
                app.setData(appData);
            }
        }
        return clouds;
    }

    private Map<String, String> getAppInfoMap() {
        DynamicObjectCollection allApps = BizAppServiceHelp.getAllBizApps();
        HashMap<String, String> appInfoMap = new HashMap<String, String>(allApps.size());
        for (DynamicObject app : allApps) {
            String type = app.getString("type");
            String nodeId = app.getString("id");
            String number = app.getString("number");
            if ("0".equals(type)) {
                appInfoMap.put(number, nodeId);
                continue;
            }
            String masterId = app.getString("masterid");
            appInfoMap.put(number, masterId);
        }
        return appInfoMap;
    }

    private Map<String, List<Long>> getConfigIdMap(Map<String, String> appInfoMap) {
        DynamicObjectCollection configs = QueryServiceHelper.query((String)BD_SCH_CONFIG, (String)"id,schschedule.job.id", null);
        Set jobIds = configs.stream().map(d -> d.getString("schschedule.job.id")).collect(Collectors.toSet());
        HashMap<String, List<Long>> configMap = new HashMap<String, List<Long>>(configs.size());
        QFilter qFilter = new QFilter("id", "in", jobIds);
        DynamicObjectCollection schJobs = QueryServiceHelper.query((String)"sch_job", (String)"id, taskclassname.appid", (QFilter[])qFilter.toArray());
        Map<String, String> schJobMap = schJobs.stream().collect(Collectors.toMap(b -> b.getString("id"), b -> b.getString("taskclassname.appid")));
        for (DynamicObject config : configs) {
            String jobId = config.getString("schschedule.job.id");
            String appId = schJobMap.get(jobId);
            long id = config.getLong("id");
            String masterId = appInfoMap.get(appId);
            if (masterId == null) continue;
            this.addToList(configMap, masterId, id);
        }
        return configMap;
    }

    private void addToList(Map<String, List<Long>> configIdMap, String key, Long value) {
        List list = configIdMap.computeIfAbsent(key, k -> new ArrayList(INITIAL_CAPACITY));
        list.add(value);
    }

    private void exportFile(String sql) {
        ByteArrayInputStream ins = null;
        String sqlFileName = String.format("scheduleConfig_%s.sql", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        try {
            ins = new ByteArrayInputStream(sql.getBytes(StandardCharsets.UTF_8));
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(sqlFileName, (InputStream)ins, 5000);
            this.getView().openUrl(url);
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(ins);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((AutoCloseable)ins);
    }
}

