/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.taxc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.user.UserService;

public class ExtentFilterPlugin
extends AbstractFormPlugin {
    private static final String EXTENT = "extent";
    private static final String FILTERGRIDAP = "filtergridap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void beforeBindData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String entityFLag = (String)customParams.get("entityFLag");
        FilterGrid filterGrid = (FilterGrid)this.getControl(FILTERGRIDAP);
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityFLag);
        List<Map> filterColumns = entityTypeUtil.getFilterColumns((IDataEntityType)entityType);
        filterColumns = filterColumns.stream().filter(v -> EXTENT.equals(v.get("fieldName"))).collect(Collectors.toList());
        filterColumns.forEach(v -> {
            v.put("fieldCaption", this.getShortString());
            List list = (List)v.get("compareTypes");
            String[] comareTypeList = new String[]{CompareTypeEnum.EQUAL.getId(), CompareTypeEnum.NOTEQUAL.getId(), CompareTypeEnum.GREATER.getId(), CompareTypeEnum.LESS.getId(), CompareTypeEnum.GREATEROREQUAL.getId(), CompareTypeEnum.LESSOREQUAL.getId()};
            list = list.stream().filter(i -> Arrays.asList(comareTypeList).contains(i.getId())).collect(Collectors.toList());
            v.put("compareTypes", list);
        });
        filterGrid.setFilterColumns(filterColumns);
        filterGrid.setEntityNumber(entityFLag);
        this.getView().updateView(FILTERGRIDAP);
        this.initFilterCondition(filterGrid, customParams.get("extentjson_tag"));
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        switch (key.toLowerCase(Locale.getDefault())) {
            case "btnok": {
                this.setwhereAndTxt();
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
        }
    }

    private void setwhereAndTxt() {
        HashMap<String, String> returnData = new HashMap<String, String>();
        returnData.put("extentjson", this.getWhere());
        returnData.put(EXTENT, this.getText());
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    private String getWhere() {
        FilterGrid filterGrid = (FilterGrid)this.getControl(FILTERGRIDAP);
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        String modelType = "DynamicFormModel";
        DomainModelBinder binder = new DomainModelBinder(DomainModelType.getDomainModelType((String)modelType, (boolean)false));
        DcJsonSerializer ser = new DcJsonSerializer((DcBinder)binder);
        Map filterConditionMap = ser.serializeToMap((Object)filterCondition, null);
        return SerializationUtils.toJsonString((Object)filterConditionMap);
    }

    private String getText() {
        FilterGrid filterGrid = (FilterGrid)this.getControl(FILTERGRIDAP);
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String entityFLag = (String)customParams.get("entityFLag");
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityFLag);
        FilterBuilder filterBuilder = new FilterBuilder(type, filterCondition);
        filterBuilder.setUserService((IUserService)new UserService());
        filterBuilder.setTimeService((ITimeService)new TimeService());
        filterBuilder.buildFilter(false);
        return this.formatStr(filterBuilder.getFilterObject().getFilter());
    }

    private void initFilterCondition(FilterGrid filterGrid, Object extentjsonTag) {
        if (StringUtils.isBlank((CharSequence)extentjsonTag.toString())) {
            return;
        }
        Map filterConditionMap = (Map)SerializationUtils.fromJsonString((String)extentjsonTag.toString(), Map.class);
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(FilterCondition.class));
        dts.add(OrmUtils.getDataEntityType(SimpleFilterRow.class));
        DcJsonSerializer ser = new DcJsonSerializer(dts);
        FilterCondition cod = (FilterCondition)ser.deserializeFromMap(filterConditionMap, null);
        filterGrid.SetValue(cod);
    }

    private String formatStr(String str) {
        str = str.replaceAll(this.getLongString1(), this.getShortString());
        str = str.replaceAll(this.getLongString2(), this.getShortString());
        return str;
    }

    private String getLongString1() {
        return ResManager.loadKDString((String)"\u5355\u636e\u4f53.\u533a\u95f4", (String)"ExtentFilterPlugin_2", (String)"bd-assistant-formplugin", (Object[])new Object[0]);
    }

    private String getLongString2() {
        return ResManager.loadKDString((String)"\u6700\u4f4e\u7a0e\u989d.\u533a\u95f4", (String)"ExtentFilterPlugin_0", (String)"bd-assistant-formplugin", (Object[])new Object[0]);
    }

    private String getShortString() {
        return ResManager.loadKDString((String)"\u533a\u95f4", (String)"ExtentFilterPlugin_1", (String)"bd-assistant-formplugin", (Object[])new Object[0]);
    }
}

